# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class PipelineTaskDetailChildTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'task_id': 'str',
        'pod_name': 'str'
    }

    attribute_map = {
        'task_id': 'task_id',
        'pod_name': 'pod_name'
    }

    def __init__(self, task_id=None, pod_name=None, local_vars_configuration=None):  # noqa: E501
        """PipelineTaskDetailChildTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._task_id = None
        self._pod_name = None
        self.discriminator = None

        if task_id is not None:
            self.task_id = task_id
        if pod_name is not None:
            self.pod_name = pod_name

    @property
    def task_id(self):
        """Gets the task_id of this PipelineTaskDetailChildTask.  # noqa: E501

        System-generated ID of a task.  # noqa: E501

        :return: The task_id of this PipelineTaskDetailChildTask.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this PipelineTaskDetailChildTask.

        System-generated ID of a task.  # noqa: E501

        :param task_id: The task_id of this PipelineTaskDetailChildTask.  # noqa: E501
        :type task_id: str
        """

        self._task_id = task_id

    @property
    def pod_name(self):
        """Gets the pod_name of this PipelineTaskDetailChildTask.  # noqa: E501

        Name of the corresponding pod assigned by the orchestration engine. Also known as node_id.  # noqa: E501

        :return: The pod_name of this PipelineTaskDetailChildTask.  # noqa: E501
        :rtype: str
        """
        return self._pod_name

    @pod_name.setter
    def pod_name(self, pod_name):
        """Sets the pod_name of this PipelineTaskDetailChildTask.

        Name of the corresponding pod assigned by the orchestration engine. Also known as node_id.  # noqa: E501

        :param pod_name: The pod_name of this PipelineTaskDetailChildTask.  # noqa: E501
        :type pod_name: str
        """

        self._pod_name = pod_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PipelineTaskDetailChildTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PipelineTaskDetailChildTask):
            return True

        return self.to_dict() != other.to_dict()
