# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1Experiment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'experiment_id': 'str',
        'display_name': 'str',
        'description': 'str',
        'created_at': 'datetime',
        'namespace': 'str',
        'storage_state': 'V2beta1ExperimentStorageState',
        'last_run_created_at': 'datetime'
    }

    attribute_map = {
        'experiment_id': 'experiment_id',
        'display_name': 'display_name',
        'description': 'description',
        'created_at': 'created_at',
        'namespace': 'namespace',
        'storage_state': 'storage_state',
        'last_run_created_at': 'last_run_created_at'
    }

    def __init__(self, experiment_id=None, display_name=None, description=None, created_at=None, namespace=None, storage_state=None, last_run_created_at=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1Experiment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._experiment_id = None
        self._display_name = None
        self._description = None
        self._created_at = None
        self._namespace = None
        self._storage_state = None
        self._last_run_created_at = None
        self.discriminator = None

        if experiment_id is not None:
            self.experiment_id = experiment_id
        if display_name is not None:
            self.display_name = display_name
        if description is not None:
            self.description = description
        if created_at is not None:
            self.created_at = created_at
        if namespace is not None:
            self.namespace = namespace
        if storage_state is not None:
            self.storage_state = storage_state
        if last_run_created_at is not None:
            self.last_run_created_at = last_run_created_at

    @property
    def experiment_id(self):
        """Gets the experiment_id of this V2beta1Experiment.  # noqa: E501

        Output. Unique experiment ID. Generated by API server.  # noqa: E501

        :return: The experiment_id of this V2beta1Experiment.  # noqa: E501
        :rtype: str
        """
        return self._experiment_id

    @experiment_id.setter
    def experiment_id(self, experiment_id):
        """Sets the experiment_id of this V2beta1Experiment.

        Output. Unique experiment ID. Generated by API server.  # noqa: E501

        :param experiment_id: The experiment_id of this V2beta1Experiment.  # noqa: E501
        :type experiment_id: str
        """

        self._experiment_id = experiment_id

    @property
    def display_name(self):
        """Gets the display_name of this V2beta1Experiment.  # noqa: E501

        Required input field. Unique experiment name provided by user.  # noqa: E501

        :return: The display_name of this V2beta1Experiment.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V2beta1Experiment.

        Required input field. Unique experiment name provided by user.  # noqa: E501

        :param display_name: The display_name of this V2beta1Experiment.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """Gets the description of this V2beta1Experiment.  # noqa: E501

        Optional input field. Describes the purpose of the experiment.  # noqa: E501

        :return: The description of this V2beta1Experiment.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V2beta1Experiment.

        Optional input field. Describes the purpose of the experiment.  # noqa: E501

        :param description: The description of this V2beta1Experiment.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def created_at(self):
        """Gets the created_at of this V2beta1Experiment.  # noqa: E501

        Output. The time that the experiment was created.  # noqa: E501

        :return: The created_at of this V2beta1Experiment.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this V2beta1Experiment.

        Output. The time that the experiment was created.  # noqa: E501

        :param created_at: The created_at of this V2beta1Experiment.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def namespace(self):
        """Gets the namespace of this V2beta1Experiment.  # noqa: E501

        Optional input field. Specify the namespace this experiment belongs to.  # noqa: E501

        :return: The namespace of this V2beta1Experiment.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this V2beta1Experiment.

        Optional input field. Specify the namespace this experiment belongs to.  # noqa: E501

        :param namespace: The namespace of this V2beta1Experiment.  # noqa: E501
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def storage_state(self):
        """Gets the storage_state of this V2beta1Experiment.  # noqa: E501


        :return: The storage_state of this V2beta1Experiment.  # noqa: E501
        :rtype: V2beta1ExperimentStorageState
        """
        return self._storage_state

    @storage_state.setter
    def storage_state(self, storage_state):
        """Sets the storage_state of this V2beta1Experiment.


        :param storage_state: The storage_state of this V2beta1Experiment.  # noqa: E501
        :type storage_state: V2beta1ExperimentStorageState
        """

        self._storage_state = storage_state

    @property
    def last_run_created_at(self):
        """Gets the last_run_created_at of this V2beta1Experiment.  # noqa: E501

        Output. The creation time of the last run in this experiment.  # noqa: E501

        :return: The last_run_created_at of this V2beta1Experiment.  # noqa: E501
        :rtype: datetime
        """
        return self._last_run_created_at

    @last_run_created_at.setter
    def last_run_created_at(self, last_run_created_at):
        """Sets the last_run_created_at of this V2beta1Experiment.

        Output. The creation time of the last run in this experiment.  # noqa: E501

        :param last_run_created_at: The last_run_created_at of this V2beta1Experiment.  # noqa: E501
        :type last_run_created_at: datetime
        """

        self._last_run_created_at = last_run_created_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1Experiment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1Experiment):
            return True

        return self.to_dict() != other.to_dict()
