# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1PipelineTaskDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'run_id': 'str',
        'task_id': 'str',
        'display_name': 'str',
        'create_time': 'datetime',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'executor_detail': 'V2beta1PipelineTaskExecutorDetail',
        'state': 'V2beta1RuntimeState',
        'execution_id': 'str',
        'error': 'GooglerpcStatus',
        'inputs': 'dict(str, V2beta1ArtifactList)',
        'outputs': 'dict(str, V2beta1ArtifactList)',
        'parent_task_id': 'str',
        'state_history': 'list[V2beta1RuntimeStatus]',
        'pod_name': 'str',
        'child_tasks': 'list[PipelineTaskDetailChildTask]'
    }

    attribute_map = {
        'run_id': 'run_id',
        'task_id': 'task_id',
        'display_name': 'display_name',
        'create_time': 'create_time',
        'start_time': 'start_time',
        'end_time': 'end_time',
        'executor_detail': 'executor_detail',
        'state': 'state',
        'execution_id': 'execution_id',
        'error': 'error',
        'inputs': 'inputs',
        'outputs': 'outputs',
        'parent_task_id': 'parent_task_id',
        'state_history': 'state_history',
        'pod_name': 'pod_name',
        'child_tasks': 'child_tasks'
    }

    def __init__(self, run_id=None, task_id=None, display_name=None, create_time=None, start_time=None, end_time=None, executor_detail=None, state=None, execution_id=None, error=None, inputs=None, outputs=None, parent_task_id=None, state_history=None, pod_name=None, child_tasks=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1PipelineTaskDetail - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._run_id = None
        self._task_id = None
        self._display_name = None
        self._create_time = None
        self._start_time = None
        self._end_time = None
        self._executor_detail = None
        self._state = None
        self._execution_id = None
        self._error = None
        self._inputs = None
        self._outputs = None
        self._parent_task_id = None
        self._state_history = None
        self._pod_name = None
        self._child_tasks = None
        self.discriminator = None

        if run_id is not None:
            self.run_id = run_id
        if task_id is not None:
            self.task_id = task_id
        if display_name is not None:
            self.display_name = display_name
        if create_time is not None:
            self.create_time = create_time
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time
        if executor_detail is not None:
            self.executor_detail = executor_detail
        if state is not None:
            self.state = state
        if execution_id is not None:
            self.execution_id = execution_id
        if error is not None:
            self.error = error
        if inputs is not None:
            self.inputs = inputs
        if outputs is not None:
            self.outputs = outputs
        if parent_task_id is not None:
            self.parent_task_id = parent_task_id
        if state_history is not None:
            self.state_history = state_history
        if pod_name is not None:
            self.pod_name = pod_name
        if child_tasks is not None:
            self.child_tasks = child_tasks

    @property
    def run_id(self):
        """Gets the run_id of this V2beta1PipelineTaskDetail.  # noqa: E501

        ID of the parent run.  # noqa: E501

        :return: The run_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._run_id

    @run_id.setter
    def run_id(self, run_id):
        """Sets the run_id of this V2beta1PipelineTaskDetail.

        ID of the parent run.  # noqa: E501

        :param run_id: The run_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type run_id: str
        """

        self._run_id = run_id

    @property
    def task_id(self):
        """Gets the task_id of this V2beta1PipelineTaskDetail.  # noqa: E501

        System-generated ID of a task.  # noqa: E501

        :return: The task_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this V2beta1PipelineTaskDetail.

        System-generated ID of a task.  # noqa: E501

        :param task_id: The task_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type task_id: str
        """

        self._task_id = task_id

    @property
    def display_name(self):
        """Gets the display_name of this V2beta1PipelineTaskDetail.  # noqa: E501

        User specified name of a task that is defined in [Pipeline.spec][].  # noqa: E501

        :return: The display_name of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V2beta1PipelineTaskDetail.

        User specified name of a task that is defined in [Pipeline.spec][].  # noqa: E501

        :param display_name: The display_name of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def create_time(self):
        """Gets the create_time of this V2beta1PipelineTaskDetail.  # noqa: E501

        Creation time of a task.  # noqa: E501

        :return: The create_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this V2beta1PipelineTaskDetail.

        Creation time of a task.  # noqa: E501

        :param create_time: The create_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type create_time: datetime
        """

        self._create_time = create_time

    @property
    def start_time(self):
        """Gets the start_time of this V2beta1PipelineTaskDetail.  # noqa: E501

        Starting time of a task.  # noqa: E501

        :return: The start_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this V2beta1PipelineTaskDetail.

        Starting time of a task.  # noqa: E501

        :param start_time: The start_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type start_time: datetime
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this V2beta1PipelineTaskDetail.  # noqa: E501

        Completion time of a task.  # noqa: E501

        :return: The end_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this V2beta1PipelineTaskDetail.

        Completion time of a task.  # noqa: E501

        :param end_time: The end_time of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type end_time: datetime
        """

        self._end_time = end_time

    @property
    def executor_detail(self):
        """Gets the executor_detail of this V2beta1PipelineTaskDetail.  # noqa: E501


        :return: The executor_detail of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: V2beta1PipelineTaskExecutorDetail
        """
        return self._executor_detail

    @executor_detail.setter
    def executor_detail(self, executor_detail):
        """Sets the executor_detail of this V2beta1PipelineTaskDetail.


        :param executor_detail: The executor_detail of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type executor_detail: V2beta1PipelineTaskExecutorDetail
        """

        self._executor_detail = executor_detail

    @property
    def state(self):
        """Gets the state of this V2beta1PipelineTaskDetail.  # noqa: E501


        :return: The state of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: V2beta1RuntimeState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this V2beta1PipelineTaskDetail.


        :param state: The state of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type state: V2beta1RuntimeState
        """

        self._state = state

    @property
    def execution_id(self):
        """Gets the execution_id of this V2beta1PipelineTaskDetail.  # noqa: E501

        Execution id of the corresponding entry in ML metadata store.  # noqa: E501

        :return: The execution_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this V2beta1PipelineTaskDetail.

        Execution id of the corresponding entry in ML metadata store.  # noqa: E501

        :param execution_id: The execution_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type execution_id: str
        """

        self._execution_id = execution_id

    @property
    def error(self):
        """Gets the error of this V2beta1PipelineTaskDetail.  # noqa: E501


        :return: The error of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: GooglerpcStatus
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this V2beta1PipelineTaskDetail.


        :param error: The error of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type error: GooglerpcStatus
        """

        self._error = error

    @property
    def inputs(self):
        """Gets the inputs of this V2beta1PipelineTaskDetail.  # noqa: E501

        Input artifacts of the task.  # noqa: E501

        :return: The inputs of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: dict(str, V2beta1ArtifactList)
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this V2beta1PipelineTaskDetail.

        Input artifacts of the task.  # noqa: E501

        :param inputs: The inputs of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type inputs: dict(str, V2beta1ArtifactList)
        """

        self._inputs = inputs

    @property
    def outputs(self):
        """Gets the outputs of this V2beta1PipelineTaskDetail.  # noqa: E501

        Output artifacts of the task.  # noqa: E501

        :return: The outputs of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: dict(str, V2beta1ArtifactList)
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this V2beta1PipelineTaskDetail.

        Output artifacts of the task.  # noqa: E501

        :param outputs: The outputs of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type outputs: dict(str, V2beta1ArtifactList)
        """

        self._outputs = outputs

    @property
    def parent_task_id(self):
        """Gets the parent_task_id of this V2beta1PipelineTaskDetail.  # noqa: E501

        ID of the parent task if the task is within a component scope. Empty if the task is at the root level.  # noqa: E501

        :return: The parent_task_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._parent_task_id

    @parent_task_id.setter
    def parent_task_id(self, parent_task_id):
        """Sets the parent_task_id of this V2beta1PipelineTaskDetail.

        ID of the parent task if the task is within a component scope. Empty if the task is at the root level.  # noqa: E501

        :param parent_task_id: The parent_task_id of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type parent_task_id: str
        """

        self._parent_task_id = parent_task_id

    @property
    def state_history(self):
        """Gets the state_history of this V2beta1PipelineTaskDetail.  # noqa: E501

        A sequence of task statuses. This field keeps a record of state transitions.  # noqa: E501

        :return: The state_history of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: list[V2beta1RuntimeStatus]
        """
        return self._state_history

    @state_history.setter
    def state_history(self, state_history):
        """Sets the state_history of this V2beta1PipelineTaskDetail.

        A sequence of task statuses. This field keeps a record of state transitions.  # noqa: E501

        :param state_history: The state_history of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type state_history: list[V2beta1RuntimeStatus]
        """

        self._state_history = state_history

    @property
    def pod_name(self):
        """Gets the pod_name of this V2beta1PipelineTaskDetail.  # noqa: E501

        Name of the corresponding pod assigned by the orchestration engine. Also known as node_id.  # noqa: E501

        :return: The pod_name of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: str
        """
        return self._pod_name

    @pod_name.setter
    def pod_name(self, pod_name):
        """Sets the pod_name of this V2beta1PipelineTaskDetail.

        Name of the corresponding pod assigned by the orchestration engine. Also known as node_id.  # noqa: E501

        :param pod_name: The pod_name of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type pod_name: str
        """

        self._pod_name = pod_name

    @property
    def child_tasks(self):
        """Gets the child_tasks of this V2beta1PipelineTaskDetail.  # noqa: E501

        Sequence of dependen tasks.  # noqa: E501

        :return: The child_tasks of this V2beta1PipelineTaskDetail.  # noqa: E501
        :rtype: list[PipelineTaskDetailChildTask]
        """
        return self._child_tasks

    @child_tasks.setter
    def child_tasks(self, child_tasks):
        """Sets the child_tasks of this V2beta1PipelineTaskDetail.

        Sequence of dependen tasks.  # noqa: E501

        :param child_tasks: The child_tasks of this V2beta1PipelineTaskDetail.  # noqa: E501
        :type child_tasks: list[PipelineTaskDetailChildTask]
        """

        self._child_tasks = child_tasks

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1PipelineTaskDetail):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1PipelineTaskDetail):
            return True

        return self.to_dict() != other.to_dict()
