# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1PipelineTaskExecutorDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'main_job': 'str',
        'pre_caching_check_job': 'str',
        'failed_main_jobs': 'list[str]',
        'failed_pre_caching_check_jobs': 'list[str]'
    }

    attribute_map = {
        'main_job': 'main_job',
        'pre_caching_check_job': 'pre_caching_check_job',
        'failed_main_jobs': 'failed_main_jobs',
        'failed_pre_caching_check_jobs': 'failed_pre_caching_check_jobs'
    }

    def __init__(self, main_job=None, pre_caching_check_job=None, failed_main_jobs=None, failed_pre_caching_check_jobs=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1PipelineTaskExecutorDetail - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._main_job = None
        self._pre_caching_check_job = None
        self._failed_main_jobs = None
        self._failed_pre_caching_check_jobs = None
        self.discriminator = None

        if main_job is not None:
            self.main_job = main_job
        if pre_caching_check_job is not None:
            self.pre_caching_check_job = pre_caching_check_job
        if failed_main_jobs is not None:
            self.failed_main_jobs = failed_main_jobs
        if failed_pre_caching_check_jobs is not None:
            self.failed_pre_caching_check_jobs = failed_pre_caching_check_jobs

    @property
    def main_job(self):
        """Gets the main_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501

        The name of the job for the main container execution.  # noqa: E501

        :return: The main_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :rtype: str
        """
        return self._main_job

    @main_job.setter
    def main_job(self, main_job):
        """Sets the main_job of this V2beta1PipelineTaskExecutorDetail.

        The name of the job for the main container execution.  # noqa: E501

        :param main_job: The main_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :type main_job: str
        """

        self._main_job = main_job

    @property
    def pre_caching_check_job(self):
        """Gets the pre_caching_check_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501

        The name of the job for the pre-caching-check container execution. This job will be available if the Run.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events.  # noqa: E501

        :return: The pre_caching_check_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :rtype: str
        """
        return self._pre_caching_check_job

    @pre_caching_check_job.setter
    def pre_caching_check_job(self, pre_caching_check_job):
        """Sets the pre_caching_check_job of this V2beta1PipelineTaskExecutorDetail.

        The name of the job for the pre-caching-check container execution. This job will be available if the Run.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events.  # noqa: E501

        :param pre_caching_check_job: The pre_caching_check_job of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :type pre_caching_check_job: str
        """

        self._pre_caching_check_job = pre_caching_check_job

    @property
    def failed_main_jobs(self):
        """Gets the failed_main_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501

        The names of the previously failed job for the main container executions. The list includes the all attempts in chronological order.  # noqa: E501

        :return: The failed_main_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._failed_main_jobs

    @failed_main_jobs.setter
    def failed_main_jobs(self, failed_main_jobs):
        """Sets the failed_main_jobs of this V2beta1PipelineTaskExecutorDetail.

        The names of the previously failed job for the main container executions. The list includes the all attempts in chronological order.  # noqa: E501

        :param failed_main_jobs: The failed_main_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :type failed_main_jobs: list[str]
        """

        self._failed_main_jobs = failed_main_jobs

    @property
    def failed_pre_caching_check_jobs(self):
        """Gets the failed_pre_caching_check_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501

        The names of the previously failed job for the pre-caching-check container executions. This job will be available if the Run.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events. The list includes the all attempts in chronological order.  # noqa: E501

        :return: The failed_pre_caching_check_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._failed_pre_caching_check_jobs

    @failed_pre_caching_check_jobs.setter
    def failed_pre_caching_check_jobs(self, failed_pre_caching_check_jobs):
        """Sets the failed_pre_caching_check_jobs of this V2beta1PipelineTaskExecutorDetail.

        The names of the previously failed job for the pre-caching-check container executions. This job will be available if the Run.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events. The list includes the all attempts in chronological order.  # noqa: E501

        :param failed_pre_caching_check_jobs: The failed_pre_caching_check_jobs of this V2beta1PipelineTaskExecutorDetail.  # noqa: E501
        :type failed_pre_caching_check_jobs: list[str]
        """

        self._failed_pre_caching_check_jobs = failed_pre_caching_check_jobs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1PipelineTaskExecutorDetail):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1PipelineTaskExecutorDetail):
            return True

        return self.to_dict() != other.to_dict()
