# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1PipelineVersionReference(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pipeline_id': 'str',
        'pipeline_version_id': 'str'
    }

    attribute_map = {
        'pipeline_id': 'pipeline_id',
        'pipeline_version_id': 'pipeline_version_id'
    }

    def __init__(self, pipeline_id=None, pipeline_version_id=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1PipelineVersionReference - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pipeline_id = None
        self._pipeline_version_id = None
        self.discriminator = None

        if pipeline_id is not None:
            self.pipeline_id = pipeline_id
        if pipeline_version_id is not None:
            self.pipeline_version_id = pipeline_version_id

    @property
    def pipeline_id(self):
        """Gets the pipeline_id of this V2beta1PipelineVersionReference.  # noqa: E501

        Input. Required. Unique ID of the parent pipeline.  # noqa: E501

        :return: The pipeline_id of this V2beta1PipelineVersionReference.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_id

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id):
        """Sets the pipeline_id of this V2beta1PipelineVersionReference.

        Input. Required. Unique ID of the parent pipeline.  # noqa: E501

        :param pipeline_id: The pipeline_id of this V2beta1PipelineVersionReference.  # noqa: E501
        :type pipeline_id: str
        """

        self._pipeline_id = pipeline_id

    @property
    def pipeline_version_id(self):
        """Gets the pipeline_version_id of this V2beta1PipelineVersionReference.  # noqa: E501

        Input. Optional. Unique ID of an existing pipeline version. If unset, the latest pipeline version is used.  # noqa: E501

        :return: The pipeline_version_id of this V2beta1PipelineVersionReference.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_version_id

    @pipeline_version_id.setter
    def pipeline_version_id(self, pipeline_version_id):
        """Sets the pipeline_version_id of this V2beta1PipelineVersionReference.

        Input. Optional. Unique ID of an existing pipeline version. If unset, the latest pipeline version is used.  # noqa: E501

        :param pipeline_version_id: The pipeline_version_id of this V2beta1PipelineVersionReference.  # noqa: E501
        :type pipeline_version_id: str
        """

        self._pipeline_version_id = pipeline_version_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1PipelineVersionReference):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1PipelineVersionReference):
            return True

        return self.to_dict() != other.to_dict()
