# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1RecurringRun(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'recurring_run_id': 'str',
        'display_name': 'str',
        'description': 'str',
        'pipeline_version_id': 'str',
        'pipeline_spec': 'object',
        'pipeline_version_reference': 'V2beta1PipelineVersionReference',
        'runtime_config': 'V2beta1RuntimeConfig',
        'service_account': 'str',
        'max_concurrency': 'str',
        'trigger': 'V2beta1Trigger',
        'mode': 'RecurringRunMode',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'status': 'V2beta1RecurringRunStatus',
        'error': 'GooglerpcStatus',
        'no_catchup': 'bool',
        'namespace': 'str',
        'experiment_id': 'str'
    }

    attribute_map = {
        'recurring_run_id': 'recurring_run_id',
        'display_name': 'display_name',
        'description': 'description',
        'pipeline_version_id': 'pipeline_version_id',
        'pipeline_spec': 'pipeline_spec',
        'pipeline_version_reference': 'pipeline_version_reference',
        'runtime_config': 'runtime_config',
        'service_account': 'service_account',
        'max_concurrency': 'max_concurrency',
        'trigger': 'trigger',
        'mode': 'mode',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'status': 'status',
        'error': 'error',
        'no_catchup': 'no_catchup',
        'namespace': 'namespace',
        'experiment_id': 'experiment_id'
    }

    def __init__(self, recurring_run_id=None, display_name=None, description=None, pipeline_version_id=None, pipeline_spec=None, pipeline_version_reference=None, runtime_config=None, service_account=None, max_concurrency=None, trigger=None, mode=None, created_at=None, updated_at=None, status=None, error=None, no_catchup=None, namespace=None, experiment_id=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1RecurringRun - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._recurring_run_id = None
        self._display_name = None
        self._description = None
        self._pipeline_version_id = None
        self._pipeline_spec = None
        self._pipeline_version_reference = None
        self._runtime_config = None
        self._service_account = None
        self._max_concurrency = None
        self._trigger = None
        self._mode = None
        self._created_at = None
        self._updated_at = None
        self._status = None
        self._error = None
        self._no_catchup = None
        self._namespace = None
        self._experiment_id = None
        self.discriminator = None

        if recurring_run_id is not None:
            self.recurring_run_id = recurring_run_id
        if display_name is not None:
            self.display_name = display_name
        if description is not None:
            self.description = description
        if pipeline_version_id is not None:
            self.pipeline_version_id = pipeline_version_id
        if pipeline_spec is not None:
            self.pipeline_spec = pipeline_spec
        if pipeline_version_reference is not None:
            self.pipeline_version_reference = pipeline_version_reference
        if runtime_config is not None:
            self.runtime_config = runtime_config
        if service_account is not None:
            self.service_account = service_account
        if max_concurrency is not None:
            self.max_concurrency = max_concurrency
        if trigger is not None:
            self.trigger = trigger
        if mode is not None:
            self.mode = mode
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if status is not None:
            self.status = status
        if error is not None:
            self.error = error
        if no_catchup is not None:
            self.no_catchup = no_catchup
        if namespace is not None:
            self.namespace = namespace
        if experiment_id is not None:
            self.experiment_id = experiment_id

    @property
    def recurring_run_id(self):
        """Gets the recurring_run_id of this V2beta1RecurringRun.  # noqa: E501

        Output. Unique run ID generated by API server.  # noqa: E501

        :return: The recurring_run_id of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._recurring_run_id

    @recurring_run_id.setter
    def recurring_run_id(self, recurring_run_id):
        """Sets the recurring_run_id of this V2beta1RecurringRun.

        Output. Unique run ID generated by API server.  # noqa: E501

        :param recurring_run_id: The recurring_run_id of this V2beta1RecurringRun.  # noqa: E501
        :type recurring_run_id: str
        """

        self._recurring_run_id = recurring_run_id

    @property
    def display_name(self):
        """Gets the display_name of this V2beta1RecurringRun.  # noqa: E501

        Required input field. Recurring run name provided by user. Not unique.  # noqa: E501

        :return: The display_name of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V2beta1RecurringRun.

        Required input field. Recurring run name provided by user. Not unique.  # noqa: E501

        :param display_name: The display_name of this V2beta1RecurringRun.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """Gets the description of this V2beta1RecurringRun.  # noqa: E501

        Optional input field. Describes the purpose of the recurring run.  # noqa: E501

        :return: The description of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V2beta1RecurringRun.

        Optional input field. Describes the purpose of the recurring run.  # noqa: E501

        :param description: The description of this V2beta1RecurringRun.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def pipeline_version_id(self):
        """Gets the pipeline_version_id of this V2beta1RecurringRun.  # noqa: E501

        This field is Deprecated. The pipeline version id is under pipeline_version_reference for v2.  # noqa: E501

        :return: The pipeline_version_id of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_version_id

    @pipeline_version_id.setter
    def pipeline_version_id(self, pipeline_version_id):
        """Sets the pipeline_version_id of this V2beta1RecurringRun.

        This field is Deprecated. The pipeline version id is under pipeline_version_reference for v2.  # noqa: E501

        :param pipeline_version_id: The pipeline_version_id of this V2beta1RecurringRun.  # noqa: E501
        :type pipeline_version_id: str
        """

        self._pipeline_version_id = pipeline_version_id

    @property
    def pipeline_spec(self):
        """Gets the pipeline_spec of this V2beta1RecurringRun.  # noqa: E501

        The pipeline spec.  # noqa: E501

        :return: The pipeline_spec of this V2beta1RecurringRun.  # noqa: E501
        :rtype: object
        """
        return self._pipeline_spec

    @pipeline_spec.setter
    def pipeline_spec(self, pipeline_spec):
        """Sets the pipeline_spec of this V2beta1RecurringRun.

        The pipeline spec.  # noqa: E501

        :param pipeline_spec: The pipeline_spec of this V2beta1RecurringRun.  # noqa: E501
        :type pipeline_spec: object
        """

        self._pipeline_spec = pipeline_spec

    @property
    def pipeline_version_reference(self):
        """Gets the pipeline_version_reference of this V2beta1RecurringRun.  # noqa: E501


        :return: The pipeline_version_reference of this V2beta1RecurringRun.  # noqa: E501
        :rtype: V2beta1PipelineVersionReference
        """
        return self._pipeline_version_reference

    @pipeline_version_reference.setter
    def pipeline_version_reference(self, pipeline_version_reference):
        """Sets the pipeline_version_reference of this V2beta1RecurringRun.


        :param pipeline_version_reference: The pipeline_version_reference of this V2beta1RecurringRun.  # noqa: E501
        :type pipeline_version_reference: V2beta1PipelineVersionReference
        """

        self._pipeline_version_reference = pipeline_version_reference

    @property
    def runtime_config(self):
        """Gets the runtime_config of this V2beta1RecurringRun.  # noqa: E501


        :return: The runtime_config of this V2beta1RecurringRun.  # noqa: E501
        :rtype: V2beta1RuntimeConfig
        """
        return self._runtime_config

    @runtime_config.setter
    def runtime_config(self, runtime_config):
        """Sets the runtime_config of this V2beta1RecurringRun.


        :param runtime_config: The runtime_config of this V2beta1RecurringRun.  # noqa: E501
        :type runtime_config: V2beta1RuntimeConfig
        """

        self._runtime_config = runtime_config

    @property
    def service_account(self):
        """Gets the service_account of this V2beta1RecurringRun.  # noqa: E501

        Optional input field. Specifies which Kubernetes service account this recurring run uses.  # noqa: E501

        :return: The service_account of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._service_account

    @service_account.setter
    def service_account(self, service_account):
        """Sets the service_account of this V2beta1RecurringRun.

        Optional input field. Specifies which Kubernetes service account this recurring run uses.  # noqa: E501

        :param service_account: The service_account of this V2beta1RecurringRun.  # noqa: E501
        :type service_account: str
        """

        self._service_account = service_account

    @property
    def max_concurrency(self):
        """Gets the max_concurrency of this V2beta1RecurringRun.  # noqa: E501

        Required input field. Specifies how many runs can be executed concurrently. Range [1-10].  # noqa: E501

        :return: The max_concurrency of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._max_concurrency

    @max_concurrency.setter
    def max_concurrency(self, max_concurrency):
        """Sets the max_concurrency of this V2beta1RecurringRun.

        Required input field. Specifies how many runs can be executed concurrently. Range [1-10].  # noqa: E501

        :param max_concurrency: The max_concurrency of this V2beta1RecurringRun.  # noqa: E501
        :type max_concurrency: str
        """

        self._max_concurrency = max_concurrency

    @property
    def trigger(self):
        """Gets the trigger of this V2beta1RecurringRun.  # noqa: E501


        :return: The trigger of this V2beta1RecurringRun.  # noqa: E501
        :rtype: V2beta1Trigger
        """
        return self._trigger

    @trigger.setter
    def trigger(self, trigger):
        """Sets the trigger of this V2beta1RecurringRun.


        :param trigger: The trigger of this V2beta1RecurringRun.  # noqa: E501
        :type trigger: V2beta1Trigger
        """

        self._trigger = trigger

    @property
    def mode(self):
        """Gets the mode of this V2beta1RecurringRun.  # noqa: E501


        :return: The mode of this V2beta1RecurringRun.  # noqa: E501
        :rtype: RecurringRunMode
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this V2beta1RecurringRun.


        :param mode: The mode of this V2beta1RecurringRun.  # noqa: E501
        :type mode: RecurringRunMode
        """

        self._mode = mode

    @property
    def created_at(self):
        """Gets the created_at of this V2beta1RecurringRun.  # noqa: E501

        Output. The time this recurring run was created.  # noqa: E501

        :return: The created_at of this V2beta1RecurringRun.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this V2beta1RecurringRun.

        Output. The time this recurring run was created.  # noqa: E501

        :param created_at: The created_at of this V2beta1RecurringRun.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this V2beta1RecurringRun.  # noqa: E501

        Output. The last time this recurring run was updated.  # noqa: E501

        :return: The updated_at of this V2beta1RecurringRun.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this V2beta1RecurringRun.

        Output. The last time this recurring run was updated.  # noqa: E501

        :param updated_at: The updated_at of this V2beta1RecurringRun.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def status(self):
        """Gets the status of this V2beta1RecurringRun.  # noqa: E501


        :return: The status of this V2beta1RecurringRun.  # noqa: E501
        :rtype: V2beta1RecurringRunStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this V2beta1RecurringRun.


        :param status: The status of this V2beta1RecurringRun.  # noqa: E501
        :type status: V2beta1RecurringRunStatus
        """

        self._status = status

    @property
    def error(self):
        """Gets the error of this V2beta1RecurringRun.  # noqa: E501


        :return: The error of this V2beta1RecurringRun.  # noqa: E501
        :rtype: GooglerpcStatus
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this V2beta1RecurringRun.


        :param error: The error of this V2beta1RecurringRun.  # noqa: E501
        :type error: GooglerpcStatus
        """

        self._error = error

    @property
    def no_catchup(self):
        """Gets the no_catchup of this V2beta1RecurringRun.  # noqa: E501

        Optional input field. Whether the recurring run should catch up if behind schedule. If true, the recurring run will only schedule the latest interval if behind schedule. If false, the recurring run will catch up on each past interval.  # noqa: E501

        :return: The no_catchup of this V2beta1RecurringRun.  # noqa: E501
        :rtype: bool
        """
        return self._no_catchup

    @no_catchup.setter
    def no_catchup(self, no_catchup):
        """Sets the no_catchup of this V2beta1RecurringRun.

        Optional input field. Whether the recurring run should catch up if behind schedule. If true, the recurring run will only schedule the latest interval if behind schedule. If false, the recurring run will catch up on each past interval.  # noqa: E501

        :param no_catchup: The no_catchup of this V2beta1RecurringRun.  # noqa: E501
        :type no_catchup: bool
        """

        self._no_catchup = no_catchup

    @property
    def namespace(self):
        """Gets the namespace of this V2beta1RecurringRun.  # noqa: E501

        TODO (gkclat): consider removing this field if it can be obtained from the parent experiment. Output only. Namespace this recurring run belongs to. Derived from the parent experiment.  # noqa: E501

        :return: The namespace of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this V2beta1RecurringRun.

        TODO (gkclat): consider removing this field if it can be obtained from the parent experiment. Output only. Namespace this recurring run belongs to. Derived from the parent experiment.  # noqa: E501

        :param namespace: The namespace of this V2beta1RecurringRun.  # noqa: E501
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def experiment_id(self):
        """Gets the experiment_id of this V2beta1RecurringRun.  # noqa: E501

        ID of the parent experiment this recurring run belongs to.  # noqa: E501

        :return: The experiment_id of this V2beta1RecurringRun.  # noqa: E501
        :rtype: str
        """
        return self._experiment_id

    @experiment_id.setter
    def experiment_id(self, experiment_id):
        """Sets the experiment_id of this V2beta1RecurringRun.

        ID of the parent experiment this recurring run belongs to.  # noqa: E501

        :param experiment_id: The experiment_id of this V2beta1RecurringRun.  # noqa: E501
        :type experiment_id: str
        """

        self._experiment_id = experiment_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1RecurringRun):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1RecurringRun):
            return True

        return self.to_dict() != other.to_dict()
