# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2017-12-25 21:39
from __future__ import unicode_literals

from django.db import migrations, models, connection
from dispatch.models import Article, Image, Author

def move_authors(apps, schema_editor):
    OldAuthor = apps.get_model('dispatch', 'Author')

    with connection.cursor() as cursor:
        cursor.execute('SELECT id, article_id FROM dispatch_author WHERE article_id IS NOT NULL')
        for author in cursor.fetchall():
            cursor.execute('INSERT INTO dispatch_article_authors (article_id, author_id) VALUES (%s, %s)', [author[1], author[0]])

    with connection.cursor() as cursor:
        cursor.execute('SELECT id, image_id FROM dispatch_author WHERE image_id IS NOT NULL')
        for author in cursor.fetchall():
            cursor.execute('INSERT INTO dispatch_image_authors (image_id, author_id) VALUES (%s, %s)', [author[1], author[0]])

class Migration(migrations.Migration):

    dependencies = [
        ('dispatch', '0005_author_type'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='article',
            name='authors',
        ),
        migrations.AddField(
            model_name='article',
            name='authors',
            field=models.ManyToManyField(related_name='article_authors', to='dispatch.Author'),
        ),
        migrations.RemoveField(
            model_name='image',
            name='authors',
        ),
        migrations.AddField(
            model_name='image',
            name='authors',
            field=models.ManyToManyField(related_name='image_authors', to='dispatch.Author'),
        ),
        migrations.AlterField(
            model_name='author',
            name='type',
            field=models.CharField(blank=True, default=b'author', max_length=100),
        ),
    	migrations.RunPython(move_authors),
        migrations.RemoveField(
            model_name='author',
            name='article',
        ),
        migrations.RemoveField(
            model_name='author',
            name='image',
        ),
]
