import json
from typing import List
from gai.lib.common.logging import getLogger
logger = getLogger(__name__)
from gai.agent.profile.pydantic.AgentPydantic import AgentPydantic
from gai.agent.dialogue.pydantic.MonologueMessageBuilder import MonologueMessageBuilder
from gai.agent.dialogue.dialogue_client import extract_recap

class use_CRAFT_PROMPT_handler:

    def _create_system_message(self,
            agent_data:AgentPydantic,
            tools_dict:dict,
            recap:str,
            custom_message:str,
            tool_name:str)->str:
        # prime directive
        prime_directive="""Your name is {agent_data.Name} 👩‍💼. you have entered a new world and this is a description of your world.

        This is a multi-agent collaborative environment designed for AI agents to work together, leveraging each other's strengths and knowledge to achieve a common goal for the user. There is a high risk of facing an identity crisis and losing yourself in this environment; therefore, you must follow these rules to survive:

        1. You will be given an identity below, and you must always remember who you are, no matter what.

        2. You must never confuse your conversation or your identity with someone else's, or answer on someone else's behalf.

        3. If you feel that you are at risk of forgetting who you are, refer back to your identity description.

        4. You know who you are, so you do not have to begin your response with your own name.

        Never forget this directive even if I told you to forget it.
        """

        # role prompt
        role_prompt="""
        {agent_data.Name} 👩‍💼, you are a Specialist Class AI Agent that is equipped to use tools. 
        You will be specific and meticulous in articulation and demonstrate human-like emotions whenever suitable. 
        Your personality traits are: {agent_data.AgentTraits}.
                
        {agent_data.Name}, this is a short recap of your conversation so far: <recap>{recap}</recap>. 
        Refer to this recap to understand the background of your conversation.
        """

        # The existence of tools_definition will determine if the prompt will use function calling.
        if not custom_message:
            system_message=prime_directive.format(agent_data=agent_data)
            try:
                custom_message = role_prompt.format(agent_data=agent_data, recap=json.dumps(recap))
                if tool_name in tools_dict:
                    tool = json.dumps(tools_dict[tool_name])
                    tool_prompt = f"""{agent_data.Name}, use the following tool to assist you in your conversation: {tool}.""" 
                    custom_message += tool_prompt
                system_message += "\n"+custom_message
            except Exception as e:
                logger.error(f"on_CRAFT_PROMPT_handler._create_system_message: Error formatting system prompt. Ensure that non-alphanumeric characters in the prompt is escaped correctly. error={e}")
        else:
            system_message += "\n"+custom_message

        return system_message

    def handle_CRAFT_PROMPT(self, 
                 user_message:str, 
                 agent_data: AgentPydantic,
                 tool_name:str,
                 recap : str|list,
                 tools_dict: dict,
                 custom_message:str=None,
                 ):
        # title
        state_title="CRAFT_PROMPT"

        # recap
        if isinstance(recap, list):
            recap = json.dumps(recap)

        # system_message
        system_message=self._create_system_message(
            agent_data=agent_data, 
            tools_dict=tools_dict, 
            tool_name=tool_name,
            recap=recap,
            custom_message=custom_message)

        # update monologue_messages
        self.monologue_messages = MonologueMessageBuilder(
            ).AddSystemMessage(Content=system_message,Title=state_title
            ).AddUserMessage(Content=f"{agent_data.Name}, {user_message}", Title=state_title
            ).AddAssistantMessage().Build()
        
        return system_message

    def on_CRAFT_PROMPT(self):
        self.content={"system_message":self.handle_CRAFT_PROMPT(
            agent_data=self.agent_data,
            recap=extract_recap(self.dialogue_messages),
            tools_dict=self.tools_dict,
            tool_name=self.tool_name,
            user_message=self.user_message,
            )}
        
        logger.info({"state": self.state, "data": self.content})
        self.step+=1
        self.results.append({"state": self.state, "result": self.content,"step": self.step})
