# Scanning for malware

**ts-scan** supports [yara](https://virustotal.github.io/yara/) to scan for malware. We added it to simplify security checks of 3rd party elements.

Yara checks are *not* enabled by default. The analysis will be file based. You may also pass a directory as target. This can be useful when your organisation has a particular inbound directory for incoming artefacts. However, to better handle the results, it may be useful to scan only one artefact per scan.

## Rule sets

Yara is a great tool but it will only find, what is defined in the rules. To learn more about yara rules, see [this site](https://). You may provide / define your own rule set or use a professional 3rd party ruleset, e.g. by virustotal or use some public collections from this [awsome list](https://github.com/InQuest/awesome-yara?tab=readme-ov-file#rules) or this [community endavour](https://github.com/Yara-Rules/rules). Unfortunately community endavours seem not to keep up the efforts necessary so that they tend to silence work over time.  

Currently we are still experimenting on how to best provide our ruleset and how to update it. However, you should make sure, you are using a suitable rule set for your purpose. Scanning with an outdated ruleset may not help you with most recent threats. 

## Usage

To scan a particular file use 

```shell
ts-scan analyse -o <path to the output file> [-f <output format>] --use-yara <path to the project directory>
```

