"""INTEGRIUM Validator. Author: Juste Elysée MALANDILA"""
from typing import Any, Callable, Optional
from pydantic import BaseModel, Field as PydanticField, field_validator

class Field:
    """Field with advanced validation."""
    def __init__(self, validator: Optional[Callable] = None, sanitizer: Optional[Callable] = None):
        self.validator = validator
        self.sanitizer = sanitizer

class Validator(BaseModel):
    """Base validator with integrity checks."""
    
    class Config:
        arbitrary_types_allowed = True
        validate_assignment = True
