angular.module("app",["ionic","app.playback","app.tracklist","app.library","app.playlists","app.settings","app.services","app.locales"]).config(function($stateProvider,$urlRouterProvider,$ionicConfigProvider,$translateProvider,ConfigProvider,MopidyProvider){if($stateProvider.state("tabs",{"abstract":!0,url:"/tabs",templateUrl:"templates/tabs.html"}),$urlRouterProvider.otherwise("/tabs/playback"),$ionicConfigProvider.tabs.position("bottom"),$ionicConfigProvider.tabs.style("standard"),$translateProvider.preferredLanguage(ConfigProvider.get("locale","en")),MopidyProvider.settings.backoffDelayMin(250),MopidyProvider.settings.backoffDelayMax(1e3),!ConfigProvider.get("webSocketUrl")&&!MopidyProvider.isWebExtension()){var webSocketUrl=window.prompt("Mopidy WebSocket URL","ws://"+(location.hostname||"localhost")+":6680/mopidy/ws/");MopidyProvider.settings.webSocketUrl(webSocketUrl)}}).run(function($ionicPlatform){$ionicPlatform.ready(function(){window.cordova&&window.cordova.plugins.Keyboard&&window.cordova.plugins.Keyboard.hideKeyboardAccessoryBar(!0)})});var trackActions={add:function(mopidy,uri){mopidy.tracklist.add({uri:uri})},"add+play":function(mopidy,uri){mopidy.tracklist.add({uri:uri}).then(function(tlTracks){mopidy.playback.play({tl_track:tlTracks[0]})})}};angular.module("app.library",["ionic","app.services"]).config(function($stateProvider){$stateProvider.state("tabs.library",{"abstract":!0,url:"/library",views:{library:{template:"<ion-nav-view></ion-nav-view>"}}}).state("tabs.library.root",{url:"",templateUrl:"templates/browse.html",controller:"BrowseCtrl",resolve:{mopidy:function(Mopidy){return Mopidy()},ref:function(){return null},refs:function(Mopidy){return Mopidy(function(mopidy){return mopidy.library.browse({uri:null})})}}}).state("tabs.library.browse",{url:"/browse?type&name&uri",controller:"BrowseCtrl",templateUrl:"templates/browse.html",resolve:{mopidy:function(Mopidy){return Mopidy()},ref:function($stateParams){return{type:$stateParams.type,name:$stateParams.name,uri:$stateParams.uri}},refs:function($stateParams,Mopidy){return Mopidy(function(mopidy){return mopidy.library.browse({uri:$stateParams.uri})})}}}).state("tabs.library.search",{url:"/search?q&uri",controller:"SearchCtrl",templateUrl:"templates/search.html",resolve:{mopidy:function(Mopidy){return Mopidy()},q:function($stateParams){return $stateParams.q},results:function($stateParams,Mopidy){return Mopidy(function(mopidy){return mopidy.library.search({query:{any:$stateParams.q},uris:$stateParams.uri?[$stateParams.uri]:null})})}}})}).controller("BrowseCtrl",function($scope,$state,$log,Config,mopidy,ref,refs){$scope.ref=ref,$scope.refs=refs,$scope.play=function(uri){trackActions[Config.get("action","add+play")](mopidy,uri)},$scope.refresh=function(){mopidy.library.refresh({uri:$scope.ref?$scope.ref.uri:null}).then(function(){$scope.$broadcast("scroll.refreshComplete")})},$scope.search=function(q){$state.go("^.search",{q:q,uri:$scope.ref.uri})}}).controller("SearchCtrl",function($scope,Config,mopidy,q,results){$scope.q=q,$scope.results=results,$scope.play=function(uri){trackActions[Config.get("action","add+play")](mopidy,uri)}}),angular.module("app.locales",["pascalprecht.translate"]).constant("locales",{en:{displayName:"English",messages:{"Clear Tracklist":"Clear Tracklist",Clear:"Clear","Clear...":"Clear&hellip;",Consume:"Consume",Edit:"Edit",Empty:"Empty",Language:"Language",Library:"Library","Nothing playing":"Nothing playling","Play All":"Play All",Playback:"Playback",Playlists:"Playlists","Pull to refresh":"Pull to refresh",Random:"Random",Remove:"Remove",Repeat:"Repeat","Save as...":"Save as&hellip;",Save:"Save","Search here...":"Search here...",Settings:"Settings",Single:"Single",Theme:"Theme",Tracklist:"Tracklist","{count} Tracks":"{{count}} Tracks","{index} of {count}":"{{index}} of {{count}}"}},de:{displayName:"Deutsch",messages:{"Clear Tracklist":"Titel löschen",Clear:"Leeren","Clear...":"Leeren&hellip;",Consume:"Verbrauchsmodus",Edit:"Bearbeiten",Empty:"Leer",Language:"Sprache",Library:"Bibliothek","Nothing playing":"Nichts spielt","Play All":"Alle abspielen",Playback:"Wiedergabe",Playlists:"Listen","Pull to refresh":"Zum Aktualisieren ziehen",Random:"Zufällig",Remove:"Löschen",Repeat:"Wiederholen","Save as...":"Speichern unter&hellip;",Save:"Speichern","Search here...":"Hier suchen...",Settings:"Einstellungen",Single:"Einzelmodus",Theme:"Design",Tracklist:"Titel","{count} Tracks":"{{count}} Titel","{index} of {count}":"{{index}} von {{count}}"}}}).factory("missingTranslationHandler",function($log){return function(translationId){$log.warn("Missing translation: "+translationId)}}).filter("duration",function(){return function(ms){if(void 0===ms||null===ms)return"n/a";var s=Math.round(ms/1e3),sec=s%60,min=parseInt(s/60),value=min+":"+(10>sec?"0":"")+sec;return value}}).config(function($translateProvider,locales){angular.forEach(locales,function(locale,id){$translateProvider.translations(id,locale.messages)}),$translateProvider.useMissingTranslationHandler("missingTranslationHandler")}),angular.module("app.playback",["ionic","app.services"]).config(function($stateProvider){$stateProvider.state("tabs.playback",{url:"/playback",views:{playback:{templateUrl:"templates/playback.html",controller:"PlaybackCtrl",resolve:{mopidy:function(Mopidy){return Mopidy()},mute:function(Mopidy){return Mopidy(function(mopidy){return mopidy.playback.getMute()})},options:function(Mopidy){return Mopidy(function(mopidy){return mopidy.tracklist.getOptions()})},state:function(Mopidy){return Mopidy(function(mopidy){return mopidy.playback.getState()})},tlTracks:function(Mopidy){return Mopidy(function(mopidy){return mopidy.playback.getCurrentTlTrack().then(function(tlTrack){return mopidy.join(mopidy.tracklist.tracks({tl_track:tlTrack}),tlTrack)}).then(function(results){return angular.extend(results[0],{current:results[1]})})})}}}}})}).controller("PlaybackCtrl",function($scope,$interval,$window,$log,$q,mopidy,mute,options,state,tlTracks){function setCurrentTlTrack(tlTrack,timePosition){$scope.$apply(function(scope){tlTrack&&scope.tlTracks.current&&tlTrack.tlid===scope.tlTracks.current.tlid||(scope.tlTracks={current:tlTrack},scope.track=tlTrack?tlTrack.track:null,mopidy.tracklist.tracks({tl_track:tlTrack}).then(function(tlTracks){scope.$apply(function(scope){!scope.track&&tlTracks.eot&&(scope.track=tlTracks.eot.track),angular.extend(scope.tlTracks,tlTracks)})})),void 0!==timePosition&&(scope.time.value=timePosition)})}var handlers={"event:muteChanged":function(event){$scope.$apply(function(scope){scope.mute=event.mute})},"event:optionsChanged":function(){mopidy.tracklist.getOptions().then(function(options){$scope.$apply(function(scope){scope.options=options})})},"event:playbackStateChanged":function(event){$scope.$apply(function(scope){scope.state=event.new_state})},"event:trackPlaybackEnded":function(){mopidy.playback.getCurrentTlTrack().then(function(tlTrack){setCurrentTlTrack(tlTrack,0)})},"event:trackPlaybackPaused":function(event){setCurrentTlTrack(event.tl_track,event.time_position)},"event:trackPlaybackResumed":function(event){setCurrentTlTrack(event.tl_track,event.time_position)},"event:trackPlaybackStarted":function(event){setCurrentTlTrack(event.tl_track,0)},"event:tracklistChanged":function(){mopidy.playback.getCurrentTlTrack().then(setCurrentTlTrack)},"event:volumeChanged":function(event){$scope.volume.pending||$scope.$apply(function(scope){scope.volume.value=event.volume})},"event:seeked":function(event){$scope.time.pending||$scope.$apply(function(scope){scope.time.value=event.time_position})}},time=$scope.time={pending:!1,value:0};time.change=function(){function update(value){mopidy.playback.seek({time_position:value}).then(function(){value===$window.parseInt(time.value)?defer.resolve():defer.notify()})}if(!time.pending){var defer=$q.defer();time.pending=!0,update($window.parseInt(time.value)),defer.promise.then(function(){$log.debug("seek done"),time.pending=!1},function(){$log.debug("seek error"),time.pending=!1},function(){$log.debug("seek pending: "+time.value),update($window.parseInt(time.value))})}},mopidy.playback.getTimePosition().then(function(value){$scope.$apply(function(scope){scope.time.position=value})});var volume=$scope.volume={pending:!1,value:0};volume.change=function(){function update(value){mopidy.playback.setVolume({volume:value}).then(function(){value===$window.parseInt(volume.value)?defer.resolve():defer.notify()})}if(!volume.pending){var defer=$q.defer();volume.pending=!0,update($window.parseInt(volume.value)),defer.promise.then(function(){$log.log("volume done"),volume.pending=!1},function(){$log.log("volume error"),volume.pending=!1},function(){$log.log("volume pending: "+volume.value),update($window.parseInt(volume.value))})}},mopidy.playback.getVolume().then(function(value){$scope.$apply(function(scope){scope.volume.value=value})}),$scope.mute=mute,$scope.options=options,$scope.state=state,$scope.tlTracks=tlTracks,$scope.track=(tlTracks.current||tlTracks.eot||{track:null}).track,$scope.interval=$interval(function(){if("playing"===$scope.state){var t=$window.parseInt($scope.time.value);Math.floor(t/1e3)%10===0?mopidy.playback.getTimePosition().then(function(value){$scope.$apply(function(scope){scope.time.value=value})}):$scope.time.value=t+1e3}},1e3),$scope.play=function(){mopidy.playback.play()},$scope.pause=function(){mopidy.playback.pause()},$scope.stop=function(){mopidy.playback.stop()},$scope.next=function(){var state=$scope.state;mopidy.playback.next().then(function(){"stopped"===state&&mopidy.playback.getCurrentTlTrack().then(setCurrentTlTrack)})},$scope.previous=function(){var state=$scope.state;mopidy.playback.previous().then(function(){"stopped"===state&&mopidy.playback.getCurrentTlTrack().then(setCurrentTlTrack)})},$scope.setMute=function(mute){mopidy.playback.setMute({value:mute})},$scope.setOptions=function(params){mopidy.tracklist.setOptions(params)},$scope.getImageURI=function(track){return track&&track.album&&track.album.images&&track.album.images.length?mopidy.resolveURI(track.album.images[0]):""},$scope.$on("$destroy",function(){angular.forEach(handlers,function(listener,event){mopidy.off(event,listener)}),$interval.cancel($scope.interval)}),angular.forEach(handlers,function(listener,event){mopidy.on(event,listener)})});var trackActions={add:function(mopidy,uri){mopidy.tracklist.add({uri:uri})},"add+play":function(mopidy,uri){mopidy.tracklist.add({uri:uri}).then(function(tlTracks){mopidy.playback.play({tl_track:tlTracks[0]})})}};angular.module("app.playlists",["ionic","app.services"]).config(function($stateProvider){$stateProvider.state("tabs.playlists",{"abstract":!0,url:"/playlists",views:{playlists:{template:"<ion-nav-view></ion-nav-view>"}}}).state("tabs.playlists.root",{url:"",controller:"PlaylistsCtrl",templateUrl:"templates/playlists.html",resolve:{mopidy:function(Mopidy){return Mopidy()},playlists:function(Mopidy){return Mopidy(function(mopidy){return mopidy.playlists.getPlaylists()})}}}).state("tabs.playlists.playlist",{url:"/{uri}",controller:"PlaylistCtrl",templateUrl:"templates/playlist.html",resolve:{mopidy:function(Mopidy){return Mopidy()},playlist:function($stateParams,Mopidy){return Mopidy(function(mopidy){return mopidy.playlists.lookup({uri:$stateParams.uri})})}}})}).controller("PlaylistsCtrl",function($scope,$log,mopidy,playlists){var handlers={"event:playlistChanged":function(playlist){$log.log("playlistChanged: "+playlist.name)},"event:playlistsLoaded":function(){mopidy.playlists.getPlaylists().then(function(playlists){$scope.$apply(function(scope){scope.playlists=playlists})})}};$scope.playlists=playlists,$scope.refresh=function(){mopidy.playlists.refresh({uri_scheme:null}).then(function(){$scope.$broadcast("scroll.refreshComplete")})},$scope.$on("$destroy",function(){angular.forEach(handlers,function(listener,event){mopidy.off(event,listener)})}),angular.forEach(handlers,function(listener,event){mopidy.on(event,listener)})}).controller("PlaylistCtrl",function($scope,$ionicPopover,Config,mopidy,playlist){$ionicPopover.fromTemplateUrl("templates/playlist.popover.html",{scope:$scope}).then(function(popover){$scope.popover=popover}),$scope.playlist=playlist,$scope.add=function(){mopidy.tracklist.add({tracks:angular.copy(playlist.tracks)})},$scope.play=function(track){track?trackActions[Config.get("action","add+play")](mopidy,track.uri):mopidy.tracklist.add({tracks:angular.copy(playlist.tracks)}).then(function(tlTracks){mopidy.playback.play({tl_track:tlTracks[0]})})},$scope.replace=function(){mopidy.tracklist.clear().then(function(){return mopidy.tracklist.add({tracks:angular.copy(playlist.tracks)})}).then(function(tlTracks){mopidy.playback.play({tl_track:tlTracks[0]})})}}),angular.module("app.services",[]).provider("Config",function(){var provider=this;provider.get=function(key,defaultValue){return key in window.localStorage?window.localStorage[key]:defaultValue},provider.set=function(key,value){window.localStorage[key]=value},provider.$get=function(){return provider}}).provider("Mopidy",function(){var provider=this,settings={autoConnect:!1,callingConvention:"by-position-or-by-name"},isUriRefRegExp=/^\//;provider.settings={backoffDelayMin:function(value){settings.backoffDelayMin=value},backoffDelayMax:function(value){settings.backoffDelayMax=value},webSocketUrl:function(value){settings.webSocketUrl=value}},provider.isWebExtension=function(){for(var scripts=window.document.scripts,i=0;i!=scripts.length;++i)if(/\/mopidy\/mopidy\.(min\.)?js$/.test(scripts[i].src||""))return!0;return!1},provider.$get=function($q,$log,$ionicLoading){var mopidy=new Mopidy(settings),pending={};mopidy.on($log.debug.bind($log)),mopidy.on("websocket:outgoingMessage",function(event){$ionicLoading.show(),pending[event.id]=event}),mopidy.on("websocket:incomingMessage",function(event){var data=angular.fromJson(event.data);data.id in pending&&(delete pending[data.id],$ionicLoading.hide())});var promise=$q(function(resolve){mopidy.once("state:online",function(){function makeObject(keys,values){for(var obj={},i=0,length=keys.length;i!==length;++i)obj[keys[i]]=values[i];return obj}var all=mopidy.getVersion().__proto__.constructor.all;angular.extend(mopidy,{all:all,join:function(){return all(arguments)},resolveURI:function(uri){if(settings.webSocketUrl&&isUriRefRegExp.test(uri)){var match=/^ws:\/\/([^\/]+)/.exec(settings.webSocketUrl);return"http://"+match[1]+uri}return uri}}),angular.extend(mopidy.tracklist,{tracks:function(params){return mopidy.join(mopidy.tracklist.eotTrack(params),mopidy.tracklist.nextTrack(params),mopidy.tracklist.previousTrack(params)).then(function(results){return makeObject(["eot","next","previous"],results)})},getOptions:function(){return mopidy.join(mopidy.tracklist.getConsume(),mopidy.tracklist.getRandom(),mopidy.tracklist.getRepeat(),mopidy.tracklist.getSingle()).then(function(results){return makeObject(["consume","random","repeat","single"],results)})},setOptions:function(params){var promises=[];return"consume"in params&&promises.push(mopidy.tracklist.setConsume({value:params.consume})),"random"in params&&promises.push(mopidy.tracklist.setRandom({value:params.random})),"repeat"in params&&promises.push(mopidy.tracklist.setRepeat({value:params.repeat})),"single"in params&&promises.push(mopidy.tracklist.setSingle({value:params.single})),mopidy.all(promises)}}),resolve(mopidy)}),mopidy.connect()}),factory=function(callback){if(callback){var defer=$q.defer();return promise.then(function(mopidy){callback(mopidy).then(function(result){$log.log("Mopidy deferred result",result),defer.resolve(result)})}),defer.promise}return promise};return factory}}),angular.module("app.settings",["ionic","app.services"]).config(function($stateProvider){$stateProvider.state("tabs.settings",{url:"/settings",views:{settings:{templateUrl:"templates/settings.html",controller:"SettingsCtrl"}}})}).controller("SettingsCtrl",function($scope,$state,$log,$ionicHistory,$translate,Config,locales){var link=angular.element(document.getElementById("theme"));$scope.locales=locales,$scope.settings={locale:Config.get("language","en"),theme:Config.get("theme","ionic"),action:Config.get("action","add+play")},$log.log("locale",$scope.settings.locale),$log.log("theme",$scope.settings.theme,link.attr("href")),$scope.$watch("settings.locale",function(value){$log.log("New locale: "+value),Config.set("locale",value),$translate.use(value)}),$scope.$watch("settings.theme",function(value){$log.log("New theme: "+value),Config.set("theme",value),link.attr("href","css/"+value+".min.css"),$state.go($state.current,{},{reload:!0})}),$scope.$watch("settings.action",function(value){$log.log("New action: "+value),Config.set("action",value)})}),angular.module("app.tracklist",["ionic","app.services"]).config(function($stateProvider){$stateProvider.state("tabs.tracklist",{url:"/tracklist",views:{tracklist:{templateUrl:"templates/tracklist.html",controller:"TracklistCtrl",resolve:{mopidy:function(Mopidy){return Mopidy()},currentTlTrack:function(Mopidy){return Mopidy(function(mopidy){return mopidy.playback.getCurrentTlTrack()})},options:function(Mopidy){return Mopidy(function(mopidy){return mopidy.tracklist.getOptions()})},tlTracks:function(Mopidy){return Mopidy(function(mopidy){return mopidy.tracklist.getTlTracks()})}}}}})}).controller("TracklistCtrl",function($scope,$log,$ionicPopover,$ionicPopup,mopidy,currentTlTrack,options,tlTracks){var handlers={"event:optionsChanged":function(){mopidy.tracklist.getOptions().then(function(options){$scope.$apply(function(scope){scope.options=options})})},"event:trackPlaybackEnded":function(event){$scope.$apply(function(scope){scope.currentTlTrack=event.tl_track})},"event:trackPlaybackPaused":function(event){$scope.$apply(function(scope){scope.currentTlTrack=event.tl_track})},"event:trackPlaybackResumed":function(event){$scope.$apply(function(scope){scope.currentTlTrack=event.tl_track})},"event:trackPlaybackStarted":function(event){$scope.$apply(function(scope){scope.currentTlTrack=event.tl_track})},"event:tracklistChanged":function(){mopidy.join(mopidy.playback.getCurrentTlTrack(),mopidy.tracklist.getTlTracks()).then(function(results){$scope.$apply(function(scope){scope.currentTlTrack=results[0],scope.tlTracks=results[1]})})}};$ionicPopover.fromTemplateUrl("templates/tracklist.popover.html",{scope:$scope}).then(function(popover){$scope.popover=popover}),$scope.currentTlTrack=currentTlTrack,$scope.options=options,$scope.tlTracks=tlTracks,$scope.clear=function(){$ionicPopup.confirm({title:"Clear Tracklist",okText:"OK",cancelText:"Cancel"}).then(function(result){result&&mopidy.tracklist.clear()})},$scope.getTracks=function(){for(var tracks=[],tlTracks=$scope.tlTracks,i=0,length=tlTracks.length;i!==length;++i)tracks.push(tlTracks[i].track);return tracks},$scope.index=function(tlTrack){for(var tlid=tlTrack.tlid,tlTracks=$scope.tlTracks,i=0,length=tlTracks.length;i!==length;++i)if(tlTracks[i].tlid===tlid)return i;return-1},$scope.play=function(tlTrack){mopidy.playback.play({tl_track:angular.copy(tlTrack)})},$scope.remove=function(tlTrack){mopidy.tracklist.remove({criteria:{tlid:[tlTrack.tlid]}})},$scope.save=function(){$ionicPopup.prompt({title:"Playlist Name",okText:"OK",cancelText:"Cancel"}).then(function(name){name&&mopidy.playlists.create({name:name}).then(function(playlist){return playlist.tracks=$scope.getTracks(),mopidy.playlists.save({playlist:playlist})}).then(function(playlist){$ionicPopup.alert({title:"Playlist "+playlist.name+" saved",okText:"OK"})},function(error){$ionicPopup.alert({title:"Error saving playlist",subTitle:error.message,okText:"OK"})})})},$scope.setOptions=function(params){mopidy.tracklist.setOptions(params)},$scope.getImageURI=function(track){return track.album&&track.album.images&&track.album.images.length?mopidy.resolveURI(track.album.images[0]):""},$scope.$on("$destroy",function(){angular.forEach(handlers,function(listener,event){mopidy.off(event,listener)}),$scope.popover.remove()}),angular.forEach(handlers,function(listener,event){mopidy.on(event,listener)})});