# Generated by Django 3.1.5 on 2021-01-25 16:52

import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('apis_entities', '0004_auto_20200722_1231'),
    ]

    operations = [
        migrations.CreateModel(
            name='IrsUser',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='auth.user')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Lemma',
            fields=[
                ('person_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='apis_entities.person')),
                ('info', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('apis_entities.person',),
        ),
        migrations.CreateModel(
            name='LemmaLabel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('color', models.CharField(default='white', max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='LemmaStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('irsuser_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='oebl_irs_workflow.irsuser')),
                ('address', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('oebl_irs_workflow.irsuser',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Editor',
            fields=[
                ('irsuser_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='oebl_irs_workflow.irsuser')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('oebl_irs_workflow.irsuser',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='LemmaNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now=True)),
                ('text', models.TextField()),
                ('lemma', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oebl_irs_workflow.lemma')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oebl_irs_workflow.irsuser')),
            ],
        ),
        migrations.CreateModel(
            name='Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('pubDate', models.DateField(blank=True, null=True, verbose_name='Publication Date')),
                ('statuses_allowed', models.ManyToManyField(to='oebl_irs_workflow.LemmaStatus')),
            ],
        ),
        migrations.CreateModel(
            name='IssueLemma',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(default=1)),
                ('created', models.DateTimeField(auto_now=True)),
                ('serialization', models.JSONField(blank=True, null=True)),
                ('issue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='oebl_irs_workflow.issue')),
                ('labels', models.ManyToManyField(blank=True, to='oebl_irs_workflow.LemmaLabel')),
                ('lemma', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='oebl_irs_workflow.lemma')),
                ('status', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='oebl_irs_workflow.lemmastatus')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='oebl_irs_workflow.author')),
                ('editor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='oebl_irs_workflow.editor')),
            ],
        ),
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contract', models.FilePathField()),
                ('issued', models.DateField()),
                ('lemma', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oebl_irs_workflow.lemma')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oebl_irs_workflow.author')),
            ],
        ),
    ]
