#  type: ignore
from collections.abc import Callable

type void = None
if __package__ or "." in __name__:
    from . import _obspython
else:
    import _obspython
try:
    import builtins as __builtin__
except ImportError:
    pass

def _swig_repr(self): ...
def _swig_setattr_nondynamic_instance_variable(set): ...
def _swig_setattr_nondynamic_class_variable(set): ...
def _swig_add_metaclass(metaclass): ...

class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""

    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)

GS_MAX_TEXTURES = _obspython.GS_MAX_TEXTURES
GS_POINTS = _obspython.GS_POINTS
GS_LINES = _obspython.GS_LINES
GS_LINESTRIP = _obspython.GS_LINESTRIP
GS_TRIS = _obspython.GS_TRIS
GS_TRISTRIP = _obspython.GS_TRISTRIP
GS_UNKNOWN = _obspython.GS_UNKNOWN
GS_A8 = _obspython.GS_A8
GS_R8 = _obspython.GS_R8
GS_RGBA = _obspython.GS_RGBA
GS_BGRX = _obspython.GS_BGRX
GS_BGRA = _obspython.GS_BGRA
GS_R10G10B10A2 = _obspython.GS_R10G10B10A2
GS_RGBA16 = _obspython.GS_RGBA16
GS_R16 = _obspython.GS_R16
GS_RGBA16F = _obspython.GS_RGBA16F
GS_RGBA32F = _obspython.GS_RGBA32F
GS_RG16F = _obspython.GS_RG16F
GS_RG32F = _obspython.GS_RG32F
GS_R16F = _obspython.GS_R16F
GS_R32F = _obspython.GS_R32F
GS_DXT1 = _obspython.GS_DXT1
GS_DXT3 = _obspython.GS_DXT3
GS_DXT5 = _obspython.GS_DXT5
GS_R8G8 = _obspython.GS_R8G8
GS_RGBA_UNORM = _obspython.GS_RGBA_UNORM
GS_BGRX_UNORM = _obspython.GS_BGRX_UNORM
GS_BGRA_UNORM = _obspython.GS_BGRA_UNORM
GS_RG16 = _obspython.GS_RG16
GS_CS_SRGB = _obspython.GS_CS_SRGB
GS_CS_SRGB_16F = _obspython.GS_CS_SRGB_16F
GS_CS_709_EXTENDED = _obspython.GS_CS_709_EXTENDED
GS_CS_709_SCRGB = _obspython.GS_CS_709_SCRGB
GS_ZS_NONE = _obspython.GS_ZS_NONE
GS_Z16 = _obspython.GS_Z16
GS_Z24_S8 = _obspython.GS_Z24_S8
GS_Z32F = _obspython.GS_Z32F
GS_Z32F_S8X24 = _obspython.GS_Z32F_S8X24
GS_UNSIGNED_SHORT = _obspython.GS_UNSIGNED_SHORT
GS_UNSIGNED_LONG = _obspython.GS_UNSIGNED_LONG
GS_BACK = _obspython.GS_BACK
GS_FRONT = _obspython.GS_FRONT
GS_NEITHER = _obspython.GS_NEITHER
GS_BLEND_ZERO = _obspython.GS_BLEND_ZERO
GS_BLEND_ONE = _obspython.GS_BLEND_ONE
GS_BLEND_SRCCOLOR = _obspython.GS_BLEND_SRCCOLOR
GS_BLEND_INVSRCCOLOR = _obspython.GS_BLEND_INVSRCCOLOR
GS_BLEND_SRCALPHA = _obspython.GS_BLEND_SRCALPHA
GS_BLEND_INVSRCALPHA = _obspython.GS_BLEND_INVSRCALPHA
GS_BLEND_DSTCOLOR = _obspython.GS_BLEND_DSTCOLOR
GS_BLEND_INVDSTCOLOR = _obspython.GS_BLEND_INVDSTCOLOR
GS_BLEND_DSTALPHA = _obspython.GS_BLEND_DSTALPHA
GS_BLEND_INVDSTALPHA = _obspython.GS_BLEND_INVDSTALPHA
GS_BLEND_SRCALPHASAT = _obspython.GS_BLEND_SRCALPHASAT
GS_BLEND_OP_ADD = _obspython.GS_BLEND_OP_ADD
GS_BLEND_OP_SUBTRACT = _obspython.GS_BLEND_OP_SUBTRACT
GS_BLEND_OP_REVERSE_SUBTRACT = _obspython.GS_BLEND_OP_REVERSE_SUBTRACT
GS_BLEND_OP_MIN = _obspython.GS_BLEND_OP_MIN
GS_BLEND_OP_MAX = _obspython.GS_BLEND_OP_MAX
GS_NEVER = _obspython.GS_NEVER
GS_LESS = _obspython.GS_LESS
GS_LEQUAL = _obspython.GS_LEQUAL
GS_EQUAL = _obspython.GS_EQUAL
GS_GEQUAL = _obspython.GS_GEQUAL
GS_GREATER = _obspython.GS_GREATER
GS_NOTEQUAL = _obspython.GS_NOTEQUAL
GS_ALWAYS = _obspython.GS_ALWAYS
GS_STENCIL_FRONT = _obspython.GS_STENCIL_FRONT
GS_STENCIL_BACK = _obspython.GS_STENCIL_BACK
GS_STENCIL_BOTH = _obspython.GS_STENCIL_BOTH
GS_KEEP = _obspython.GS_KEEP
GS_ZERO = _obspython.GS_ZERO
GS_REPLACE = _obspython.GS_REPLACE
GS_INCR = _obspython.GS_INCR
GS_DECR = _obspython.GS_DECR
GS_INVERT = _obspython.GS_INVERT
GS_POSITIVE_X = _obspython.GS_POSITIVE_X
GS_NEGATIVE_X = _obspython.GS_NEGATIVE_X
GS_POSITIVE_Y = _obspython.GS_POSITIVE_Y
GS_NEGATIVE_Y = _obspython.GS_NEGATIVE_Y
GS_POSITIVE_Z = _obspython.GS_POSITIVE_Z
GS_NEGATIVE_Z = _obspython.GS_NEGATIVE_Z
GS_FILTER_POINT = _obspython.GS_FILTER_POINT
GS_FILTER_LINEAR = _obspython.GS_FILTER_LINEAR
GS_FILTER_ANISOTROPIC = _obspython.GS_FILTER_ANISOTROPIC
GS_FILTER_MIN_MAG_POINT_MIP_LINEAR = _obspython.GS_FILTER_MIN_MAG_POINT_MIP_LINEAR
GS_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = (
    _obspython.GS_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT
)
GS_FILTER_MIN_POINT_MAG_MIP_LINEAR = _obspython.GS_FILTER_MIN_POINT_MAG_MIP_LINEAR
GS_FILTER_MIN_LINEAR_MAG_MIP_POINT = _obspython.GS_FILTER_MIN_LINEAR_MAG_MIP_POINT
GS_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = (
    _obspython.GS_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR
)
GS_FILTER_MIN_MAG_LINEAR_MIP_POINT = _obspython.GS_FILTER_MIN_MAG_LINEAR_MIP_POINT
GS_ADDRESS_CLAMP = _obspython.GS_ADDRESS_CLAMP
GS_ADDRESS_WRAP = _obspython.GS_ADDRESS_WRAP
GS_ADDRESS_MIRROR = _obspython.GS_ADDRESS_MIRROR
GS_ADDRESS_BORDER = _obspython.GS_ADDRESS_BORDER
GS_ADDRESS_MIRRORONCE = _obspython.GS_ADDRESS_MIRRORONCE
GS_TEXTURE_2D = _obspython.GS_TEXTURE_2D
GS_TEXTURE_3D = _obspython.GS_TEXTURE_3D
GS_TEXTURE_CUBE = _obspython.GS_TEXTURE_CUBE

class gs_device_loss:
    """Proxy of C gs_device_loss struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    device_loss_release: "void (*)(void *)" = property(
        _obspython.gs_device_loss_device_loss_release_get,
        _obspython.gs_device_loss_device_loss_release_set,
        doc="device_loss_release",
    )
    device_loss_rebuild: "void (*)(void *,void *)" = property(
        _obspython.gs_device_loss_device_loss_rebuild_get,
        _obspython.gs_device_loss_device_loss_rebuild_set,
        doc="device_loss_rebuild",
    )
    data: "void *" = property(
        _obspython.gs_device_loss_data_get,
        _obspython.gs_device_loss_data_set,
        doc="data",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_device_loss

_obspython.gs_device_loss_swigregister(gs_device_loss)

class gs_monitor_info:
    """Proxy of C gs_monitor_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    rotation_degrees: int = property(
        _obspython.gs_monitor_info_rotation_degrees_get,
        _obspython.gs_monitor_info_rotation_degrees_set,
        doc="rotation_degrees",
    )
    x: long = property(
        _obspython.gs_monitor_info_x_get, _obspython.gs_monitor_info_x_set, doc="x"
    )
    y: long = property(
        _obspython.gs_monitor_info_y_get, _obspython.gs_monitor_info_y_set, doc="y"
    )
    cx: long = property(
        _obspython.gs_monitor_info_cx_get, _obspython.gs_monitor_info_cx_set, doc="cx"
    )
    cy: long = property(
        _obspython.gs_monitor_info_cy_get, _obspython.gs_monitor_info_cy_set, doc="cy"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_monitor_info

_obspython.gs_monitor_info_swigregister(gs_monitor_info)

class gs_tvertarray:
    """Proxy of C gs_tvertarray struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    width: size_t = property(
        _obspython.gs_tvertarray_width_get,
        _obspython.gs_tvertarray_width_set,
        doc="width",
    )
    array: "void *" = property(
        _obspython.gs_tvertarray_array_get,
        _obspython.gs_tvertarray_array_set,
        doc="array",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_tvertarray

_obspython.gs_tvertarray_swigregister(gs_tvertarray)

class gs_vb_data:
    """Proxy of C gs_vb_data struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    num: size_t = property(
        _obspython.gs_vb_data_num_get, _obspython.gs_vb_data_num_set, doc="num"
    )
    points: "struct vec3 *" = property(
        _obspython.gs_vb_data_points_get, _obspython.gs_vb_data_points_set, doc="points"
    )
    normals: "struct vec3 *" = property(
        _obspython.gs_vb_data_normals_get,
        _obspython.gs_vb_data_normals_set,
        doc="normals",
    )
    tangents: "struct vec3 *" = property(
        _obspython.gs_vb_data_tangents_get,
        _obspython.gs_vb_data_tangents_set,
        doc="tangents",
    )
    colors: "uint32_t *" = property(
        _obspython.gs_vb_data_colors_get, _obspython.gs_vb_data_colors_set, doc="colors"
    )
    num_tex: size_t = property(
        _obspython.gs_vb_data_num_tex_get,
        _obspython.gs_vb_data_num_tex_set,
        doc="num_tex",
    )
    tvarray: "struct gs_tvertarray *" = property(
        _obspython.gs_vb_data_tvarray_get,
        _obspython.gs_vb_data_tvarray_set,
        doc="tvarray",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_vb_data

_obspython.gs_vb_data_swigregister(gs_vb_data)

def gs_vbdata_create() -> "struct gs_vb_data *": ...
def gs_vbdata_destroy(data: gs_vb_data) -> void: ...

class gs_sampler_info:
    """Proxy of C gs_sampler_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    filter: "enum gs_sample_filter" = property(
        _obspython.gs_sampler_info_filter_get,
        _obspython.gs_sampler_info_filter_set,
        doc="filter",
    )
    address_u: "enum gs_address_mode" = property(
        _obspython.gs_sampler_info_address_u_get,
        _obspython.gs_sampler_info_address_u_set,
        doc="address_u",
    )
    address_v: "enum gs_address_mode" = property(
        _obspython.gs_sampler_info_address_v_get,
        _obspython.gs_sampler_info_address_v_set,
        doc="address_v",
    )
    address_w: "enum gs_address_mode" = property(
        _obspython.gs_sampler_info_address_w_get,
        _obspython.gs_sampler_info_address_w_set,
        doc="address_w",
    )
    max_anisotropy: int = property(
        _obspython.gs_sampler_info_max_anisotropy_get,
        _obspython.gs_sampler_info_max_anisotropy_set,
        doc="max_anisotropy",
    )
    border_color: uint32_t = property(
        _obspython.gs_sampler_info_border_color_get,
        _obspython.gs_sampler_info_border_color_set,
        doc="border_color",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_sampler_info

_obspython.gs_sampler_info_swigregister(gs_sampler_info)

class gs_display_mode:
    """Proxy of C gs_display_mode struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    width: uint32_t = property(
        _obspython.gs_display_mode_width_get,
        _obspython.gs_display_mode_width_set,
        doc="width",
    )
    height: uint32_t = property(
        _obspython.gs_display_mode_height_get,
        _obspython.gs_display_mode_height_set,
        doc="height",
    )
    bits: uint32_t = property(
        _obspython.gs_display_mode_bits_get,
        _obspython.gs_display_mode_bits_set,
        doc="bits",
    )
    freq: uint32_t = property(
        _obspython.gs_display_mode_freq_get,
        _obspython.gs_display_mode_freq_set,
        doc="freq",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_display_mode

_obspython.gs_display_mode_swigregister(gs_display_mode)

class gs_rect:
    """Proxy of C gs_rect struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: int = property(_obspython.gs_rect_x_get, _obspython.gs_rect_x_set, doc="x")
    y: int = property(_obspython.gs_rect_y_get, _obspython.gs_rect_y_set, doc="y")
    cx: int = property(_obspython.gs_rect_cx_get, _obspython.gs_rect_cx_set, doc="cx")
    cy: int = property(_obspython.gs_rect_cy_get, _obspython.gs_rect_cy_set, doc="cy")

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_rect

_obspython.gs_rect_swigregister(gs_rect)
GS_SHADER_PARAM_UNKNOWN = _obspython.GS_SHADER_PARAM_UNKNOWN
GS_SHADER_PARAM_BOOL = _obspython.GS_SHADER_PARAM_BOOL
GS_SHADER_PARAM_FLOAT = _obspython.GS_SHADER_PARAM_FLOAT
GS_SHADER_PARAM_INT = _obspython.GS_SHADER_PARAM_INT
GS_SHADER_PARAM_STRING = _obspython.GS_SHADER_PARAM_STRING
GS_SHADER_PARAM_VEC2 = _obspython.GS_SHADER_PARAM_VEC2
GS_SHADER_PARAM_VEC3 = _obspython.GS_SHADER_PARAM_VEC3
GS_SHADER_PARAM_VEC4 = _obspython.GS_SHADER_PARAM_VEC4
GS_SHADER_PARAM_INT2 = _obspython.GS_SHADER_PARAM_INT2
GS_SHADER_PARAM_INT3 = _obspython.GS_SHADER_PARAM_INT3
GS_SHADER_PARAM_INT4 = _obspython.GS_SHADER_PARAM_INT4
GS_SHADER_PARAM_MATRIX4X4 = _obspython.GS_SHADER_PARAM_MATRIX4X4
GS_SHADER_PARAM_TEXTURE = _obspython.GS_SHADER_PARAM_TEXTURE

class gs_shader_texture:
    """Proxy of C gs_shader_texture struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    tex: "gs_texture_t *" = property(
        _obspython.gs_shader_texture_tex_get,
        _obspython.gs_shader_texture_tex_set,
        doc="tex",
    )
    srgb: bool = property(
        _obspython.gs_shader_texture_srgb_get,
        _obspython.gs_shader_texture_srgb_set,
        doc="srgb",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_shader_texture

_obspython.gs_shader_texture_swigregister(gs_shader_texture)

def gs_effect_destroy(effect: "gs_effect_t *") -> void: ...
def gs_effect_get_technique(
    effect: "gs_effect_t const *", name: "char const *"
) -> "gs_technique_t *": ...
def gs_effect_get_current_technique(
    effect: "gs_effect_t const *",
) -> "gs_technique_t *": ...
def gs_technique_begin(technique: "gs_technique_t *") -> size_t: ...
def gs_technique_end(technique: "gs_technique_t *") -> void: ...
def gs_technique_begin_pass(technique: "gs_technique_t *", _pass: size_t) -> bool: ...
def gs_technique_begin_pass_by_name(
    technique: "gs_technique_t *", name: "char const *"
) -> bool: ...
def gs_technique_end_pass(technique: "gs_technique_t *") -> void: ...
def gs_technique_get_pass_by_idx(
    technique: "gs_technique_t const *", _pass: size_t
) -> "gs_epass_t *": ...
def gs_technique_get_pass_by_name(
    technique: "gs_technique_t const *", name: "char const *"
) -> "gs_epass_t *": ...
def gs_effect_get_num_params(effect: "gs_effect_t const *") -> size_t: ...
def gs_effect_get_param_by_idx(
    effect: "gs_effect_t const *", param: size_t
) -> "gs_eparam_t *": ...
def gs_effect_get_param_by_name(
    effect: "gs_effect_t const *", name: "char const *"
) -> "gs_eparam_t *": ...
def gs_param_get_num_annotations(param: "gs_eparam_t const *") -> size_t: ...
def gs_param_get_annotation_by_idx(
    param: "gs_eparam_t const *", annotation: size_t
) -> "gs_eparam_t *": ...
def gs_param_get_annotation_by_name(
    param: "gs_eparam_t const *", name: "char const *"
) -> "gs_eparam_t *": ...
def gs_effect_loop(effect: "gs_effect_t *", name: "char const *") -> bool: ...
def gs_effect_update_params(effect: "gs_effect_t *") -> void: ...
def gs_effect_get_viewproj_matrix(effect: "gs_effect_t const *") -> "gs_eparam_t *": ...
def gs_effect_get_world_matrix(effect: "gs_effect_t const *") -> "gs_eparam_t *": ...
def gs_effect_set_bool(param: "gs_eparam_t *", val: bool) -> void: ...
def gs_effect_set_float(param: "gs_eparam_t *", val: float) -> void: ...
def gs_effect_set_int(param: "gs_eparam_t *", val: int) -> void: ...
def gs_effect_set_matrix4(param: "gs_eparam_t *", val: matrix4) -> void: ...
def gs_effect_set_vec2(param: "gs_eparam_t *", val: vec2) -> void: ...
def gs_effect_set_vec3(param: "gs_eparam_t *", val: vec3) -> void: ...
def gs_effect_set_vec4(param: "gs_eparam_t *", val: vec4) -> void: ...
def gs_effect_set_texture(param: "gs_eparam_t *", val: "gs_texture_t *") -> void: ...
def gs_effect_set_texture_srgb(
    param: "gs_eparam_t *", val: "gs_texture_t *"
) -> void: ...
def gs_effect_set_val(
    param: "gs_eparam_t *", val: "void const *", size: size_t
) -> void: ...
def gs_effect_set_default(param: "gs_eparam_t *") -> void: ...
def gs_effect_get_val_size(param: "gs_eparam_t *") -> size_t: ...
def gs_effect_get_val(param: "gs_eparam_t *") -> "void *": ...
def gs_effect_get_default_val_size(param: "gs_eparam_t *") -> size_t: ...
def gs_effect_get_default_val(param: "gs_eparam_t *") -> "void *": ...
def gs_effect_set_next_sampler(
    param: "gs_eparam_t *", sampler: "gs_samplerstate_t *"
) -> void: ...
def gs_effect_set_color(param: "gs_eparam_t *", argb: uint32_t) -> void: ...
def gs_texrender_create(
    format: "enum gs_color_format", zsformat: "enum gs_zstencil_format"
) -> "gs_texrender_t *": ...
def gs_texrender_destroy(texrender: "gs_texrender_t *") -> void: ...
def gs_texrender_begin(
    texrender: "gs_texrender_t *", cx: uint32_t, cy: uint32_t
) -> bool: ...
def gs_texrender_begin_with_color_space(
    texrender: "gs_texrender_t *",
    cx: uint32_t,
    cy: uint32_t,
    space: "enum gs_color_space",
) -> bool: ...
def gs_texrender_end(texrender: "gs_texrender_t *") -> void: ...
def gs_texrender_reset(texrender: "gs_texrender_t *") -> void: ...
def gs_texrender_get_texture(
    texrender: "gs_texrender_t const *",
) -> "gs_texture_t *": ...
def gs_texrender_get_format(
    texrender: "gs_texrender_t const *",
) -> "enum gs_color_format": ...

GS_BUILD_MIPMAPS = _obspython.GS_BUILD_MIPMAPS
GS_DYNAMIC = _obspython.GS_DYNAMIC
GS_RENDER_TARGET = _obspython.GS_RENDER_TARGET
GS_GL_DUMMYTEX = _obspython.GS_GL_DUMMYTEX
GS_DUP_BUFFER = _obspython.GS_DUP_BUFFER
GS_SHARED_TEX = _obspython.GS_SHARED_TEX
GS_SHARED_KM_TEX = _obspython.GS_SHARED_KM_TEX
GS_SUCCESS = _obspython.GS_SUCCESS
GS_ERROR_FAIL = _obspython.GS_ERROR_FAIL
GS_ERROR_MODULE_NOT_FOUND = _obspython.GS_ERROR_MODULE_NOT_FOUND
GS_ERROR_NOT_SUPPORTED = _obspython.GS_ERROR_NOT_SUPPORTED

class gs_window:
    """Proxy of C gs_window struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_window

_obspython.gs_window_swigregister(gs_window)

class gs_init_data:
    """Proxy of C gs_init_data struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    window: "struct gs_window" = property(
        _obspython.gs_init_data_window_get,
        _obspython.gs_init_data_window_set,
        doc="window",
    )
    cx: uint32_t = property(
        _obspython.gs_init_data_cx_get, _obspython.gs_init_data_cx_set, doc="cx"
    )
    cy: uint32_t = property(
        _obspython.gs_init_data_cy_get, _obspython.gs_init_data_cy_set, doc="cy"
    )
    num_backbuffers: uint32_t = property(
        _obspython.gs_init_data_num_backbuffers_get,
        _obspython.gs_init_data_num_backbuffers_set,
        doc="num_backbuffers",
    )
    format: "enum gs_color_format" = property(
        _obspython.gs_init_data_format_get,
        _obspython.gs_init_data_format_set,
        doc="format",
    )
    zsformat: "enum gs_zstencil_format" = property(
        _obspython.gs_init_data_zsformat_get,
        _obspython.gs_init_data_zsformat_set,
        doc="zsformat",
    )
    adapter: uint32_t = property(
        _obspython.gs_init_data_adapter_get,
        _obspython.gs_init_data_adapter_set,
        doc="adapter",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_gs_init_data

_obspython.gs_init_data_swigregister(gs_init_data)
GS_DEVICE_OPENGL = _obspython.GS_DEVICE_OPENGL
GS_DEVICE_DIRECT3D_11 = _obspython.GS_DEVICE_DIRECT3D_11

def gs_get_device_name() -> "char const *": ...
def gs_get_device_type() -> int: ...
def gs_get_adapter_count() -> uint32_t: ...
def gs_enum_adapters(
    callback: "bool (*)(void *,char const *,uint32_t)", param: "void *"
) -> void: ...
def gs_create(
    graphics: "graphics_t **", module: "char const *", adapter: uint32_t
) -> int: ...
def gs_destroy(graphics: "graphics_t *") -> void: ...
def gs_enter_context(graphics: "graphics_t *") -> void: ...
def gs_leave_context() -> void: ...
def gs_get_context() -> "graphics_t *": ...
def gs_get_device_obj() -> "void *": ...
def gs_matrix_push() -> void: ...
def gs_matrix_pop() -> void: ...
def gs_matrix_identity() -> void: ...
def gs_matrix_transpose() -> void: ...
def gs_matrix_set(matrix: matrix4) -> void: ...
def gs_matrix_get(dst: matrix4) -> void: ...
def gs_matrix_mul(matrix: matrix4) -> void: ...
def gs_matrix_rotquat(rot: quat) -> void: ...
def gs_matrix_rotaa(rot: "struct axisang const *") -> void: ...
def gs_matrix_translate(pos: vec3) -> void: ...
def gs_matrix_scale(scale: vec3) -> void: ...
def gs_matrix_rotaa4f(x: float, y: float, z: float, angle: float) -> void: ...
def gs_matrix_translate3f(x: float, y: float, z: float) -> void: ...
def gs_matrix_scale3f(x: float, y: float, z: float) -> void: ...
def gs_render_start(b_new: bool) -> void: ...
def gs_render_stop(mode: "enum gs_draw_mode") -> void: ...
def gs_render_save() -> "gs_vertbuffer_t *": ...
def gs_vertex2f(x: float, y: float) -> void: ...
def gs_vertex3f(x: float, y: float, z: float) -> void: ...
def gs_normal3f(x: float, y: float, z: float) -> void: ...
def gs_color(color: uint32_t) -> void: ...
def gs_texcoord(x: float, y: float, unit: int) -> void: ...
def gs_vertex2v(v: vec2) -> void: ...
def gs_vertex3v(v: vec3) -> void: ...
def gs_normal3v(v: vec3) -> void: ...
def gs_color4v(v: vec4) -> void: ...
def gs_texcoord2v(v: vec2, unit: int) -> void: ...
def gs_get_input() -> "input_t *": ...
def gs_get_effect() -> "gs_effect_t *": ...
def gs_effect_create_from_file(
    file: "char const *", error_string: "char **"
) -> "gs_effect_t *": ...
def gs_effect_create(
    effect_string: "char const *", filename: "char const *", error_string: "char **"
) -> "gs_effect_t *": ...
def gs_vertexshader_create_from_file(
    file: "char const *", error_string: "char **"
) -> "gs_shader_t *": ...
def gs_pixelshader_create_from_file(
    file: "char const *", error_string: "char **"
) -> "gs_shader_t *": ...

GS_IMAGE_ALPHA_STRAIGHT = _obspython.GS_IMAGE_ALPHA_STRAIGHT
GS_IMAGE_ALPHA_PREMULTIPLY_SRGB = _obspython.GS_IMAGE_ALPHA_PREMULTIPLY_SRGB
GS_IMAGE_ALPHA_PREMULTIPLY = _obspython.GS_IMAGE_ALPHA_PREMULTIPLY

def gs_texture_create_from_file(file: "char const *") -> "gs_texture_t *": ...
def gs_create_texture_file_data(
    file: "char const *",
    format: "enum gs_color_format *",
    cx: "uint32_t *",
    cy: "uint32_t *",
) -> "uint8_t *": ...
def gs_create_texture_file_data2(
    file: "char const *",
    alpha_mode: "enum gs_image_alpha_mode",
    format: "enum gs_color_format *",
    cx: "uint32_t *",
    cy: "uint32_t *",
) -> "uint8_t *": ...
def gs_create_texture_file_data3(
    file: "char const *",
    alpha_mode: "enum gs_image_alpha_mode",
    format: "enum gs_color_format *",
    cx: "uint32_t *",
    cy: "uint32_t *",
    space: "enum gs_color_space *",
) -> "uint8_t *": ...

GS_FLIP_U = _obspython.GS_FLIP_U
GS_FLIP_V = _obspython.GS_FLIP_V

def gs_draw_sprite(
    tex: "gs_texture_t *", flip: uint32_t, width: uint32_t, height: uint32_t
) -> void: ...
def gs_draw_sprite_subregion(
    tex: "gs_texture_t *",
    flip: uint32_t,
    x: uint32_t,
    y: uint32_t,
    cx: uint32_t,
    cy: uint32_t,
) -> void: ...
def gs_draw_cube_backdrop(
    cubetex: "gs_texture_t *",
    rot: quat,
    left: float,
    right: float,
    top: float,
    bottom: float,
    znear: float,
) -> void: ...
def gs_reset_viewport() -> void: ...
def gs_set_2d_mode() -> void: ...
def gs_set_3d_mode(fovy: double, znear: double, zvar: double) -> void: ...
def gs_viewport_push() -> void: ...
def gs_viewport_pop() -> void: ...
def gs_texture_set_image(
    tex: "gs_texture_t *", data: "uint8_t const *", linesize: uint32_t, invert: bool
) -> void: ...
def gs_cubetexture_set_image(
    cubetex: "gs_texture_t *",
    side: uint32_t,
    data: "void const *",
    linesize: uint32_t,
    invert: bool,
) -> void: ...
def gs_perspective(fovy: float, aspect: float, znear: float, zfar: float) -> void: ...
def gs_blend_state_push() -> void: ...
def gs_blend_state_pop() -> void: ...
def gs_reset_blend_state() -> void: ...
def gs_swapchain_create(data: gs_init_data) -> "gs_swapchain_t *": ...
def gs_resize(x: uint32_t, y: uint32_t) -> void: ...
def gs_update_color_space() -> void: ...
def gs_get_size(x: "uint32_t *", y: "uint32_t *") -> void: ...
def gs_get_width() -> uint32_t: ...
def gs_get_height() -> uint32_t: ...
def gs_texture_create(
    width: uint32_t,
    height: uint32_t,
    color_format: "enum gs_color_format",
    levels: uint32_t,
    data: "uint8_t const **",
    flags: uint32_t,
) -> "gs_texture_t *": ...
def gs_cubetexture_create(
    size: uint32_t,
    color_format: "enum gs_color_format",
    levels: uint32_t,
    data: "uint8_t const **",
    flags: uint32_t,
) -> "gs_texture_t *": ...
def gs_voltexture_create(
    width: uint32_t,
    height: uint32_t,
    depth: uint32_t,
    color_format: "enum gs_color_format",
    levels: uint32_t,
    data: "uint8_t const **",
    flags: uint32_t,
) -> "gs_texture_t *": ...
def gs_zstencil_create(
    width: uint32_t, height: uint32_t, format: "enum gs_zstencil_format"
) -> "gs_zstencil_t *": ...
def gs_stagesurface_create(
    width: uint32_t, height: uint32_t, color_format: "enum gs_color_format"
) -> "gs_stagesurf_t *": ...
def gs_samplerstate_create(info: gs_sampler_info) -> "gs_samplerstate_t *": ...
def gs_vertexshader_create(
    shader: "char const *", file: "char const *", error_string: "char **"
) -> "gs_shader_t *": ...
def gs_pixelshader_create(
    shader: "char const *", file: "char const *", error_string: "char **"
) -> "gs_shader_t *": ...
def gs_vertexbuffer_create(
    data: gs_vb_data, flags: uint32_t
) -> "gs_vertbuffer_t *": ...
def gs_indexbuffer_create(
    type: "enum gs_index_type", indices: "void *", num: size_t, flags: uint32_t
) -> "gs_indexbuffer_t *": ...
def gs_timer_create() -> "gs_timer_t *": ...
def gs_timer_range_create() -> "gs_timer_range_t *": ...
def gs_get_texture_type(texture: "gs_texture_t const *") -> "enum gs_texture_type": ...
def gs_load_vertexbuffer(vertbuffer: "gs_vertbuffer_t *") -> void: ...
def gs_load_indexbuffer(indexbuffer: "gs_indexbuffer_t *") -> void: ...
def gs_load_texture(tex: "gs_texture_t *", unit: int) -> void: ...
def gs_load_samplerstate(samplerstate: "gs_samplerstate_t *", unit: int) -> void: ...
def gs_load_vertexshader(vertshader: "gs_shader_t *") -> void: ...
def gs_load_pixelshader(pixelshader: "gs_shader_t *") -> void: ...
def gs_load_default_samplerstate(b_3d: bool, unit: int) -> void: ...
def gs_get_vertex_shader() -> "gs_shader_t *": ...
def gs_get_pixel_shader() -> "gs_shader_t *": ...
def gs_get_color_space() -> "enum gs_color_space": ...
def gs_get_render_target() -> "gs_texture_t *": ...
def gs_get_zstencil_target() -> "gs_zstencil_t *": ...
def gs_set_render_target(
    tex: "gs_texture_t *", zstencil: "gs_zstencil_t *"
) -> void: ...
def gs_set_render_target_with_color_space(
    tex: "gs_texture_t *", zstencil: "gs_zstencil_t *", space: "enum gs_color_space"
) -> void: ...
def gs_set_cube_render_target(
    cubetex: "gs_texture_t *", side: int, zstencil: "gs_zstencil_t *"
) -> void: ...
def gs_enable_framebuffer_srgb(enable: bool) -> void: ...
def gs_framebuffer_srgb_enabled() -> bool: ...
def gs_get_linear_srgb() -> bool: ...
def gs_set_linear_srgb(linear_srgb: bool) -> bool: ...
def gs_copy_texture(dst: "gs_texture_t *", src: "gs_texture_t *") -> void: ...
def gs_copy_texture_region(
    dst: "gs_texture_t *",
    dst_x: uint32_t,
    dst_y: uint32_t,
    src: "gs_texture_t *",
    src_x: uint32_t,
    src_y: uint32_t,
    src_w: uint32_t,
    src_h: uint32_t,
) -> void: ...
def gs_stage_texture(dst: "gs_stagesurf_t *", src: "gs_texture_t *") -> void: ...
def gs_begin_frame() -> void: ...
def gs_begin_scene() -> void: ...
def gs_draw(
    draw_mode: "enum gs_draw_mode", start_vert: uint32_t, num_verts: uint32_t
) -> void: ...
def gs_end_scene() -> void: ...

GS_CLEAR_COLOR = _obspython.GS_CLEAR_COLOR
GS_CLEAR_DEPTH = _obspython.GS_CLEAR_DEPTH
GS_CLEAR_STENCIL = _obspython.GS_CLEAR_STENCIL

def gs_load_swapchain(swapchain: "gs_swapchain_t *") -> void: ...
def gs_clear(
    clear_flags: uint32_t, color: vec4, depth: float, stencil: uint8_t
) -> void: ...
def gs_is_present_ready() -> bool: ...
def gs_present() -> void: ...
def gs_flush() -> void: ...
def gs_set_cull_mode(mode: "enum gs_cull_mode") -> void: ...
def gs_get_cull_mode() -> "enum gs_cull_mode": ...
def gs_enable_blending(enable: bool) -> void: ...
def gs_enable_depth_test(enable: bool) -> void: ...
def gs_enable_stencil_test(enable: bool) -> void: ...
def gs_enable_stencil_write(enable: bool) -> void: ...
def gs_enable_color(red: bool, green: bool, blue: bool, alpha: bool) -> void: ...
def gs_blend_function(
    src: "enum gs_blend_type", dest: "enum gs_blend_type"
) -> void: ...
def gs_blend_function_separate(
    src_c: "enum gs_blend_type",
    dest_c: "enum gs_blend_type",
    src_a: "enum gs_blend_type",
    dest_a: "enum gs_blend_type",
) -> void: ...
def gs_blend_op(op: "enum gs_blend_op_type") -> void: ...
def gs_depth_function(test: "enum gs_depth_test") -> void: ...
def gs_stencil_function(
    side: "enum gs_stencil_side", test: "enum gs_depth_test"
) -> void: ...
def gs_stencil_op(
    side: "enum gs_stencil_side",
    fail: "enum gs_stencil_op_type",
    zfail: "enum gs_stencil_op_type",
    zpass: "enum gs_stencil_op_type",
) -> void: ...
def gs_set_viewport(x: int, y: int, width: int, height: int) -> void: ...
def gs_get_viewport(rect: gs_rect) -> void: ...
def gs_set_scissor_rect(rect: gs_rect) -> void: ...
def gs_ortho(
    left: float, right: float, top: float, bottom: float, znear: float, zfar: float
) -> void: ...
def gs_frustum(
    left: float, right: float, top: float, bottom: float, znear: float, zfar: float
) -> void: ...
def gs_projection_push() -> void: ...
def gs_projection_pop() -> void: ...
def gs_swapchain_destroy(swapchain: "gs_swapchain_t *") -> void: ...
def gs_texture_destroy(tex: "gs_texture_t *") -> void: ...
def gs_texture_get_width(tex: "gs_texture_t const *") -> uint32_t: ...
def gs_texture_get_height(tex: "gs_texture_t const *") -> uint32_t: ...
def gs_texture_get_color_format(
    tex: "gs_texture_t const *",
) -> "enum gs_color_format": ...
def gs_texture_map(
    tex: "gs_texture_t *", ptr: "uint8_t **", linesize: "uint32_t *"
) -> bool: ...
def gs_texture_unmap(tex: "gs_texture_t *") -> void: ...
def gs_texture_is_rect(tex: "gs_texture_t const *") -> bool: ...
def gs_texture_get_obj(tex: "gs_texture_t *") -> "void *": ...
def gs_cubetexture_destroy(cubetex: "gs_texture_t *") -> void: ...
def gs_cubetexture_get_size(cubetex: "gs_texture_t const *") -> uint32_t: ...
def gs_cubetexture_get_color_format(
    cubetex: "gs_texture_t const *",
) -> "enum gs_color_format": ...
def gs_voltexture_destroy(voltex: "gs_texture_t *") -> void: ...
def gs_voltexture_get_width(voltex: "gs_texture_t const *") -> uint32_t: ...
def gs_voltexture_get_height(voltex: "gs_texture_t const *") -> uint32_t: ...
def gs_voltexture_get_depth(voltex: "gs_texture_t const *") -> uint32_t: ...
def gs_voltexture_get_color_format(
    voltex: "gs_texture_t const *",
) -> "enum gs_color_format": ...
def gs_stagesurface_destroy(stagesurf: "gs_stagesurf_t *") -> void: ...
def gs_stagesurface_get_width(stagesurf: "gs_stagesurf_t const *") -> uint32_t: ...
def gs_stagesurface_get_height(stagesurf: "gs_stagesurf_t const *") -> uint32_t: ...
def gs_stagesurface_get_color_format(
    stagesurf: "gs_stagesurf_t const *",
) -> "enum gs_color_format": ...
def gs_stagesurface_map(
    stagesurf: "gs_stagesurf_t *", data: "uint8_t **", linesize: "uint32_t *"
) -> bool: ...
def gs_stagesurface_unmap(stagesurf: "gs_stagesurf_t *") -> void: ...
def gs_zstencil_destroy(zstencil: "gs_zstencil_t *") -> void: ...
def gs_samplerstate_destroy(samplerstate: "gs_samplerstate_t *") -> void: ...
def gs_vertexbuffer_destroy(vertbuffer: "gs_vertbuffer_t *") -> void: ...
def gs_vertexbuffer_flush(vertbuffer: "gs_vertbuffer_t *") -> void: ...
def gs_vertexbuffer_flush_direct(
    vertbuffer: "gs_vertbuffer_t *", data: gs_vb_data
) -> void: ...
def gs_vertexbuffer_get_data(
    vertbuffer: "gs_vertbuffer_t const *",
) -> "struct gs_vb_data *": ...
def gs_indexbuffer_destroy(indexbuffer: "gs_indexbuffer_t *") -> void: ...
def gs_indexbuffer_flush(indexbuffer: "gs_indexbuffer_t *") -> void: ...
def gs_indexbuffer_flush_direct(
    indexbuffer: "gs_indexbuffer_t *", data: "void const *"
) -> void: ...
def gs_indexbuffer_get_data(indexbuffer: "gs_indexbuffer_t const *") -> "void *": ...
def gs_indexbuffer_get_num_indices(
    indexbuffer: "gs_indexbuffer_t const *",
) -> size_t: ...
def gs_indexbuffer_get_type(
    indexbuffer: "gs_indexbuffer_t const *",
) -> "enum gs_index_type": ...
def gs_timer_destroy(timer: "gs_timer_t *") -> void: ...
def gs_timer_begin(timer: "gs_timer_t *") -> void: ...
def gs_timer_end(timer: "gs_timer_t *") -> void: ...
def gs_timer_get_data(timer: "gs_timer_t *", ticks: "uint64_t *") -> bool: ...
def gs_timer_range_destroy(timer: "gs_timer_range_t *") -> void: ...
def gs_timer_range_begin(range: "gs_timer_range_t *") -> void: ...
def gs_timer_range_end(range: "gs_timer_range_t *") -> void: ...
def gs_timer_range_get_data(
    range: "gs_timer_range_t *", disjoint: "bool *", frequency: "uint64_t *"
) -> bool: ...
def gs_nv12_available() -> bool: ...
def gs_p010_available() -> bool: ...
def gs_texture_create_nv12(
    tex_y: "gs_texture_t **",
    tex_uv: "gs_texture_t **",
    width: uint32_t,
    height: uint32_t,
    flags: uint32_t,
) -> bool: ...
def gs_texture_create_p010(
    tex_y: "gs_texture_t **",
    tex_uv: "gs_texture_t **",
    width: uint32_t,
    height: uint32_t,
    flags: uint32_t,
) -> bool: ...
def gs_is_monitor_hdr(monitor: "void *") -> bool: ...

GS_USE_DEBUG_MARKERS = _obspython.GS_USE_DEBUG_MARKERS

def gs_debug_marker_begin(
    color: "float const [4]", markername: "char const *"
) -> void: ...
def gs_debug_marker_begin_format(*args) -> void: ...
def gs_debug_marker_end() -> void: ...
def gs_get_format_bpp(format: "enum gs_color_format") -> uint32_t: ...
def gs_is_compressed_format(format: "enum gs_color_format") -> bool: ...
def gs_is_srgb_format(format: "enum gs_color_format") -> bool: ...
def gs_generalize_format(format: "enum gs_color_format") -> "enum gs_color_format": ...
def gs_get_format_from_space(
    space: "enum gs_color_space",
) -> "enum gs_color_format": ...
def gs_get_total_levels(
    width: uint32_t, height: uint32_t, depth: uint32_t
) -> uint32_t: ...

class vec4:
    """Proxy of C vec4 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: float = property(_obspython.vec4_x_get, _obspython.vec4_x_set, doc="x")
    y: float = property(_obspython.vec4_y_get, _obspython.vec4_y_set, doc="y")
    z: float = property(_obspython.vec4_z_get, _obspython.vec4_z_set, doc="z")
    w: float = property(_obspython.vec4_w_get, _obspython.vec4_w_set, doc="w")
    ptr: float[4] = property(
        _obspython.vec4_ptr_get, _obspython.vec4_ptr_set, doc="ptr"
    )
    m: __m128 = property(_obspython.vec4_m_get, _obspython.vec4_m_set, doc="m")

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_vec4

_obspython.vec4_swigregister(vec4)

def vec4_zero(v: vec4) -> void: ...
def vec4_set(dst: vec4, x: float, y: float, z: float, w: float) -> void: ...
def vec4_copy(dst: vec4, v: vec4) -> void: ...
def vec4_from_vec3(dst: vec4, v: vec3) -> void: ...
def vec4_add(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_sub(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_mul(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_div(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_addf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_subf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_mulf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_divf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_dot(v1: vec4, v2: vec4) -> float: ...
def vec4_neg(dst: vec4, v: vec4) -> void: ...
def vec4_len(v: vec4) -> float: ...
def vec4_dist(v1: vec4, v2: vec4) -> float: ...
def vec4_norm(dst: vec4, v: vec4) -> void: ...
def vec4_close(v1: vec4, v2: vec4, epsilon: float) -> int: ...
def vec4_min(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_minf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_max(dst: vec4, v1: vec4, v2: vec4) -> void: ...
def vec4_maxf(dst: vec4, v: vec4, f: float) -> void: ...
def vec4_abs(dst: vec4, v: vec4) -> void: ...
def vec4_floor(dst: vec4, v: vec4) -> void: ...
def vec4_ceil(dst: vec4, v: vec4) -> void: ...
def vec4_to_rgba(src: vec4) -> uint32_t: ...
def vec4_to_bgra(src: vec4) -> uint32_t: ...
def vec4_from_rgba(dst: vec4, rgba: uint32_t) -> void: ...
def vec4_from_bgra(dst: vec4, bgra: uint32_t) -> void: ...
def vec4_from_rgba_srgb(dst: vec4, rgba: uint32_t) -> void: ...
def vec4_transform(dst: vec4, v: vec4, m: matrix4) -> void: ...

class vec3:
    """Proxy of C vec3 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: float = property(_obspython.vec3_x_get, _obspython.vec3_x_set, doc="x")
    y: float = property(_obspython.vec3_y_get, _obspython.vec3_y_set, doc="y")
    z: float = property(_obspython.vec3_z_get, _obspython.vec3_z_set, doc="z")
    w: float = property(_obspython.vec3_w_get, _obspython.vec3_w_set, doc="w")
    ptr: float[4] = property(
        _obspython.vec3_ptr_get, _obspython.vec3_ptr_set, doc="ptr"
    )
    m: __m128 = property(_obspython.vec3_m_get, _obspython.vec3_m_set, doc="m")

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_vec3

_obspython.vec3_swigregister(vec3)

def vec3_zero(v: vec3) -> void: ...
def vec3_set(dst: vec3, x: float, y: float, z: float) -> void: ...
def vec3_copy(dst: vec3, v: vec3) -> void: ...
def vec3_from_vec4(dst: vec3, v: vec4) -> void: ...
def vec3_add(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_sub(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_mul(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_div(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_addf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_subf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_mulf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_divf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_dot(v1: vec3, v2: vec3) -> float: ...
def vec3_cross(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_neg(dst: vec3, v: vec3) -> void: ...
def vec3_len(v: vec3) -> float: ...
def vec3_dist(v1: vec3, v2: vec3) -> float: ...
def vec3_norm(dst: vec3, v: vec3) -> void: ...
def vec3_close(v1: vec3, v2: vec3, epsilon: float) -> bool: ...
def vec3_min(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_minf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_max(dst: vec3, v1: vec3, v2: vec3) -> void: ...
def vec3_maxf(dst: vec3, v: vec3, f: float) -> void: ...
def vec3_abs(dst: vec3, v: vec3) -> void: ...
def vec3_floor(dst: vec3, v: vec3) -> void: ...
def vec3_ceil(dst: vec3, v: vec3) -> void: ...
def vec3_plane_dist(v: vec3, p: "struct plane const *") -> float: ...
def vec3_transform(dst: vec3, v: vec3, m: matrix4) -> void: ...
def vec3_rotate(dst: vec3, v: vec3, m: matrix3) -> void: ...
def vec3_transform3x4(dst: vec3, v: vec3, m: matrix3) -> void: ...
def vec3_mirror(dst: vec3, v: vec3, p: "struct plane const *") -> void: ...
def vec3_mirrorv(dst: vec3, v: vec3, vec: vec3) -> void: ...
def vec3_rand(dst: vec3, positive_only: int) -> void: ...

class vec2:
    """Proxy of C vec2 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: float = property(_obspython.vec2_x_get, _obspython.vec2_x_set, doc="x")
    y: float = property(_obspython.vec2_y_get, _obspython.vec2_y_set, doc="y")
    ptr: float[2] = property(
        _obspython.vec2_ptr_get, _obspython.vec2_ptr_set, doc="ptr"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_vec2

_obspython.vec2_swigregister(vec2)

def vec2_zero(dst: vec2) -> void: ...
def vec2_set(dst: vec2, x: float, y: float) -> void: ...
def vec2_copy(dst: vec2, v: vec2) -> void: ...
def vec2_add(dst: vec2, v1: vec2, v2: vec2) -> void: ...
def vec2_sub(dst: vec2, v1: vec2, v2: vec2) -> void: ...
def vec2_mul(dst: vec2, v1: vec2, v2: vec2) -> void: ...
def vec2_div(dst: vec2, v1: vec2, v2: vec2) -> void: ...
def vec2_addf(dst: vec2, v: vec2, f: float) -> void: ...
def vec2_subf(dst: vec2, v: vec2, f: float) -> void: ...
def vec2_mulf(dst: vec2, v: vec2, f: float) -> void: ...
def vec2_divf(dst: vec2, v: vec2, f: float) -> void: ...
def vec2_neg(dst: vec2, v: vec2) -> void: ...
def vec2_dot(v1: vec2, v2: vec2) -> float: ...
def vec2_len(v: vec2) -> float: ...
def vec2_dist(v1: vec2, v2: vec2) -> float: ...
def vec2_minf(dst: vec2, v: vec2, val: float) -> void: ...
def vec2_min(dst: vec2, v: vec2, min_v: vec2) -> void: ...
def vec2_maxf(dst: vec2, v: vec2, val: float) -> void: ...
def vec2_max(dst: vec2, v: vec2, max_v: vec2) -> void: ...
def vec2_abs(dst: vec2, v: vec2) -> void: ...
def vec2_floor(dst: vec2, v: vec2) -> void: ...
def vec2_ceil(dst: vec2, v: vec2) -> void: ...
def vec2_close(v1: vec2, v2: vec2, epsilon: float) -> int: ...
def vec2_norm(dst: vec2, v: vec2) -> void: ...

class matrix4:
    """Proxy of C matrix4 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: "struct vec4" = property(
        _obspython.matrix4_x_get, _obspython.matrix4_x_set, doc="x"
    )
    y: "struct vec4" = property(
        _obspython.matrix4_y_get, _obspython.matrix4_y_set, doc="y"
    )
    z: "struct vec4" = property(
        _obspython.matrix4_z_get, _obspython.matrix4_z_set, doc="z"
    )
    t: "struct vec4" = property(
        _obspython.matrix4_t_get, _obspython.matrix4_t_set, doc="t"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_matrix4

_obspython.matrix4_swigregister(matrix4)

def matrix4_copy(dst: matrix4, m: matrix4) -> void: ...
def matrix4_identity(dst: matrix4) -> void: ...
def matrix4_from_matrix3(dst: matrix4, m: matrix3) -> void: ...
def matrix4_from_quat(dst: matrix4, q: quat) -> void: ...
def matrix4_from_axisang(dst: matrix4, aa: "struct axisang const *") -> void: ...
def matrix4_mul(dst: matrix4, m1: matrix4, m2: matrix4) -> void: ...
def matrix4_determinant(m: matrix4) -> float: ...
def matrix4_translate3v(dst: matrix4, m: matrix4, v: vec3) -> void: ...
def matrix4_translate4v(dst: matrix4, m: matrix4, v: vec4) -> void: ...
def matrix4_rotate(dst: matrix4, m: matrix4, q: quat) -> void: ...
def matrix4_rotate_aa(
    dst: matrix4, m: matrix4, aa: "struct axisang const *"
) -> void: ...
def matrix4_scale(dst: matrix4, m: matrix4, v: vec3) -> void: ...
def matrix4_inv(dst: matrix4, m: matrix4) -> bool: ...
def matrix4_transpose(dst: matrix4, m: matrix4) -> void: ...
def matrix4_translate3v_i(dst: matrix4, v: vec3, m: matrix4) -> void: ...
def matrix4_translate4v_i(dst: matrix4, v: vec4, m: matrix4) -> void: ...
def matrix4_rotate_i(dst: matrix4, q: quat, m: matrix4) -> void: ...
def matrix4_rotate_aa_i(
    dst: matrix4, aa: "struct axisang const *", m: matrix4
) -> void: ...
def matrix4_scale_i(dst: matrix4, v: vec3, m: matrix4) -> void: ...
def matrix4_translate3f(
    dst: matrix4, m: matrix4, x: float, y: float, z: float
) -> void: ...
def matrix4_rotate_aa4f(
    dst: matrix4, m: matrix4, x: float, y: float, z: float, rot: float
) -> void: ...
def matrix4_scale3f(dst: matrix4, m: matrix4, x: float, y: float, z: float) -> void: ...

class matrix3:
    """Proxy of C matrix3 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: "struct vec3" = property(
        _obspython.matrix3_x_get, _obspython.matrix3_x_set, doc="x"
    )
    y: "struct vec3" = property(
        _obspython.matrix3_y_get, _obspython.matrix3_y_set, doc="y"
    )
    z: "struct vec3" = property(
        _obspython.matrix3_z_get, _obspython.matrix3_z_set, doc="z"
    )
    t: "struct vec3" = property(
        _obspython.matrix3_t_get, _obspython.matrix3_t_set, doc="t"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_matrix3

_obspython.matrix3_swigregister(matrix3)

def matrix3_copy(dst: matrix3, m: matrix3) -> void: ...
def matrix3_identity(dst: matrix3) -> void: ...
def matrix3_from_quat(dst: matrix3, q: quat) -> void: ...
def matrix3_from_axisang(dst: matrix3, aa: "struct axisang const *") -> void: ...
def matrix3_from_matrix4(dst: matrix3, m: matrix4) -> void: ...
def matrix3_mul(dst: matrix3, m1: matrix3, m2: matrix3) -> void: ...
def matrix3_translate(dst: matrix3, m: matrix3, v: vec3) -> void: ...
def matrix3_rotate(dst: matrix3, m: matrix3, q: quat) -> void: ...
def matrix3_rotate_aa(
    dst: matrix3, m: matrix3, aa: "struct axisang const *"
) -> void: ...
def matrix3_scale(dst: matrix3, m: matrix3, v: vec3) -> void: ...
def matrix3_transpose(dst: matrix3, m: matrix3) -> void: ...
def matrix3_inv(dst: matrix3, m: matrix3) -> void: ...
def matrix3_mirror(dst: matrix3, m: matrix3, p: "struct plane const *") -> void: ...
def matrix3_mirrorv(dst: matrix3, m: matrix3, v: vec3) -> void: ...
def matrix3_translate3f(
    dst: matrix3, m: matrix3, x: float, y: float, z: float
) -> void: ...
def matrix3_rotate_aa4f(
    dst: matrix3, m: matrix3, x: float, y: float, z: float, rot: float
) -> void: ...
def matrix3_scale3f(dst: matrix3, m: matrix3, x: float, y: float, z: float) -> void: ...

class quat:
    """Proxy of C quat struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    x: float = property(_obspython.quat_x_get, _obspython.quat_x_set, doc="x")
    y: float = property(_obspython.quat_y_get, _obspython.quat_y_set, doc="y")
    z: float = property(_obspython.quat_z_get, _obspython.quat_z_set, doc="z")
    w: float = property(_obspython.quat_w_get, _obspython.quat_w_set, doc="w")
    ptr: float[4] = property(
        _obspython.quat_ptr_get, _obspython.quat_ptr_set, doc="ptr"
    )
    m: __m128 = property(_obspython.quat_m_get, _obspython.quat_m_set, doc="m")

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_quat

_obspython.quat_swigregister(quat)

def quat_identity(q: quat) -> void: ...
def quat_set(dst: quat, x: float, y: float, z: float, w: float) -> void: ...
def quat_copy(dst: quat, q: quat) -> void: ...
def quat_add(dst: quat, q1: quat, q2: quat) -> void: ...
def quat_sub(dst: quat, q1: quat, q2: quat) -> void: ...
def quat_mul(dst: quat, q1: quat, q2: quat) -> void: ...
def quat_addf(dst: quat, q: quat, f: float) -> void: ...
def quat_subf(dst: quat, q: quat, f: float) -> void: ...
def quat_mulf(dst: quat, q: quat, f: float) -> void: ...
def quat_divf(dst: quat, q: quat, f: float) -> void: ...
def quat_dot(q1: quat, q2: quat) -> float: ...
def quat_inv(dst: quat, q: quat) -> void: ...
def quat_neg(dst: quat, q: quat) -> void: ...
def quat_len(q: quat) -> float: ...
def quat_dist(q1: quat, q2: quat) -> float: ...
def quat_norm(dst: quat, q: quat) -> void: ...
def quat_close(q1: quat, q2: quat, epsilon: float) -> bool: ...
def quat_from_axisang(dst: quat, aa: "struct axisang const *") -> void: ...
def quat_from_matrix3(dst: quat, m: matrix3) -> void: ...
def quat_from_matrix4(dst: quat, m: matrix4) -> void: ...
def quat_get_dir(dst: vec3, q: quat) -> void: ...
def quat_set_look_dir(dst: quat, dir: vec3) -> void: ...
def quat_log(dst: quat, q: quat) -> void: ...
def quat_exp(dst: quat, q: quat) -> void: ...
def quat_interpolate(dst: quat, q1: quat, q2: quat, t: float) -> void: ...
def quat_get_tangent(dst: quat, prev: quat, q: quat, next: quat) -> void: ...
def quat_interpolate_cubic(
    dst: quat, q1: quat, q2: quat, m1: quat, m2: quat, t: float
) -> void: ...

PYTHON_LIB = _obspython.PYTHON_LIB
OBS_DATA_NULL = _obspython.OBS_DATA_NULL
OBS_DATA_STRING = _obspython.OBS_DATA_STRING
OBS_DATA_NUMBER = _obspython.OBS_DATA_NUMBER
OBS_DATA_BOOLEAN = _obspython.OBS_DATA_BOOLEAN
OBS_DATA_OBJECT = _obspython.OBS_DATA_OBJECT
OBS_DATA_ARRAY = _obspython.OBS_DATA_ARRAY
OBS_DATA_NUM_INVALID = _obspython.OBS_DATA_NUM_INVALID
OBS_DATA_NUM_INT = _obspython.OBS_DATA_NUM_INT
OBS_DATA_NUM_DOUBLE = _obspython.OBS_DATA_NUM_DOUBLE

def obs_data_create() -> "obs_data_t *": ...
def obs_data_create_from_json(json_string: "char const *") -> "obs_data_t *": ...
def obs_data_create_from_json_file(json_file: "char const *") -> "obs_data_t *": ...
def obs_data_create_from_json_file_safe(
    json_file: "char const *", backup_ext: "char const *"
) -> "obs_data_t *": ...
def obs_data_addref(data: "obs_data_t *") -> void: ...
def obs_data_release(data: "obs_data_t *") -> void: ...
def obs_data_get_json(data: "obs_data_t *") -> "char const *": ...
def obs_data_get_json_with_defaults(data: "obs_data_t *") -> "char const *": ...
def obs_data_get_json_pretty(data: "obs_data_t *") -> "char const *": ...
def obs_data_get_json_pretty_with_defaults(data: "obs_data_t *") -> "char const *": ...
def obs_data_get_last_json(data: "obs_data_t *") -> "char const *": ...
def obs_data_save_json(data: "obs_data_t *", file: "char const *") -> bool: ...
def obs_data_save_json_safe(
    data: "obs_data_t *",
    file: "char const *",
    temp_ext: "char const *",
    backup_ext: "char const *",
) -> bool: ...
def obs_data_save_json_pretty_safe(
    data: "obs_data_t *",
    file: "char const *",
    temp_ext: "char const *",
    backup_ext: "char const *",
) -> bool: ...
def obs_data_apply(target: "obs_data_t *", apply_data: "obs_data_t *") -> void: ...
def obs_data_erase(data: "obs_data_t *", name: "char const *") -> void: ...
def obs_data_clear(data: "obs_data_t *") -> void: ...
def obs_data_set_string(
    data: "obs_data_t *", name: "char const *", val: "char const *"
) -> void: ...
def obs_data_set_int(
    data: "obs_data_t *", name: "char const *", val: "long long"
) -> void: ...
def obs_data_set_double(
    data: "obs_data_t *", name: "char const *", val: double
) -> void: ...
def obs_data_set_bool(
    data: "obs_data_t *", name: "char const *", val: bool
) -> void: ...
def obs_data_set_obj(
    data: "obs_data_t *", name: "char const *", obj: "obs_data_t *"
) -> void: ...
def obs_data_set_array(
    data: "obs_data_t *", name: "char const *", array: "obs_data_array_t *"
) -> void: ...
def obs_data_get_defaults(data: "obs_data_t *") -> "obs_data_t *": ...
def obs_data_set_default_string(
    data: "obs_data_t *", name: "char const *", val: "char const *"
) -> void: ...
def obs_data_set_default_int(
    data: "obs_data_t *", name: "char const *", val: "long long"
) -> void: ...
def obs_data_set_default_double(
    data: "obs_data_t *", name: "char const *", val: double
) -> void: ...
def obs_data_set_default_bool(
    data: "obs_data_t *", name: "char const *", val: bool
) -> void: ...
def obs_data_set_default_obj(
    data: "obs_data_t *", name: "char const *", obj: "obs_data_t *"
) -> void: ...
def obs_data_set_default_array(
    data: "obs_data_t *", name: "char const *", arr: "obs_data_array_t *"
) -> void: ...
def obs_data_set_autoselect_string(
    data: "obs_data_t *", name: "char const *", val: "char const *"
) -> void: ...
def obs_data_set_autoselect_int(
    data: "obs_data_t *", name: "char const *", val: "long long"
) -> void: ...
def obs_data_set_autoselect_double(
    data: "obs_data_t *", name: "char const *", val: double
) -> void: ...
def obs_data_set_autoselect_bool(
    data: "obs_data_t *", name: "char const *", val: bool
) -> void: ...
def obs_data_set_autoselect_obj(
    data: "obs_data_t *", name: "char const *", obj: "obs_data_t *"
) -> void: ...
def obs_data_set_autoselect_array(
    data: "obs_data_t *", name: "char const *", arr: "obs_data_array_t *"
) -> void: ...
def obs_data_get_string(
    data: "obs_data_t *", name: "char const *"
) -> "char const *": ...
def obs_data_get_int(data: "obs_data_t *", name: "char const *") -> "long long": ...
def obs_data_get_double(data: "obs_data_t *", name: "char const *") -> double: ...
def obs_data_get_bool(data: "obs_data_t *", name: "char const *") -> bool: ...
def obs_data_get_obj(data: "obs_data_t *", name: "char const *") -> "obs_data_t *": ...
def obs_data_get_array(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_array_t *": ...
def obs_data_get_default_string(
    data: "obs_data_t *", name: "char const *"
) -> "char const *": ...
def obs_data_get_default_int(
    data: "obs_data_t *", name: "char const *"
) -> "long long": ...
def obs_data_get_default_double(
    data: "obs_data_t *", name: "char const *"
) -> double: ...
def obs_data_get_default_bool(data: "obs_data_t *", name: "char const *") -> bool: ...
def obs_data_get_default_obj(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_t *": ...
def obs_data_get_default_array(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_array_t *": ...
def obs_data_get_autoselect_string(
    data: "obs_data_t *", name: "char const *"
) -> "char const *": ...
def obs_data_get_autoselect_int(
    data: "obs_data_t *", name: "char const *"
) -> "long long": ...
def obs_data_get_autoselect_double(
    data: "obs_data_t *", name: "char const *"
) -> double: ...
def obs_data_get_autoselect_bool(
    data: "obs_data_t *", name: "char const *"
) -> bool: ...
def obs_data_get_autoselect_obj(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_t *": ...
def obs_data_get_autoselect_array(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_array_t *": ...
def obs_data_array_create() -> "obs_data_array_t *": ...
def obs_data_array_addref(array: "obs_data_array_t *") -> void: ...
def obs_data_array_release(array: "obs_data_array_t *") -> void: ...
def obs_data_array_count(array: "obs_data_array_t *") -> size_t: ...
def obs_data_array_item(array: "obs_data_array_t *", idx: size_t) -> "obs_data_t *": ...
def obs_data_array_push_back(
    array: "obs_data_array_t *", obj: "obs_data_t *"
) -> size_t: ...
def obs_data_array_insert(
    array: "obs_data_array_t *", idx: size_t, obj: "obs_data_t *"
) -> void: ...
def obs_data_array_push_back_array(
    array: "obs_data_array_t *", array2: "obs_data_array_t *"
) -> void: ...
def obs_data_array_erase(array: "obs_data_array_t *", idx: size_t) -> void: ...
def obs_data_array_enum(
    array: "obs_data_array_t *", cb: "void (*)(obs_data_t *,void *)", param: "void *"
) -> void: ...
def obs_data_has_user_value(data: "obs_data_t *", name: "char const *") -> bool: ...
def obs_data_has_default_value(data: "obs_data_t *", name: "char const *") -> bool: ...
def obs_data_has_autoselect_value(
    data: "obs_data_t *", name: "char const *"
) -> bool: ...
def obs_data_item_has_user_value(data: "obs_data_item_t *") -> bool: ...
def obs_data_item_has_default_value(data: "obs_data_item_t *") -> bool: ...
def obs_data_item_has_autoselect_value(data: "obs_data_item_t *") -> bool: ...
def obs_data_unset_user_value(data: "obs_data_t *", name: "char const *") -> void: ...
def obs_data_unset_default_value(
    data: "obs_data_t *", name: "char const *"
) -> void: ...
def obs_data_unset_autoselect_value(
    data: "obs_data_t *", name: "char const *"
) -> void: ...
def obs_data_item_unset_user_value(data: "obs_data_item_t *") -> void: ...
def obs_data_item_unset_default_value(data: "obs_data_item_t *") -> void: ...
def obs_data_item_unset_autoselect_value(data: "obs_data_item_t *") -> void: ...
def obs_data_first(data: "obs_data_t *") -> "obs_data_item_t *": ...
def obs_data_item_byname(
    data: "obs_data_t *", name: "char const *"
) -> "obs_data_item_t *": ...
def obs_data_item_next(item: "obs_data_item_t **") -> bool: ...
def obs_data_item_release(item: "obs_data_item_t **") -> void: ...
def obs_data_item_remove(item: "obs_data_item_t **") -> void: ...
def obs_data_item_gettype(item: "obs_data_item_t *") -> "enum obs_data_type": ...
def obs_data_item_numtype(item: "obs_data_item_t *") -> "enum obs_data_number_type": ...
def obs_data_item_get_name(item: "obs_data_item_t *") -> "char const *": ...
def obs_data_item_set_string(
    item: "obs_data_item_t **", val: "char const *"
) -> void: ...
def obs_data_item_set_int(item: "obs_data_item_t **", val: "long long") -> void: ...
def obs_data_item_set_double(item: "obs_data_item_t **", val: double) -> void: ...
def obs_data_item_set_bool(item: "obs_data_item_t **", val: bool) -> void: ...
def obs_data_item_set_obj(item: "obs_data_item_t **", val: "obs_data_t *") -> void: ...
def obs_data_item_set_array(
    item: "obs_data_item_t **", val: "obs_data_array_t *"
) -> void: ...
def obs_data_item_set_default_string(
    item: "obs_data_item_t **", val: "char const *"
) -> void: ...
def obs_data_item_set_default_int(
    item: "obs_data_item_t **", val: "long long"
) -> void: ...
def obs_data_item_set_default_double(
    item: "obs_data_item_t **", val: double
) -> void: ...
def obs_data_item_set_default_bool(item: "obs_data_item_t **", val: bool) -> void: ...
def obs_data_item_set_default_obj(
    item: "obs_data_item_t **", val: "obs_data_t *"
) -> void: ...
def obs_data_item_set_default_array(
    item: "obs_data_item_t **", val: "obs_data_array_t *"
) -> void: ...
def obs_data_item_set_autoselect_string(
    item: "obs_data_item_t **", val: "char const *"
) -> void: ...
def obs_data_item_set_autoselect_int(
    item: "obs_data_item_t **", val: "long long"
) -> void: ...
def obs_data_item_set_autoselect_double(
    item: "obs_data_item_t **", val: double
) -> void: ...
def obs_data_item_set_autoselect_bool(
    item: "obs_data_item_t **", val: bool
) -> void: ...
def obs_data_item_set_autoselect_obj(
    item: "obs_data_item_t **", val: "obs_data_t *"
) -> void: ...
def obs_data_item_set_autoselect_array(
    item: "obs_data_item_t **", val: "obs_data_array_t *"
) -> void: ...
def obs_data_item_get_string(item: "obs_data_item_t *") -> "char const *": ...
def obs_data_item_get_int(item: "obs_data_item_t *") -> "long long": ...
def obs_data_item_get_double(item: "obs_data_item_t *") -> double: ...
def obs_data_item_get_bool(item: "obs_data_item_t *") -> bool: ...
def obs_data_item_get_obj(item: "obs_data_item_t *") -> "obs_data_t *": ...
def obs_data_item_get_array(item: "obs_data_item_t *") -> "obs_data_array_t *": ...
def obs_data_item_get_default_string(item: "obs_data_item_t *") -> "char const *": ...
def obs_data_item_get_default_int(item: "obs_data_item_t *") -> "long long": ...
def obs_data_item_get_default_double(item: "obs_data_item_t *") -> double: ...
def obs_data_item_get_default_bool(item: "obs_data_item_t *") -> bool: ...
def obs_data_item_get_default_obj(item: "obs_data_item_t *") -> "obs_data_t *": ...
def obs_data_item_get_default_array(
    item: "obs_data_item_t *",
) -> "obs_data_array_t *": ...
def obs_data_item_get_autoselect_string(
    item: "obs_data_item_t *",
) -> "char const *": ...
def obs_data_item_get_autoselect_int(item: "obs_data_item_t *") -> "long long": ...
def obs_data_item_get_autoselect_double(item: "obs_data_item_t *") -> double: ...
def obs_data_item_get_autoselect_bool(item: "obs_data_item_t *") -> bool: ...
def obs_data_item_get_autoselect_obj(item: "obs_data_item_t *") -> "obs_data_t *": ...
def obs_data_item_get_autoselect_array(
    item: "obs_data_item_t *",
) -> "obs_data_array_t *": ...
def obs_data_set_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_set_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_set_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_set_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_set_default_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_set_default_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_set_default_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_set_default_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_set_autoselect_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_set_autoselect_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_set_autoselect_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_set_autoselect_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_get_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_get_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_get_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_get_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_get_default_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_get_default_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_get_default_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_get_default_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_get_autoselect_vec2(
    data: "obs_data_t *", name: "char const *", val: vec2
) -> void: ...
def obs_data_get_autoselect_vec3(
    data: "obs_data_t *", name: "char const *", val: vec3
) -> void: ...
def obs_data_get_autoselect_vec4(
    data: "obs_data_t *", name: "char const *", val: vec4
) -> void: ...
def obs_data_get_autoselect_quat(
    data: "obs_data_t *", name: "char const *", val: quat
) -> void: ...
def obs_data_set_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_set_default_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_set_autoselect_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_get_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_get_default_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_get_autoselect_frames_per_second(
    data: "obs_data_t *",
    name: "char const *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_item_set_frames_per_second(
    item: "obs_data_item_t **",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_item_set_default_frames_per_second(
    item: "obs_data_item_t **",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_item_set_autoselect_frames_per_second(
    item: "obs_data_item_t **",
    fps: "struct media_frames_per_second",
    option: "char const *",
) -> void: ...
def obs_data_item_get_frames_per_second(
    item: "obs_data_item_t *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_item_get_default_frames_per_second(
    item: "obs_data_item_t *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_item_get_autoselect_frames_per_second(
    item: "obs_data_item_t *",
    fps: "struct media_frames_per_second *",
    option: "char const **",
) -> bool: ...
def obs_data_newref(data: "obs_data_t *") -> "obs_data_t *": ...

OBS_SOURCE_TYPE_INPUT = _obspython.OBS_SOURCE_TYPE_INPUT
OBS_SOURCE_TYPE_FILTER = _obspython.OBS_SOURCE_TYPE_FILTER
OBS_SOURCE_TYPE_TRANSITION = _obspython.OBS_SOURCE_TYPE_TRANSITION
OBS_SOURCE_TYPE_SCENE = _obspython.OBS_SOURCE_TYPE_SCENE
OBS_BALANCE_TYPE_SINE_LAW = _obspython.OBS_BALANCE_TYPE_SINE_LAW
OBS_BALANCE_TYPE_SQUARE_LAW = _obspython.OBS_BALANCE_TYPE_SQUARE_LAW
OBS_BALANCE_TYPE_LINEAR = _obspython.OBS_BALANCE_TYPE_LINEAR
OBS_ICON_TYPE_UNKNOWN = _obspython.OBS_ICON_TYPE_UNKNOWN
OBS_ICON_TYPE_IMAGE = _obspython.OBS_ICON_TYPE_IMAGE
OBS_ICON_TYPE_COLOR = _obspython.OBS_ICON_TYPE_COLOR
OBS_ICON_TYPE_SLIDESHOW = _obspython.OBS_ICON_TYPE_SLIDESHOW
OBS_ICON_TYPE_AUDIO_INPUT = _obspython.OBS_ICON_TYPE_AUDIO_INPUT
OBS_ICON_TYPE_AUDIO_OUTPUT = _obspython.OBS_ICON_TYPE_AUDIO_OUTPUT
OBS_ICON_TYPE_DESKTOP_CAPTURE = _obspython.OBS_ICON_TYPE_DESKTOP_CAPTURE
OBS_ICON_TYPE_WINDOW_CAPTURE = _obspython.OBS_ICON_TYPE_WINDOW_CAPTURE
OBS_ICON_TYPE_GAME_CAPTURE = _obspython.OBS_ICON_TYPE_GAME_CAPTURE
OBS_ICON_TYPE_CAMERA = _obspython.OBS_ICON_TYPE_CAMERA
OBS_ICON_TYPE_TEXT = _obspython.OBS_ICON_TYPE_TEXT
OBS_ICON_TYPE_MEDIA = _obspython.OBS_ICON_TYPE_MEDIA
OBS_ICON_TYPE_BROWSER = _obspython.OBS_ICON_TYPE_BROWSER
OBS_ICON_TYPE_CUSTOM = _obspython.OBS_ICON_TYPE_CUSTOM
OBS_ICON_TYPE_PROCESS_AUDIO_OUTPUT = _obspython.OBS_ICON_TYPE_PROCESS_AUDIO_OUTPUT
OBS_MEDIA_STATE_NONE = _obspython.OBS_MEDIA_STATE_NONE
OBS_MEDIA_STATE_PLAYING = _obspython.OBS_MEDIA_STATE_PLAYING
OBS_MEDIA_STATE_OPENING = _obspython.OBS_MEDIA_STATE_OPENING
OBS_MEDIA_STATE_BUFFERING = _obspython.OBS_MEDIA_STATE_BUFFERING
OBS_MEDIA_STATE_PAUSED = _obspython.OBS_MEDIA_STATE_PAUSED
OBS_MEDIA_STATE_STOPPED = _obspython.OBS_MEDIA_STATE_STOPPED
OBS_MEDIA_STATE_ENDED = _obspython.OBS_MEDIA_STATE_ENDED
OBS_MEDIA_STATE_ERROR = _obspython.OBS_MEDIA_STATE_ERROR
OBS_SOURCE_VIDEO = _obspython.OBS_SOURCE_VIDEO
OBS_SOURCE_AUDIO = _obspython.OBS_SOURCE_AUDIO
OBS_SOURCE_ASYNC = _obspython.OBS_SOURCE_ASYNC
OBS_SOURCE_ASYNC_VIDEO = _obspython.OBS_SOURCE_ASYNC_VIDEO
OBS_SOURCE_CUSTOM_DRAW = _obspython.OBS_SOURCE_CUSTOM_DRAW
OBS_SOURCE_INTERACTION = _obspython.OBS_SOURCE_INTERACTION
OBS_SOURCE_COMPOSITE = _obspython.OBS_SOURCE_COMPOSITE
OBS_SOURCE_DO_NOT_DUPLICATE = _obspython.OBS_SOURCE_DO_NOT_DUPLICATE
OBS_SOURCE_DEPRECATED = _obspython.OBS_SOURCE_DEPRECATED
OBS_SOURCE_DO_NOT_SELF_MONITOR = _obspython.OBS_SOURCE_DO_NOT_SELF_MONITOR
OBS_SOURCE_CAP_DISABLED = _obspython.OBS_SOURCE_CAP_DISABLED
OBS_SOURCE_CAP_OBSOLETE = _obspython.OBS_SOURCE_CAP_OBSOLETE
OBS_SOURCE_MONITOR_BY_DEFAULT = _obspython.OBS_SOURCE_MONITOR_BY_DEFAULT
OBS_SOURCE_SUBMIX = _obspython.OBS_SOURCE_SUBMIX
OBS_SOURCE_CONTROLLABLE_MEDIA = _obspython.OBS_SOURCE_CONTROLLABLE_MEDIA
OBS_SOURCE_CEA_708 = _obspython.OBS_SOURCE_CEA_708
OBS_SOURCE_SRGB = _obspython.OBS_SOURCE_SRGB
OBS_SOURCE_CAP_DONT_SHOW_PROPERTIES = _obspython.OBS_SOURCE_CAP_DONT_SHOW_PROPERTIES

class obs_source_audio_mix:
    """Proxy of C obs_source_audio_mix struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    output: "struct audio_output_data [MAX_AUDIO_MIXES]" = property(
        _obspython.obs_source_audio_mix_output_get,
        _obspython.obs_source_audio_mix_output_set,
        doc="output",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_audio_mix

_obspython.obs_source_audio_mix_swigregister(obs_source_audio_mix)

class obs_source_info:
    """Proxy of C obs_source_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    id: "char const *" = property(
        _obspython.obs_source_info_id_get, _obspython.obs_source_info_id_set, doc="id"
    )
    type: "enum obs_source_type" = property(
        _obspython.obs_source_info_type_get,
        _obspython.obs_source_info_type_set,
        doc="type",
    )
    output_flags: uint32_t = property(
        _obspython.obs_source_info_output_flags_get,
        _obspython.obs_source_info_output_flags_set,
        doc="output_flags",
    )
    get_name: "char const *(*)(void *)" = property(
        _obspython.obs_source_info_get_name_get,
        _obspython.obs_source_info_get_name_set,
        doc="get_name",
    )
    create: "void *(*)(obs_data_t *,obs_source_t *)" = property(
        _obspython.obs_source_info_create_get,
        _obspython.obs_source_info_create_set,
        doc="create",
    )
    destroy: "void (*)(void *)" = property(
        _obspython.obs_source_info_destroy_get,
        _obspython.obs_source_info_destroy_set,
        doc="destroy",
    )
    get_width: "uint32_t (*)(void *)" = property(
        _obspython.obs_source_info_get_width_get,
        _obspython.obs_source_info_get_width_set,
        doc="get_width",
    )
    get_height: "uint32_t (*)(void *)" = property(
        _obspython.obs_source_info_get_height_get,
        _obspython.obs_source_info_get_height_set,
        doc="get_height",
    )
    get_defaults: "void (*)(obs_data_t *)" = property(
        _obspython.obs_source_info_get_defaults_get,
        _obspython.obs_source_info_get_defaults_set,
        doc="get_defaults",
    )
    get_properties: "obs_properties_t *(*)(void *)" = property(
        _obspython.obs_source_info_get_properties_get,
        _obspython.obs_source_info_get_properties_set,
        doc="get_properties",
    )
    update: "void (*)(void *,obs_data_t *)" = property(
        _obspython.obs_source_info_update_get,
        _obspython.obs_source_info_update_set,
        doc="update",
    )
    activate: "void (*)(void *)" = property(
        _obspython.obs_source_info_activate_get,
        _obspython.obs_source_info_activate_set,
        doc="activate",
    )
    deactivate: "void (*)(void *)" = property(
        _obspython.obs_source_info_deactivate_get,
        _obspython.obs_source_info_deactivate_set,
        doc="deactivate",
    )
    show: "void (*)(void *)" = property(
        _obspython.obs_source_info_show_get,
        _obspython.obs_source_info_show_set,
        doc="show",
    )
    hide: "void (*)(void *)" = property(
        _obspython.obs_source_info_hide_get,
        _obspython.obs_source_info_hide_set,
        doc="hide",
    )
    video_tick: "void (*)(void *,float)" = property(
        _obspython.obs_source_info_video_tick_get,
        _obspython.obs_source_info_video_tick_set,
        doc="video_tick",
    )
    video_render: "void (*)(void *,gs_effect_t *)" = property(
        _obspython.obs_source_info_video_render_get,
        _obspython.obs_source_info_video_render_set,
        doc="video_render",
    )
    filter_video: "struct obs_source_frame *(*)(void *,struct obs_source_frame *)" = (
        property(
            _obspython.obs_source_info_filter_video_get,
            _obspython.obs_source_info_filter_video_set,
            doc="filter_video",
        )
    )
    filter_audio: "struct obs_audio_data *(*)(void *,struct obs_audio_data *)" = (
        property(
            _obspython.obs_source_info_filter_audio_get,
            _obspython.obs_source_info_filter_audio_set,
            doc="filter_audio",
        )
    )
    enum_active_sources: "void (*)(void *,obs_source_enum_proc_t,void *)" = property(
        _obspython.obs_source_info_enum_active_sources_get,
        _obspython.obs_source_info_enum_active_sources_set,
        doc="enum_active_sources",
    )
    save: "void (*)(void *,obs_data_t *)" = property(
        _obspython.obs_source_info_save_get,
        _obspython.obs_source_info_save_set,
        doc="save",
    )
    load: "void (*)(void *,obs_data_t *)" = property(
        _obspython.obs_source_info_load_get,
        _obspython.obs_source_info_load_set,
        doc="load",
    )
    mouse_click: "void (*)(void *,struct obs_mouse_event const *,int32_t,bool,uint32_t)" = property(
        _obspython.obs_source_info_mouse_click_get,
        _obspython.obs_source_info_mouse_click_set,
        doc="mouse_click",
    )
    mouse_move: "void (*)(void *,struct obs_mouse_event const *,bool)" = property(
        _obspython.obs_source_info_mouse_move_get,
        _obspython.obs_source_info_mouse_move_set,
        doc="mouse_move",
    )
    mouse_wheel: "void (*)(void *,struct obs_mouse_event const *,int,int)" = property(
        _obspython.obs_source_info_mouse_wheel_get,
        _obspython.obs_source_info_mouse_wheel_set,
        doc="mouse_wheel",
    )
    focus: "void (*)(void *,bool)" = property(
        _obspython.obs_source_info_focus_get,
        _obspython.obs_source_info_focus_set,
        doc="focus",
    )
    key_click: "void (*)(void *,struct obs_key_event const *,bool)" = property(
        _obspython.obs_source_info_key_click_get,
        _obspython.obs_source_info_key_click_set,
        doc="key_click",
    )
    filter_remove: "void (*)(void *,obs_source_t *)" = property(
        _obspython.obs_source_info_filter_remove_get,
        _obspython.obs_source_info_filter_remove_set,
        doc="filter_remove",
    )
    type_data: "void *" = property(
        _obspython.obs_source_info_type_data_get,
        _obspython.obs_source_info_type_data_set,
        doc="type_data",
    )
    free_type_data: "void (*)(void *)" = property(
        _obspython.obs_source_info_free_type_data_get,
        _obspython.obs_source_info_free_type_data_set,
        doc="free_type_data",
    )
    audio_render: "bool (*)(void *,uint64_t *,struct obs_source_audio_mix *,uint32_t,size_t,size_t)" = property(
        _obspython.obs_source_info_audio_render_get,
        _obspython.obs_source_info_audio_render_set,
        doc="audio_render",
    )
    enum_all_sources: "void (*)(void *,obs_source_enum_proc_t,void *)" = property(
        _obspython.obs_source_info_enum_all_sources_get,
        _obspython.obs_source_info_enum_all_sources_set,
        doc="enum_all_sources",
    )
    transition_start: "void (*)(void *)" = property(
        _obspython.obs_source_info_transition_start_get,
        _obspython.obs_source_info_transition_start_set,
        doc="transition_start",
    )
    transition_stop: "void (*)(void *)" = property(
        _obspython.obs_source_info_transition_stop_get,
        _obspython.obs_source_info_transition_stop_set,
        doc="transition_stop",
    )
    get_defaults2: "void (*)(void *,obs_data_t *)" = property(
        _obspython.obs_source_info_get_defaults2_get,
        _obspython.obs_source_info_get_defaults2_set,
        doc="get_defaults2",
    )
    get_properties2: "obs_properties_t *(*)(void *,void *)" = property(
        _obspython.obs_source_info_get_properties2_get,
        _obspython.obs_source_info_get_properties2_set,
        doc="get_properties2",
    )
    audio_mix: "bool (*)(void *,uint64_t *,struct audio_output_data *,size_t,size_t)" = property(
        _obspython.obs_source_info_audio_mix_get,
        _obspython.obs_source_info_audio_mix_set,
        doc="audio_mix",
    )
    icon_type: "enum obs_icon_type" = property(
        _obspython.obs_source_info_icon_type_get,
        _obspython.obs_source_info_icon_type_set,
        doc="icon_type",
    )
    media_play_pause: "void (*)(void *,bool)" = property(
        _obspython.obs_source_info_media_play_pause_get,
        _obspython.obs_source_info_media_play_pause_set,
        doc="media_play_pause",
    )
    media_restart: "void (*)(void *)" = property(
        _obspython.obs_source_info_media_restart_get,
        _obspython.obs_source_info_media_restart_set,
        doc="media_restart",
    )
    media_stop: "void (*)(void *)" = property(
        _obspython.obs_source_info_media_stop_get,
        _obspython.obs_source_info_media_stop_set,
        doc="media_stop",
    )
    media_next: "void (*)(void *)" = property(
        _obspython.obs_source_info_media_next_get,
        _obspython.obs_source_info_media_next_set,
        doc="media_next",
    )
    media_previous: "void (*)(void *)" = property(
        _obspython.obs_source_info_media_previous_get,
        _obspython.obs_source_info_media_previous_set,
        doc="media_previous",
    )
    media_get_duration: "int64_t (*)(void *)" = property(
        _obspython.obs_source_info_media_get_duration_get,
        _obspython.obs_source_info_media_get_duration_set,
        doc="media_get_duration",
    )
    media_get_time: "int64_t (*)(void *)" = property(
        _obspython.obs_source_info_media_get_time_get,
        _obspython.obs_source_info_media_get_time_set,
        doc="media_get_time",
    )
    media_set_time: "void (*)(void *,int64_t)" = property(
        _obspython.obs_source_info_media_set_time_get,
        _obspython.obs_source_info_media_set_time_set,
        doc="media_set_time",
    )
    media_get_state: "enum obs_media_state (*)(void *)" = property(
        _obspython.obs_source_info_media_get_state_get,
        _obspython.obs_source_info_media_get_state_set,
        doc="media_get_state",
    )
    version: uint32_t = property(
        _obspython.obs_source_info_version_get,
        _obspython.obs_source_info_version_set,
        doc="version",
    )
    unversioned_id: "char const *" = property(
        _obspython.obs_source_info_unversioned_id_get,
        _obspython.obs_source_info_unversioned_id_set,
        doc="unversioned_id",
    )
    missing_files: "obs_missing_files_t *(*)(void *)" = property(
        _obspython.obs_source_info_missing_files_get,
        _obspython.obs_source_info_missing_files_set,
        doc="missing_files",
    )
    video_get_color_space: "enum gs_color_space (*)(void *,size_t,enum gs_color_space const *)" = property(
        _obspython.obs_source_info_video_get_color_space_get,
        _obspython.obs_source_info_video_get_color_space_set,
        doc="video_get_color_space",
    )
    filter_add: "void (*)(void *,obs_source_t *)" = property(
        _obspython.obs_source_info_filter_add_get,
        _obspython.obs_source_info_filter_add_set,
        doc="filter_add",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_info

_obspython.obs_source_info_swigregister(obs_source_info)

def obs_register_source_s(info: obs_source_info, size: size_t) -> void: ...

OBS_PROPERTIES_DEFER_UPDATE = _obspython.OBS_PROPERTIES_DEFER_UPDATE
OBS_PROPERTY_INVALID = _obspython.OBS_PROPERTY_INVALID
OBS_PROPERTY_BOOL = _obspython.OBS_PROPERTY_BOOL
OBS_PROPERTY_INT = _obspython.OBS_PROPERTY_INT
OBS_PROPERTY_FLOAT = _obspython.OBS_PROPERTY_FLOAT
OBS_PROPERTY_TEXT = _obspython.OBS_PROPERTY_TEXT
OBS_PROPERTY_PATH = _obspython.OBS_PROPERTY_PATH
OBS_PROPERTY_LIST = _obspython.OBS_PROPERTY_LIST
OBS_PROPERTY_COLOR = _obspython.OBS_PROPERTY_COLOR
OBS_PROPERTY_BUTTON = _obspython.OBS_PROPERTY_BUTTON
OBS_PROPERTY_FONT = _obspython.OBS_PROPERTY_FONT
OBS_PROPERTY_EDITABLE_LIST = _obspython.OBS_PROPERTY_EDITABLE_LIST
OBS_PROPERTY_FRAME_RATE = _obspython.OBS_PROPERTY_FRAME_RATE
OBS_PROPERTY_GROUP = _obspython.OBS_PROPERTY_GROUP
OBS_PROPERTY_COLOR_ALPHA = _obspython.OBS_PROPERTY_COLOR_ALPHA
OBS_COMBO_FORMAT_INVALID = _obspython.OBS_COMBO_FORMAT_INVALID
OBS_COMBO_FORMAT_INT = _obspython.OBS_COMBO_FORMAT_INT
OBS_COMBO_FORMAT_FLOAT = _obspython.OBS_COMBO_FORMAT_FLOAT
OBS_COMBO_FORMAT_STRING = _obspython.OBS_COMBO_FORMAT_STRING
OBS_COMBO_FORMAT_BOOL = _obspython.OBS_COMBO_FORMAT_BOOL
OBS_COMBO_TYPE_INVALID = _obspython.OBS_COMBO_TYPE_INVALID
OBS_COMBO_TYPE_EDITABLE = _obspython.OBS_COMBO_TYPE_EDITABLE
OBS_COMBO_TYPE_LIST = _obspython.OBS_COMBO_TYPE_LIST
OBS_COMBO_TYPE_RADIO = _obspython.OBS_COMBO_TYPE_RADIO
OBS_EDITABLE_LIST_TYPE_STRINGS = _obspython.OBS_EDITABLE_LIST_TYPE_STRINGS
OBS_EDITABLE_LIST_TYPE_FILES = _obspython.OBS_EDITABLE_LIST_TYPE_FILES
OBS_EDITABLE_LIST_TYPE_FILES_AND_URLS = _obspython.OBS_EDITABLE_LIST_TYPE_FILES_AND_URLS
OBS_PATH_FILE = _obspython.OBS_PATH_FILE
OBS_PATH_FILE_SAVE = _obspython.OBS_PATH_FILE_SAVE
OBS_PATH_DIRECTORY = _obspython.OBS_PATH_DIRECTORY
OBS_TEXT_DEFAULT = _obspython.OBS_TEXT_DEFAULT
OBS_TEXT_PASSWORD = _obspython.OBS_TEXT_PASSWORD
OBS_TEXT_MULTILINE = _obspython.OBS_TEXT_MULTILINE
OBS_TEXT_INFO = _obspython.OBS_TEXT_INFO
OBS_TEXT_INFO_NORMAL = _obspython.OBS_TEXT_INFO_NORMAL
OBS_TEXT_INFO_WARNING = _obspython.OBS_TEXT_INFO_WARNING
OBS_TEXT_INFO_ERROR = _obspython.OBS_TEXT_INFO_ERROR
OBS_NUMBER_SCROLLER = _obspython.OBS_NUMBER_SCROLLER
OBS_NUMBER_SLIDER = _obspython.OBS_NUMBER_SLIDER
OBS_COMBO_INVALID = _obspython.OBS_COMBO_INVALID
OBS_GROUP_NORMAL = _obspython.OBS_GROUP_NORMAL
OBS_GROUP_CHECKABLE = _obspython.OBS_GROUP_CHECKABLE
OBS_BUTTON_DEFAULT = _obspython.OBS_BUTTON_DEFAULT
OBS_BUTTON_URL = _obspython.OBS_BUTTON_URL
OBS_FONT_BOLD = _obspython.OBS_FONT_BOLD
OBS_FONT_ITALIC = _obspython.OBS_FONT_ITALIC
OBS_FONT_UNDERLINE = _obspython.OBS_FONT_UNDERLINE
OBS_FONT_STRIKEOUT = _obspython.OBS_FONT_STRIKEOUT

def obs_properties_create() -> "obs_properties_t *": ...
def obs_properties_create_param(
    param: "void *", destroy: "void (*)(void *)"
) -> "obs_properties_t *": ...
def obs_properties_destroy(props: "obs_properties_t *") -> void: ...
def obs_properties_set_flags(props: "obs_properties_t *", flags: uint32_t) -> void: ...
def obs_properties_get_flags(props: "obs_properties_t *") -> uint32_t: ...
def obs_properties_set_param(
    props: "obs_properties_t *", param: "void *", destroy: "void (*)(void *)"
) -> void: ...
def obs_properties_get_param(props: "obs_properties_t *") -> "void *": ...
def obs_properties_first(props: "obs_properties_t *") -> "obs_property_t *": ...
def obs_properties_get(
    props: "obs_properties_t *", property: "char const *"
) -> "obs_property_t *": ...
def obs_properties_get_parent(props: "obs_properties_t *") -> "obs_properties_t *": ...
def obs_properties_remove_by_name(
    props: "obs_properties_t *", property: "char const *"
) -> void: ...
def obs_properties_apply_settings(
    props: "obs_properties_t *", settings: "obs_data_t *"
) -> void: ...
def obs_properties_add_bool(
    props: "obs_properties_t *", name: "char const *", description: "char const *"
) -> "obs_property_t *": ...
def obs_properties_add_int(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    min: int,
    max: int,
    step: int,
) -> "obs_property_t *": ...
def obs_properties_add_float(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    min: double,
    max: double,
    step: double,
) -> "obs_property_t *": ...
def obs_properties_add_int_slider(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    min: int,
    max: int,
    step: int,
) -> "obs_property_t *": ...
def obs_properties_add_float_slider(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    min: double,
    max: double,
    step: double,
) -> "obs_property_t *": ...
def obs_properties_add_text(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    type: "enum obs_text_type",
) -> "obs_property_t *": ...
def obs_properties_add_path(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    type: "enum obs_path_type",
    filter: "char const *",
    default_path: "char const *",
) -> "obs_property_t *": ...
def obs_properties_add_list(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    type: "enum obs_combo_type",
    format: "enum obs_combo_format",
) -> "obs_property_t *": ...
def obs_properties_add_color(
    props: "obs_properties_t *", name: "char const *", description: "char const *"
) -> "obs_property_t *": ...
def obs_properties_add_color_alpha(
    props: "obs_properties_t *", name: "char const *", description: "char const *"
) -> "obs_property_t *": ...
def obs_properties_add_button(
    props: "obs_properties_t *",
    name: "char const *",
    text: "char const *",
    callback: obs_property_clicked_t,
) -> "obs_property_t *": ...
def obs_properties_add_button2(
    props: "obs_properties_t *",
    name: "char const *",
    text: "char const *",
    callback: obs_property_clicked_t,
    priv: "void *",
) -> "obs_property_t *": ...
def obs_properties_add_font(
    props: "obs_properties_t *", name: "char const *", description: "char const *"
) -> "obs_property_t *": ...
def obs_properties_add_editable_list(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    type: "enum obs_editable_list_type",
    filter: "char const *",
    default_path: "char const *",
) -> "obs_property_t *": ...
def obs_properties_add_frame_rate(
    props: "obs_properties_t *", name: "char const *", description: "char const *"
) -> "obs_property_t *": ...
def obs_properties_add_group(
    props: "obs_properties_t *",
    name: "char const *",
    description: "char const *",
    type: "enum obs_group_type",
    group: "obs_properties_t *",
) -> "obs_property_t *": ...
def obs_property_set_modified_callback(
    p: "obs_property_t *", modified: obs_property_modified_t
) -> void: ...
def obs_property_set_modified_callback2(
    p: "obs_property_t *", modified: obs_property_modified2_t, priv: "void *"
) -> void: ...
def obs_property_modified(p: "obs_property_t *", settings: "obs_data_t *") -> bool: ...
def obs_property_button_clicked(p: "obs_property_t *", obj: "void *") -> bool: ...
def obs_property_set_visible(p: "obs_property_t *", visible: bool) -> void: ...
def obs_property_set_enabled(p: "obs_property_t *", enabled: bool) -> void: ...
def obs_property_set_description(
    p: "obs_property_t *", description: "char const *"
) -> void: ...
def obs_property_set_long_description(
    p: "obs_property_t *", long_description: "char const *"
) -> void: ...
def obs_property_name(p: "obs_property_t *") -> "char const *": ...
def obs_property_description(p: "obs_property_t *") -> "char const *": ...
def obs_property_long_description(p: "obs_property_t *") -> "char const *": ...
def obs_property_get_type(p: "obs_property_t *") -> "enum obs_property_type": ...
def obs_property_enabled(p: "obs_property_t *") -> bool: ...
def obs_property_visible(p: "obs_property_t *") -> bool: ...
def obs_property_next(p: "obs_property_t **") -> bool: ...
def obs_property_int_min(p: "obs_property_t *") -> int: ...
def obs_property_int_max(p: "obs_property_t *") -> int: ...
def obs_property_int_step(p: "obs_property_t *") -> int: ...
def obs_property_int_type(p: "obs_property_t *") -> "enum obs_number_type": ...
def obs_property_int_suffix(p: "obs_property_t *") -> "char const *": ...
def obs_property_float_min(p: "obs_property_t *") -> double: ...
def obs_property_float_max(p: "obs_property_t *") -> double: ...
def obs_property_float_step(p: "obs_property_t *") -> double: ...
def obs_property_float_type(p: "obs_property_t *") -> "enum obs_number_type": ...
def obs_property_float_suffix(p: "obs_property_t *") -> "char const *": ...
def obs_property_text_type(p: "obs_property_t *") -> "enum obs_text_type": ...
def obs_property_text_monospace(p: "obs_property_t *") -> bool: ...
def obs_property_text_info_type(p: "obs_property_t *") -> "enum obs_text_info_type": ...
def obs_property_text_info_word_wrap(p: "obs_property_t *") -> bool: ...
def obs_property_path_type(p: "obs_property_t *") -> "enum obs_path_type": ...
def obs_property_path_filter(p: "obs_property_t *") -> "char const *": ...
def obs_property_path_default_path(p: "obs_property_t *") -> "char const *": ...
def obs_property_list_type(p: "obs_property_t *") -> "enum obs_combo_type": ...
def obs_property_list_format(p: "obs_property_t *") -> "enum obs_combo_format": ...
def obs_property_int_set_limits(
    p: "obs_property_t *", min: int, max: int, step: int
) -> void: ...
def obs_property_float_set_limits(
    p: "obs_property_t *", min: double, max: double, step: double
) -> void: ...
def obs_property_int_set_suffix(
    p: "obs_property_t *", suffix: "char const *"
) -> void: ...
def obs_property_float_set_suffix(
    p: "obs_property_t *", suffix: "char const *"
) -> void: ...
def obs_property_text_set_monospace(p: "obs_property_t *", monospace: bool) -> void: ...
def obs_property_text_set_info_type(
    p: "obs_property_t *", type: "enum obs_text_info_type"
) -> void: ...
def obs_property_text_set_info_word_wrap(
    p: "obs_property_t *", word_wrap: bool
) -> void: ...
def obs_property_button_set_type(
    p: "obs_property_t *", type: "enum obs_button_type"
) -> void: ...
def obs_property_button_set_url(p: "obs_property_t *", url: "char *") -> void: ...
def obs_property_list_clear(p: "obs_property_t *") -> void: ...
def obs_property_list_add_string(
    p: "obs_property_t *", name: "char const *", val: "char const *"
) -> size_t: ...
def obs_property_list_add_int(
    p: "obs_property_t *", name: "char const *", val: "long long"
) -> size_t: ...
def obs_property_list_add_float(
    p: "obs_property_t *", name: "char const *", val: double
) -> size_t: ...
def obs_property_list_add_bool(
    p: "obs_property_t *", name: "char const *", val: bool
) -> size_t: ...
def obs_property_list_insert_string(
    p: "obs_property_t *", idx: size_t, name: "char const *", val: "char const *"
) -> void: ...
def obs_property_list_insert_int(
    p: "obs_property_t *", idx: size_t, name: "char const *", val: "long long"
) -> void: ...
def obs_property_list_insert_float(
    p: "obs_property_t *", idx: size_t, name: "char const *", val: double
) -> void: ...
def obs_property_list_insert_bool(
    p: "obs_property_t *", idx: size_t, name: "char const *", val: bool
) -> void: ...
def obs_property_list_item_disable(
    p: "obs_property_t *", idx: size_t, disabled: bool
) -> void: ...
def obs_property_list_item_disabled(p: "obs_property_t *", idx: size_t) -> bool: ...
def obs_property_list_item_remove(p: "obs_property_t *", idx: size_t) -> void: ...
def obs_property_list_item_count(p: "obs_property_t *") -> size_t: ...
def obs_property_list_item_name(
    p: "obs_property_t *", idx: size_t
) -> "char const *": ...
def obs_property_list_item_string(
    p: "obs_property_t *", idx: size_t
) -> "char const *": ...
def obs_property_list_item_int(p: "obs_property_t *", idx: size_t) -> "long long": ...
def obs_property_list_item_float(p: "obs_property_t *", idx: size_t) -> double: ...
def obs_property_list_item_bool(p: "obs_property_t *", idx: size_t) -> bool: ...
def obs_property_editable_list_type(
    p: "obs_property_t *",
) -> "enum obs_editable_list_type": ...
def obs_property_editable_list_filter(p: "obs_property_t *") -> "char const *": ...
def obs_property_editable_list_default_path(
    p: "obs_property_t *",
) -> "char const *": ...
def obs_property_frame_rate_clear(p: "obs_property_t *") -> void: ...
def obs_property_frame_rate_options_clear(p: "obs_property_t *") -> void: ...
def obs_property_frame_rate_fps_ranges_clear(p: "obs_property_t *") -> void: ...
def obs_property_frame_rate_option_add(
    p: "obs_property_t *", name: "char const *", description: "char const *"
) -> size_t: ...
def obs_property_frame_rate_fps_range_add(
    p: "obs_property_t *",
    min: "struct media_frames_per_second",
    max: "struct media_frames_per_second",
) -> size_t: ...
def obs_property_frame_rate_option_insert(
    p: "obs_property_t *",
    idx: size_t,
    name: "char const *",
    description: "char const *",
) -> void: ...
def obs_property_frame_rate_fps_range_insert(
    p: "obs_property_t *",
    idx: size_t,
    min: "struct media_frames_per_second",
    max: "struct media_frames_per_second",
) -> void: ...
def obs_property_frame_rate_options_count(p: "obs_property_t *") -> size_t: ...
def obs_property_frame_rate_option_name(
    p: "obs_property_t *", idx: size_t
) -> "char const *": ...
def obs_property_frame_rate_option_description(
    p: "obs_property_t *", idx: size_t
) -> "char const *": ...
def obs_property_frame_rate_fps_ranges_count(p: "obs_property_t *") -> size_t: ...
def obs_property_frame_rate_fps_range_min(
    p: "obs_property_t *", idx: size_t
) -> "struct media_frames_per_second": ...
def obs_property_frame_rate_fps_range_max(
    p: "obs_property_t *", idx: size_t
) -> "struct media_frames_per_second": ...
def obs_property_group_type(p: "obs_property_t *") -> "enum obs_group_type": ...
def obs_property_group_content(p: "obs_property_t *") -> "obs_properties_t *": ...
def obs_property_button_type(p: "obs_property_t *") -> "enum obs_button_type": ...
def obs_property_button_url(p: "obs_property_t *") -> "char const *": ...

INTERACT_NONE = _obspython.INTERACT_NONE
INTERACT_CAPS_KEY = _obspython.INTERACT_CAPS_KEY
INTERACT_SHIFT_KEY = _obspython.INTERACT_SHIFT_KEY
INTERACT_CONTROL_KEY = _obspython.INTERACT_CONTROL_KEY
INTERACT_ALT_KEY = _obspython.INTERACT_ALT_KEY
INTERACT_MOUSE_LEFT = _obspython.INTERACT_MOUSE_LEFT
INTERACT_MOUSE_MIDDLE = _obspython.INTERACT_MOUSE_MIDDLE
INTERACT_MOUSE_RIGHT = _obspython.INTERACT_MOUSE_RIGHT
INTERACT_COMMAND_KEY = _obspython.INTERACT_COMMAND_KEY
INTERACT_NUMLOCK_KEY = _obspython.INTERACT_NUMLOCK_KEY
INTERACT_IS_KEY_PAD = _obspython.INTERACT_IS_KEY_PAD
INTERACT_IS_LEFT = _obspython.INTERACT_IS_LEFT
INTERACT_IS_RIGHT = _obspython.INTERACT_IS_RIGHT
MOUSE_LEFT = _obspython.MOUSE_LEFT
MOUSE_MIDDLE = _obspython.MOUSE_MIDDLE
MOUSE_RIGHT = _obspython.MOUSE_RIGHT

class obs_mouse_event:
    """Proxy of C obs_mouse_event struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    modifiers: uint32_t = property(
        _obspython.obs_mouse_event_modifiers_get,
        _obspython.obs_mouse_event_modifiers_set,
        doc="modifiers",
    )
    x: int32_t = property(
        _obspython.obs_mouse_event_x_get, _obspython.obs_mouse_event_x_set, doc="x"
    )
    y: int32_t = property(
        _obspython.obs_mouse_event_y_get, _obspython.obs_mouse_event_y_set, doc="y"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_mouse_event

_obspython.obs_mouse_event_swigregister(obs_mouse_event)

class obs_key_event:
    """Proxy of C obs_key_event struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    modifiers: uint32_t = property(
        _obspython.obs_key_event_modifiers_get,
        _obspython.obs_key_event_modifiers_set,
        doc="modifiers",
    )
    text: "char *" = property(
        _obspython.obs_key_event_text_get, _obspython.obs_key_event_text_set, doc="text"
    )
    native_modifiers: uint32_t = property(
        _obspython.obs_key_event_native_modifiers_get,
        _obspython.obs_key_event_native_modifiers_set,
        doc="native_modifiers",
    )
    native_scancode: uint32_t = property(
        _obspython.obs_key_event_native_scancode_get,
        _obspython.obs_key_event_native_scancode_set,
        doc="native_scancode",
    )
    native_vkey: uint32_t = property(
        _obspython.obs_key_event_native_vkey_get,
        _obspython.obs_key_event_native_vkey_set,
        doc="native_vkey",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_key_event

_obspython.obs_key_event_swigregister(obs_key_event)
XINPUT_MOUSE_LEN = _obspython.XINPUT_MOUSE_LEN
OBS_KEY_LAST_VALUE = _obspython.OBS_KEY_LAST_VALUE

class obs_key_combination:
    """Proxy of C obs_key_combination struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    modifiers: uint32_t = property(
        _obspython.obs_key_combination_modifiers_get,
        _obspython.obs_key_combination_modifiers_set,
        doc="modifiers",
    )
    key: obs_key_t = property(
        _obspython.obs_key_combination_key_get,
        _obspython.obs_key_combination_key_set,
        doc="key",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_key_combination

_obspython.obs_key_combination_swigregister(obs_key_combination)
cvar = _obspython.cvar
OBS_INVALID_HOTKEY_ID = cvar.OBS_INVALID_HOTKEY_ID
OBS_INVALID_HOTKEY_PAIR_ID = cvar.OBS_INVALID_HOTKEY_PAIR_ID
OBS_HOTKEY_REGISTERER_FRONTEND = _obspython.OBS_HOTKEY_REGISTERER_FRONTEND
OBS_HOTKEY_REGISTERER_SOURCE = _obspython.OBS_HOTKEY_REGISTERER_SOURCE
OBS_HOTKEY_REGISTERER_OUTPUT = _obspython.OBS_HOTKEY_REGISTERER_OUTPUT
OBS_HOTKEY_REGISTERER_ENCODER = _obspython.OBS_HOTKEY_REGISTERER_ENCODER
OBS_HOTKEY_REGISTERER_SERVICE = _obspython.OBS_HOTKEY_REGISTERER_SERVICE

def obs_hotkey_get_id(key: "obs_hotkey_t const *") -> obs_hotkey_id: ...
def obs_hotkey_get_name(key: "obs_hotkey_t const *") -> "char const *": ...
def obs_hotkey_get_description(key: "obs_hotkey_t const *") -> "char const *": ...
def obs_hotkey_get_registerer_type(
    key: "obs_hotkey_t const *",
) -> obs_hotkey_registerer_t: ...
def obs_hotkey_get_registerer(key: "obs_hotkey_t const *") -> "void *": ...
def obs_hotkey_get_pair_partner_id(key: "obs_hotkey_t const *") -> obs_hotkey_id: ...
def obs_hotkey_binding_get_key_combination(
    binding: "obs_hotkey_binding_t *",
) -> obs_key_combination_t: ...
def obs_hotkey_binding_get_hotkey_id(
    binding: "obs_hotkey_binding_t *",
) -> obs_hotkey_id: ...
def obs_hotkey_binding_get_hotkey(
    binding: "obs_hotkey_binding_t *",
) -> "obs_hotkey_t *": ...
def obs_hotkey_set_name(id: obs_hotkey_id, name: "char const *") -> void: ...
def obs_hotkey_set_description(id: obs_hotkey_id, desc: "char const *") -> void: ...
def obs_hotkey_pair_set_names(
    id: obs_hotkey_pair_id, name0: "char const *", name1: "char const *"
) -> void: ...
def obs_hotkey_pair_set_descriptions(
    id: obs_hotkey_pair_id, desc0: "char const *", desc1: "char const *"
) -> void: ...
def obs_hotkeys_set_audio_hotkeys_translations(
    mute: "char const *",
    unmute: "char const *",
    push_to_mute: "char const *",
    push_to_talk: "char const *",
) -> void: ...
def obs_hotkeys_set_sceneitem_hotkeys_translations(
    show: "char const *", hide: "char const *"
) -> void: ...
def obs_hotkey_register_frontend(
    name: "char const *",
    description: "char const *",
    func: obs_hotkey_func,
    data: "void *",
) -> obs_hotkey_id: ...
def obs_hotkey_register_encoder(
    encoder: "obs_encoder_t *",
    name: "char const *",
    description: "char const *",
    func: obs_hotkey_func,
    data: "void *",
) -> obs_hotkey_id: ...
def obs_hotkey_register_output(
    output: "obs_output_t *",
    name: "char const *",
    description: "char const *",
    func: obs_hotkey_func,
    data: "void *",
) -> obs_hotkey_id: ...
def obs_hotkey_register_service(
    service: "obs_service_t *",
    name: "char const *",
    description: "char const *",
    func: obs_hotkey_func,
    data: "void *",
) -> obs_hotkey_id: ...
def obs_hotkey_register_source(
    source: "obs_source_t *",
    name: "char const *",
    description: "char const *",
    func: obs_hotkey_func,
    data: "void *",
) -> obs_hotkey_id: ...
def obs_hotkey_pair_register_frontend(
    name0: "char const *",
    description0: "char const *",
    name1: "char const *",
    description1: "char const *",
    func0: obs_hotkey_active_func,
    func1: obs_hotkey_active_func,
    data0: "void *",
    data1: "void *",
) -> obs_hotkey_pair_id: ...
def obs_hotkey_pair_register_encoder(
    encoder: "obs_encoder_t *",
    name0: "char const *",
    description0: "char const *",
    name1: "char const *",
    description1: "char const *",
    func0: obs_hotkey_active_func,
    func1: obs_hotkey_active_func,
    data0: "void *",
    data1: "void *",
) -> obs_hotkey_pair_id: ...
def obs_hotkey_pair_register_output(
    output: "obs_output_t *",
    name0: "char const *",
    description0: "char const *",
    name1: "char const *",
    description1: "char const *",
    func0: obs_hotkey_active_func,
    func1: obs_hotkey_active_func,
    data0: "void *",
    data1: "void *",
) -> obs_hotkey_pair_id: ...
def obs_hotkey_pair_register_service(
    service: "obs_service_t *",
    name0: "char const *",
    description0: "char const *",
    name1: "char const *",
    description1: "char const *",
    func0: obs_hotkey_active_func,
    func1: obs_hotkey_active_func,
    data0: "void *",
    data1: "void *",
) -> obs_hotkey_pair_id: ...
def obs_hotkey_pair_register_source(
    source: "obs_source_t *",
    name0: "char const *",
    description0: "char const *",
    name1: "char const *",
    description1: "char const *",
    func0: obs_hotkey_active_func,
    func1: obs_hotkey_active_func,
    data0: "void *",
    data1: "void *",
) -> obs_hotkey_pair_id: ...
def obs_hotkey_unregister(id: obs_hotkey_id) -> void: ...
def obs_hotkey_pair_unregister(id: obs_hotkey_pair_id) -> void: ...
def obs_hotkey_load_bindings(
    id: obs_hotkey_id, combinations: obs_key_combination, num: size_t
) -> void: ...
def obs_hotkey_load(id: obs_hotkey_id, data: "obs_data_array_t *") -> void: ...
def obs_hotkeys_load_encoder(
    encoder: "obs_encoder_t *", hotkeys: "obs_data_t *"
) -> void: ...
def obs_hotkeys_load_output(
    output: "obs_output_t *", hotkeys: "obs_data_t *"
) -> void: ...
def obs_hotkeys_load_service(
    service: "obs_service_t *", hotkeys: "obs_data_t *"
) -> void: ...
def obs_hotkeys_load_source(
    source: "obs_source_t *", hotkeys: "obs_data_t *"
) -> void: ...
def obs_hotkey_pair_load(
    id: obs_hotkey_pair_id, data0: "obs_data_array_t *", data1: "obs_data_array_t *"
) -> void: ...
def obs_hotkey_save(id: obs_hotkey_id) -> "obs_data_array_t *": ...
def obs_hotkey_pair_save(
    id: obs_hotkey_pair_id,
    p_data0: "obs_data_array_t **",
    p_data1: "obs_data_array_t **",
) -> void: ...
def obs_hotkeys_save_encoder(encoder: "obs_encoder_t *") -> "obs_data_t *": ...
def obs_hotkeys_save_output(output: "obs_output_t *") -> "obs_data_t *": ...
def obs_hotkeys_save_service(service: "obs_service_t *") -> "obs_data_t *": ...
def obs_hotkeys_save_source(source: "obs_source_t *") -> "obs_data_t *": ...
def obs_enum_hotkeys(func: obs_hotkey_enum_func, data: "void *") -> void: ...
def obs_enum_hotkey_bindings(
    func: obs_hotkey_binding_enum_func, data: "void *"
) -> void: ...
def obs_hotkey_inject_event(hotkey: obs_key_combination, pressed: bool) -> void: ...
def obs_hotkey_enable_background_press(enable: bool) -> void: ...
def obs_hotkey_enable_strict_modifiers(enable: bool) -> void: ...
def obs_hotkey_set_callback_routing_func(
    func: obs_hotkey_callback_router_func, data: "void *"
) -> void: ...
def obs_hotkey_trigger_routed_callback(id: obs_hotkey_id, pressed: bool) -> void: ...
def obs_hotkey_enable_callback_rerouting(enable: bool) -> void: ...
def obs_hotkey_update_atomic(
    func: obs_hotkey_atomic_update_func, data: "void *"
) -> void: ...
def obs_key_to_str(key: obs_key_t, str: "struct dstr *") -> void: ...
def obs_key_combination_to_str(
    key: obs_key_combination, str: "struct dstr *"
) -> void: ...
def obs_key_from_virtual_key(code: int) -> obs_key_t: ...
def obs_key_to_virtual_key(key: obs_key_t) -> int: ...
def obs_key_to_name(key: obs_key_t) -> "char const *": ...
def obs_key_from_name(name: "char const *") -> obs_key_t: ...
def obs_key_combination_is_empty(combo: obs_key_combination) -> bool: ...

OBS_ORDER_MOVE_UP = _obspython.OBS_ORDER_MOVE_UP
OBS_ORDER_MOVE_DOWN = _obspython.OBS_ORDER_MOVE_DOWN
OBS_ORDER_MOVE_TOP = _obspython.OBS_ORDER_MOVE_TOP
OBS_ORDER_MOVE_BOTTOM = _obspython.OBS_ORDER_MOVE_BOTTOM
OBS_NO_DIRECT_RENDERING = _obspython.OBS_NO_DIRECT_RENDERING
OBS_ALLOW_DIRECT_RENDERING = _obspython.OBS_ALLOW_DIRECT_RENDERING
OBS_SCALE_DISABLE = _obspython.OBS_SCALE_DISABLE
OBS_SCALE_POINT = _obspython.OBS_SCALE_POINT
OBS_SCALE_BICUBIC = _obspython.OBS_SCALE_BICUBIC
OBS_SCALE_BILINEAR = _obspython.OBS_SCALE_BILINEAR
OBS_SCALE_LANCZOS = _obspython.OBS_SCALE_LANCZOS
OBS_SCALE_AREA = _obspython.OBS_SCALE_AREA
OBS_BLEND_METHOD_DEFAULT = _obspython.OBS_BLEND_METHOD_DEFAULT
OBS_BLEND_METHOD_SRGB_OFF = _obspython.OBS_BLEND_METHOD_SRGB_OFF
OBS_BLEND_NORMAL = _obspython.OBS_BLEND_NORMAL
OBS_BLEND_ADDITIVE = _obspython.OBS_BLEND_ADDITIVE
OBS_BLEND_SUBTRACT = _obspython.OBS_BLEND_SUBTRACT
OBS_BLEND_SCREEN = _obspython.OBS_BLEND_SCREEN
OBS_BLEND_MULTIPLY = _obspython.OBS_BLEND_MULTIPLY
OBS_BLEND_LIGHTEN = _obspython.OBS_BLEND_LIGHTEN
OBS_BLEND_DARKEN = _obspython.OBS_BLEND_DARKEN
OBS_BOUNDS_NONE = _obspython.OBS_BOUNDS_NONE
OBS_BOUNDS_STRETCH = _obspython.OBS_BOUNDS_STRETCH
OBS_BOUNDS_SCALE_INNER = _obspython.OBS_BOUNDS_SCALE_INNER
OBS_BOUNDS_SCALE_OUTER = _obspython.OBS_BOUNDS_SCALE_OUTER
OBS_BOUNDS_SCALE_TO_WIDTH = _obspython.OBS_BOUNDS_SCALE_TO_WIDTH
OBS_BOUNDS_SCALE_TO_HEIGHT = _obspython.OBS_BOUNDS_SCALE_TO_HEIGHT
OBS_BOUNDS_MAX_ONLY = _obspython.OBS_BOUNDS_MAX_ONLY

class obs_transform_info:
    """Proxy of C obs_transform_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    pos: "struct vec2" = property(
        _obspython.obs_transform_info_pos_get,
        _obspython.obs_transform_info_pos_set,
        doc="pos",
    )
    rot: float = property(
        _obspython.obs_transform_info_rot_get,
        _obspython.obs_transform_info_rot_set,
        doc="rot",
    )
    scale: "struct vec2" = property(
        _obspython.obs_transform_info_scale_get,
        _obspython.obs_transform_info_scale_set,
        doc="scale",
    )
    alignment: uint32_t = property(
        _obspython.obs_transform_info_alignment_get,
        _obspython.obs_transform_info_alignment_set,
        doc="alignment",
    )
    bounds_type: "enum obs_bounds_type" = property(
        _obspython.obs_transform_info_bounds_type_get,
        _obspython.obs_transform_info_bounds_type_set,
        doc="bounds_type",
    )
    bounds_alignment: uint32_t = property(
        _obspython.obs_transform_info_bounds_alignment_get,
        _obspython.obs_transform_info_bounds_alignment_set,
        doc="bounds_alignment",
    )
    bounds: "struct vec2" = property(
        _obspython.obs_transform_info_bounds_get,
        _obspython.obs_transform_info_bounds_set,
        doc="bounds",
    )
    crop_to_bounds: bool = property(
        _obspython.obs_transform_info_crop_to_bounds_get,
        _obspython.obs_transform_info_crop_to_bounds_set,
        doc="crop_to_bounds",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_transform_info

_obspython.obs_transform_info_swigregister(obs_transform_info)

class obs_video_info:
    """Proxy of C obs_video_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    fps_num: uint32_t = property(
        _obspython.obs_video_info_fps_num_get,
        _obspython.obs_video_info_fps_num_set,
        doc="fps_num",
    )
    fps_den: uint32_t = property(
        _obspython.obs_video_info_fps_den_get,
        _obspython.obs_video_info_fps_den_set,
        doc="fps_den",
    )
    base_width: uint32_t = property(
        _obspython.obs_video_info_base_width_get,
        _obspython.obs_video_info_base_width_set,
        doc="base_width",
    )
    base_height: uint32_t = property(
        _obspython.obs_video_info_base_height_get,
        _obspython.obs_video_info_base_height_set,
        doc="base_height",
    )
    output_width: uint32_t = property(
        _obspython.obs_video_info_output_width_get,
        _obspython.obs_video_info_output_width_set,
        doc="output_width",
    )
    output_height: uint32_t = property(
        _obspython.obs_video_info_output_height_get,
        _obspython.obs_video_info_output_height_set,
        doc="output_height",
    )
    output_format: "enum video_format" = property(
        _obspython.obs_video_info_output_format_get,
        _obspython.obs_video_info_output_format_set,
        doc="output_format",
    )
    adapter: uint32_t = property(
        _obspython.obs_video_info_adapter_get,
        _obspython.obs_video_info_adapter_set,
        doc="adapter",
    )
    gpu_conversion: bool = property(
        _obspython.obs_video_info_gpu_conversion_get,
        _obspython.obs_video_info_gpu_conversion_set,
        doc="gpu_conversion",
    )
    colorspace: "enum video_colorspace" = property(
        _obspython.obs_video_info_colorspace_get,
        _obspython.obs_video_info_colorspace_set,
        doc="colorspace",
    )
    range: "enum video_range_type" = property(
        _obspython.obs_video_info_range_get,
        _obspython.obs_video_info_range_set,
        doc="range",
    )
    scale_type: "enum obs_scale_type" = property(
        _obspython.obs_video_info_scale_type_get,
        _obspython.obs_video_info_scale_type_set,
        doc="scale_type",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_video_info

_obspython.obs_video_info_swigregister(obs_video_info)

class obs_audio_info:
    """Proxy of C obs_audio_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    samples_per_sec: uint32_t = property(
        _obspython.obs_audio_info_samples_per_sec_get,
        _obspython.obs_audio_info_samples_per_sec_set,
        doc="samples_per_sec",
    )
    speakers: "enum speaker_layout" = property(
        _obspython.obs_audio_info_speakers_get,
        _obspython.obs_audio_info_speakers_set,
        doc="speakers",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_audio_info

_obspython.obs_audio_info_swigregister(obs_audio_info)

class obs_audio_info2:
    """Proxy of C obs_audio_info2 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    samples_per_sec: uint32_t = property(
        _obspython.obs_audio_info2_samples_per_sec_get,
        _obspython.obs_audio_info2_samples_per_sec_set,
        doc="samples_per_sec",
    )
    speakers: "enum speaker_layout" = property(
        _obspython.obs_audio_info2_speakers_get,
        _obspython.obs_audio_info2_speakers_set,
        doc="speakers",
    )
    max_buffering_ms: uint32_t = property(
        _obspython.obs_audio_info2_max_buffering_ms_get,
        _obspython.obs_audio_info2_max_buffering_ms_set,
        doc="max_buffering_ms",
    )
    fixed_buffering: bool = property(
        _obspython.obs_audio_info2_fixed_buffering_get,
        _obspython.obs_audio_info2_fixed_buffering_set,
        doc="fixed_buffering",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_audio_info2

_obspython.obs_audio_info2_swigregister(obs_audio_info2)

class obs_audio_data:
    """Proxy of C obs_audio_data struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    data: uint8_t * [MAX_AV_PLANES] = property(
        _obspython.obs_audio_data_data_get,
        _obspython.obs_audio_data_data_set,
        doc="data",
    )
    frames: uint32_t = property(
        _obspython.obs_audio_data_frames_get,
        _obspython.obs_audio_data_frames_set,
        doc="frames",
    )
    timestamp: uint64_t = property(
        _obspython.obs_audio_data_timestamp_get,
        _obspython.obs_audio_data_timestamp_set,
        doc="timestamp",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_audio_data

_obspython.obs_audio_data_swigregister(obs_audio_data)

class obs_source_audio:
    """Proxy of C obs_source_audio struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    data: "uint8_t const *[MAX_AV_PLANES]" = property(
        _obspython.obs_source_audio_data_get,
        _obspython.obs_source_audio_data_set,
        doc="data",
    )
    frames: uint32_t = property(
        _obspython.obs_source_audio_frames_get,
        _obspython.obs_source_audio_frames_set,
        doc="frames",
    )
    speakers: "enum speaker_layout" = property(
        _obspython.obs_source_audio_speakers_get,
        _obspython.obs_source_audio_speakers_set,
        doc="speakers",
    )
    format: "enum audio_format" = property(
        _obspython.obs_source_audio_format_get,
        _obspython.obs_source_audio_format_set,
        doc="format",
    )
    samples_per_sec: uint32_t = property(
        _obspython.obs_source_audio_samples_per_sec_get,
        _obspython.obs_source_audio_samples_per_sec_set,
        doc="samples_per_sec",
    )
    timestamp: uint64_t = property(
        _obspython.obs_source_audio_timestamp_get,
        _obspython.obs_source_audio_timestamp_set,
        doc="timestamp",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_audio

_obspython.obs_source_audio_swigregister(obs_source_audio)

class obs_source_cea_708:
    """Proxy of C obs_source_cea_708 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    data: "uint8_t const *" = property(
        _obspython.obs_source_cea_708_data_get,
        _obspython.obs_source_cea_708_data_set,
        doc="data",
    )
    packets: uint32_t = property(
        _obspython.obs_source_cea_708_packets_get,
        _obspython.obs_source_cea_708_packets_set,
        doc="packets",
    )
    timestamp: uint64_t = property(
        _obspython.obs_source_cea_708_timestamp_get,
        _obspython.obs_source_cea_708_timestamp_set,
        doc="timestamp",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_cea_708

_obspython.obs_source_cea_708_swigregister(obs_source_cea_708)
OBS_SOURCE_FRAME_LINEAR_ALPHA = _obspython.OBS_SOURCE_FRAME_LINEAR_ALPHA

class obs_source_frame:
    """Proxy of C obs_source_frame struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    data: uint8_t * [MAX_AV_PLANES] = property(
        _obspython.obs_source_frame_data_get,
        _obspython.obs_source_frame_data_set,
        doc="data",
    )
    linesize: uint32_t[MAX_AV_PLANES] = property(
        _obspython.obs_source_frame_linesize_get,
        _obspython.obs_source_frame_linesize_set,
        doc="linesize",
    )
    width: uint32_t = property(
        _obspython.obs_source_frame_width_get,
        _obspython.obs_source_frame_width_set,
        doc="width",
    )
    height: uint32_t = property(
        _obspython.obs_source_frame_height_get,
        _obspython.obs_source_frame_height_set,
        doc="height",
    )
    timestamp: uint64_t = property(
        _obspython.obs_source_frame_timestamp_get,
        _obspython.obs_source_frame_timestamp_set,
        doc="timestamp",
    )
    format: "enum video_format" = property(
        _obspython.obs_source_frame_format_get,
        _obspython.obs_source_frame_format_set,
        doc="format",
    )
    color_matrix: float[16] = property(
        _obspython.obs_source_frame_color_matrix_get,
        _obspython.obs_source_frame_color_matrix_set,
        doc="color_matrix",
    )
    full_range: bool = property(
        _obspython.obs_source_frame_full_range_get,
        _obspython.obs_source_frame_full_range_set,
        doc="full_range",
    )
    max_luminance: uint16_t = property(
        _obspython.obs_source_frame_max_luminance_get,
        _obspython.obs_source_frame_max_luminance_set,
        doc="max_luminance",
    )
    color_range_min: float[3] = property(
        _obspython.obs_source_frame_color_range_min_get,
        _obspython.obs_source_frame_color_range_min_set,
        doc="color_range_min",
    )
    color_range_max: float[3] = property(
        _obspython.obs_source_frame_color_range_max_get,
        _obspython.obs_source_frame_color_range_max_set,
        doc="color_range_max",
    )
    flip: bool = property(
        _obspython.obs_source_frame_flip_get,
        _obspython.obs_source_frame_flip_set,
        doc="flip",
    )
    flags: uint8_t = property(
        _obspython.obs_source_frame_flags_get,
        _obspython.obs_source_frame_flags_set,
        doc="flags",
    )
    trc: uint8_t = property(
        _obspython.obs_source_frame_trc_get,
        _obspython.obs_source_frame_trc_set,
        doc="trc",
    )
    refs: "long volatile" = property(
        _obspython.obs_source_frame_refs_get,
        _obspython.obs_source_frame_refs_set,
        doc="refs",
    )
    prev_frame: bool = property(
        _obspython.obs_source_frame_prev_frame_get,
        _obspython.obs_source_frame_prev_frame_set,
        doc="prev_frame",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_frame

_obspython.obs_source_frame_swigregister(obs_source_frame)

class obs_source_frame2:
    """Proxy of C obs_source_frame2 struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    data: uint8_t * [MAX_AV_PLANES] = property(
        _obspython.obs_source_frame2_data_get,
        _obspython.obs_source_frame2_data_set,
        doc="data",
    )
    linesize: uint32_t[MAX_AV_PLANES] = property(
        _obspython.obs_source_frame2_linesize_get,
        _obspython.obs_source_frame2_linesize_set,
        doc="linesize",
    )
    width: uint32_t = property(
        _obspython.obs_source_frame2_width_get,
        _obspython.obs_source_frame2_width_set,
        doc="width",
    )
    height: uint32_t = property(
        _obspython.obs_source_frame2_height_get,
        _obspython.obs_source_frame2_height_set,
        doc="height",
    )
    timestamp: uint64_t = property(
        _obspython.obs_source_frame2_timestamp_get,
        _obspython.obs_source_frame2_timestamp_set,
        doc="timestamp",
    )
    format: "enum video_format" = property(
        _obspython.obs_source_frame2_format_get,
        _obspython.obs_source_frame2_format_set,
        doc="format",
    )
    range: "enum video_range_type" = property(
        _obspython.obs_source_frame2_range_get,
        _obspython.obs_source_frame2_range_set,
        doc="range",
    )
    color_matrix: float[16] = property(
        _obspython.obs_source_frame2_color_matrix_get,
        _obspython.obs_source_frame2_color_matrix_set,
        doc="color_matrix",
    )
    color_range_min: float[3] = property(
        _obspython.obs_source_frame2_color_range_min_get,
        _obspython.obs_source_frame2_color_range_min_set,
        doc="color_range_min",
    )
    color_range_max: float[3] = property(
        _obspython.obs_source_frame2_color_range_max_get,
        _obspython.obs_source_frame2_color_range_max_set,
        doc="color_range_max",
    )
    flip: bool = property(
        _obspython.obs_source_frame2_flip_get,
        _obspython.obs_source_frame2_flip_set,
        doc="flip",
    )
    flags: uint8_t = property(
        _obspython.obs_source_frame2_flags_get,
        _obspython.obs_source_frame2_flags_set,
        doc="flags",
    )
    trc: uint8_t = property(
        _obspython.obs_source_frame2_trc_get,
        _obspython.obs_source_frame2_trc_set,
        doc="trc",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_source_frame2

_obspython.obs_source_frame2_swigregister(obs_source_frame2)

class obs_cmdline_args:
    """Proxy of C obs_cmdline_args struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    argc: int = property(
        _obspython.obs_cmdline_args_argc_get,
        _obspython.obs_cmdline_args_argc_set,
        doc="argc",
    )
    argv: "char **" = property(
        _obspython.obs_cmdline_args_argv_get,
        _obspython.obs_cmdline_args_argv_set,
        doc="argv",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_cmdline_args

_obspython.obs_cmdline_args_swigregister(obs_cmdline_args)

def obs_find_data_file(file: "char const *") -> "char *": ...
def obs_add_data_path(path: "char const *") -> void: ...
def obs_remove_data_path(path: "char const *") -> bool: ...
def obs_startup(
    locale: "char const *",
    module_config_path: "char const *",
    store: "profiler_name_store_t *",
) -> bool: ...
def obs_shutdown() -> void: ...
def obs_initialized() -> bool: ...
def obs_get_version() -> uint32_t: ...
def obs_get_version_string() -> "char const *": ...
def obs_set_cmdline_args(argc: int, argv: "char const *const *") -> void: ...
def obs_get_cmdline_args() -> "struct obs_cmdline_args": ...
def obs_set_locale(locale: "char const *") -> void: ...
def obs_get_locale() -> "char const *": ...
def obs_get_profiler_name_store() -> "profiler_name_store_t *": ...
def obs_reset_video(ovi: obs_video_info) -> int: ...
def obs_reset_audio(oai: obs_audio_info) -> bool: ...
def obs_reset_audio2(oai: obs_audio_info2) -> bool: ...
def obs_get_video_info(ovi: obs_video_info) -> bool: ...
def obs_get_video_sdr_white_level() -> float: ...
def obs_get_video_hdr_nominal_peak_level() -> float: ...
def obs_set_video_levels(
    sdr_white_level: float, hdr_nominal_peak_level: float
) -> void: ...
def obs_get_audio_info(oai: obs_audio_info) -> bool: ...
def obs_open_module(
    module: "obs_module_t **", path: "char const *", data_path: "char const *"
) -> int: ...
def obs_init_module(module: "obs_module_t *") -> bool: ...
def obs_get_module(name: "char const *") -> "obs_module_t *": ...
def obs_get_module_lib(module: "obs_module_t *") -> "void *": ...
def obs_module_get_locale_string(
    mod: "obs_module_t const *",
    lookup_string: "char const *",
    translated_string: "char const **",
) -> bool: ...
def obs_module_get_locale_text(
    mod: "obs_module_t const *", text: "char const *"
) -> "char const *": ...
def obs_log_loaded_modules() -> void: ...
def obs_get_module_file_name(module: "obs_module_t *") -> "char const *": ...
def obs_get_module_name(module: "obs_module_t *") -> "char const *": ...
def obs_get_module_author(module: "obs_module_t *") -> "char const *": ...
def obs_get_module_description(module: "obs_module_t *") -> "char const *": ...
def obs_get_module_binary_path(module: "obs_module_t *") -> "char const *": ...
def obs_get_module_data_path(module: "obs_module_t *") -> "char const *": ...
def obs_enum_modules(callback: obs_enum_module_callback_t, param: "void *") -> void: ...
def obs_module_load_locale(
    module: "obs_module_t *", default_locale: "char const *", locale: "char const *"
) -> "lookup_t *": ...
def obs_find_module_file(
    module: "obs_module_t *", file: "char const *"
) -> "char *": ...
def obs_module_get_config_path(
    module: "obs_module_t *", file: "char const *"
) -> "char *": ...
def obs_enum_source_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_input_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_input_types2(
    idx: size_t, id: "char const **", unversioned_id: "char const **"
) -> bool: ...
def obs_get_latest_input_type_id(unversioned_id: "char const *") -> "char const *": ...
def obs_enum_filter_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_transition_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_output_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_encoder_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enum_service_types(idx: size_t, id: "char const **") -> bool: ...
def obs_enter_graphics() -> void: ...
def obs_leave_graphics() -> void: ...
def obs_get_audio() -> "audio_t *": ...
def obs_get_video() -> "video_t *": ...
def obs_video_active() -> bool: ...
def obs_set_output_source(channel: uint32_t, source: "obs_source_t *") -> void: ...
def obs_get_output_source(channel: uint32_t) -> "obs_source_t *": ...
def obs_enum_sources(
    enum_proc: "bool (*)(void *,obs_source_t *)", param: "void *"
) -> void: ...
def obs_enum_scenes(
    enum_proc: "bool (*)(void *,obs_source_t *)", param: "void *"
) -> void: ...
def obs_enum_all_sources(
    enum_proc: "bool (*)(void *,obs_source_t *)", param: "void *"
) -> void: ...
def obs_enum_outputs(
    enum_proc: "bool (*)(void *,obs_output_t *)", param: "void *"
) -> void: ...
def obs_enum_encoders(
    enum_proc: "bool (*)(void *,obs_encoder_t *)", param: "void *"
) -> void: ...
def obs_enum_services(
    enum_proc: "bool (*)(void *,obs_service_t *)", param: "void *"
) -> void: ...
def obs_get_source_by_name(name: "char const *") -> "obs_source_t *": ...
def obs_get_source_by_uuid(uuid: "char const *") -> "obs_source_t *": ...
def obs_get_transition_by_name(name: "char const *") -> "obs_source_t *": ...
def obs_get_transition_by_uuid(uuid: "char const *") -> "obs_source_t *": ...
def obs_get_output_by_name(name: "char const *") -> "obs_output_t *": ...
def obs_get_encoder_by_name(name: "char const *") -> "obs_encoder_t *": ...
def obs_get_service_by_name(name: "char const *") -> "obs_service_t *": ...

OBS_EFFECT_DEFAULT = _obspython.OBS_EFFECT_DEFAULT
OBS_EFFECT_DEFAULT_RECT = _obspython.OBS_EFFECT_DEFAULT_RECT
OBS_EFFECT_OPAQUE = _obspython.OBS_EFFECT_OPAQUE
OBS_EFFECT_SOLID = _obspython.OBS_EFFECT_SOLID
OBS_EFFECT_BICUBIC = _obspython.OBS_EFFECT_BICUBIC
OBS_EFFECT_LANCZOS = _obspython.OBS_EFFECT_LANCZOS
OBS_EFFECT_BILINEAR_LOWRES = _obspython.OBS_EFFECT_BILINEAR_LOWRES
OBS_EFFECT_PREMULTIPLIED_ALPHA = _obspython.OBS_EFFECT_PREMULTIPLIED_ALPHA
OBS_EFFECT_REPEAT = _obspython.OBS_EFFECT_REPEAT
OBS_EFFECT_AREA = _obspython.OBS_EFFECT_AREA

def obs_get_base_effect(effect: "enum obs_base_effect") -> "gs_effect_t *": ...
def obs_get_signal_handler() -> "signal_handler_t *": ...
def obs_get_proc_handler() -> "proc_handler_t *": ...
def obs_render_main_texture() -> void: ...
def obs_render_main_texture_src_color_only() -> void: ...
def obs_get_main_texture() -> "gs_texture_t *": ...
def obs_set_master_volume(volume: float) -> void: ...
def obs_get_master_volume() -> float: ...
def obs_save_source(source: "obs_source_t *") -> "obs_data_t *": ...
def obs_load_source(data: "obs_data_t *") -> "obs_source_t *": ...
def obs_load_private_source(data: "obs_data_t *") -> "obs_source_t *": ...
def obs_source_save(source: "obs_source_t *") -> void: ...
def obs_source_load(source: "obs_source_t *") -> void: ...
def obs_source_load2(source: "obs_source_t *") -> void: ...
def obs_load_sources(
    array: "obs_data_array_t *", cb: obs_load_source_cb, private_data: "void *"
) -> void: ...
def obs_save_sources() -> "obs_data_array_t *": ...
def obs_save_sources_filtered(
    cb: obs_save_source_filter_cb, data: "void *"
) -> "obs_data_array_t *": ...
def obs_reset_source_uuids() -> void: ...

OBS_OBJ_TYPE_INVALID = _obspython.OBS_OBJ_TYPE_INVALID
OBS_OBJ_TYPE_SOURCE = _obspython.OBS_OBJ_TYPE_SOURCE
OBS_OBJ_TYPE_OUTPUT = _obspython.OBS_OBJ_TYPE_OUTPUT
OBS_OBJ_TYPE_ENCODER = _obspython.OBS_OBJ_TYPE_ENCODER
OBS_OBJ_TYPE_SERVICE = _obspython.OBS_OBJ_TYPE_SERVICE

def obs_obj_get_type(obj: "void *") -> "enum obs_obj_type": ...
def obs_obj_get_id(obj: "void *") -> "char const *": ...
def obs_obj_invalid(obj: "void *") -> bool: ...
def obs_obj_get_data(obj: "void *") -> "void *": ...
def obs_obj_is_private(obj: "void *") -> bool: ...
def obs_audio_monitoring_available() -> bool: ...
def obs_reset_audio_monitoring() -> void: ...
def obs_enum_audio_monitoring_devices(
    cb: obs_enum_audio_device_cb, data: "void *"
) -> void: ...
def obs_set_audio_monitoring_device(
    name: "char const *", id: "char const *"
) -> bool: ...
def obs_get_audio_monitoring_device(
    name: "char const **", id: "char const **"
) -> void: ...
def obs_add_tick_callback(tick: "void (*)(void *,float)", param: "void *") -> void: ...
def obs_remove_tick_callback(
    tick: "void (*)(void *,float)", param: "void *"
) -> void: ...
def obs_add_main_render_callback(
    draw: "void (*)(void *,uint32_t,uint32_t)", param: "void *"
) -> void: ...
def obs_remove_main_render_callback(
    draw: "void (*)(void *,uint32_t,uint32_t)", param: "void *"
) -> void: ...
def obs_add_main_rendered_callback(
    rendered: "void (*)(void *)", param: "void *"
) -> void: ...
def obs_remove_main_rendered_callback(
    rendered: "void (*)(void *)", param: "void *"
) -> void: ...
def obs_add_raw_video_callback(
    conversion: "struct video_scale_info const *",
    callback: "void (*)(void *,struct video_data *)",
    param: "void *",
) -> void: ...
def obs_add_raw_video_callback2(
    conversion: "struct video_scale_info const *",
    frame_rate_divisor: uint32_t,
    callback: "void (*)(void *,struct video_data *)",
    param: "void *",
) -> void: ...
def obs_remove_raw_video_callback(
    callback: "void (*)(void *,struct video_data *)", param: "void *"
) -> void: ...
def obs_add_raw_audio_callback(
    mix_idx: size_t,
    conversion: "struct audio_convert_info const *",
    callback: audio_output_callback_t,
    param: "void *",
) -> void: ...
def obs_remove_raw_audio_callback(
    mix_idx: size_t, callback: audio_output_callback_t, param: "void *"
) -> void: ...
def obs_get_video_frame_time() -> uint64_t: ...
def obs_get_active_fps() -> double: ...
def obs_get_average_frame_time_ns() -> uint64_t: ...
def obs_get_frame_interval_ns() -> uint64_t: ...
def obs_get_total_frames() -> uint32_t: ...
def obs_get_lagged_frames() -> uint32_t: ...
def obs_nv12_tex_active() -> bool: ...
def obs_p010_tex_active() -> bool: ...
def obs_apply_private_data(settings: "obs_data_t *") -> void: ...
def obs_set_private_data(settings: "obs_data_t *") -> void: ...
def obs_get_private_data() -> "obs_data_t *": ...

OBS_TASK_UI = _obspython.OBS_TASK_UI
OBS_TASK_GRAPHICS = _obspython.OBS_TASK_GRAPHICS
OBS_TASK_AUDIO = _obspython.OBS_TASK_AUDIO
OBS_TASK_DESTROY = _obspython.OBS_TASK_DESTROY

def obs_queue_task(
    type: "enum obs_task_type", task: obs_task_t, param: "void *", wait: bool
) -> void: ...
def obs_in_task_thread(type: "enum obs_task_type") -> bool: ...
def obs_wait_for_destroy_queue() -> bool: ...
def obs_set_ui_task_handler(handler: obs_task_handler_t) -> void: ...
def obs_object_get_ref(object: "obs_object_t *") -> "obs_object_t *": ...
def obs_object_release(object: "obs_object_t *") -> void: ...
def obs_weak_object_addref(weak: "obs_weak_object_t *") -> void: ...
def obs_weak_object_release(weak: "obs_weak_object_t *") -> void: ...
def obs_object_get_weak_object(object: "obs_object_t *") -> "obs_weak_object_t *": ...
def obs_weak_object_get_object(weak: "obs_weak_object_t *") -> "obs_object_t *": ...
def obs_weak_object_expired(weak: "obs_weak_object_t *") -> bool: ...
def obs_weak_object_references_object(
    weak: "obs_weak_object_t *", object: "obs_object_t *"
) -> bool: ...
def obs_view_create() -> "obs_view_t *": ...
def obs_view_destroy(view: "obs_view_t *") -> void: ...
def obs_view_set_source(
    view: "obs_view_t *", channel: uint32_t, source: "obs_source_t *"
) -> void: ...
def obs_view_get_source(
    view: "obs_view_t *", channel: uint32_t
) -> "obs_source_t *": ...
def obs_view_render(view: "obs_view_t *") -> void: ...
def obs_view_add(view: "obs_view_t *") -> "video_t *": ...
def obs_view_add2(view: "obs_view_t *", ovi: obs_video_info) -> "video_t *": ...
def obs_view_remove(view: "obs_view_t *") -> void: ...
def obs_view_get_video_info(view: "obs_view_t *", ovi: obs_video_info) -> bool: ...
def obs_view_enum_video_info(
    view: "obs_view_t *",
    enum_proc: "bool (*)(void *,struct obs_video_info *)",
    param: "void *",
) -> void: ...
def obs_display_create(
    graphics_data: gs_init_data, backround_color: uint32_t
) -> "obs_display_t *": ...
def obs_display_destroy(display: "obs_display_t *") -> void: ...
def obs_display_resize(
    display: "obs_display_t *", cx: uint32_t, cy: uint32_t
) -> void: ...
def obs_display_update_color_space(display: "obs_display_t *") -> void: ...
def obs_display_add_draw_callback(
    display: "obs_display_t *",
    draw: "void (*)(void *,uint32_t,uint32_t)",
    param: "void *",
) -> void: ...
def obs_display_remove_draw_callback(
    display: "obs_display_t *",
    draw: "void (*)(void *,uint32_t,uint32_t)",
    param: "void *",
) -> void: ...
def obs_display_set_enabled(display: "obs_display_t *", enable: bool) -> void: ...
def obs_display_enabled(display: "obs_display_t *") -> bool: ...
def obs_display_set_background_color(
    display: "obs_display_t *", color: uint32_t
) -> void: ...
def obs_display_size(
    display: "obs_display_t *", width: "uint32_t *", height: "uint32_t *"
) -> void: ...
def obs_source_get_display_name(id: "char const *") -> "char const *": ...
def obs_source_create(
    id: "char const *",
    name: "char const *",
    settings: "obs_data_t *",
    hotkey_data: "obs_data_t *",
) -> "obs_source_t *": ...
def obs_source_create_private(
    id: "char const *", name: "char const *", settings: "obs_data_t *"
) -> "obs_source_t *": ...
def obs_source_duplicate(
    source: "obs_source_t *", desired_name: "char const *", create_private: bool
) -> "obs_source_t *": ...
def obs_source_addref(source: "obs_source_t *") -> void: ...
def obs_source_release(source: "obs_source_t *") -> void: ...
def obs_weak_source_addref(weak: "obs_weak_source_t *") -> void: ...
def obs_weak_source_release(weak: "obs_weak_source_t *") -> void: ...
def obs_source_get_ref(source: "obs_source_t *") -> "obs_source_t *": ...
def obs_source_get_weak_source(source: "obs_source_t *") -> "obs_weak_source_t *": ...
def obs_weak_source_get_source(weak: "obs_weak_source_t *") -> "obs_source_t *": ...
def obs_weak_source_expired(weak: "obs_weak_source_t *") -> bool: ...
def obs_weak_source_references_source(
    weak: "obs_weak_source_t *", source: "obs_source_t *"
) -> bool: ...
def obs_source_remove(source: "obs_source_t *") -> void: ...
def obs_source_removed(source: "obs_source_t const *") -> bool: ...
def obs_source_set_hidden(source: "obs_source_t *", hidden: bool) -> void: ...
def obs_source_is_hidden(source: "obs_source_t *") -> bool: ...
def obs_source_get_output_flags(source: "obs_source_t const *") -> uint32_t: ...
def obs_get_source_output_flags(id: "char const *") -> uint32_t: ...
def obs_get_source_defaults(id: "char const *") -> "obs_data_t *": ...
def obs_get_source_properties(id: "char const *") -> "obs_properties_t *": ...
def obs_source_get_missing_files(
    source: "obs_source_t const *",
) -> "obs_missing_files_t *": ...
def obs_source_replace_missing_file(
    cb: obs_missing_file_cb,
    source: "obs_source_t *",
    new_path: "char const *",
    data: "void *",
) -> void: ...
def obs_is_source_configurable(id: "char const *") -> bool: ...
def obs_source_configurable(source: "obs_source_t const *") -> bool: ...
def obs_source_properties(source: "obs_source_t const *") -> "obs_properties_t *": ...
def obs_source_update(source: "obs_source_t *", settings: "obs_data_t *") -> void: ...
def obs_source_reset_settings(
    source: "obs_source_t *", settings: "obs_data_t *"
) -> void: ...
def obs_source_video_render(source: "obs_source_t *") -> void: ...
def obs_source_get_width(source: "obs_source_t *") -> uint32_t: ...
def obs_source_get_height(source: "obs_source_t *") -> uint32_t: ...
def obs_source_get_color_space(
    source: "obs_source_t *",
    count: size_t,
    preferred_spaces: "enum gs_color_space const *",
) -> "enum gs_color_space": ...
def obs_source_get_texcoords_centered(source: "obs_source_t *") -> bool: ...
def obs_filter_get_parent(filter: "obs_source_t const *") -> "obs_source_t *": ...
def obs_filter_get_target(filter: "obs_source_t const *") -> "obs_source_t *": ...
def obs_source_default_render(source: "obs_source_t *") -> void: ...
def obs_source_filter_add(
    source: "obs_source_t *", filter: "obs_source_t *"
) -> void: ...
def obs_source_filter_remove(
    source: "obs_source_t *", filter: "obs_source_t *"
) -> void: ...
def obs_source_filter_set_order(
    source: "obs_source_t *",
    filter: "obs_source_t *",
    movement: "enum obs_order_movement",
) -> void: ...
def obs_source_filter_get_index(
    source: "obs_source_t *", filter: "obs_source_t *"
) -> int: ...
def obs_source_filter_set_index(
    source: "obs_source_t *", filter: "obs_source_t *", index: size_t
) -> void: ...
def obs_source_get_settings(source: "obs_source_t const *") -> "obs_data_t *": ...
def obs_source_get_name(source: "obs_source_t const *") -> "char const *": ...
def obs_source_set_name(source: "obs_source_t *", name: "char const *") -> void: ...
def obs_source_get_uuid(source: "obs_source_t const *") -> "char const *": ...
def obs_source_get_type(source: "obs_source_t const *") -> "enum obs_source_type": ...
def obs_source_get_id(source: "obs_source_t const *") -> "char const *": ...
def obs_source_get_unversioned_id(source: "obs_source_t const *") -> "char const *": ...
def obs_source_get_signal_handler(
    source: "obs_source_t const *",
) -> "signal_handler_t *": ...
def obs_source_get_proc_handler(
    source: "obs_source_t const *",
) -> "proc_handler_t *": ...
def obs_source_set_volume(source: "obs_source_t *", volume: float) -> void: ...
def obs_source_get_volume(source: "obs_source_t const *") -> float: ...
def obs_source_get_speaker_layout(
    source: "obs_source_t *",
) -> "enum speaker_layout": ...
def obs_source_set_balance_value(source: "obs_source_t *", balance: float) -> void: ...
def obs_source_get_balance_value(source: "obs_source_t const *") -> float: ...
def obs_source_set_sync_offset(source: "obs_source_t *", offset: int64_t) -> void: ...
def obs_source_get_sync_offset(source: "obs_source_t const *") -> int64_t: ...
def obs_source_enum_active_sources(
    source: "obs_source_t *", enum_callback: obs_source_enum_proc_t, param: "void *"
) -> void: ...
def obs_source_enum_active_tree(
    source: "obs_source_t *", enum_callback: obs_source_enum_proc_t, param: "void *"
) -> void: ...
def obs_source_enum_full_tree(
    source: "obs_source_t *", enum_callback: obs_source_enum_proc_t, param: "void *"
) -> void: ...
def obs_source_active(source: "obs_source_t const *") -> bool: ...
def obs_source_showing(source: "obs_source_t const *") -> bool: ...

OBS_SOURCE_FLAG_UNUSED_1 = _obspython.OBS_SOURCE_FLAG_UNUSED_1
OBS_SOURCE_FLAG_FORCE_MONO = _obspython.OBS_SOURCE_FLAG_FORCE_MONO

def obs_source_set_flags(source: "obs_source_t *", flags: uint32_t) -> void: ...
def obs_source_get_flags(source: "obs_source_t const *") -> uint32_t: ...
def obs_source_set_audio_mixers(source: "obs_source_t *", mixers: uint32_t) -> void: ...
def obs_source_get_audio_mixers(source: "obs_source_t const *") -> uint32_t: ...
def obs_source_inc_showing(source: "obs_source_t *") -> void: ...
def obs_source_inc_active(source: "obs_source_t *") -> void: ...
def obs_source_dec_showing(source: "obs_source_t *") -> void: ...
def obs_source_dec_active(source: "obs_source_t *") -> void: ...
def obs_source_enum_filters(
    source: "obs_source_t *", callback: obs_source_enum_proc_t, param: "void *"
) -> void: ...
def obs_source_get_filter_by_name(
    source: "obs_source_t *", name: "char const *"
) -> "obs_source_t *": ...
def obs_source_filter_count(source: "obs_source_t const *") -> size_t: ...
def obs_source_copy_filters(dst: "obs_source_t *", src: "obs_source_t *") -> void: ...
def obs_source_copy_single_filter(
    dst: "obs_source_t *", filter: "obs_source_t *"
) -> void: ...
def obs_source_enabled(source: "obs_source_t const *") -> bool: ...
def obs_source_set_enabled(source: "obs_source_t *", enabled: bool) -> void: ...
def obs_source_muted(source: "obs_source_t const *") -> bool: ...
def obs_source_set_muted(source: "obs_source_t *", muted: bool) -> void: ...
def obs_source_push_to_mute_enabled(source: "obs_source_t *") -> bool: ...
def obs_source_enable_push_to_mute(source: "obs_source_t *", enabled: bool) -> void: ...
def obs_source_get_push_to_mute_delay(source: "obs_source_t *") -> uint64_t: ...
def obs_source_set_push_to_mute_delay(
    source: "obs_source_t *", delay: uint64_t
) -> void: ...
def obs_source_push_to_talk_enabled(source: "obs_source_t *") -> bool: ...
def obs_source_enable_push_to_talk(source: "obs_source_t *", enabled: bool) -> void: ...
def obs_source_get_push_to_talk_delay(source: "obs_source_t *") -> uint64_t: ...
def obs_source_set_push_to_talk_delay(
    source: "obs_source_t *", delay: uint64_t
) -> void: ...
def obs_source_add_audio_pause_callback(
    source: "obs_source_t *", callback: signal_callback_t, param: "void *"
) -> void: ...
def obs_source_remove_audio_pause_callback(
    source: "obs_source_t *", callback: signal_callback_t, param: "void *"
) -> void: ...
def obs_source_add_audio_capture_callback(
    source: "obs_source_t *", callback: obs_source_audio_capture_t, param: "void *"
) -> void: ...
def obs_source_remove_audio_capture_callback(
    source: "obs_source_t *", callback: obs_source_audio_capture_t, param: "void *"
) -> void: ...
def obs_source_add_caption_callback(
    source: "obs_source_t *", callback: obs_source_caption_t, param: "void *"
) -> void: ...
def obs_source_remove_caption_callback(
    source: "obs_source_t *", callback: obs_source_caption_t, param: "void *"
) -> void: ...

OBS_DEINTERLACE_MODE_DISABLE = _obspython.OBS_DEINTERLACE_MODE_DISABLE
OBS_DEINTERLACE_MODE_DISCARD = _obspython.OBS_DEINTERLACE_MODE_DISCARD
OBS_DEINTERLACE_MODE_RETRO = _obspython.OBS_DEINTERLACE_MODE_RETRO
OBS_DEINTERLACE_MODE_BLEND = _obspython.OBS_DEINTERLACE_MODE_BLEND
OBS_DEINTERLACE_MODE_BLEND_2X = _obspython.OBS_DEINTERLACE_MODE_BLEND_2X
OBS_DEINTERLACE_MODE_LINEAR = _obspython.OBS_DEINTERLACE_MODE_LINEAR
OBS_DEINTERLACE_MODE_LINEAR_2X = _obspython.OBS_DEINTERLACE_MODE_LINEAR_2X
OBS_DEINTERLACE_MODE_YADIF = _obspython.OBS_DEINTERLACE_MODE_YADIF
OBS_DEINTERLACE_MODE_YADIF_2X = _obspython.OBS_DEINTERLACE_MODE_YADIF_2X
OBS_DEINTERLACE_FIELD_ORDER_TOP = _obspython.OBS_DEINTERLACE_FIELD_ORDER_TOP
OBS_DEINTERLACE_FIELD_ORDER_BOTTOM = _obspython.OBS_DEINTERLACE_FIELD_ORDER_BOTTOM

def obs_source_set_deinterlace_mode(
    source: "obs_source_t *", mode: "enum obs_deinterlace_mode"
) -> void: ...
def obs_source_get_deinterlace_mode(
    source: "obs_source_t const *",
) -> "enum obs_deinterlace_mode": ...
def obs_source_set_deinterlace_field_order(
    source: "obs_source_t *", field_order: "enum obs_deinterlace_field_order"
) -> void: ...
def obs_source_get_deinterlace_field_order(
    source: "obs_source_t const *",
) -> "enum obs_deinterlace_field_order": ...

OBS_MONITORING_TYPE_NONE = _obspython.OBS_MONITORING_TYPE_NONE
OBS_MONITORING_TYPE_MONITOR_ONLY = _obspython.OBS_MONITORING_TYPE_MONITOR_ONLY
OBS_MONITORING_TYPE_MONITOR_AND_OUTPUT = (
    _obspython.OBS_MONITORING_TYPE_MONITOR_AND_OUTPUT
)

def obs_source_set_monitoring_type(
    source: "obs_source_t *", type: "enum obs_monitoring_type"
) -> void: ...
def obs_source_get_monitoring_type(
    source: "obs_source_t const *",
) -> "enum obs_monitoring_type": ...
def obs_source_get_private_settings(item: "obs_source_t *") -> "obs_data_t *": ...
def obs_source_backup_filters(source: "obs_source_t *") -> "obs_data_array_t *": ...
def obs_source_restore_filters(
    source: "obs_source_t *", array: "obs_data_array_t *"
) -> void: ...
def obs_source_get_type_data(source: "obs_source_t *") -> "void *": ...
def obs_source_draw_set_color_matrix(
    color_matrix: matrix4, color_range_min: vec3, color_range_max: vec3
) -> void: ...
def obs_source_draw(
    image: "gs_texture_t *", x: int, y: int, cx: uint32_t, cy: uint32_t, flip: bool
) -> void: ...
def obs_source_output_video(
    source: "obs_source_t *", frame: obs_source_frame
) -> void: ...
def obs_source_output_video2(
    source: "obs_source_t *", frame: obs_source_frame2
) -> void: ...
def obs_source_set_async_rotation(source: "obs_source_t *", rotation: long) -> void: ...
def obs_source_output_cea708(
    source: "obs_source_t *", captions: obs_source_cea_708
) -> void: ...
def obs_source_preload_video(
    source: "obs_source_t *", frame: obs_source_frame
) -> void: ...
def obs_source_preload_video2(
    source: "obs_source_t *", frame: obs_source_frame2
) -> void: ...
def obs_source_show_preloaded_video(source: "obs_source_t *") -> void: ...
def obs_source_set_video_frame(
    source: "obs_source_t *", frame: obs_source_frame
) -> void: ...
def obs_source_set_video_frame2(
    source: "obs_source_t *", frame: obs_source_frame2
) -> void: ...
def obs_source_output_audio(
    source: "obs_source_t *", audio: obs_source_audio
) -> void: ...
def obs_source_update_properties(source: "obs_source_t *") -> void: ...
def obs_source_get_frame(source: "obs_source_t *") -> "struct obs_source_frame *": ...
def obs_source_release_frame(
    source: "obs_source_t *", frame: obs_source_frame
) -> void: ...
def obs_source_process_filter_begin(
    filter: "obs_source_t *",
    format: "enum gs_color_format",
    allow_direct: "enum obs_allow_direct_render",
) -> bool: ...
def obs_source_process_filter_begin_with_color_space(
    filter: "obs_source_t *",
    format: "enum gs_color_format",
    space: "enum gs_color_space",
    allow_direct: "enum obs_allow_direct_render",
) -> bool: ...
def obs_source_process_filter_end(
    filter: "obs_source_t *", effect: "gs_effect_t *", width: uint32_t, height: uint32_t
) -> void: ...
def obs_source_process_filter_tech_end(
    filter: "obs_source_t *",
    effect: "gs_effect_t *",
    width: uint32_t,
    height: uint32_t,
    tech_name: "char const *",
) -> void: ...
def obs_source_skip_video_filter(filter: "obs_source_t *") -> void: ...
def obs_source_add_active_child(
    parent: "obs_source_t *", child: "obs_source_t *"
) -> bool: ...
def obs_source_remove_active_child(
    parent: "obs_source_t *", child: "obs_source_t *"
) -> void: ...
def obs_source_send_mouse_click(
    source: "obs_source_t *",
    event: obs_mouse_event,
    type: int32_t,
    mouse_up: bool,
    click_count: uint32_t,
) -> void: ...
def obs_source_send_mouse_move(
    source: "obs_source_t *", event: obs_mouse_event, mouse_leave: bool
) -> void: ...
def obs_source_send_mouse_wheel(
    source: "obs_source_t *", event: obs_mouse_event, x_delta: int, y_delta: int
) -> void: ...
def obs_source_send_focus(source: "obs_source_t *", focus: bool) -> void: ...
def obs_source_send_key_click(
    source: "obs_source_t *", event: obs_key_event, key_up: bool
) -> void: ...
def obs_source_set_default_flags(source: "obs_source_t *", flags: uint32_t) -> void: ...
def obs_source_get_base_width(source: "obs_source_t *") -> uint32_t: ...
def obs_source_get_base_height(source: "obs_source_t *") -> uint32_t: ...
def obs_source_audio_pending(source: "obs_source_t const *") -> bool: ...
def obs_source_get_audio_timestamp(source: "obs_source_t const *") -> uint64_t: ...
def obs_source_get_audio_mix(
    source: "obs_source_t const *", audio: obs_source_audio_mix
) -> void: ...
def obs_source_set_async_unbuffered(
    source: "obs_source_t *", unbuffered: bool
) -> void: ...
def obs_source_async_unbuffered(source: "obs_source_t const *") -> bool: ...
def obs_source_set_async_decoupled(
    source: "obs_source_t *", decouple: bool
) -> void: ...
def obs_source_async_decoupled(source: "obs_source_t const *") -> bool: ...
def obs_source_set_audio_active(source: "obs_source_t *", show: bool) -> void: ...
def obs_source_audio_active(source: "obs_source_t const *") -> bool: ...
def obs_source_get_last_obs_version(source: "obs_source_t const *") -> uint32_t: ...
def obs_source_media_play_pause(source: "obs_source_t *", pause: bool) -> void: ...
def obs_source_media_restart(source: "obs_source_t *") -> void: ...
def obs_source_media_stop(source: "obs_source_t *") -> void: ...
def obs_source_media_next(source: "obs_source_t *") -> void: ...
def obs_source_media_previous(source: "obs_source_t *") -> void: ...
def obs_source_media_get_duration(source: "obs_source_t *") -> int64_t: ...
def obs_source_media_get_time(source: "obs_source_t *") -> int64_t: ...
def obs_source_media_set_time(source: "obs_source_t *", ms: int64_t) -> void: ...
def obs_source_media_get_state(source: "obs_source_t *") -> "enum obs_media_state": ...
def obs_source_media_started(source: "obs_source_t *") -> void: ...
def obs_source_media_ended(source: "obs_source_t *") -> void: ...

OBS_TRANSITION_SOURCE_A = _obspython.OBS_TRANSITION_SOURCE_A
OBS_TRANSITION_SOURCE_B = _obspython.OBS_TRANSITION_SOURCE_B

def obs_transition_get_source(
    transition: "obs_source_t *", target: "enum obs_transition_target"
) -> "obs_source_t *": ...
def obs_transition_clear(transition: "obs_source_t *") -> void: ...
def obs_transition_get_active_source(
    transition: "obs_source_t *",
) -> "obs_source_t *": ...

OBS_TRANSITION_MODE_AUTO = _obspython.OBS_TRANSITION_MODE_AUTO
OBS_TRANSITION_MODE_MANUAL = _obspython.OBS_TRANSITION_MODE_MANUAL

def obs_transition_start(
    transition: "obs_source_t *",
    mode: "enum obs_transition_mode",
    duration_ms: uint32_t,
    dest: "obs_source_t *",
) -> bool: ...
def obs_transition_set(
    transition: "obs_source_t *", source: "obs_source_t *"
) -> void: ...
def obs_transition_set_manual_time(transition: "obs_source_t *", t: float) -> void: ...
def obs_transition_set_manual_torque(
    transition: "obs_source_t *", torque: float, clamp: float
) -> void: ...

OBS_TRANSITION_SCALE_MAX_ONLY = _obspython.OBS_TRANSITION_SCALE_MAX_ONLY
OBS_TRANSITION_SCALE_ASPECT = _obspython.OBS_TRANSITION_SCALE_ASPECT
OBS_TRANSITION_SCALE_STRETCH = _obspython.OBS_TRANSITION_SCALE_STRETCH

def obs_transition_set_scale_type(
    transition: "obs_source_t *", type: "enum obs_transition_scale_type"
) -> void: ...
def obs_transition_get_scale_type(
    transition: "obs_source_t const *",
) -> "enum obs_transition_scale_type": ...
def obs_transition_set_alignment(
    transition: "obs_source_t *", alignment: uint32_t
) -> void: ...
def obs_transition_get_alignment(transition: "obs_source_t const *") -> uint32_t: ...
def obs_transition_set_size(
    transition: "obs_source_t *", cx: uint32_t, cy: uint32_t
) -> void: ...
def obs_transition_get_size(
    transition: "obs_source_t const *", cx: "uint32_t *", cy: "uint32_t *"
) -> void: ...
def obs_transition_enable_fixed(
    transition: "obs_source_t *", enable: bool, duration_ms: uint32_t
) -> void: ...
def obs_transition_fixed(transition: "obs_source_t *") -> bool: ...
def obs_transition_get_time(transition: "obs_source_t *") -> float: ...
def obs_transition_force_stop(transition: "obs_source_t *") -> void: ...
def obs_transition_video_render(
    transition: "obs_source_t *", callback: obs_transition_video_render_callback_t
) -> void: ...
def obs_transition_video_render2(
    transition: "obs_source_t *",
    callback: obs_transition_video_render_callback_t,
    placeholder_texture: "gs_texture_t *",
) -> void: ...
def obs_transition_video_get_color_space(
    transition: "obs_source_t *",
) -> "enum gs_color_space": ...
def obs_transition_video_render_direct(
    transition: "obs_source_t *", target: "enum obs_transition_target"
) -> bool: ...
def obs_transition_audio_render(
    transition: "obs_source_t *",
    ts_out: "uint64_t *",
    audio: obs_source_audio_mix,
    mixers: uint32_t,
    channels: size_t,
    sample_rate: size_t,
    mix_a_callback: obs_transition_audio_mix_callback_t,
    mix_b_callback: obs_transition_audio_mix_callback_t,
) -> bool: ...
def obs_transition_swap_begin(
    tr_dest: "obs_source_t *", tr_source: "obs_source_t *"
) -> void: ...
def obs_transition_swap_end(
    tr_dest: "obs_source_t *", tr_source: "obs_source_t *"
) -> void: ...
def obs_scene_create(name: "char const *") -> "obs_scene_t *": ...
def obs_scene_create_private(name: "char const *") -> "obs_scene_t *": ...

OBS_SCENE_DUP_REFS = _obspython.OBS_SCENE_DUP_REFS
OBS_SCENE_DUP_COPY = _obspython.OBS_SCENE_DUP_COPY
OBS_SCENE_DUP_PRIVATE_REFS = _obspython.OBS_SCENE_DUP_PRIVATE_REFS
OBS_SCENE_DUP_PRIVATE_COPY = _obspython.OBS_SCENE_DUP_PRIVATE_COPY

def obs_scene_duplicate(
    scene: "obs_scene_t *", name: "char const *", type: "enum obs_scene_duplicate_type"
) -> "obs_scene_t *": ...
def obs_scene_addref(scene: "obs_scene_t *") -> void: ...
def obs_scene_release(scene: "obs_scene_t *") -> void: ...
def obs_scene_get_ref(scene: "obs_scene_t *") -> "obs_scene_t *": ...
def obs_scene_get_source(scene: "obs_scene_t const *") -> "obs_source_t *": ...
def obs_scene_from_source(source: "obs_source_t const *") -> "obs_scene_t *": ...
def obs_scene_find_source(
    scene: "obs_scene_t *", name: "char const *"
) -> "obs_sceneitem_t *": ...
def obs_scene_find_source_recursive(
    scene: "obs_scene_t *", name: "char const *"
) -> "obs_sceneitem_t *": ...
def obs_scene_find_sceneitem_by_id(
    scene: "obs_scene_t *", id: int64_t
) -> "obs_sceneitem_t *": ...
def obs_get_scene_by_name(name: "char const *") -> "obs_scene_t *": ...
def obs_scene_enum_items(
    scene: "obs_scene_t *",
    callback: "bool (*)(obs_scene_t *,obs_sceneitem_t *,void *)",
    param: "void *",
) -> void: ...
def obs_scene_reorder_items(
    scene: "obs_scene_t *",
    item_order: "obs_sceneitem_t *const *",
    item_order_size: size_t,
) -> bool: ...

class obs_sceneitem_order_info:
    """Proxy of C obs_sceneitem_order_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    group: "obs_sceneitem_t *" = property(
        _obspython.obs_sceneitem_order_info_group_get,
        _obspython.obs_sceneitem_order_info_group_set,
        doc="group",
    )
    item: "obs_sceneitem_t *" = property(
        _obspython.obs_sceneitem_order_info_item_get,
        _obspython.obs_sceneitem_order_info_item_set,
        doc="item",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_sceneitem_order_info

_obspython.obs_sceneitem_order_info_swigregister(obs_sceneitem_order_info)

def obs_scene_reorder_items2(
    scene: "obs_scene_t *",
    item_order: obs_sceneitem_order_info,
    item_order_size: size_t,
) -> bool: ...
def obs_source_is_scene(source: "obs_source_t const *") -> bool: ...
def obs_scene_add(
    scene: "obs_scene_t *", source: "obs_source_t *"
) -> "obs_sceneitem_t *": ...
def obs_scene_atomic_update(
    scene: "obs_scene_t *", func: obs_scene_atomic_update_func, data: "void *"
) -> void: ...
def obs_sceneitem_addref(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_release(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_remove(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitems_add(scene: "obs_scene_t *", data: "obs_data_array_t *") -> void: ...
def obs_sceneitem_save(
    item: "obs_sceneitem_t *", arr: "obs_data_array_t *"
) -> void: ...
def obs_sceneitem_set_id(sceneitem: "obs_sceneitem_t *", id: int64_t) -> void: ...
def obs_scene_sceneitem_from_source(
    scene: "obs_scene_t *", source: "obs_source_t *"
) -> "obs_sceneitem_t *": ...
def obs_scene_save_transform_states(
    scene: "obs_scene_t *", all_items: bool
) -> "obs_data_t *": ...
def obs_scene_load_transform_states(state: "char const *") -> void: ...
def obs_sceneitem_get_order_position(item: "obs_sceneitem_t *") -> int: ...
def obs_sceneitem_get_scene(item: "obs_sceneitem_t const *") -> "obs_scene_t *": ...
def obs_sceneitem_get_source(item: "obs_sceneitem_t const *") -> "obs_source_t *": ...
def obs_sceneitem_select(item: "obs_sceneitem_t *", select: bool) -> void: ...
def obs_sceneitem_selected(item: "obs_sceneitem_t const *") -> bool: ...
def obs_sceneitem_locked(item: "obs_sceneitem_t const *") -> bool: ...
def obs_sceneitem_set_locked(item: "obs_sceneitem_t *", lock: bool) -> bool: ...
def obs_sceneitem_set_pos(item: "obs_sceneitem_t *", pos: vec2) -> void: ...
def obs_sceneitem_set_rot(item: "obs_sceneitem_t *", rot_deg: float) -> void: ...
def obs_sceneitem_set_scale(item: "obs_sceneitem_t *", scale: vec2) -> void: ...
def obs_sceneitem_set_alignment(
    item: "obs_sceneitem_t *", alignment: uint32_t
) -> void: ...
def obs_sceneitem_set_order(
    item: "obs_sceneitem_t *", movement: "enum obs_order_movement"
) -> void: ...
def obs_sceneitem_set_order_position(
    item: "obs_sceneitem_t *", position: int
) -> void: ...
def obs_sceneitem_set_bounds_type(
    item: "obs_sceneitem_t *", type: "enum obs_bounds_type"
) -> void: ...
def obs_sceneitem_set_bounds_alignment(
    item: "obs_sceneitem_t *", alignment: uint32_t
) -> void: ...
def obs_sceneitem_set_bounds_crop(item: "obs_sceneitem_t *", crop: bool) -> void: ...
def obs_sceneitem_set_bounds(item: "obs_sceneitem_t *", bounds: vec2) -> void: ...
def obs_sceneitem_get_id(item: "obs_sceneitem_t const *") -> int64_t: ...
def obs_sceneitem_get_pos(item: "obs_sceneitem_t const *", pos: vec2) -> void: ...
def obs_sceneitem_get_rot(item: "obs_sceneitem_t const *") -> float: ...
def obs_sceneitem_get_scale(item: "obs_sceneitem_t const *", scale: vec2) -> void: ...
def obs_sceneitem_get_alignment(item: "obs_sceneitem_t const *") -> uint32_t: ...
def obs_sceneitem_get_bounds_type(
    item: "obs_sceneitem_t const *",
) -> "enum obs_bounds_type": ...
def obs_sceneitem_get_bounds_alignment(item: "obs_sceneitem_t const *") -> uint32_t: ...
def obs_sceneitem_get_bounds_crop(item: "obs_sceneitem_t const *") -> bool: ...
def obs_sceneitem_get_bounds(item: "obs_sceneitem_t const *", bounds: vec2) -> void: ...
def obs_sceneitem_get_info(
    item: "obs_sceneitem_t const *", info: obs_transform_info
) -> void: ...
def obs_sceneitem_set_info(
    item: "obs_sceneitem_t *", info: obs_transform_info
) -> void: ...
def obs_sceneitem_get_info2(
    item: "obs_sceneitem_t const *", info: obs_transform_info
) -> void: ...
def obs_sceneitem_set_info2(
    item: "obs_sceneitem_t *", info: obs_transform_info
) -> void: ...
def obs_sceneitem_get_draw_transform(
    item: "obs_sceneitem_t const *", transform: matrix4
) -> void: ...
def obs_sceneitem_get_box_transform(
    item: "obs_sceneitem_t const *", transform: matrix4
) -> void: ...
def obs_sceneitem_get_box_scale(
    item: "obs_sceneitem_t const *", scale: vec2
) -> void: ...
def obs_sceneitem_visible(item: "obs_sceneitem_t const *") -> bool: ...
def obs_sceneitem_set_visible(item: "obs_sceneitem_t *", visible: bool) -> bool: ...

class obs_sceneitem_crop:
    """Proxy of C obs_sceneitem_crop struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    left: int = property(
        _obspython.obs_sceneitem_crop_left_get,
        _obspython.obs_sceneitem_crop_left_set,
        doc="left",
    )
    top: int = property(
        _obspython.obs_sceneitem_crop_top_get,
        _obspython.obs_sceneitem_crop_top_set,
        doc="top",
    )
    right: int = property(
        _obspython.obs_sceneitem_crop_right_get,
        _obspython.obs_sceneitem_crop_right_set,
        doc="right",
    )
    bottom: int = property(
        _obspython.obs_sceneitem_crop_bottom_get,
        _obspython.obs_sceneitem_crop_bottom_set,
        doc="bottom",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_obs_sceneitem_crop

_obspython.obs_sceneitem_crop_swigregister(obs_sceneitem_crop)

def obs_sceneitem_set_crop(
    item: "obs_sceneitem_t *", crop: obs_sceneitem_crop
) -> void: ...
def obs_sceneitem_get_crop(
    item: "obs_sceneitem_t const *", crop: obs_sceneitem_crop
) -> void: ...
def obs_sceneitem_set_scale_filter(
    item: "obs_sceneitem_t *", filter: "enum obs_scale_type"
) -> void: ...
def obs_sceneitem_get_scale_filter(
    item: "obs_sceneitem_t *",
) -> "enum obs_scale_type": ...
def obs_sceneitem_set_blending_method(
    item: "obs_sceneitem_t *", method: "enum obs_blending_method"
) -> void: ...
def obs_sceneitem_get_blending_method(
    item: "obs_sceneitem_t *",
) -> "enum obs_blending_method": ...
def obs_sceneitem_set_blending_mode(
    item: "obs_sceneitem_t *", type: "enum obs_blending_type"
) -> void: ...
def obs_sceneitem_get_blending_mode(
    item: "obs_sceneitem_t *",
) -> "enum obs_blending_type": ...
def obs_sceneitem_force_update_transform(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_defer_update_begin(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_defer_update_end(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_get_private_settings(item: "obs_sceneitem_t *") -> "obs_data_t *": ...
def obs_scene_add_group(
    scene: "obs_scene_t *", name: "char const *"
) -> "obs_sceneitem_t *": ...
def obs_scene_insert_group(
    scene: "obs_scene_t *",
    name: "char const *",
    items: "obs_sceneitem_t **",
    count: size_t,
) -> "obs_sceneitem_t *": ...
def obs_scene_add_group2(
    scene: "obs_scene_t *", name: "char const *", signal: bool
) -> "obs_sceneitem_t *": ...
def obs_scene_insert_group2(
    scene: "obs_scene_t *",
    name: "char const *",
    items: "obs_sceneitem_t **",
    count: size_t,
    signal: bool,
) -> "obs_sceneitem_t *": ...
def obs_scene_get_group(
    scene: "obs_scene_t *", name: "char const *"
) -> "obs_sceneitem_t *": ...
def obs_sceneitem_is_group(item: "obs_sceneitem_t *") -> bool: ...
def obs_sceneitem_group_get_scene(
    group: "obs_sceneitem_t const *",
) -> "obs_scene_t *": ...
def obs_sceneitem_group_ungroup(group: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_group_ungroup2(group: "obs_sceneitem_t *", signal: bool) -> void: ...
def obs_sceneitem_group_add_item(
    group: "obs_sceneitem_t *", item: "obs_sceneitem_t *"
) -> void: ...
def obs_sceneitem_group_remove_item(
    group: "obs_sceneitem_t *", item: "obs_sceneitem_t *"
) -> void: ...
def obs_sceneitem_get_group(
    scene: "obs_scene_t *", item: "obs_sceneitem_t *"
) -> "obs_sceneitem_t *": ...
def obs_source_is_group(source: "obs_source_t const *") -> bool: ...
def obs_scene_is_group(scene: "obs_scene_t const *") -> bool: ...
def obs_sceneitem_group_enum_items(
    group: "obs_sceneitem_t *",
    callback: "bool (*)(obs_scene_t *,obs_sceneitem_t *,void *)",
    param: "void *",
) -> void: ...
def obs_group_from_source(source: "obs_source_t const *") -> "obs_scene_t *": ...
def obs_group_or_scene_from_source(
    source: "obs_source_t const *",
) -> "obs_scene_t *": ...
def obs_sceneitem_defer_group_resize_begin(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_defer_group_resize_end(item: "obs_sceneitem_t *") -> void: ...
def obs_sceneitem_set_show_transition(
    item: "obs_sceneitem_t *", transition: "obs_source_t *"
) -> void: ...
def obs_sceneitem_set_show_transition_duration(
    item: "obs_sceneitem_t *", duration_ms: uint32_t
) -> void: ...
def obs_sceneitem_get_show_transition(
    item: "obs_sceneitem_t *",
) -> "obs_source_t *": ...
def obs_sceneitem_get_show_transition_duration(
    item: "obs_sceneitem_t *",
) -> uint32_t: ...
def obs_sceneitem_set_hide_transition(
    item: "obs_sceneitem_t *", transition: "obs_source_t *"
) -> void: ...
def obs_sceneitem_set_hide_transition_duration(
    item: "obs_sceneitem_t *", duration_ms: uint32_t
) -> void: ...
def obs_sceneitem_get_hide_transition(
    item: "obs_sceneitem_t *",
) -> "obs_source_t *": ...
def obs_sceneitem_get_hide_transition_duration(
    item: "obs_sceneitem_t *",
) -> uint32_t: ...
def obs_sceneitem_set_transition(
    item: "obs_sceneitem_t *", show: bool, transition: "obs_source_t *"
) -> void: ...
def obs_sceneitem_get_transition(
    item: "obs_sceneitem_t *", show: bool
) -> "obs_source_t *": ...
def obs_sceneitem_set_transition_duration(
    item: "obs_sceneitem_t *", show: bool, duration_ms: uint32_t
) -> void: ...
def obs_sceneitem_get_transition_duration(
    item: "obs_sceneitem_t *", show: bool
) -> uint32_t: ...
def obs_sceneitem_do_transition(item: "obs_sceneitem_t *", visible: bool) -> void: ...
def obs_sceneitem_transition_load(
    item: "struct obs_scene_item *", data: "obs_data_t *", show: bool
) -> void: ...
def obs_sceneitem_transition_save(
    item: "struct obs_scene_item *", show: bool
) -> "obs_data_t *": ...
def obs_scene_prune_sources(scene: "obs_scene_t *") -> void: ...
def obs_output_get_display_name(id: "char const *") -> "char const *": ...
def obs_output_create(
    id: "char const *",
    name: "char const *",
    settings: "obs_data_t *",
    hotkey_data: "obs_data_t *",
) -> "obs_output_t *": ...
def obs_output_addref(output: "obs_output_t *") -> void: ...
def obs_output_release(output: "obs_output_t *") -> void: ...
def obs_weak_output_addref(weak: "obs_weak_output_t *") -> void: ...
def obs_weak_output_release(weak: "obs_weak_output_t *") -> void: ...
def obs_output_get_ref(output: "obs_output_t *") -> "obs_output_t *": ...
def obs_output_get_weak_output(output: "obs_output_t *") -> "obs_weak_output_t *": ...
def obs_weak_output_get_output(weak: "obs_weak_output_t *") -> "obs_output_t *": ...
def obs_weak_output_references_output(
    weak: "obs_weak_output_t *", output: "obs_output_t *"
) -> bool: ...
def obs_output_get_name(output: "obs_output_t const *") -> "char const *": ...
def obs_output_start(output: "obs_output_t *") -> bool: ...
def obs_output_stop(output: "obs_output_t *") -> void: ...

OBS_OUTPUT_DELAY_PRESERVE = _obspython.OBS_OUTPUT_DELAY_PRESERVE

def obs_output_set_delay(
    output: "obs_output_t *", delay_sec: uint32_t, flags: uint32_t
) -> void: ...
def obs_output_get_delay(output: "obs_output_t const *") -> uint32_t: ...
def obs_output_get_active_delay(output: "obs_output_t const *") -> uint32_t: ...
def obs_output_force_stop(output: "obs_output_t *") -> void: ...
def obs_output_active(output: "obs_output_t const *") -> bool: ...
def obs_output_get_flags(output: "obs_output_t const *") -> uint32_t: ...
def obs_get_output_flags(id: "char const *") -> uint32_t: ...
def obs_output_defaults(id: "char const *") -> "obs_data_t *": ...
def obs_get_output_properties(id: "char const *") -> "obs_properties_t *": ...
def obs_output_properties(output: "obs_output_t const *") -> "obs_properties_t *": ...
def obs_output_update(output: "obs_output_t *", settings: "obs_data_t *") -> void: ...
def obs_output_can_pause(output: "obs_output_t const *") -> bool: ...
def obs_output_pause(output: "obs_output_t *", pause: bool) -> bool: ...
def obs_output_paused(output: "obs_output_t const *") -> bool: ...
def obs_output_get_settings(output: "obs_output_t const *") -> "obs_data_t *": ...
def obs_output_get_signal_handler(
    output: "obs_output_t const *",
) -> "signal_handler_t *": ...
def obs_output_get_proc_handler(
    output: "obs_output_t const *",
) -> "proc_handler_t *": ...
def obs_output_set_media(
    output: "obs_output_t *", video: "video_t *", audio: "audio_t *"
) -> void: ...
def obs_output_video(output: "obs_output_t const *") -> "video_t *": ...
def obs_output_audio(output: "obs_output_t const *") -> "audio_t *": ...
def obs_output_set_mixer(output: "obs_output_t *", mixer_idx: size_t) -> void: ...
def obs_output_get_mixer(output: "obs_output_t const *") -> size_t: ...
def obs_output_set_mixers(output: "obs_output_t *", mixers: size_t) -> void: ...
def obs_output_get_mixers(output: "obs_output_t const *") -> size_t: ...
def obs_output_set_video_encoder(
    output: "obs_output_t *", encoder: "obs_encoder_t *"
) -> void: ...
def obs_output_set_video_encoder2(
    output: "obs_output_t *", encoder: "obs_encoder_t *", idx: size_t
) -> void: ...
def obs_output_set_audio_encoder(
    output: "obs_output_t *", encoder: "obs_encoder_t *", idx: size_t
) -> void: ...
def obs_output_get_video_encoder(
    output: "obs_output_t const *",
) -> "obs_encoder_t *": ...
def obs_output_get_video_encoder2(
    output: "obs_output_t const *", idx: size_t
) -> "obs_encoder_t *": ...
def obs_output_get_audio_encoder(
    output: "obs_output_t const *", idx: size_t
) -> "obs_encoder_t *": ...
def obs_output_set_service(
    output: "obs_output_t *", service: "obs_service_t *"
) -> void: ...
def obs_output_get_service(output: "obs_output_t const *") -> "obs_service_t *": ...
def obs_output_set_reconnect_settings(
    output: "obs_output_t *", retry_count: int, retry_sec: int
) -> void: ...
def obs_output_get_total_bytes(output: "obs_output_t const *") -> uint64_t: ...
def obs_output_get_frames_dropped(output: "obs_output_t const *") -> int: ...
def obs_output_get_total_frames(output: "obs_output_t const *") -> int: ...
def obs_output_set_preferred_size(
    output: "obs_output_t *", width: uint32_t, height: uint32_t
) -> void: ...
def obs_output_set_preferred_size2(
    output: "obs_output_t *", width: uint32_t, height: uint32_t, idx: size_t
) -> void: ...
def obs_output_get_width(output: "obs_output_t const *") -> uint32_t: ...
def obs_output_get_width2(output: "obs_output_t const *", idx: size_t) -> uint32_t: ...
def obs_output_get_height(output: "obs_output_t const *") -> uint32_t: ...
def obs_output_get_height2(output: "obs_output_t const *", idx: size_t) -> uint32_t: ...
def obs_output_get_id(output: "obs_output_t const *") -> "char const *": ...
def obs_output_caption(
    output: "obs_output_t *", captions: obs_source_cea_708
) -> void: ...
def obs_output_output_caption_text1(
    output: "obs_output_t *", text: "char const *"
) -> void: ...
def obs_output_output_caption_text2(
    output: "obs_output_t *", text: "char const *", display_duration: double
) -> void: ...
def obs_output_get_congestion(output: "obs_output_t *") -> float: ...
def obs_output_get_connect_time_ms(output: "obs_output_t *") -> int: ...
def obs_output_reconnecting(output: "obs_output_t const *") -> bool: ...
def obs_output_set_last_error(
    output: "obs_output_t *", message: "char const *"
) -> void: ...
def obs_output_get_last_error(output: "obs_output_t *") -> "char const *": ...
def obs_output_get_supported_video_codecs(
    output: "obs_output_t const *",
) -> "char const *": ...
def obs_output_get_supported_audio_codecs(
    output: "obs_output_t const *",
) -> "char const *": ...
def obs_output_get_protocols(output: "obs_output_t const *") -> "char const *": ...
def obs_is_output_protocol_registered(protocol: "char const *") -> bool: ...
def obs_enum_output_protocols(idx: size_t, protocol: "char **") -> bool: ...
def obs_enum_output_types_with_protocol(
    protocol: "char const *", data: "void *", enum_cb: "bool (*)(void *,char const *)"
) -> void: ...
def obs_get_output_supported_video_codecs(id: "char const *") -> "char const *": ...
def obs_get_output_supported_audio_codecs(id: "char const *") -> "char const *": ...
def obs_output_get_type_data(output: "obs_output_t *") -> "void *": ...
def obs_output_get_video_conversion(
    output: "obs_output_t *",
) -> "struct video_scale_info const *": ...
def obs_output_set_video_conversion(
    output: "obs_output_t *", conversion: "struct video_scale_info const *"
) -> void: ...
def obs_output_set_audio_conversion(
    output: "obs_output_t *", conversion: "struct audio_convert_info const *"
) -> void: ...
def obs_output_can_begin_data_capture(
    output: "obs_output_t const *", flags: uint32_t
) -> bool: ...
def obs_output_initialize_encoders(
    output: "obs_output_t *", flags: uint32_t
) -> bool: ...
def obs_output_begin_data_capture(
    output: "obs_output_t *", flags: uint32_t
) -> bool: ...
def obs_output_end_data_capture(output: "obs_output_t *") -> void: ...
def obs_output_signal_stop(output: "obs_output_t *", code: int) -> void: ...
def obs_output_get_pause_offset(output: "obs_output_t *") -> uint64_t: ...
def obs_encoder_get_display_name(id: "char const *") -> "char const *": ...
def obs_video_encoder_create(
    id: "char const *",
    name: "char const *",
    settings: "obs_data_t *",
    hotkey_data: "obs_data_t *",
) -> "obs_encoder_t *": ...
def obs_audio_encoder_create(
    id: "char const *",
    name: "char const *",
    settings: "obs_data_t *",
    mixer_idx: size_t,
    hotkey_data: "obs_data_t *",
) -> "obs_encoder_t *": ...
def obs_encoder_addref(encoder: "obs_encoder_t *") -> void: ...
def obs_encoder_release(encoder: "obs_encoder_t *") -> void: ...
def obs_weak_encoder_addref(weak: "obs_weak_encoder_t *") -> void: ...
def obs_weak_encoder_release(weak: "obs_weak_encoder_t *") -> void: ...
def obs_encoder_get_ref(encoder: "obs_encoder_t *") -> "obs_encoder_t *": ...
def obs_encoder_get_weak_encoder(
    encoder: "obs_encoder_t *",
) -> "obs_weak_encoder_t *": ...
def obs_weak_encoder_get_encoder(weak: "obs_weak_encoder_t *") -> "obs_encoder_t *": ...
def obs_weak_encoder_references_encoder(
    weak: "obs_weak_encoder_t *", encoder: "obs_encoder_t *"
) -> bool: ...
def obs_encoder_set_name(encoder: "obs_encoder_t *", name: "char const *") -> void: ...
def obs_encoder_get_name(encoder: "obs_encoder_t const *") -> "char const *": ...
def obs_get_encoder_codec(id: "char const *") -> "char const *": ...
def obs_get_encoder_type(id: "char const *") -> "enum obs_encoder_type": ...
def obs_encoder_get_codec(encoder: "obs_encoder_t const *") -> "char const *": ...
def obs_encoder_get_type(
    encoder: "obs_encoder_t const *",
) -> "enum obs_encoder_type": ...
def obs_encoder_set_scaled_size(
    encoder: "obs_encoder_t *", width: uint32_t, height: uint32_t
) -> void: ...
def obs_encoder_set_gpu_scale_type(
    encoder: "obs_encoder_t *", gpu_scale_type: "enum obs_scale_type"
) -> void: ...
def obs_encoder_set_frame_rate_divisor(
    encoder: "obs_encoder_t *", divisor: uint32_t
) -> bool: ...
def obs_encoder_add_roi(
    encoder: "obs_encoder_t *", roi: "struct obs_encoder_roi const *"
) -> bool: ...
def obs_encoder_has_roi(encoder: "obs_encoder_t const *") -> bool: ...
def obs_encoder_clear_roi(encoder: "obs_encoder_t *") -> void: ...
def obs_encoder_enum_roi(
    encoder: "obs_encoder_t *",
    enum_proc: "void (*)(void *,struct obs_encoder_roi *)",
    param: "void *",
) -> void: ...
def obs_encoder_get_roi_increment(encoder: "obs_encoder_t const *") -> uint32_t: ...
def obs_encoder_scaling_enabled(encoder: "obs_encoder_t const *") -> bool: ...
def obs_encoder_get_width(encoder: "obs_encoder_t const *") -> uint32_t: ...
def obs_encoder_get_height(encoder: "obs_encoder_t const *") -> uint32_t: ...
def obs_encoder_gpu_scaling_enabled(encoder: "obs_encoder_t *") -> bool: ...
def obs_encoder_get_scale_type(encoder: "obs_encoder_t *") -> "enum obs_scale_type": ...
def obs_encoder_get_frame_rate_divisor(
    encoder: "obs_encoder_t const *",
) -> uint32_t: ...
def obs_encoder_get_sample_rate(encoder: "obs_encoder_t const *") -> uint32_t: ...
def obs_encoder_get_frame_size(encoder: "obs_encoder_t const *") -> size_t: ...
def obs_encoder_set_preferred_video_format(
    encoder: "obs_encoder_t *", format: "enum video_format"
) -> void: ...
def obs_encoder_get_preferred_video_format(
    encoder: "obs_encoder_t const *",
) -> "enum video_format": ...
def obs_encoder_defaults(id: "char const *") -> "obs_data_t *": ...
def obs_encoder_get_defaults(encoder: "obs_encoder_t const *") -> "obs_data_t *": ...
def obs_get_encoder_properties(id: "char const *") -> "obs_properties_t *": ...
def obs_encoder_properties(
    encoder: "obs_encoder_t const *",
) -> "obs_properties_t *": ...
def obs_encoder_update(
    encoder: "obs_encoder_t *", settings: "obs_data_t *"
) -> void: ...
def obs_encoder_get_extra_data(
    encoder: "obs_encoder_t const *", extra_data: "uint8_t **", size: "size_t *"
) -> bool: ...
def obs_encoder_get_settings(encoder: "obs_encoder_t const *") -> "obs_data_t *": ...
def obs_encoder_set_video(encoder: "obs_encoder_t *", video: "video_t *") -> void: ...
def obs_encoder_set_audio(encoder: "obs_encoder_t *", audio: "audio_t *") -> void: ...
def obs_encoder_video(encoder: "obs_encoder_t const *") -> "video_t *": ...
def obs_encoder_parent_video(encoder: "obs_encoder_t const *") -> "video_t *": ...
def obs_encoder_audio(encoder: "obs_encoder_t const *") -> "audio_t *": ...
def obs_encoder_active(encoder: "obs_encoder_t const *") -> bool: ...
def obs_encoder_get_type_data(encoder: "obs_encoder_t *") -> "void *": ...
def obs_encoder_get_id(encoder: "obs_encoder_t const *") -> "char const *": ...
def obs_get_encoder_caps(encoder_id: "char const *") -> uint32_t: ...
def obs_encoder_get_caps(encoder: "obs_encoder_t const *") -> uint32_t: ...
def obs_encoder_packet_ref(
    dst: "struct encoder_packet *", src: "struct encoder_packet *"
) -> void: ...
def obs_encoder_packet_release(packet: "struct encoder_packet *") -> void: ...
def obs_encoder_create_rerouted(
    encoder: "obs_encoder_t *", reroute_id: "char const *"
) -> "void *": ...
def obs_encoder_paused(output: "obs_encoder_t const *") -> bool: ...
def obs_encoder_get_last_error(encoder: "obs_encoder_t *") -> "char const *": ...
def obs_encoder_set_last_error(
    encoder: "obs_encoder_t *", message: "char const *"
) -> void: ...
def obs_encoder_get_pause_offset(encoder: "obs_encoder_t const *") -> uint64_t: ...
def obs_encoder_set_group(
    encoder: "obs_encoder_t *", group: "obs_encoder_group_t *"
) -> bool: ...
def obs_encoder_group_create() -> "obs_encoder_group_t *": ...
def obs_encoder_group_destroy(group: "obs_encoder_group_t *") -> void: ...
def obs_service_get_display_name(id: "char const *") -> "char const *": ...
def obs_service_create(
    id: "char const *",
    name: "char const *",
    settings: "obs_data_t *",
    hotkey_data: "obs_data_t *",
) -> "obs_service_t *": ...
def obs_service_create_private(
    id: "char const *", name: "char const *", settings: "obs_data_t *"
) -> "obs_service_t *": ...
def obs_service_addref(service: "obs_service_t *") -> void: ...
def obs_service_release(service: "obs_service_t *") -> void: ...
def obs_weak_service_addref(weak: "obs_weak_service_t *") -> void: ...
def obs_weak_service_release(weak: "obs_weak_service_t *") -> void: ...
def obs_service_get_ref(service: "obs_service_t *") -> "obs_service_t *": ...
def obs_service_get_weak_service(
    service: "obs_service_t *",
) -> "obs_weak_service_t *": ...
def obs_weak_service_get_service(weak: "obs_weak_service_t *") -> "obs_service_t *": ...
def obs_weak_service_references_service(
    weak: "obs_weak_service_t *", service: "obs_service_t *"
) -> bool: ...
def obs_service_get_name(service: "obs_service_t const *") -> "char const *": ...
def obs_service_defaults(id: "char const *") -> "obs_data_t *": ...
def obs_get_service_properties(id: "char const *") -> "obs_properties_t *": ...
def obs_service_properties(
    service: "obs_service_t const *",
) -> "obs_properties_t *": ...
def obs_service_get_type(service: "obs_service_t const *") -> "char const *": ...
def obs_service_update(
    service: "obs_service_t *", settings: "obs_data_t *"
) -> void: ...
def obs_service_get_settings(service: "obs_service_t const *") -> "obs_data_t *": ...
def obs_service_get_url(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_key(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_username(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_password(service: "obs_service_t const *") -> "char const *": ...
def obs_service_apply_encoder_settings(
    service: "obs_service_t *",
    video_encoder_settings: "obs_data_t *",
    audio_encoder_settings: "obs_data_t *",
) -> void: ...
def obs_service_get_type_data(service: "obs_service_t *") -> "void *": ...
def obs_service_get_id(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_supported_resolutions(
    service: "obs_service_t const *",
    resolutions: "struct obs_service_resolution **",
    count: "size_t *",
) -> void: ...
def obs_service_get_max_fps(service: "obs_service_t const *", fps: "int *") -> void: ...
def obs_service_get_max_bitrate(
    service: "obs_service_t const *", video_bitrate: "int *", audio_bitrate: "int *"
) -> void: ...
def obs_service_get_supported_video_codecs(
    service: "obs_service_t const *",
) -> "char const **": ...
def obs_service_get_supported_audio_codecs(
    service: "obs_service_t const *",
) -> "char const **": ...
def obs_service_get_output_type(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_protocol(service: "obs_service_t const *") -> "char const *": ...
def obs_service_get_preferred_output_type(
    service: "obs_service_t const *",
) -> "char const *": ...
def obs_service_get_connect_info(
    service: "obs_service_t const *", type: uint32_t
) -> "char const *": ...
def obs_service_can_try_to_connect(service: "obs_service_t const *") -> bool: ...
def obs_source_frame_init(
    frame: obs_source_frame,
    format: "enum video_format",
    width: uint32_t,
    height: uint32_t,
) -> void: ...
def obs_source_frame_free(frame: obs_source_frame) -> void: ...
def obs_source_frame_create(
    format: "enum video_format", width: uint32_t, height: uint32_t
) -> "struct obs_source_frame *": ...
def obs_source_frame_destroy(frame: obs_source_frame) -> void: ...
def obs_source_frame_copy(dst: obs_source_frame, src: obs_source_frame) -> void: ...
def obs_source_get_icon_type(id: "char const *") -> "enum obs_icon_type": ...

CALL_PARAM_TYPE_VOID = _obspython.CALL_PARAM_TYPE_VOID
CALL_PARAM_TYPE_INT = _obspython.CALL_PARAM_TYPE_INT
CALL_PARAM_TYPE_FLOAT = _obspython.CALL_PARAM_TYPE_FLOAT
CALL_PARAM_TYPE_BOOL = _obspython.CALL_PARAM_TYPE_BOOL
CALL_PARAM_TYPE_PTR = _obspython.CALL_PARAM_TYPE_PTR
CALL_PARAM_TYPE_STRING = _obspython.CALL_PARAM_TYPE_STRING
CALL_PARAM_IN = _obspython.CALL_PARAM_IN
CALL_PARAM_OUT = _obspython.CALL_PARAM_OUT

class calldata:
    """Proxy of C calldata struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    stack: "uint8_t *" = property(
        _obspython.calldata_stack_get, _obspython.calldata_stack_set, doc="stack"
    )
    size: size_t = property(
        _obspython.calldata_size_get, _obspython.calldata_size_set, doc="size"
    )
    capacity: size_t = property(
        _obspython.calldata_capacity_get,
        _obspython.calldata_capacity_set,
        doc="capacity",
    )
    fixed: bool = property(
        _obspython.calldata_fixed_get, _obspython.calldata_fixed_set, doc="fixed"
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_calldata

_obspython.calldata_swigregister(calldata)

def calldata_init(data: calldata) -> void: ...
def calldata_clear(data: calldata) -> void: ...
def calldata_init_fixed(data: calldata, stack: "uint8_t *", size: size_t) -> void: ...
def calldata_free(data: calldata) -> void: ...
def calldata_get_data(
    data: calldata, name: "char const *", out: "void *", size: size_t
) -> bool: ...
def calldata_set_data(
    data: calldata, name: "char const *", _in: "void const *", new_size: size_t
) -> void: ...
def calldata_create() -> "calldata_t *": ...
def calldata_destroy(cd: calldata) -> void: ...
def calldata_get_int(
    data: calldata, name: "char const *", val: "long long *"
) -> bool: ...
def calldata_get_float(
    data: calldata, name: "char const *", val: "double *"
) -> bool: ...
def calldata_get_bool(data: calldata, name: "char const *", val: "bool *") -> bool: ...
def calldata_get_ptr(data: calldata, name: "char const *", p_ptr: "void *") -> bool: ...
def calldata_get_string(
    data: calldata, name: "char const *", str: "char const **"
) -> bool: ...
def calldata_int(data: calldata, name: "char const *") -> "long long": ...
def calldata_float(data: calldata, name: "char const *") -> double: ...
def calldata_bool(data: calldata, name: "char const *") -> bool: ...
def calldata_ptr(data: calldata, name: "char const *") -> "void *": ...
def calldata_string(data: calldata, name: "char const *") -> "char const *": ...
def calldata_set_int(
    data: calldata, name: "char const *", val: "long long"
) -> void: ...
def calldata_set_float(data: calldata, name: "char const *", val: double) -> void: ...
def calldata_set_bool(data: calldata, name: "char const *", val: bool) -> void: ...
def calldata_set_ptr(data: calldata, name: "char const *", ptr: "void *") -> void: ...
def calldata_set_string(
    data: calldata, name: "char const *", str: "char const *"
) -> void: ...
def proc_handler_create() -> "proc_handler_t *": ...
def proc_handler_destroy(handler: "proc_handler_t *") -> void: ...
def proc_handler_add(
    handler: "proc_handler_t *",
    decl_string: "char const *",
    proc: proc_handler_proc_t,
    data: "void *",
) -> void: ...
def proc_handler_call(
    handler: "proc_handler_t *", name: "char const *", params: calldata
) -> bool: ...
def signal_handler_create() -> "signal_handler_t *": ...
def signal_handler_destroy(handler: "signal_handler_t *") -> void: ...
def signal_handler_add(
    handler: "signal_handler_t *", signal_decl: "char const *"
) -> bool: ...
def signal_handler_add_array(
    handler: "signal_handler_t *", signal_decls: "char const **"
) -> bool: ...
def signal_handler_connect(
    handler: "signal_handler_t *",
    signal: "char const *",
    callback: signal_callback_t,
    data: "void *",
) -> void: ...
def signal_handler_connect_ref(
    handler: "signal_handler_t *",
    signal: "char const *",
    callback: signal_callback_t,
    data: "void *",
) -> void: ...
def signal_handler_disconnect(
    handler: "signal_handler_t *",
    signal: "char const *",
    callback: signal_callback_t,
    data: "void *",
) -> void: ...
def signal_handler_connect_global(
    handler: "signal_handler_t *", callback: global_signal_callback_t, data: "void *"
) -> void: ...
def signal_handler_disconnect_global(
    handler: "signal_handler_t *", callback: global_signal_callback_t, data: "void *"
) -> void: ...
def signal_handler_remove_current() -> void: ...
def signal_handler_signal(
    handler: "signal_handler_t *", signal: "char const *", params: calldata
) -> void: ...

class base_allocator:
    """Proxy of C base_allocator struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    malloc: "void *(*)(size_t)" = property(
        _obspython.base_allocator_malloc_get,
        _obspython.base_allocator_malloc_set,
        doc="malloc",
    )
    realloc: "void *(*)(void *,size_t)" = property(
        _obspython.base_allocator_realloc_get,
        _obspython.base_allocator_realloc_set,
        doc="realloc",
    )
    free: "void (*)(void *)" = property(
        _obspython.base_allocator_free_get,
        _obspython.base_allocator_free_set,
        doc="free",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_base_allocator

_obspython.base_allocator_swigregister(base_allocator)

def base_set_allocator(defs: base_allocator) -> void: ...
def bmalloc(size: size_t) -> "void *": ...
def brealloc(ptr: "void *", size: size_t) -> "void *": ...
def bfree(ptr: "void *") -> void: ...
def base_get_alignment() -> int: ...
def bnum_allocs() -> long: ...
def bmemdup(ptr: "void const *", size: size_t) -> "void *": ...
def bzalloc(size: size_t) -> "void *": ...
def bstrdup_n(str: "char const *", n: size_t) -> "char *": ...
def bwstrdup_n(str: "wchar_t const *", n: size_t) -> "wchar_t *": ...
def bstrdup(str: "char const *") -> "char *": ...
def bwstrdup(str: "wchar_t const *") -> "wchar_t *": ...

S__LINE__ = _obspython.S__LINE__
INT_CUR_LINE = _obspython.INT_CUR_LINE
FILE_LINE = _obspython.FILE_LINE
LOG_ERROR = _obspython.LOG_ERROR
LOG_WARNING = _obspython.LOG_WARNING
LOG_INFO = _obspython.LOG_INFO
LOG_DEBUG = _obspython.LOG_DEBUG

def base_get_log_handler(handler: "log_handler_t *", param: "void **") -> void: ...
def base_set_log_handler(handler: log_handler_t, param: "void *") -> void: ...
def base_set_crash_handler(
    handler: "void (*)(char const *,va_list,void *)", param: "void *"
) -> void: ...
def blogva(log_level: int, format: "char const *", args: va_list) -> void: ...
def blog(*args) -> void: ...
def bcrash(*args) -> void: ...
def os_wfopen(path: "wchar_t const *", mode: "char const *") -> "FILE *": ...
def os_fopen(path: "char const *", mode: "char const *") -> "FILE *": ...
def os_fgetsize(file: "FILE *") -> int64_t: ...
def os_fseeki64(file: "FILE *", offset: int64_t, origin: int) -> int: ...
def os_ftelli64(file: "FILE *") -> int64_t: ...
def os_fread_mbs(file: "FILE *", pstr: "char **") -> size_t: ...
def os_fread_utf8(file: "FILE *", pstr: "char **") -> size_t: ...
def os_quick_read_utf8_file(path: "char const *") -> "char *": ...
def os_quick_write_utf8_file(
    path: "char const *", str: "char const *", len: size_t, marker: bool
) -> bool: ...
def os_quick_write_utf8_file_safe(
    path: "char const *",
    str: "char const *",
    len: size_t,
    marker: bool,
    temp_ext: "char const *",
    backup_ext: "char const *",
) -> bool: ...
def os_quick_read_mbs_file(path: "char const *") -> "char *": ...
def os_quick_write_mbs_file(
    path: "char const *", str: "char const *", len: size_t
) -> bool: ...
def os_get_file_size(path: "char const *") -> int64_t: ...
def os_get_free_space(path: "char const *") -> int64_t: ...
def os_mbs_to_wcs(
    str: "char const *", str_len: size_t, dst: "wchar_t *", dst_size: size_t
) -> size_t: ...
def os_utf8_to_wcs(
    str: "char const *", len: size_t, dst: "wchar_t *", dst_size: size_t
) -> size_t: ...
def os_wcs_to_mbs(
    str: "wchar_t const *", len: size_t, dst: "char *", dst_size: size_t
) -> size_t: ...
def os_wcs_to_utf8(
    str: "wchar_t const *", len: size_t, dst: "char *", dst_size: size_t
) -> size_t: ...
def os_mbs_to_wcs_ptr(
    str: "char const *", len: size_t, pstr: "wchar_t **"
) -> size_t: ...
def os_utf8_to_wcs_ptr(
    str: "char const *", len: size_t, pstr: "wchar_t **"
) -> size_t: ...
def os_wcs_to_mbs_ptr(
    str: "wchar_t const *", len: size_t, pstr: "char **"
) -> size_t: ...
def os_wcs_to_utf8_ptr(
    str: "wchar_t const *", len: size_t, pstr: "char **"
) -> size_t: ...
def os_utf8_to_mbs_ptr(str: "char const *", len: size_t, pstr: "char **") -> size_t: ...
def os_mbs_to_utf8_ptr(str: "char const *", len: size_t, pstr: "char **") -> size_t: ...
def os_strtod(str: "char const *") -> double: ...
def os_dtostr(value: double, dst: "char *", size: size_t) -> int: ...
def os_dlopen(path: "char const *") -> "void *": ...
def os_dlsym(module: "void *", func: "char const *") -> "void *": ...
def os_dlclose(module: "void *") -> void: ...
def os_is_obs_plugin(path: "char const *") -> bool: ...
def os_cpu_usage_info_start() -> "os_cpu_usage_info_t *": ...
def os_cpu_usage_info_query(info: "os_cpu_usage_info_t *") -> double: ...
def os_cpu_usage_info_destroy(info: "os_cpu_usage_info_t *") -> void: ...
def os_request_high_performance(
    reason: "char const *",
) -> "os_performance_token_t *": ...
def os_end_high_performance(arg1: "os_performance_token_t *") -> void: ...
def os_sleepto_ns(time_target: uint64_t) -> bool: ...
def os_sleepto_ns_fast(time_target: uint64_t) -> bool: ...
def os_sleep_ms(duration: uint32_t) -> void: ...
def os_gettime_ns() -> uint64_t: ...
def os_get_config_path(dst: "char *", size: size_t, name: "char const *") -> int: ...
def os_get_config_path_ptr(name: "char const *") -> "char *": ...
def os_get_program_data_path(
    dst: "char *", size: size_t, name: "char const *"
) -> int: ...
def os_get_program_data_path_ptr(name: "char const *") -> "char *": ...
def os_get_executable_path_ptr(name: "char const *") -> "char *": ...
def os_file_exists(path: "char const *") -> bool: ...
def os_get_abs_path(
    path: "char const *", abspath: "char *", size: size_t
) -> size_t: ...
def os_get_abs_path_ptr(path: "char const *") -> "char *": ...
def os_get_path_extension(path: "char const *") -> "char const *": ...
def os_get_emulation_status() -> bool: ...

class os_dirent:
    """Proxy of C os_dirent struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    d_name: char[256] = property(
        _obspython.os_dirent_d_name_get, _obspython.os_dirent_d_name_set, doc="d_name"
    )
    directory: bool = property(
        _obspython.os_dirent_directory_get,
        _obspython.os_dirent_directory_set,
        doc="directory",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_os_dirent

_obspython.os_dirent_swigregister(os_dirent)

def os_opendir(path: "char const *") -> "os_dir_t *": ...
def os_readdir(dir: "os_dir_t *") -> "struct os_dirent *": ...
def os_closedir(dir: "os_dir_t *") -> void: ...

class os_globent:
    """Proxy of C os_globent struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    path: "char *" = property(
        _obspython.os_globent_path_get, _obspython.os_globent_path_set, doc="path"
    )
    directory: bool = property(
        _obspython.os_globent_directory_get,
        _obspython.os_globent_directory_set,
        doc="directory",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_os_globent

_obspython.os_globent_swigregister(os_globent)

class os_glob_info:
    """Proxy of C os_glob_info struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    gl_pathc: size_t = property(
        _obspython.os_glob_info_gl_pathc_get,
        _obspython.os_glob_info_gl_pathc_set,
        doc="gl_pathc",
    )
    gl_pathv: "struct os_globent *" = property(
        _obspython.os_glob_info_gl_pathv_get,
        _obspython.os_glob_info_gl_pathv_set,
        doc="gl_pathv",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_os_glob_info

_obspython.os_glob_info_swigregister(os_glob_info)

def os_glob(pattern: "char const *", flags: int, pglob: "os_glob_t **") -> int: ...
def os_globfree(pglob: os_glob_info) -> void: ...
def os_unlink(path: "char const *") -> int: ...
def os_rmdir(path: "char const *") -> int: ...
def os_getcwd(path: "char *", size: size_t) -> "char *": ...
def os_chdir(path: "char const *") -> int: ...
def os_get_free_disk_space(dir: "char const *") -> uint64_t: ...

MKDIR_EXISTS = _obspython.MKDIR_EXISTS
MKDIR_SUCCESS = _obspython.MKDIR_SUCCESS
MKDIR_ERROR = _obspython.MKDIR_ERROR

def os_mkdir(path: "char const *") -> int: ...
def os_mkdirs(path: "char const *") -> int: ...
def os_rename(old_path: "char const *", new_path: "char const *") -> int: ...
def os_copyfile(file_in: "char const *", file_out: "char const *") -> int: ...
def os_safe_replace(
    target_path: "char const *", from_path: "char const *", backup_path: "char const *"
) -> int: ...
def os_generate_formatted_filename(
    extension: "char const *", space: bool, format: "char const *"
) -> "char *": ...
def os_inhibit_sleep_create(reason: "char const *") -> "os_inhibit_t *": ...
def os_inhibit_sleep_set_active(info: "os_inhibit_t *", active: bool) -> bool: ...
def os_inhibit_sleep_destroy(info: "os_inhibit_t *") -> void: ...
def os_breakpoint() -> void: ...
def os_get_physical_cores() -> int: ...
def os_get_logical_cores() -> int: ...
def os_get_sys_free_size() -> uint64_t: ...
def os_get_sys_total_size() -> uint64_t: ...

class os_proc_memory_usage:
    """Proxy of C os_proc_memory_usage struct."""

    thisown = property(
        lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag"
    )
    __repr__ = _swig_repr
    resident_size: uint64_t = property(
        _obspython.os_proc_memory_usage_resident_size_get,
        _obspython.os_proc_memory_usage_resident_size_set,
        doc="resident_size",
    )
    virtual_size: uint64_t = property(
        _obspython.os_proc_memory_usage_virtual_size_get,
        _obspython.os_proc_memory_usage_virtual_size_set,
        doc="virtual_size",
    )

    def __init__(self): ...
    __swig_destroy__ = _obspython.delete_os_proc_memory_usage

_obspython.os_proc_memory_usage_swigregister(os_proc_memory_usage)

def os_get_proc_memory_usage(usage: os_proc_memory_usage) -> bool: ...
def os_get_proc_resident_size() -> uint64_t: ...
def os_get_proc_virtual_size() -> uint64_t: ...

UUID_STR_LENGTH = _obspython.UUID_STR_LENGTH

def os_generate_uuid() -> "char *": ...

ARCH_BITS = _obspython.ARCH_BITS
CONFIG_SUCCESS = _obspython.CONFIG_SUCCESS
CONFIG_FILENOTFOUND = _obspython.CONFIG_FILENOTFOUND
CONFIG_ERROR = _obspython.CONFIG_ERROR
CONFIG_OPEN_EXISTING = _obspython.CONFIG_OPEN_EXISTING
CONFIG_OPEN_ALWAYS = _obspython.CONFIG_OPEN_ALWAYS

def config_create(file: "char const *") -> "config_t *": ...
def config_open(
    config: "config_t **", file: "char const *", open_type: "enum config_open_type"
) -> int: ...
def config_open_string(config: "config_t **", str: "char const *") -> int: ...
def config_save(config: "config_t *") -> int: ...
def config_save_safe(
    config: "config_t *", temp_ext: "char const *", backup_ext: "char const *"
) -> int: ...
def config_close(config: "config_t *") -> void: ...
def config_num_sections(config: "config_t *") -> size_t: ...
def config_get_section(config: "config_t *", idx: size_t) -> "char const *": ...
def config_set_string(
    config: "config_t *",
    section: "char const *",
    name: "char const *",
    value: "char const *",
) -> void: ...
def config_set_int(
    config: "config_t *", section: "char const *", name: "char const *", value: int64_t
) -> void: ...
def config_set_uint(
    config: "config_t *", section: "char const *", name: "char const *", value: uint64_t
) -> void: ...
def config_set_bool(
    config: "config_t *", section: "char const *", name: "char const *", value: bool
) -> void: ...
def config_set_double(
    config: "config_t *", section: "char const *", name: "char const *", value: double
) -> void: ...
def config_get_string(
    config: "config_t *", section: "char const *", name: "char const *"
) -> "char const *": ...
def config_get_int(
    config: "config_t *", section: "char const *", name: "char const *"
) -> int64_t: ...
def config_get_uint(
    config: "config_t *", section: "char const *", name: "char const *"
) -> uint64_t: ...
def config_get_bool(
    config: "config_t *", section: "char const *", name: "char const *"
) -> bool: ...
def config_get_double(
    config: "config_t *", section: "char const *", name: "char const *"
) -> double: ...
def config_remove_value(
    config: "config_t *", section: "char const *", name: "char const *"
) -> bool: ...
def config_open_defaults(config: "config_t *", file: "char const *") -> int: ...
def config_set_default_string(
    config: "config_t *",
    section: "char const *",
    name: "char const *",
    value: "char const *",
) -> void: ...
def config_set_default_int(
    config: "config_t *", section: "char const *", name: "char const *", value: int64_t
) -> void: ...
def config_set_default_uint(
    config: "config_t *", section: "char const *", name: "char const *", value: uint64_t
) -> void: ...
def config_set_default_bool(
    config: "config_t *", section: "char const *", name: "char const *", value: bool
) -> void: ...
def config_set_default_double(
    config: "config_t *", section: "char const *", name: "char const *", value: double
) -> void: ...
def config_get_default_string(
    config: "config_t *", section: "char const *", name: "char const *"
) -> "char const *": ...
def config_get_default_int(
    config: "config_t *", section: "char const *", name: "char const *"
) -> int64_t: ...
def config_get_default_uint(
    config: "config_t *", section: "char const *", name: "char const *"
) -> uint64_t: ...
def config_get_default_bool(
    config: "config_t *", section: "char const *", name: "char const *"
) -> bool: ...
def config_get_default_double(
    config: "config_t *", section: "char const *", name: "char const *"
) -> double: ...
def config_has_user_value(
    config: "config_t *", section: "char const *", name: "char const *"
) -> bool: ...
def config_has_default_value(
    config: "config_t *", section: "char const *", name: "char const *"
) -> bool: ...

OBS_FRONTEND_EVENT_STREAMING_STARTING = _obspython.OBS_FRONTEND_EVENT_STREAMING_STARTING
OBS_FRONTEND_EVENT_STREAMING_STARTED = _obspython.OBS_FRONTEND_EVENT_STREAMING_STARTED
OBS_FRONTEND_EVENT_STREAMING_STOPPING = _obspython.OBS_FRONTEND_EVENT_STREAMING_STOPPING
OBS_FRONTEND_EVENT_STREAMING_STOPPED = _obspython.OBS_FRONTEND_EVENT_STREAMING_STOPPED
OBS_FRONTEND_EVENT_RECORDING_STARTING = _obspython.OBS_FRONTEND_EVENT_RECORDING_STARTING
OBS_FRONTEND_EVENT_RECORDING_STARTED = _obspython.OBS_FRONTEND_EVENT_RECORDING_STARTED
OBS_FRONTEND_EVENT_RECORDING_STOPPING = _obspython.OBS_FRONTEND_EVENT_RECORDING_STOPPING
OBS_FRONTEND_EVENT_RECORDING_STOPPED = _obspython.OBS_FRONTEND_EVENT_RECORDING_STOPPED
OBS_FRONTEND_EVENT_SCENE_CHANGED = _obspython.OBS_FRONTEND_EVENT_SCENE_CHANGED
OBS_FRONTEND_EVENT_SCENE_LIST_CHANGED = _obspython.OBS_FRONTEND_EVENT_SCENE_LIST_CHANGED
OBS_FRONTEND_EVENT_TRANSITION_CHANGED = _obspython.OBS_FRONTEND_EVENT_TRANSITION_CHANGED
OBS_FRONTEND_EVENT_TRANSITION_STOPPED = _obspython.OBS_FRONTEND_EVENT_TRANSITION_STOPPED
OBS_FRONTEND_EVENT_TRANSITION_LIST_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_TRANSITION_LIST_CHANGED
)
OBS_FRONTEND_EVENT_SCENE_COLLECTION_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_SCENE_COLLECTION_CHANGED
)
OBS_FRONTEND_EVENT_SCENE_COLLECTION_LIST_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_SCENE_COLLECTION_LIST_CHANGED
)
OBS_FRONTEND_EVENT_PROFILE_CHANGED = _obspython.OBS_FRONTEND_EVENT_PROFILE_CHANGED
OBS_FRONTEND_EVENT_PROFILE_LIST_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_PROFILE_LIST_CHANGED
)
OBS_FRONTEND_EVENT_EXIT = _obspython.OBS_FRONTEND_EVENT_EXIT
OBS_FRONTEND_EVENT_REPLAY_BUFFER_STARTING = (
    _obspython.OBS_FRONTEND_EVENT_REPLAY_BUFFER_STARTING
)
OBS_FRONTEND_EVENT_REPLAY_BUFFER_STARTED = (
    _obspython.OBS_FRONTEND_EVENT_REPLAY_BUFFER_STARTED
)
OBS_FRONTEND_EVENT_REPLAY_BUFFER_STOPPING = (
    _obspython.OBS_FRONTEND_EVENT_REPLAY_BUFFER_STOPPING
)
OBS_FRONTEND_EVENT_REPLAY_BUFFER_STOPPED = (
    _obspython.OBS_FRONTEND_EVENT_REPLAY_BUFFER_STOPPED
)
OBS_FRONTEND_EVENT_STUDIO_MODE_ENABLED = (
    _obspython.OBS_FRONTEND_EVENT_STUDIO_MODE_ENABLED
)
OBS_FRONTEND_EVENT_STUDIO_MODE_DISABLED = (
    _obspython.OBS_FRONTEND_EVENT_STUDIO_MODE_DISABLED
)
OBS_FRONTEND_EVENT_PREVIEW_SCENE_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_PREVIEW_SCENE_CHANGED
)
OBS_FRONTEND_EVENT_SCENE_COLLECTION_CLEANUP = (
    _obspython.OBS_FRONTEND_EVENT_SCENE_COLLECTION_CLEANUP
)
OBS_FRONTEND_EVENT_FINISHED_LOADING = _obspython.OBS_FRONTEND_EVENT_FINISHED_LOADING
OBS_FRONTEND_EVENT_RECORDING_PAUSED = _obspython.OBS_FRONTEND_EVENT_RECORDING_PAUSED
OBS_FRONTEND_EVENT_RECORDING_UNPAUSED = _obspython.OBS_FRONTEND_EVENT_RECORDING_UNPAUSED
OBS_FRONTEND_EVENT_TRANSITION_DURATION_CHANGED = (
    _obspython.OBS_FRONTEND_EVENT_TRANSITION_DURATION_CHANGED
)
OBS_FRONTEND_EVENT_REPLAY_BUFFER_SAVED = (
    _obspython.OBS_FRONTEND_EVENT_REPLAY_BUFFER_SAVED
)
OBS_FRONTEND_EVENT_VIRTUALCAM_STARTED = _obspython.OBS_FRONTEND_EVENT_VIRTUALCAM_STARTED
OBS_FRONTEND_EVENT_VIRTUALCAM_STOPPED = _obspython.OBS_FRONTEND_EVENT_VIRTUALCAM_STOPPED
OBS_FRONTEND_EVENT_TBAR_VALUE_CHANGED = _obspython.OBS_FRONTEND_EVENT_TBAR_VALUE_CHANGED
OBS_FRONTEND_EVENT_SCENE_COLLECTION_CHANGING = (
    _obspython.OBS_FRONTEND_EVENT_SCENE_COLLECTION_CHANGING
)
OBS_FRONTEND_EVENT_PROFILE_CHANGING = _obspython.OBS_FRONTEND_EVENT_PROFILE_CHANGING
OBS_FRONTEND_EVENT_SCRIPTING_SHUTDOWN = _obspython.OBS_FRONTEND_EVENT_SCRIPTING_SHUTDOWN
OBS_FRONTEND_EVENT_PROFILE_RENAMED = _obspython.OBS_FRONTEND_EVENT_PROFILE_RENAMED
OBS_FRONTEND_EVENT_SCENE_COLLECTION_RENAMED = (
    _obspython.OBS_FRONTEND_EVENT_SCENE_COLLECTION_RENAMED
)
OBS_FRONTEND_EVENT_THEME_CHANGED = _obspython.OBS_FRONTEND_EVENT_THEME_CHANGED
OBS_FRONTEND_EVENT_SCREENSHOT_TAKEN = _obspython.OBS_FRONTEND_EVENT_SCREENSHOT_TAKEN

def obs_frontend_get_main_window() -> "void *": ...
def obs_frontend_get_main_window_handle() -> "void *": ...
def obs_frontend_get_system_tray() -> "void *": ...
def obs_frontend_get_scene_names() -> "char **": ...
def obs_frontend_get_scenes(sources: "struct obs_frontend_source_list *") -> void: ...
def obs_frontend_get_current_scene() -> "obs_source_t *": ...
def obs_frontend_set_current_scene(scene: "obs_source_t *") -> void: ...
def obs_frontend_get_transitions(
    sources: "struct obs_frontend_source_list *",
) -> void: ...
def obs_frontend_get_current_transition() -> "obs_source_t *": ...
def obs_frontend_set_current_transition(transition: "obs_source_t *") -> void: ...
def obs_frontend_get_transition_duration() -> int: ...
def obs_frontend_set_transition_duration(duration: int) -> void: ...
def obs_frontend_release_tbar() -> void: ...
def obs_frontend_set_tbar_position(position: int) -> void: ...
def obs_frontend_get_tbar_position() -> int: ...
def obs_frontend_get_scene_collections() -> "char **": ...
def obs_frontend_get_current_scene_collection() -> "char *": ...
def obs_frontend_set_current_scene_collection(collection: "char const *") -> void: ...
def obs_frontend_add_scene_collection(name: "char const *") -> bool: ...
def obs_frontend_get_profiles() -> "char **": ...
def obs_frontend_get_current_profile() -> "char *": ...
def obs_frontend_get_current_profile_path() -> "char *": ...
def obs_frontend_set_current_profile(profile: "char const *") -> void: ...
def obs_frontend_create_profile(name: "char const *") -> void: ...
def obs_frontend_duplicate_profile(name: "char const *") -> void: ...
def obs_frontend_delete_profile(profile: "char const *") -> void: ...
def obs_frontend_add_tools_menu_qaction(name: "char const *") -> "void *": ...
def obs_frontend_add_tools_menu_item(
    name: "char const *", callback: obs_frontend_cb, private_data: "void *"
) -> void: ...
def obs_frontend_add_dock(dock: "void *") -> "void *": ...
def obs_frontend_add_dock_by_id(
    id: "char const *", title: "char const *", widget: "void *"
) -> bool: ...
def obs_frontend_remove_dock(id: "char const *") -> void: ...
def obs_frontend_add_custom_qdock(id: "char const *", dock: "void *") -> bool: ...
def obs_frontend_add_event_callback(
    callback: obs_frontend_event_cb, private_data: "void *"
) -> void: ...
def obs_frontend_remove_event_callback(
    callback: obs_frontend_event_cb, private_data: "void *"
) -> void: ...
def obs_frontend_add_save_callback(
    callback: obs_frontend_save_cb, private_data: "void *"
) -> void: ...
def obs_frontend_remove_save_callback(
    callback: obs_frontend_save_cb, private_data: "void *"
) -> void: ...
def obs_frontend_add_preload_callback(
    callback: obs_frontend_save_cb, private_data: "void *"
) -> void: ...
def obs_frontend_remove_preload_callback(
    callback: obs_frontend_save_cb, private_data: "void *"
) -> void: ...
def obs_frontend_push_ui_translation(
    translate: obs_frontend_translate_ui_cb,
) -> void: ...
def obs_frontend_pop_ui_translation() -> void: ...
def obs_frontend_streaming_start() -> void: ...
def obs_frontend_streaming_stop() -> void: ...
def obs_frontend_streaming_active() -> bool: ...
def obs_frontend_recording_start() -> void: ...
def obs_frontend_recording_stop() -> void: ...
def obs_frontend_recording_active() -> bool: ...
def obs_frontend_recording_pause(pause: bool) -> void: ...
def obs_frontend_recording_paused() -> bool: ...
def obs_frontend_recording_split_file() -> bool: ...
def obs_frontend_recording_add_chapter(name: "char const *") -> bool: ...
def obs_frontend_replay_buffer_start() -> void: ...
def obs_frontend_replay_buffer_save() -> void: ...
def obs_frontend_replay_buffer_stop() -> void: ...
def obs_frontend_replay_buffer_active() -> bool: ...
def obs_frontend_open_projector(
    type: "char const *", monitor: int, geometry: "char const *", name: "char const *"
) -> void: ...
def obs_frontend_save() -> void: ...
def obs_frontend_defer_save_begin() -> void: ...
def obs_frontend_defer_save_end() -> void: ...
def obs_frontend_get_streaming_output() -> "obs_output_t *": ...
def obs_frontend_get_recording_output() -> "obs_output_t *": ...
def obs_frontend_get_replay_buffer_output() -> "obs_output_t *": ...
def obs_frontend_get_profile_config() -> "config_t *": ...
def obs_frontend_get_global_config() -> "config_t *": ...
def obs_frontend_set_streaming_service(service: "obs_service_t *") -> void: ...
def obs_frontend_get_streaming_service() -> "obs_service_t *": ...
def obs_frontend_save_streaming_service() -> void: ...
def obs_frontend_preview_program_mode_active() -> bool: ...
def obs_frontend_set_preview_program_mode(enable: bool) -> void: ...
def obs_frontend_preview_program_trigger_transition() -> void: ...
def obs_frontend_set_preview_enabled(enable: bool) -> void: ...
def obs_frontend_preview_enabled() -> bool: ...
def obs_frontend_get_current_preview_scene() -> "obs_source_t *": ...
def obs_frontend_set_current_preview_scene(scene: "obs_source_t *") -> void: ...
def obs_frontend_take_screenshot() -> void: ...
def obs_frontend_take_source_screenshot(source: "obs_source_t *") -> void: ...
def obs_frontend_get_virtualcam_output() -> "obs_output_t *": ...
def obs_frontend_start_virtualcam() -> void: ...
def obs_frontend_stop_virtualcam() -> void: ...
def obs_frontend_virtualcam_active() -> bool: ...
def obs_frontend_reset_video() -> void: ...
def obs_frontend_open_source_properties(source: "obs_source_t *") -> void: ...
def obs_frontend_open_source_filters(source: "obs_source_t *") -> void: ...
def obs_frontend_open_source_interaction(source: "obs_source_t *") -> void: ...
def obs_frontend_open_sceneitem_edit_transform(item: "obs_sceneitem_t *") -> void: ...
def obs_frontend_get_current_record_output_path() -> "char *": ...
def obs_frontend_get_locale_string(string: "char const *") -> "char const *": ...
def obs_frontend_is_theme_dark() -> bool: ...
def obs_frontend_get_last_recording() -> "char *": ...
def obs_frontend_get_last_screenshot() -> "char *": ...
def obs_frontend_get_last_replay() -> "char *": ...
def obs_frontend_add_undo_redo_action(
    name: "char const *",
    undo: "undo_redo_cb const",
    redo: "undo_redo_cb const",
    undo_data: "char const *",
    redo_data: "char const *",
    repeatable: bool,
) -> void: ...

# なぜか自動で生成されていない関数
def script_log_no_endl(log_level: int, msg: str) -> None: ...
def script_log(log_level: int, msg: str) -> None: ...
def timer_add(callback: Callable[[], ...], milliseconds: int) -> None: ...
def timer_remove(callback: Callable[[], ...]) -> None: ...
def calldata_source(calldata: "calldata_t *", name: str) -> "obs_source_t *": ...
def calldata_sceneitem(calldata: "calldata_t *", name: str) -> "obs_sceneitem_t *": ...
def source_list_release(source_list: "struct obs_frontend_source_list *") -> None: ...
def sceneitem_list_release(
    item_list: "struct obs_frontend_sceneitem_list *",
) -> None: ...
def remove_current_callback() -> None: ...
