# Generated by Django 4.1.6 on 2023-02-28 13:51

# import csgoogleanalytics.forms
from django.conf import settings
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("tokikomprofile", "0031_alter_tokikomuser_member_type"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="AllowedPattern",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("pattern", models.CharField(max_length=255)),
                ("is_valid", models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name="Page",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("pagepath", models.CharField(max_length=255)),
                ("content_type", models.IntegerField()),
                ("object_id", models.IntegerField()),
                ("added_at", models.DateField()),
                ("added_day", models.IntegerField(default=0)),
                ("added_week", models.IntegerField(default=0)),
                ("added_month", models.IntegerField(default=0)),
                ("added_year", models.IntegerField(default=0)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("modified_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="PageStats",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "period",
                    models.SmallIntegerField(
                        choices=[
                            (0, "1d"),
                            (1, "2d"),
                            (2, "1w"),
                            (3, "2w"),
                            (4, "1m"),
                            (5, "2m"),
                            (6, "1y"),
                            (7, "2y"),
                            (8, "5y"),
                            (9, "10y"),
                            (10, "20y"),
                        ]
                    ),
                ),
                ("pageviews", models.IntegerField(default=0)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "page",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="csgoogleanalytics.page",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CredentialsModel",
            fields=[
                (
                    "id",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                # (
                #     "credential",
                #     csgoogleanalytics.forms.CredentialsField(null=True),
                # ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
            managers=[
                ("objects", django.db.models.manager.Manager()),
                (
                    "siteobjects",
                    django.contrib.sites.managers.CurrentSiteManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AnalyticsProfile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tracking_code",
                    models.CharField(max_length=32, unique=True),
                ),
                (
                    "credentials",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="csgoogleanalytics.credentialsmodel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Analytics profila",
                "verbose_name_plural": "Analytics profilak",
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                (
                    "siteobjects",
                    django.contrib.sites.managers.CurrentSiteManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Analytics",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                ("pageviews", models.IntegerField(default=0)),
                (
                    "path",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("date_added", models.DateTimeField(auto_now_add=True)),
                ("is_valid", models.BooleanField(default=False)),
                (
                    "photo_src",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("content_type", models.IntegerField(blank=True, null=True)),
                ("object_id", models.IntegerField(blank=True, null=True)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Bisiten analitika",
                "verbose_name_plural": "Bisiten analitikak",
            },
            managers=[
                ("objects", django.db.models.manager.Manager()),
                (
                    "siteobjects",
                    django.contrib.sites.managers.CurrentSiteManager(),
                ),
            ],
        ),
    ]
