# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterNetwork',
]

@pulumi.output_type
class ClusterNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str,
                 vswitches: Sequence[str],
                 security_group_ids: Optional[Sequence[str]] = None):
        """
        :param str vpc_id: VpcId to which the cluster belongs.
        :param Sequence[str] vswitches: Switch to which the cluster belongs.
        :param Sequence[str] security_group_ids: Security group to which the cluster belongs.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitches", vswitches)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        VpcId to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def vswitches(self) -> Sequence[str]:
        """
        Switch to which the cluster belongs.
        """
        return pulumi.get(self, "vswitches")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Security group to which the cluster belongs.
        """
        return pulumi.get(self, "security_group_ids")


