# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHistoryDeliveryJobsResult',
    'AwaitableGetHistoryDeliveryJobsResult',
    'get_history_delivery_jobs',
    'get_history_delivery_jobs_output',
]

@pulumi.output_type
class GetHistoryDeliveryJobsResult:
    """
    A collection of values returned by getHistoryDeliveryJobs.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, jobs=None, output_file=None, status=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if jobs and not isinstance(jobs, list):
            raise TypeError("Expected argument 'jobs' to be a list")
        pulumi.set(__self__, "jobs", jobs)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def jobs(self) -> Sequence['outputs.GetHistoryDeliveryJobsJobResult']:
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        return pulumi.get(self, "status")


class AwaitableGetHistoryDeliveryJobsResult(GetHistoryDeliveryJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHistoryDeliveryJobsResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            jobs=self.jobs,
            output_file=self.output_file,
            status=self.status)


def get_history_delivery_jobs(enable_details: Optional[bool] = None,
                              ids: Optional[Sequence[str]] = None,
                              output_file: Optional[str] = None,
                              status: Optional[int] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHistoryDeliveryJobsResult:
    """
    This data source provides the Actiontrail History Delivery Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.139.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"])
    pulumi.export("actiontrailHistoryDeliveryJobId1", ids.jobs[0].id)
    status = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"],
        status=2)
    pulumi.export("actiontrailHistoryDeliveryJobId2", status.jobs[0].id)
    ```


    :param Sequence[str] ids: A list of History Delivery Job IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int status: The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:actiontrail/getHistoryDeliveryJobs:getHistoryDeliveryJobs', __args__, opts=opts, typ=GetHistoryDeliveryJobsResult).value

    return AwaitableGetHistoryDeliveryJobsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        jobs=pulumi.get(__ret__, 'jobs'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_history_delivery_jobs)
def get_history_delivery_jobs_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                     status: Optional[pulumi.Input[Optional[int]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHistoryDeliveryJobsResult]:
    """
    This data source provides the Actiontrail History Delivery Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.139.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"])
    pulumi.export("actiontrailHistoryDeliveryJobId1", ids.jobs[0].id)
    status = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"],
        status=2)
    pulumi.export("actiontrailHistoryDeliveryJobId2", status.jobs[0].id)
    ```


    :param Sequence[str] ids: A list of History Delivery Job IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int status: The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
    """
    ...
