# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 db_cluster_category: pulumi.Input[str],
                 mode: pulumi.Input[str],
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_class: Optional[pulumi.Input[str]] = None,
                 db_node_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_performance_level: Optional[pulumi.Input[str]] = None,
                 elastic_io_resource: Optional[pulumi.Input[int]] = None,
                 elastic_io_resource_size: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 pay_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] db_cluster_category: Cluster category. Value options: `Basic`, `Cluster`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[str] db_cluster_version: Cluster version. Value options: `3.0`, Default to `3.0`.
        :param pulumi.Input[str] db_node_class: The db_node_class of cluster node.
        :param pulumi.Input[int] db_node_count: The db_node_count of cluster node.
        :param pulumi.Input[int] db_node_storage: The db_node_storage of cluster node.
        :param pulumi.Input[str] description: The description of cluster.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] pay_type: Field `pay_type` has been deprecated. New field `payment_type` instead.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        :param pulumi.Input[int] period: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        :param pulumi.Input[str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB cluster.
        """
        pulumi.set(__self__, "db_cluster_category", db_cluster_category)
        pulumi.set(__self__, "mode", mode)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if db_cluster_class is not None:
            warnings.warn("""It duplicates with attribute db_node_class and is deprecated from 1.121.2.""", DeprecationWarning)
            pulumi.log.warn("""db_cluster_class is deprecated: It duplicates with attribute db_node_class and is deprecated from 1.121.2.""")
        if db_cluster_class is not None:
            pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if db_node_class is not None:
            pulumi.set(__self__, "db_node_class", db_node_class)
        if db_node_count is not None:
            pulumi.set(__self__, "db_node_count", db_node_count)
        if db_node_storage is not None:
            pulumi.set(__self__, "db_node_storage", db_node_storage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_performance_level is not None:
            pulumi.set(__self__, "disk_performance_level", disk_performance_level)
        if elastic_io_resource is not None:
            pulumi.set(__self__, "elastic_io_resource", elastic_io_resource)
        if elastic_io_resource_size is not None:
            pulumi.set(__self__, "elastic_io_resource_size", elastic_io_resource_size)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if pay_type is not None:
            warnings.warn("""Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""pay_type is deprecated: Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""")
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dbClusterCategory")
    def db_cluster_category(self) -> pulumi.Input[str]:
        """
        Cluster category. Value options: `Basic`, `Cluster`.
        """
        return pulumi.get(self, "db_cluster_category")

    @db_cluster_category.setter
    def db_cluster_category(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_category", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_resource", value)

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""It duplicates with attribute db_node_class and is deprecated from 1.121.2.""", DeprecationWarning)
        pulumi.log.warn("""db_cluster_class is deprecated: It duplicates with attribute db_node_class and is deprecated from 1.121.2.""")

        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_class", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster version. Value options: `3.0`, Default to `3.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> Optional[pulumi.Input[str]]:
        """
        The db_node_class of cluster node.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_node_class", value)

    @property
    @pulumi.getter(name="dbNodeCount")
    def db_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The db_node_count of cluster node.
        """
        return pulumi.get(self, "db_node_count")

    @db_node_count.setter
    def db_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_count", value)

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The db_node_storage of cluster node.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskPerformanceLevel")
    def disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "disk_performance_level")

    @disk_performance_level.setter
    def disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_performance_level", value)

    @property
    @pulumi.getter(name="elasticIoResource")
    def elastic_io_resource(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "elastic_io_resource")

    @elastic_io_resource.setter
    def elastic_io_resource(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "elastic_io_resource", value)

    @property
    @pulumi.getter(name="elasticIoResourceSize")
    def elastic_io_resource_size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elastic_io_resource_size")

    @elastic_io_resource_size.setter
    def elastic_io_resource_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_io_resource_size", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[str]]:
        """
        Field `pay_type` has been deprecated. New field `payment_type` instead.
        """
        warnings.warn("""Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""pay_type is deprecated: Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""")

        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pay_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 db_cluster_category: Optional[pulumi.Input[str]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_class: Optional[pulumi.Input[str]] = None,
                 db_node_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_performance_level: Optional[pulumi.Input[str]] = None,
                 elastic_io_resource: Optional[pulumi.Input[int]] = None,
                 elastic_io_resource_size: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 pay_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[str] connection_string: (Available in 1.93.0+) The connection string of the ADB cluster.
        :param pulumi.Input[str] db_cluster_category: Cluster category. Value options: `Basic`, `Cluster`.
        :param pulumi.Input[str] db_cluster_version: Cluster version. Value options: `3.0`, Default to `3.0`.
        :param pulumi.Input[str] db_node_class: The db_node_class of cluster node.
        :param pulumi.Input[int] db_node_count: The db_node_count of cluster node.
        :param pulumi.Input[int] db_node_storage: The db_node_storage of cluster node.
        :param pulumi.Input[str] description: The description of cluster.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] pay_type: Field `pay_type` has been deprecated. New field `payment_type` instead.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        :param pulumi.Input[int] period: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        :param pulumi.Input[str] port: (Available in 1.196.0+) The connection port of the ADB cluster.
        :param pulumi.Input[str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB cluster.
        """
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_cluster_category is not None:
            pulumi.set(__self__, "db_cluster_category", db_cluster_category)
        if db_cluster_class is not None:
            warnings.warn("""It duplicates with attribute db_node_class and is deprecated from 1.121.2.""", DeprecationWarning)
            pulumi.log.warn("""db_cluster_class is deprecated: It duplicates with attribute db_node_class and is deprecated from 1.121.2.""")
        if db_cluster_class is not None:
            pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if db_node_class is not None:
            pulumi.set(__self__, "db_node_class", db_node_class)
        if db_node_count is not None:
            pulumi.set(__self__, "db_node_count", db_node_count)
        if db_node_storage is not None:
            pulumi.set(__self__, "db_node_storage", db_node_storage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_performance_level is not None:
            pulumi.set(__self__, "disk_performance_level", disk_performance_level)
        if elastic_io_resource is not None:
            pulumi.set(__self__, "elastic_io_resource", elastic_io_resource)
        if elastic_io_resource_size is not None:
            pulumi.set(__self__, "elastic_io_resource_size", elastic_io_resource_size)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if pay_type is not None:
            warnings.warn("""Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""pay_type is deprecated: Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""")
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_resource", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Available in 1.93.0+) The connection string of the ADB cluster.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dbClusterCategory")
    def db_cluster_category(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster category. Value options: `Basic`, `Cluster`.
        """
        return pulumi.get(self, "db_cluster_category")

    @db_cluster_category.setter
    def db_cluster_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_category", value)

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""It duplicates with attribute db_node_class and is deprecated from 1.121.2.""", DeprecationWarning)
        pulumi.log.warn("""db_cluster_class is deprecated: It duplicates with attribute db_node_class and is deprecated from 1.121.2.""")

        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_class", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster version. Value options: `3.0`, Default to `3.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> Optional[pulumi.Input[str]]:
        """
        The db_node_class of cluster node.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_node_class", value)

    @property
    @pulumi.getter(name="dbNodeCount")
    def db_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The db_node_count of cluster node.
        """
        return pulumi.get(self, "db_node_count")

    @db_node_count.setter
    def db_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_count", value)

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The db_node_storage of cluster node.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskPerformanceLevel")
    def disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "disk_performance_level")

    @disk_performance_level.setter
    def disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_performance_level", value)

    @property
    @pulumi.getter(name="elasticIoResource")
    def elastic_io_resource(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "elastic_io_resource")

    @elastic_io_resource.setter
    def elastic_io_resource(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "elastic_io_resource", value)

    @property
    @pulumi.getter(name="elasticIoResourceSize")
    def elastic_io_resource_size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elastic_io_resource_size")

    @elastic_io_resource_size.setter
    def elastic_io_resource_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_io_resource_size", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[str]]:
        """
        Field `pay_type` has been deprecated. New field `payment_type` instead.
        """
        warnings.warn("""Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""pay_type is deprecated: Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""")

        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pay_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        (Available in 1.196.0+) The connection port of the ADB cluster.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 db_cluster_category: Optional[pulumi.Input[str]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_class: Optional[pulumi.Input[str]] = None,
                 db_node_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_performance_level: Optional[pulumi.Input[str]] = None,
                 elastic_io_resource: Optional[pulumi.Input[int]] = None,
                 elastic_io_resource_size: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 pay_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ADB cluster resource. An ADB cluster is an isolated database
        environment in the cloud. An ADB cluster can contain multiple user-created
        databases.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.121.0`. Please use new resource alicloud_adb_db_cluster.

        > **NOTE:** Available in v1.71.0+.

        ## Example Usage
        ### Create a ADB MySQL cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "adbClusterconfig"
        creation = config.get("creation")
        if creation is None:
            creation = "ADB"
        default_zones = alicloud.get_zones(available_resource_creation=creation)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_cluster = alicloud.adb.Cluster("defaultCluster",
            db_cluster_version="3.0",
            db_cluster_category="Cluster",
            db_node_class="C8",
            db_node_count=2,
            db_node_storage=200,
            pay_type="PostPaid",
            description=name,
            vswitch_id=default_switch.id)
        ```

        ## Import

        ADB cluster can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:adb/cluster:Cluster example am-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[str] db_cluster_category: Cluster category. Value options: `Basic`, `Cluster`.
        :param pulumi.Input[str] db_cluster_version: Cluster version. Value options: `3.0`, Default to `3.0`.
        :param pulumi.Input[str] db_node_class: The db_node_class of cluster node.
        :param pulumi.Input[int] db_node_count: The db_node_count of cluster node.
        :param pulumi.Input[int] db_node_storage: The db_node_storage of cluster node.
        :param pulumi.Input[str] description: The description of cluster.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] pay_type: Field `pay_type` has been deprecated. New field `payment_type` instead.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        :param pulumi.Input[int] period: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        :param pulumi.Input[str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ADB cluster resource. An ADB cluster is an isolated database
        environment in the cloud. An ADB cluster can contain multiple user-created
        databases.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.121.0`. Please use new resource alicloud_adb_db_cluster.

        > **NOTE:** Available in v1.71.0+.

        ## Example Usage
        ### Create a ADB MySQL cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "adbClusterconfig"
        creation = config.get("creation")
        if creation is None:
            creation = "ADB"
        default_zones = alicloud.get_zones(available_resource_creation=creation)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_cluster = alicloud.adb.Cluster("defaultCluster",
            db_cluster_version="3.0",
            db_cluster_category="Cluster",
            db_node_class="C8",
            db_node_count=2,
            db_node_storage=200,
            pay_type="PostPaid",
            description=name,
            vswitch_id=default_switch.id)
        ```

        ## Import

        ADB cluster can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:adb/cluster:Cluster example am-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 db_cluster_category: Optional[pulumi.Input[str]] = None,
                 db_cluster_class: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 db_node_class: Optional[pulumi.Input[str]] = None,
                 db_node_count: Optional[pulumi.Input[int]] = None,
                 db_node_storage: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_performance_level: Optional[pulumi.Input[str]] = None,
                 elastic_io_resource: Optional[pulumi.Input[int]] = None,
                 elastic_io_resource_size: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 pay_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["compute_resource"] = compute_resource
            if db_cluster_category is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_category'")
            __props__.__dict__["db_cluster_category"] = db_cluster_category
            __props__.__dict__["db_cluster_class"] = db_cluster_class
            __props__.__dict__["db_cluster_version"] = db_cluster_version
            __props__.__dict__["db_node_class"] = db_node_class
            __props__.__dict__["db_node_count"] = db_node_count
            __props__.__dict__["db_node_storage"] = db_node_storage
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_performance_level"] = disk_performance_level
            __props__.__dict__["elastic_io_resource"] = elastic_io_resource
            __props__.__dict__["elastic_io_resource_size"] = elastic_io_resource_size
            __props__.__dict__["maintain_time"] = maintain_time
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["modify_type"] = modify_type
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
        super(Cluster, __self__).__init__(
            'alicloud:adb/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            compute_resource: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            db_cluster_category: Optional[pulumi.Input[str]] = None,
            db_cluster_class: Optional[pulumi.Input[str]] = None,
            db_cluster_version: Optional[pulumi.Input[str]] = None,
            db_node_class: Optional[pulumi.Input[str]] = None,
            db_node_count: Optional[pulumi.Input[int]] = None,
            db_node_storage: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_performance_level: Optional[pulumi.Input[str]] = None,
            elastic_io_resource: Optional[pulumi.Input[int]] = None,
            elastic_io_resource_size: Optional[pulumi.Input[str]] = None,
            maintain_time: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            modify_type: Optional[pulumi.Input[str]] = None,
            pay_type: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[str]] = None,
            renewal_status: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[str] connection_string: (Available in 1.93.0+) The connection string of the ADB cluster.
        :param pulumi.Input[str] db_cluster_category: Cluster category. Value options: `Basic`, `Cluster`.
        :param pulumi.Input[str] db_cluster_version: Cluster version. Value options: `3.0`, Default to `3.0`.
        :param pulumi.Input[str] db_node_class: The db_node_class of cluster node.
        :param pulumi.Input[int] db_node_count: The db_node_count of cluster node.
        :param pulumi.Input[int] db_node_storage: The db_node_storage of cluster node.
        :param pulumi.Input[str] description: The description of cluster.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] pay_type: Field `pay_type` has been deprecated. New field `payment_type` instead.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        :param pulumi.Input[int] period: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        :param pulumi.Input[str] port: (Available in 1.196.0+) The connection port of the ADB cluster.
        :param pulumi.Input[str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["compute_resource"] = compute_resource
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_cluster_category"] = db_cluster_category
        __props__.__dict__["db_cluster_class"] = db_cluster_class
        __props__.__dict__["db_cluster_version"] = db_cluster_version
        __props__.__dict__["db_node_class"] = db_node_class
        __props__.__dict__["db_node_count"] = db_node_count
        __props__.__dict__["db_node_storage"] = db_node_storage
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_performance_level"] = disk_performance_level
        __props__.__dict__["elastic_io_resource"] = elastic_io_resource
        __props__.__dict__["elastic_io_resource_size"] = elastic_io_resource_size
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["mode"] = mode
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[int]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "compute_resource")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        (Available in 1.93.0+) The connection string of the ADB cluster.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbClusterCategory")
    def db_cluster_category(self) -> pulumi.Output[str]:
        """
        Cluster category. Value options: `Basic`, `Cluster`.
        """
        return pulumi.get(self, "db_cluster_category")

    @property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Output[Optional[str]]:
        warnings.warn("""It duplicates with attribute db_node_class and is deprecated from 1.121.2.""", DeprecationWarning)
        pulumi.log.warn("""db_cluster_class is deprecated: It duplicates with attribute db_node_class and is deprecated from 1.121.2.""")

        return pulumi.get(self, "db_cluster_class")

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster version. Value options: `3.0`, Default to `3.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> pulumi.Output[str]:
        """
        The db_node_class of cluster node.
        """
        return pulumi.get(self, "db_node_class")

    @property
    @pulumi.getter(name="dbNodeCount")
    def db_node_count(self) -> pulumi.Output[int]:
        """
        The db_node_count of cluster node.
        """
        return pulumi.get(self, "db_node_count")

    @property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Output[int]:
        """
        The db_node_storage of cluster node.
        """
        return pulumi.get(self, "db_node_storage")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskPerformanceLevel")
    def disk_performance_level(self) -> pulumi.Output[str]:
        return pulumi.get(self, "disk_performance_level")

    @property
    @pulumi.getter(name="elasticIoResource")
    def elastic_io_resource(self) -> pulumi.Output[int]:
        return pulumi.get(self, "elastic_io_resource")

    @property
    @pulumi.getter(name="elasticIoResourceSize")
    def elastic_io_resource_size(self) -> pulumi.Output[str]:
        return pulumi.get(self, "elastic_io_resource_size")

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[str]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "modify_type")

    @property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[str]:
        """
        Field `pay_type` has been deprecated. New field `payment_type` instead.
        """
        warnings.warn("""Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""pay_type is deprecated: Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove in the future version. Please use the new attribute 'payment_type' instead.""")

        return pulumi.get(self, "pay_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        (Available in 1.196.0+) The connection port of the ADB cluster.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[str]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "zone_id")

