# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DBClusterLakeVersionArgs', 'DBClusterLakeVersion']

@pulumi.input_type
class DBClusterLakeVersionArgs:
    def __init__(__self__, *,
                 compute_resource: pulumi.Input[str],
                 db_cluster_version: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 storage_resource: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DBClusterLakeVersion resource.
        :param pulumi.Input[str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[str] zone_id: The zone ID of the resource.
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        pulumi.set(__self__, "compute_resource", compute_resource)
        pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "storage_resource", storage_resource)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if enable_default_resource_group is not None:
            pulumi.set(__self__, "enable_default_resource_group", enable_default_resource_group)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if source_db_cluster_id is not None:
            pulumi.set(__self__, "source_db_cluster_id", source_db_cluster_id)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> pulumi.Input[str]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_resource", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Input[str]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> pulumi.Input[str]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @storage_resource.setter
    def storage_resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_resource", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_id", value)

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_description", value)

    @property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @enable_default_resource_group.setter
    def enable_default_resource_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_default_resource_group", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[str]]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @source_db_cluster_id.setter
    def source_db_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_id", value)


@pulumi.input_type
class _DBClusterLakeVersionState:
    def __init__(__self__, *,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 commodity_code: Optional[pulumi.Input[str]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 expired: Optional[pulumi.Input[str]] = None,
                 lock_mode: Optional[pulumi.Input[str]] = None,
                 lock_reason: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_resource: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DBClusterLakeVersion resources.
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[str] commodity_code: The name of the service.
        :param pulumi.Input[str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[str] connection_string: The endpoint of the cluster.
        :param pulumi.Input[str] create_time: The createTime of the cluster.
        :param pulumi.Input[str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[str] engine: The engine of the database.
        :param pulumi.Input[str] engine_version: The engine version of the database.
        :param pulumi.Input[str] expire_time: The time when the cluster expires.
        :param pulumi.Input[str] expired: Indicates whether the cluster has expired.
        :param pulumi.Input[str] lock_mode: The lock mode of the cluster.
        :param pulumi.Input[str] lock_reason: The reason why the cluster is locked.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] port: The port that is used to access the cluster.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[str] zone_id: The zone ID of the resource.
        """
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if enable_default_resource_group is not None:
            pulumi.set(__self__, "enable_default_resource_group", enable_default_resource_group)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if lock_mode is not None:
            pulumi.set(__self__, "lock_mode", lock_mode)
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if source_db_cluster_id is not None:
            pulumi.set(__self__, "source_db_cluster_id", source_db_cluster_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_resource is not None:
            pulumi.set(__self__, "storage_resource", storage_resource)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_id", value)

    @property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commodity_code", value)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_resource", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The createTime of the cluster.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_description", value)

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_version", value)

    @property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @enable_default_resource_group.setter
    def enable_default_resource_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_default_resource_group", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version of the database.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the cluster expires.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def expired(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the cluster has expired.
        """
        return pulumi.get(self, "expired")

    @expired.setter
    def expired(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired", value)

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The lock mode of the cluster.
        """
        return pulumi.get(self, "lock_mode")

    @lock_mode.setter
    def lock_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_mode", value)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the cluster is locked.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_reason", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port that is used to access the cluster.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[str]]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @source_db_cluster_id.setter
    def source_db_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @storage_resource.setter
    def storage_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_resource", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DBClusterLakeVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[str]] = None,
                 storage_resource: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.

        For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).

        > **NOTE:** Available since v1.190.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_zones = alicloud.adb.get_zones()
        default_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=default_zones.ids[0])
        default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("defaultDBClusterLakeVersion",
            db_cluster_version="5.0",
            vpc_id=default_networks.ids[0],
            vswitch_id=default_switches.ids[0],
            zone_id=default_zones.ids[0],
            compute_resource="16ACU",
            storage_resource="0ACU",
            payment_type="PayAsYouGo",
            enable_default_resource_group=False)
        ```

        ## Import

        AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[str] zone_id: The zone ID of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DBClusterLakeVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.

        For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).

        > **NOTE:** Available since v1.190.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_zones = alicloud.adb.get_zones()
        default_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=default_zones.ids[0])
        default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("defaultDBClusterLakeVersion",
            db_cluster_version="5.0",
            vpc_id=default_networks.ids[0],
            vswitch_id=default_switches.ids[0],
            zone_id=default_zones.ids[0],
            compute_resource="16ACU",
            storage_resource="0ACU",
            payment_type="PayAsYouGo",
            enable_default_resource_group=False)
        ```

        ## Import

        AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DBClusterLakeVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DBClusterLakeVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 compute_resource: Optional[pulumi.Input[str]] = None,
                 db_cluster_description: Optional[pulumi.Input[str]] = None,
                 db_cluster_version: Optional[pulumi.Input[str]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[str]] = None,
                 storage_resource: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DBClusterLakeVersionArgs.__new__(DBClusterLakeVersionArgs)

            __props__.__dict__["backup_set_id"] = backup_set_id
            if compute_resource is None and not opts.urn:
                raise TypeError("Missing required property 'compute_resource'")
            __props__.__dict__["compute_resource"] = compute_resource
            __props__.__dict__["db_cluster_description"] = db_cluster_description
            if db_cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_version'")
            __props__.__dict__["db_cluster_version"] = db_cluster_version
            __props__.__dict__["enable_default_resource_group"] = enable_default_resource_group
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restore_to_time"] = restore_to_time
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["source_db_cluster_id"] = source_db_cluster_id
            if storage_resource is None and not opts.urn:
                raise TypeError("Missing required property 'storage_resource'")
            __props__.__dict__["storage_resource"] = storage_resource
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["commodity_code"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["expired"] = None
            __props__.__dict__["lock_mode"] = None
            __props__.__dict__["lock_reason"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
        super(DBClusterLakeVersion, __self__).__init__(
            'alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_set_id: Optional[pulumi.Input[str]] = None,
            commodity_code: Optional[pulumi.Input[str]] = None,
            compute_resource: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            db_cluster_description: Optional[pulumi.Input[str]] = None,
            db_cluster_version: Optional[pulumi.Input[str]] = None,
            enable_default_resource_group: Optional[pulumi.Input[bool]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            expire_time: Optional[pulumi.Input[str]] = None,
            expired: Optional[pulumi.Input[str]] = None,
            lock_mode: Optional[pulumi.Input[str]] = None,
            lock_reason: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            restore_to_time: Optional[pulumi.Input[str]] = None,
            restore_type: Optional[pulumi.Input[str]] = None,
            security_ips: Optional[pulumi.Input[str]] = None,
            source_db_cluster_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_resource: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DBClusterLakeVersion':
        """
        Get an existing DBClusterLakeVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[str] commodity_code: The name of the service.
        :param pulumi.Input[str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[str] connection_string: The endpoint of the cluster.
        :param pulumi.Input[str] create_time: The createTime of the cluster.
        :param pulumi.Input[str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[str] engine: The engine of the database.
        :param pulumi.Input[str] engine_version: The engine version of the database.
        :param pulumi.Input[str] expire_time: The time when the cluster expires.
        :param pulumi.Input[str] expired: Indicates whether the cluster has expired.
        :param pulumi.Input[str] lock_mode: The lock mode of the cluster.
        :param pulumi.Input[str] lock_reason: The reason why the cluster is locked.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[str] port: The port that is used to access the cluster.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[str] zone_id: The zone ID of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DBClusterLakeVersionState.__new__(_DBClusterLakeVersionState)

        __props__.__dict__["backup_set_id"] = backup_set_id
        __props__.__dict__["commodity_code"] = commodity_code
        __props__.__dict__["compute_resource"] = compute_resource
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_cluster_description"] = db_cluster_description
        __props__.__dict__["db_cluster_version"] = db_cluster_version
        __props__.__dict__["enable_default_resource_group"] = enable_default_resource_group
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["expired"] = expired
        __props__.__dict__["lock_mode"] = lock_mode
        __props__.__dict__["lock_reason"] = lock_reason
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["port"] = port
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restore_to_time"] = restore_to_time
        __props__.__dict__["restore_type"] = restore_type
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["source_db_cluster_id"] = source_db_cluster_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_resource"] = storage_resource
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DBClusterLakeVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Output[str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "commodity_code")

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> pulumi.Output[str]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        The endpoint of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The createTime of the cluster.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Output[str]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Output[str]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The engine version of the database.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[str]:
        """
        The time when the cluster expires.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def expired(self) -> pulumi.Output[str]:
        """
        Indicates whether the cluster has expired.
        """
        return pulumi.get(self, "expired")

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> pulumi.Output[str]:
        """
        The lock mode of the cluster.
        """
        return pulumi.get(self, "lock_mode")

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> pulumi.Output[str]:
        """
        The reason why the cluster is locked.
        """
        return pulumi.get(self, "lock_reason")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        The port that is used to access the cluster.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> pulumi.Output[Optional[str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[Optional[str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[str]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> pulumi.Output[str]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

