# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, listener_ids=None, listener_protocol=None, listeners=None, load_balancer_ids=None, output_file=None, status=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_ids and not isinstance(listener_ids, list):
            raise TypeError("Expected argument 'listener_ids' to be a list")
        pulumi.set(__self__, "listener_ids", listener_ids)
        if listener_protocol and not isinstance(listener_protocol, str):
            raise TypeError("Expected argument 'listener_protocol' to be a str")
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerIds")
    def listener_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "listener_ids")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[str]:
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "load_balancer_ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            listener_ids=self.listener_ids,
            listener_protocol=self.listener_protocol,
            listeners=self.listeners,
            load_balancer_ids=self.load_balancer_ids,
            output_file=self.output_file,
            status=self.status)


def get_listeners(enable_details: Optional[bool] = None,
                  ids: Optional[Sequence[str]] = None,
                  listener_ids: Optional[Sequence[str]] = None,
                  listener_protocol: Optional[str] = None,
                  load_balancer_ids: Optional[Sequence[str]] = None,
                  output_file: Optional[str] = None,
                  status: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    This data source provides the Application Load Balancer (ALB) Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.133.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_listeners(ids=["example_id"])
    pulumi.export("albListenerId1", ids.listeners[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Listener IDs.
    :param Sequence[str] listener_ids: The listener ids.
    :param str listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The association status between the ACL and the listener.  Valid values: `Associating`, `Associated` Or `Dissociating`. `Associating`: The ACL is being associated with the listener. `Associated`: The ACL is associated with the listener. `Dissociating`: The ACL is being disassociated from the listener.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['listenerIds'] = listener_ids
    __args__['listenerProtocol'] = listener_protocol
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_ids=pulumi.get(__ret__, 'listener_ids'),
        listener_protocol=pulumi.get(__ret__, 'listener_protocol'),
        listeners=pulumi.get(__ret__, 'listeners'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_listeners)
def get_listeners_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         listener_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         listener_protocol: Optional[pulumi.Input[Optional[str]]] = None,
                         load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListenersResult]:
    """
    This data source provides the Application Load Balancer (ALB) Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.133.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_listeners(ids=["example_id"])
    pulumi.export("albListenerId1", ids.listeners[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Listener IDs.
    :param Sequence[str] listener_ids: The listener ids.
    :param str listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The association status between the ACL and the listener.  Valid values: `Associating`, `Associated` Or `Dissociating`. `Associating`: The ACL is being associated with the listener. `Associated`: The ACL is associated with the listener. `Dissociating`: The ACL is being disassociated from the listener.
    """
    ...
