# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLoadBalancersResult',
    'AwaitableGetLoadBalancersResult',
    'get_load_balancers',
    'get_load_balancers_output',
]

@pulumi.output_type
class GetLoadBalancersResult:
    """
    A collection of values returned by getLoadBalancers.
    """
    def __init__(__self__, address_type=None, balancers=None, enable_details=None, id=None, ids=None, load_balancer_business_status=None, load_balancer_bussiness_status=None, load_balancer_ids=None, load_balancer_name=None, name_regex=None, names=None, output_file=None, resource_group_id=None, status=None, tags=None, vpc_id=None, vpc_ids=None, zone_id=None):
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if balancers and not isinstance(balancers, list):
            raise TypeError("Expected argument 'balancers' to be a list")
        pulumi.set(__self__, "balancers", balancers)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if load_balancer_business_status and not isinstance(load_balancer_business_status, str):
            raise TypeError("Expected argument 'load_balancer_business_status' to be a str")
        pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        if load_balancer_bussiness_status and not isinstance(load_balancer_bussiness_status, str):
            raise TypeError("Expected argument 'load_balancer_bussiness_status' to be a str")
        pulumi.set(__self__, "load_balancer_bussiness_status", load_balancer_bussiness_status)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_ids and not isinstance(vpc_ids, list):
            raise TypeError("Expected argument 'vpc_ids' to be a list")
        pulumi.set(__self__, "vpc_ids", vpc_ids)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[str]:
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter
    def balancers(self) -> Sequence['outputs.GetLoadBalancersBalancerResult']:
        return pulumi.get(self, "balancers")

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> Optional[str]:
        return pulumi.get(self, "load_balancer_business_status")

    @property
    @pulumi.getter(name="loadBalancerBussinessStatus")
    def load_balancer_bussiness_status(self) -> Optional[str]:
        warnings.warn("""Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it will be removed in the future version. Please use the new attribute 'load_balancer_business_status' instead.""", DeprecationWarning)
        pulumi.log.warn("""load_balancer_bussiness_status is deprecated: Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it will be removed in the future version. Please use the new attribute 'load_balancer_business_status' instead.""")

        return pulumi.get(self, "load_balancer_bussiness_status")

    @property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "load_balancer_ids")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "vpc_ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        return pulumi.get(self, "zone_id")


class AwaitableGetLoadBalancersResult(GetLoadBalancersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancersResult(
            address_type=self.address_type,
            balancers=self.balancers,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            load_balancer_business_status=self.load_balancer_business_status,
            load_balancer_bussiness_status=self.load_balancer_bussiness_status,
            load_balancer_ids=self.load_balancer_ids,
            load_balancer_name=self.load_balancer_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id,
            vpc_ids=self.vpc_ids,
            zone_id=self.zone_id)


def get_load_balancers(address_type: Optional[str] = None,
                       enable_details: Optional[bool] = None,
                       ids: Optional[Sequence[str]] = None,
                       load_balancer_business_status: Optional[str] = None,
                       load_balancer_bussiness_status: Optional[str] = None,
                       load_balancer_ids: Optional[Sequence[str]] = None,
                       load_balancer_name: Optional[str] = None,
                       name_regex: Optional[str] = None,
                       output_file: Optional[str] = None,
                       resource_group_id: Optional[str] = None,
                       status: Optional[str] = None,
                       tags: Optional[Mapping[str, Any]] = None,
                       vpc_id: Optional[str] = None,
                       vpc_ids: Optional[Sequence[str]] = None,
                       zone_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancersResult:
    """
    This data source provides the Alb Load Balancers of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.132.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_load_balancers()
    pulumi.export("albLoadBalancerId1", ids.balancers[0].id)
    name_regex = alicloud.alb.get_load_balancers(name_regex="^my-LoadBalancer")
    pulumi.export("albLoadBalancerId2", name_regex.balancers[0].id)
    ```


    :param str address_type: The type of IP address that the ALB instance uses to provide services.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Load Balancer IDs.
    :param str load_balancer_business_status: Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`. **NOTE:** Available in 1.142.0+
    :param str load_balancer_bussiness_status: Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`.  **NOTE:** Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str load_balancer_name: The name of the resource.
    :param str name_regex: A regex string to filter results by Load Balancer name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str status: The The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
    :param Mapping[str, Any] tags: The tag of the resource.
    :param str vpc_id: The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
    :param Sequence[str] vpc_ids: The vpc ids.
    :param str zone_id: The ID of the zone to which the ALB instance belongs.
    """
    __args__ = dict()
    __args__['addressType'] = address_type
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['loadBalancerBusinessStatus'] = load_balancer_business_status
    __args__['loadBalancerBussinessStatus'] = load_balancer_bussiness_status
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['loadBalancerName'] = load_balancer_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vpcIds'] = vpc_ids
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getLoadBalancers:getLoadBalancers', __args__, opts=opts, typ=GetLoadBalancersResult).value

    return AwaitableGetLoadBalancersResult(
        address_type=pulumi.get(__ret__, 'address_type'),
        balancers=pulumi.get(__ret__, 'balancers'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        load_balancer_business_status=pulumi.get(__ret__, 'load_balancer_business_status'),
        load_balancer_bussiness_status=pulumi.get(__ret__, 'load_balancer_bussiness_status'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_ids=pulumi.get(__ret__, 'vpc_ids'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(get_load_balancers)
def get_load_balancers_output(address_type: Optional[pulumi.Input[Optional[str]]] = None,
                              enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              load_balancer_business_status: Optional[pulumi.Input[Optional[str]]] = None,
                              load_balancer_bussiness_status: Optional[pulumi.Input[Optional[str]]] = None,
                              load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              load_balancer_name: Optional[pulumi.Input[Optional[str]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                              status: Optional[pulumi.Input[Optional[str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                              vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                              vpc_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLoadBalancersResult]:
    """
    This data source provides the Alb Load Balancers of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.132.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_load_balancers()
    pulumi.export("albLoadBalancerId1", ids.balancers[0].id)
    name_regex = alicloud.alb.get_load_balancers(name_regex="^my-LoadBalancer")
    pulumi.export("albLoadBalancerId2", name_regex.balancers[0].id)
    ```


    :param str address_type: The type of IP address that the ALB instance uses to provide services.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Load Balancer IDs.
    :param str load_balancer_business_status: Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`. **NOTE:** Available in 1.142.0+
    :param str load_balancer_bussiness_status: Load Balancing of the Service Status. Valid Values: `Abnormal` and `Normal`.  **NOTE:** Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str load_balancer_name: The name of the resource.
    :param str name_regex: A regex string to filter results by Load Balancer name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str status: The The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
    :param Mapping[str, Any] tags: The tag of the resource.
    :param str vpc_id: The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
    :param Sequence[str] vpc_ids: The vpc ids.
    :param str zone_id: The ID of the zone to which the ALB instance belongs.
    """
    ...
