# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRulesResult',
    'AwaitableGetRulesResult',
    'get_rules',
    'get_rules_output',
]

@pulumi.output_type
class GetRulesResult:
    """
    A collection of values returned by getRules.
    """
    def __init__(__self__, id=None, ids=None, listener_ids=None, load_balancer_ids=None, name_regex=None, names=None, output_file=None, rule_ids=None, rules=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_ids and not isinstance(listener_ids, list):
            raise TypeError("Expected argument 'listener_ids' to be a list")
        pulumi.set(__self__, "listener_ids", listener_ids)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rule_ids and not isinstance(rule_ids, list):
            raise TypeError("Expected argument 'rule_ids' to be a list")
        pulumi.set(__self__, "rule_ids", rule_ids)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerIds")
    def listener_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "listener_ids")

    @property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "load_balancer_ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "rule_ids")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetRulesRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetRulesResult(GetRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesResult(
            id=self.id,
            ids=self.ids,
            listener_ids=self.listener_ids,
            load_balancer_ids=self.load_balancer_ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            rule_ids=self.rule_ids,
            rules=self.rules,
            status=self.status)


def get_rules(ids: Optional[Sequence[str]] = None,
              listener_ids: Optional[Sequence[str]] = None,
              load_balancer_ids: Optional[Sequence[str]] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              rule_ids: Optional[Sequence[str]] = None,
              status: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesResult:
    """
    This data source provides the Alb Rules of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.133.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_rules(ids=["example_id"])
    pulumi.export("albRuleId1", ids.rules[0].id)
    name_regex = alicloud.alb.get_rules(name_regex="^my-Rule")
    pulumi.export("albRuleId2", name_regex.rules[0].id)
    ```


    :param Sequence[str] ids: A list of Rule IDs.
    :param Sequence[str] listener_ids: The listener ids.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str name_regex: A regex string to filter results by Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[str] rule_ids: The rule ids.
    :param str status: The status of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerIds'] = listener_ids
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['ruleIds'] = rule_ids
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getRules:getRules', __args__, opts=opts, typ=GetRulesResult).value

    return AwaitableGetRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_ids=pulumi.get(__ret__, 'listener_ids'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rule_ids=pulumi.get(__ret__, 'rule_ids'),
        rules=pulumi.get(__ret__, 'rules'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_rules)
def get_rules_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     listener_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     rule_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRulesResult]:
    """
    This data source provides the Alb Rules of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.133.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_rules(ids=["example_id"])
    pulumi.export("albRuleId1", ids.rules[0].id)
    name_regex = alicloud.alb.get_rules(name_regex="^my-Rule")
    pulumi.export("albRuleId2", name_regex.rules[0].id)
    ```


    :param Sequence[str] ids: A list of Rule IDs.
    :param Sequence[str] listener_ids: The listener ids.
    :param Sequence[str] load_balancer_ids: The load balancer ids.
    :param str name_regex: A regex string to filter results by Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[str] rule_ids: The rule ids.
    :param str status: The status of the resource.
    """
    ...
