# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerGroupsResult',
    'AwaitableGetServerGroupsResult',
    'get_server_groups',
    'get_server_groups_output',
]

@pulumi.output_type
class GetServerGroupsResult:
    """
    A collection of values returned by getServerGroups.
    """
    def __init__(__self__, enable_details=None, groups=None, id=None, ids=None, name_regex=None, names=None, output_file=None, resource_group_id=None, server_group_ids=None, server_group_name=None, status=None, tags=None, vpc_id=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_group_ids and not isinstance(server_group_ids, list):
            raise TypeError("Expected argument 'server_group_ids' to be a list")
        pulumi.set(__self__, "server_group_ids", server_group_ids)
        if server_group_name and not isinstance(server_group_name, str):
            raise TypeError("Expected argument 'server_group_name' to be a str")
        pulumi.set(__self__, "server_group_name", server_group_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetServerGroupsGroupResult']:
        """
        A list of Alb Server Groups. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of Server Group names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="serverGroupIds")
    def server_group_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "server_group_ids")

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "server_group_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the resource. Valid values: `Provisioning`, `Available` and `Configuring`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC that you want to access.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetServerGroupsResult(GetServerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerGroupsResult(
            enable_details=self.enable_details,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            server_group_ids=self.server_group_ids,
            server_group_name=self.server_group_name,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_server_groups(enable_details: Optional[bool] = None,
                      ids: Optional[Sequence[str]] = None,
                      name_regex: Optional[str] = None,
                      output_file: Optional[str] = None,
                      resource_group_id: Optional[str] = None,
                      server_group_ids: Optional[Sequence[str]] = None,
                      server_group_name: Optional[str] = None,
                      status: Optional[str] = None,
                      tags: Optional[Mapping[str, Any]] = None,
                      vpc_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerGroupsResult:
    """
    This data source provides the Alb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.131.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_server_groups()
    pulumi.export("albServerGroupId1", ids.groups[0].id)
    name_regex = alicloud.alb.get_server_groups(name_regex="^my-ServerGroup")
    pulumi.export("albServerGroupId2", name_regex.groups[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Server Group IDs.
    :param str name_regex: A regex string to filter results by Server Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param Sequence[str] server_group_ids: The server group ids.
    :param str server_group_name: The name of the resource.
    :param str status: The status of the resource.
    :param Mapping[str, Any] tags: A map of tags assigned to the group.
    :param str vpc_id: The ID of the VPC that you want to access.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverGroupIds'] = server_group_ids
    __args__['serverGroupName'] = server_group_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getServerGroups:getServerGroups', __args__, opts=opts, typ=GetServerGroupsResult).value

    return AwaitableGetServerGroupsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        server_group_ids=pulumi.get(__ret__, 'server_group_ids'),
        server_group_name=pulumi.get(__ret__, 'server_group_name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_server_groups)
def get_server_groups_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                             server_group_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             server_group_name: Optional[pulumi.Input[Optional[str]]] = None,
                             status: Optional[pulumi.Input[Optional[str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerGroupsResult]:
    """
    This data source provides the Alb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.131.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.alb.get_server_groups()
    pulumi.export("albServerGroupId1", ids.groups[0].id)
    name_regex = alicloud.alb.get_server_groups(name_regex="^my-ServerGroup")
    pulumi.export("albServerGroupId2", name_regex.groups[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Server Group IDs.
    :param str name_regex: A regex string to filter results by Server Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param Sequence[str] server_group_ids: The server group ids.
    :param str server_group_name: The name of the resource.
    :param str status: The status of the resource.
    :param Mapping[str, Any] tags: A map of tags assigned to the group.
    :param str vpc_id: The ID of the VPC that you want to access.
    """
    ...
