# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HealthCheckTemplateArgs', 'HealthCheckTemplate']

@pulumi.input_type
class HealthCheckTemplateArgs:
    def __init__(__self__, *,
                 health_check_template_name: pulumi.Input[str],
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[int]] = None,
                 health_check_host: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a HealthCheckTemplate resource.
        :param pulumi.Input[str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[bool] dry_run: Whether to precheck the API request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_check_codes: The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        :param pulumi.Input[str] health_check_host: The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_http_version: The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_interval: The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        :param pulumi.Input[str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_protocol: The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        :param pulumi.Input[int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        :param pulumi.Input[int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        :param pulumi.Input[int] unhealthy_threshold: The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_codes is not None:
            pulumi.set(__self__, "health_check_codes", health_check_codes)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Input[str]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_template_name", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to precheck the API request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_codes")

    @health_check_codes.setter
    def health_check_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "health_check_codes", value)

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_host", value)

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_version", value)

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval", value)

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_method", value)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_path", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class _HealthCheckTemplateState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[int]] = None,
                 health_check_host: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering HealthCheckTemplate resources.
        :param pulumi.Input[bool] dry_run: Whether to precheck the API request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_check_codes: The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        :param pulumi.Input[str] health_check_host: The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_http_version: The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_interval: The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        :param pulumi.Input[str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_protocol: The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        :param pulumi.Input[str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        :param pulumi.Input[int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        :param pulumi.Input[int] unhealthy_threshold: The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_codes is not None:
            pulumi.set(__self__, "health_check_codes", health_check_codes)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_host is not None:
            pulumi.set(__self__, "health_check_host", health_check_host)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_template_name is not None:
            pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to precheck the API request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_codes")

    @health_check_codes.setter
    def health_check_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "health_check_codes", value)

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_host")

    @health_check_host.setter
    def health_check_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_host", value)

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_version", value)

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval", value)

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_method", value)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_path", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_template_name", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


class HealthCheckTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[int]] = None,
                 health_check_host: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Health Check Template resource.

        For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name="example_name")
        ```

        ## Import

        Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Whether to precheck the API request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_check_codes: The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        :param pulumi.Input[str] health_check_host: The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_http_version: The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_interval: The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        :param pulumi.Input[str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_protocol: The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        :param pulumi.Input[str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        :param pulumi.Input[int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        :param pulumi.Input[int] unhealthy_threshold: The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthCheckTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Health Check Template resource.

        For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name="example_name")
        ```

        ## Import

        Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param HealthCheckTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthCheckTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check_connect_port: Optional[pulumi.Input[int]] = None,
                 health_check_host: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthCheckTemplateArgs.__new__(HealthCheckTemplateArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["health_check_codes"] = health_check_codes
            __props__.__dict__["health_check_connect_port"] = health_check_connect_port
            __props__.__dict__["health_check_host"] = health_check_host
            __props__.__dict__["health_check_http_version"] = health_check_http_version
            __props__.__dict__["health_check_interval"] = health_check_interval
            __props__.__dict__["health_check_method"] = health_check_method
            __props__.__dict__["health_check_path"] = health_check_path
            __props__.__dict__["health_check_protocol"] = health_check_protocol
            if health_check_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'health_check_template_name'")
            __props__.__dict__["health_check_template_name"] = health_check_template_name
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        super(HealthCheckTemplate, __self__).__init__(
            'alicloud:alb/healthCheckTemplate:HealthCheckTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            health_check_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            health_check_connect_port: Optional[pulumi.Input[int]] = None,
            health_check_host: Optional[pulumi.Input[str]] = None,
            health_check_http_version: Optional[pulumi.Input[str]] = None,
            health_check_interval: Optional[pulumi.Input[int]] = None,
            health_check_method: Optional[pulumi.Input[str]] = None,
            health_check_path: Optional[pulumi.Input[str]] = None,
            health_check_protocol: Optional[pulumi.Input[str]] = None,
            health_check_template_name: Optional[pulumi.Input[str]] = None,
            health_check_timeout: Optional[pulumi.Input[int]] = None,
            healthy_threshold: Optional[pulumi.Input[int]] = None,
            unhealthy_threshold: Optional[pulumi.Input[int]] = None) -> 'HealthCheckTemplate':
        """
        Get an existing HealthCheckTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Whether to precheck the API request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_check_codes: The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_connect_port: The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        :param pulumi.Input[str] health_check_host: The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_http_version: The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[int] health_check_interval: The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        :param pulumi.Input[str] health_check_method: The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_path: The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        :param pulumi.Input[str] health_check_protocol: The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        :param pulumi.Input[str] health_check_template_name: The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[int] health_check_timeout: The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        :param pulumi.Input[int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        :param pulumi.Input[int] unhealthy_threshold: The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthCheckTemplateState.__new__(_HealthCheckTemplateState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["health_check_codes"] = health_check_codes
        __props__.__dict__["health_check_connect_port"] = health_check_connect_port
        __props__.__dict__["health_check_host"] = health_check_host
        __props__.__dict__["health_check_http_version"] = health_check_http_version
        __props__.__dict__["health_check_interval"] = health_check_interval
        __props__.__dict__["health_check_method"] = health_check_method
        __props__.__dict__["health_check_path"] = health_check_path
        __props__.__dict__["health_check_protocol"] = health_check_protocol
        __props__.__dict__["health_check_template_name"] = health_check_template_name
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        return HealthCheckTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to precheck the API request.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="healthCheckCodes")
    def health_check_codes(self) -> pulumi.Output[Sequence[str]]:
        """
        The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_codes")

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> pulumi.Output[int]:
        """
        The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @property
    @pulumi.getter(name="healthCheckHost")
    def health_check_host(self) -> pulumi.Output[str]:
        """
        The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_host")

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> pulumi.Output[str]:
        """
        The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_http_version")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> pulumi.Output[int]:
        """
        The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> pulumi.Output[str]:
        """
        The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_method")

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> pulumi.Output[str]:
        """
        The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
        """
        return pulumi.get(self, "health_check_path")

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> pulumi.Output[str]:
        """
        The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
        """
        return pulumi.get(self, "health_check_protocol")

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Output[str]:
        """
        The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "health_check_template_name")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[int]:
        """
        The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[int]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[int]:
        """
        The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
        """
        return pulumi.get(self, "unhealthy_threshold")

