# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 listener_port: pulumi.Input[int],
                 listener_protocol: pulumi.Input[str],
                 load_balancer_id: pulumi.Input[str],
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']] = None,
                 acl_config: Optional[pulumi.Input['ListenerAclConfigArgs']] = None,
                 certificates: Optional[pulumi.Input['ListenerCertificatesArgs']] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[bool]] = None,
                 http2_enabled: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 quic_config: Optional[pulumi.Input['ListenerQuicConfigArgs']] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[int] listener_port: The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        :param pulumi.Input[str] listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        :param pulumi.Input[str] load_balancer_id: The ALB Instance Id.
        :param pulumi.Input[bool] access_log_record_customized_headers_enabled: Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
               
               > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        :param pulumi.Input['ListenerAccessLogTracingConfigArgs'] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        :param pulumi.Input['ListenerAclConfigArgs'] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input['ListenerCertificatesArgs'] certificates: The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: The Default Rule Action List. See `default_actions` below for details.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        :param pulumi.Input[bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[int] idle_timeout: Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        :param pulumi.Input[str] listener_description: The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        :param pulumi.Input['ListenerQuicConfigArgs'] quic_config: Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        :param pulumi.Input[int] request_timeout: The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[str] security_policy_id: Security Policy.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[str] status: The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        :param pulumi.Input['ListenerXForwardedForConfigArgs'] x_forwarded_for_config: The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if access_log_record_customized_headers_enabled is not None:
            pulumi.set(__self__, "access_log_record_customized_headers_enabled", access_log_record_customized_headers_enabled)
        if access_log_tracing_config is not None:
            pulumi.set(__self__, "access_log_tracing_config", access_log_tracing_config)
        if acl_config is not None:
            warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
        if acl_config is not None:
            pulumi.set(__self__, "acl_config", acl_config)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if gzip_enabled is not None:
            pulumi.set(__self__, "gzip_enabled", gzip_enabled)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if quic_config is not None:
            pulumi.set(__self__, "quic_config", quic_config)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if x_forwarded_for_config is not None:
            pulumi.set(__self__, "x_forwarded_for_config", x_forwarded_for_config)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[int]:
        """
        The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Input[str]:
        """
        Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The ALB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.

        > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @access_log_record_customized_headers_enabled.setter
    def access_log_record_customized_headers_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_log_record_customized_headers_enabled", value)

    @property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @access_log_tracing_config.setter
    def access_log_tracing_config(self, value: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]):
        pulumi.set(self, "access_log_tracing_config", value)

    @property
    @pulumi.getter(name="aclConfig")
    def acl_config(self) -> Optional[pulumi.Input['ListenerAclConfigArgs']]:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
        pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")

        return pulumi.get(self, "acl_config")

    @acl_config.setter
    def acl_config(self, value: Optional[pulumi.Input['ListenerAclConfigArgs']]):
        pulumi.set(self, "acl_config", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['ListenerCertificatesArgs']]:
        """
        The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['ListenerCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]:
        """
        The Default Rule Action List. See `default_actions` below for details.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        """
        return pulumi.get(self, "gzip_enabled")

    @gzip_enabled.setter
    def gzip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gzip_enabled", value)

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enabled", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_description", value)

    @property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> Optional[pulumi.Input['ListenerQuicConfigArgs']]:
        """
        Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        """
        return pulumi.get(self, "quic_config")

    @quic_config.setter
    def quic_config(self, value: Optional[pulumi.Input['ListenerQuicConfigArgs']]):
        pulumi.set(self, "quic_config", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Security Policy.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]:
        """
        The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "x_forwarded_for_config")

    @x_forwarded_for_config.setter
    def x_forwarded_for_config(self, value: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]):
        pulumi.set(self, "x_forwarded_for_config", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']] = None,
                 acl_config: Optional[pulumi.Input['ListenerAclConfigArgs']] = None,
                 certificates: Optional[pulumi.Input['ListenerCertificatesArgs']] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[bool]] = None,
                 http2_enabled: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 quic_config: Optional[pulumi.Input['ListenerQuicConfigArgs']] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[bool] access_log_record_customized_headers_enabled: Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
               
               > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        :param pulumi.Input['ListenerAccessLogTracingConfigArgs'] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        :param pulumi.Input['ListenerAclConfigArgs'] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input['ListenerCertificatesArgs'] certificates: The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: The Default Rule Action List. See `default_actions` below for details.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        :param pulumi.Input[bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[int] idle_timeout: Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        :param pulumi.Input[str] listener_description: The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        :param pulumi.Input[int] listener_port: The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        :param pulumi.Input[str] listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        :param pulumi.Input[str] load_balancer_id: The ALB Instance Id.
        :param pulumi.Input['ListenerQuicConfigArgs'] quic_config: Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        :param pulumi.Input[int] request_timeout: The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[str] security_policy_id: Security Policy.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[str] status: The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        :param pulumi.Input['ListenerXForwardedForConfigArgs'] x_forwarded_for_config: The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        if access_log_record_customized_headers_enabled is not None:
            pulumi.set(__self__, "access_log_record_customized_headers_enabled", access_log_record_customized_headers_enabled)
        if access_log_tracing_config is not None:
            pulumi.set(__self__, "access_log_tracing_config", access_log_tracing_config)
        if acl_config is not None:
            warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
        if acl_config is not None:
            pulumi.set(__self__, "acl_config", acl_config)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if gzip_enabled is not None:
            pulumi.set(__self__, "gzip_enabled", gzip_enabled)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if quic_config is not None:
            pulumi.set(__self__, "quic_config", quic_config)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if x_forwarded_for_config is not None:
            pulumi.set(__self__, "x_forwarded_for_config", x_forwarded_for_config)

    @property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.

        > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @access_log_record_customized_headers_enabled.setter
    def access_log_record_customized_headers_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_log_record_customized_headers_enabled", value)

    @property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @access_log_tracing_config.setter
    def access_log_tracing_config(self, value: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]):
        pulumi.set(self, "access_log_tracing_config", value)

    @property
    @pulumi.getter(name="aclConfig")
    def acl_config(self) -> Optional[pulumi.Input['ListenerAclConfigArgs']]:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
        pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")

        return pulumi.get(self, "acl_config")

    @acl_config.setter
    def acl_config(self, value: Optional[pulumi.Input['ListenerAclConfigArgs']]):
        pulumi.set(self, "acl_config", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['ListenerCertificatesArgs']]:
        """
        The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['ListenerCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]:
        """
        The Default Rule Action List. See `default_actions` below for details.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        """
        return pulumi.get(self, "gzip_enabled")

    @gzip_enabled.setter
    def gzip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gzip_enabled", value)

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enabled", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_description", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ALB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> Optional[pulumi.Input['ListenerQuicConfigArgs']]:
        """
        Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        """
        return pulumi.get(self, "quic_config")

    @quic_config.setter
    def quic_config(self, value: Optional[pulumi.Input['ListenerQuicConfigArgs']]):
        pulumi.set(self, "quic_config", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Security Policy.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]:
        """
        The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "x_forwarded_for_config")

    @x_forwarded_for_config.setter
    def x_forwarded_for_config(self, value: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]):
        pulumi.set(self, "x_forwarded_for_config", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input[pulumi.InputType['ListenerAccessLogTracingConfigArgs']]] = None,
                 acl_config: Optional[pulumi.Input[pulumi.InputType['ListenerAclConfigArgs']]] = None,
                 certificates: Optional[pulumi.Input[pulumi.InputType['ListenerCertificatesArgs']]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerDefaultActionArgs']]]]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[bool]] = None,
                 http2_enabled: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 quic_config: Optional[pulumi.Input[pulumi.InputType['ListenerQuicConfigArgs']]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerXForwardedForConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Listener resource.

        For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).

        > **NOTE:** Available since v1.133.0.

        ## Import

        Application Load Balancer (ALB) Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_log_record_customized_headers_enabled: Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
               
               > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        :param pulumi.Input[pulumi.InputType['ListenerAccessLogTracingConfigArgs']] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        :param pulumi.Input[pulumi.InputType['ListenerAclConfigArgs']] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[pulumi.InputType['ListenerCertificatesArgs']] certificates: The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerDefaultActionArgs']]]] default_actions: The Default Rule Action List. See `default_actions` below for details.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        :param pulumi.Input[bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[int] idle_timeout: Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        :param pulumi.Input[str] listener_description: The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        :param pulumi.Input[int] listener_port: The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        :param pulumi.Input[str] listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        :param pulumi.Input[str] load_balancer_id: The ALB Instance Id.
        :param pulumi.Input[pulumi.InputType['ListenerQuicConfigArgs']] quic_config: Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        :param pulumi.Input[int] request_timeout: The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[str] security_policy_id: Security Policy.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[str] status: The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        :param pulumi.Input[pulumi.InputType['ListenerXForwardedForConfigArgs']] x_forwarded_for_config: The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Listener resource.

        For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).

        > **NOTE:** Available since v1.133.0.

        ## Import

        Application Load Balancer (ALB) Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input[pulumi.InputType['ListenerAccessLogTracingConfigArgs']]] = None,
                 acl_config: Optional[pulumi.Input[pulumi.InputType['ListenerAclConfigArgs']]] = None,
                 certificates: Optional[pulumi.Input[pulumi.InputType['ListenerCertificatesArgs']]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerDefaultActionArgs']]]]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[bool]] = None,
                 http2_enabled: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 quic_config: Optional[pulumi.Input[pulumi.InputType['ListenerQuicConfigArgs']]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerXForwardedForConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["access_log_record_customized_headers_enabled"] = access_log_record_customized_headers_enabled
            __props__.__dict__["access_log_tracing_config"] = access_log_tracing_config
            __props__.__dict__["acl_config"] = acl_config
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["default_actions"] = default_actions
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["gzip_enabled"] = gzip_enabled
            __props__.__dict__["http2_enabled"] = http2_enabled
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["listener_description"] = listener_description
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            if listener_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'listener_protocol'")
            __props__.__dict__["listener_protocol"] = listener_protocol
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["quic_config"] = quic_config
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["status"] = status
            __props__.__dict__["x_forwarded_for_config"] = x_forwarded_for_config
        super(Listener, __self__).__init__(
            'alicloud:alb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_log_record_customized_headers_enabled: Optional[pulumi.Input[bool]] = None,
            access_log_tracing_config: Optional[pulumi.Input[pulumi.InputType['ListenerAccessLogTracingConfigArgs']]] = None,
            acl_config: Optional[pulumi.Input[pulumi.InputType['ListenerAclConfigArgs']]] = None,
            certificates: Optional[pulumi.Input[pulumi.InputType['ListenerCertificatesArgs']]] = None,
            default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerDefaultActionArgs']]]]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            gzip_enabled: Optional[pulumi.Input[bool]] = None,
            http2_enabled: Optional[pulumi.Input[bool]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            listener_description: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[int]] = None,
            listener_protocol: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            quic_config: Optional[pulumi.Input[pulumi.InputType['ListenerQuicConfigArgs']]] = None,
            request_timeout: Optional[pulumi.Input[int]] = None,
            security_policy_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            x_forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerXForwardedForConfigArgs']]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] access_log_record_customized_headers_enabled: Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
               
               > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        :param pulumi.Input[pulumi.InputType['ListenerAccessLogTracingConfigArgs']] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        :param pulumi.Input[pulumi.InputType['ListenerAclConfigArgs']] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[pulumi.InputType['ListenerCertificatesArgs']] certificates: The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerDefaultActionArgs']]]] default_actions: The Default Rule Action List. See `default_actions` below for details.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        :param pulumi.Input[bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[int] idle_timeout: Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        :param pulumi.Input[str] listener_description: The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        :param pulumi.Input[int] listener_port: The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        :param pulumi.Input[str] listener_protocol: Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        :param pulumi.Input[str] load_balancer_id: The ALB Instance Id.
        :param pulumi.Input[pulumi.InputType['ListenerQuicConfigArgs']] quic_config: Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        :param pulumi.Input[int] request_timeout: The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[str] security_policy_id: Security Policy.
               
               > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        :param pulumi.Input[str] status: The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        :param pulumi.Input[pulumi.InputType['ListenerXForwardedForConfigArgs']] x_forwarded_for_config: The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["access_log_record_customized_headers_enabled"] = access_log_record_customized_headers_enabled
        __props__.__dict__["access_log_tracing_config"] = access_log_tracing_config
        __props__.__dict__["acl_config"] = acl_config
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["default_actions"] = default_actions
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["gzip_enabled"] = gzip_enabled
        __props__.__dict__["http2_enabled"] = http2_enabled
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["listener_description"] = listener_description
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_protocol"] = listener_protocol
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["quic_config"] = quic_config
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["status"] = status
        __props__.__dict__["x_forwarded_for_config"] = x_forwarded_for_config
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.

        > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> pulumi.Output[Optional['outputs.ListenerAccessLogTracingConfig']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below for details.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @property
    @pulumi.getter(name="aclConfig")
    def acl_config(self) -> pulumi.Output['outputs.ListenerAclConfig']:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
        pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")

        return pulumi.get(self, "acl_config")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional['outputs.ListenerCertificates']]:
        """
        The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ListenerDefaultAction']]]:
        """
        The Default Rule Action List. See `default_actions` below for details.
        """
        return pulumi.get(self, "default_actions")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
        """
        return pulumi.get(self, "gzip_enabled")

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "http2_enabled")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[int]:
        """
        Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\\x00-\\xff]|[\\w.,;/@-]){2,256}$/`.
        """
        return pulumi.get(self, "listener_description")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[int]:
        """
        The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Output[str]:
        """
        Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
        """
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The ALB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> pulumi.Output['outputs.ListenerQuicConfig']:
        """
        Configuration Associated with the QuIC Listening. See `quic_config` below for details.
        """
        return pulumi.get(self, "quic_config")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[int]:
        """
        The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[str]:
        """
        Security Policy.

        > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> pulumi.Output['outputs.ListenerXForwardedForConfig']:
        """
        The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
        """
        return pulumi.get(self, "x_forwarded_for_config")

