# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerGroupArgs', 'ServerGroup']

@pulumi.input_type
class ServerGroupArgs:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_config: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServerGroup resource.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: The configuration of health checks. See `health_check_config` below for details.
        :param pulumi.Input[str] protocol: The server protocol. Valid values: ` HTTPS`, `HTTP`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        :param pulumi.Input[str] server_group_name: The name of the resource.
        :param pulumi.Input[str] server_group_type: The type of the server group. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: The backend server. See `servers` below for details.
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The configuration of the sticky session. See `sticky_session_config` below for details.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC that you want to access.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]:
        """
        The configuration of health checks. See `health_check_config` below for details.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The server protocol. Valid values: ` HTTPS`, `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server group. Valid values:
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_type", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        The backend server. See `servers` below for details.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The configuration of the sticky session. See `sticky_session_config` below for details.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC that you want to access.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _ServerGroupState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_config: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerGroup resources.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input['ServerGroupHealthCheckConfigArgs'] health_check_config: The configuration of health checks. See `health_check_config` below for details.
        :param pulumi.Input[str] protocol: The server protocol. Valid values: ` HTTPS`, `HTTP`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        :param pulumi.Input[str] server_group_name: The name of the resource.
        :param pulumi.Input[str] server_group_type: The type of the server group. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]] servers: The backend server. See `servers` below for details.
        :param pulumi.Input[str] status: The status of the backend server. Valid values:
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The configuration of the sticky session. See `sticky_session_config` below for details.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC that you want to access.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]:
        """
        The configuration of health checks. See `health_check_config` below for details.
        """
        return pulumi.get(self, "health_check_config")

    @health_check_config.setter
    def health_check_config(self, value: Optional[pulumi.Input['ServerGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check_config", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The server protocol. Valid values: ` HTTPS`, `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server group. Valid values:
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_type", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]:
        """
        The backend server. See `servers` below for details.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerGroupServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the backend server. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The configuration of the sticky session. See `sticky_session_config` below for details.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC that you want to access.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class ServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckConfigArgs']]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerGroupServerArgs']]]]] = None,
                 sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ALB Server Group resource.

        For information about ALB Server Group and how to use it,
        see [What is Server Group](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createservergroup).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example_zones = alicloud.get_zones(available_resource_creation="Instance")
        example_instance_types = alicloud.ecs.get_instance_types(availability_zone=example_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        example_resource_groups = alicloud.resourcemanager.get_resource_groups()
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup",
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("exampleInstance",
            availability_zone=example_zones.zones[0].id,
            instance_name=name,
            image_id=example_images.images[0].id,
            instance_type=example_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id)
        example_server_group = alicloud.alb.ServerGroup("exampleServerGroup",
            protocol="HTTP",
            vpc_id=example_network.id,
            server_group_name=name,
            resource_group_id=example_resource_groups.groups[0].id,
            health_check_config=alicloud.alb.ServerGroupHealthCheckConfigArgs(
                health_check_connect_port=46325,
                health_check_enabled=True,
                health_check_host="tf-example.com",
                health_check_codes=[
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                health_check_http_version="HTTP1.1",
                health_check_interval=2,
                health_check_method="HEAD",
                health_check_path="/tf-example",
                health_check_protocol="HTTP",
                health_check_timeout=5,
                healthy_threshold=3,
                unhealthy_threshold=3,
            ),
            sticky_session_config=alicloud.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled=True,
                cookie="tf-example",
                sticky_session_type="Server",
            ),
            tags={
                "Created": "TF",
            },
            servers=[alicloud.alb.ServerGroupServerArgs(
                description=name,
                port=80,
                server_id=example_instance.id,
                server_ip=example_instance.private_ip,
                server_type="Ecs",
                weight=10,
            )])
        ```

        ## Import

        ALB Server Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[pulumi.InputType['ServerGroupHealthCheckConfigArgs']] health_check_config: The configuration of health checks. See `health_check_config` below for details.
        :param pulumi.Input[str] protocol: The server protocol. Valid values: ` HTTPS`, `HTTP`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        :param pulumi.Input[str] server_group_name: The name of the resource.
        :param pulumi.Input[str] server_group_type: The type of the server group. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerGroupServerArgs']]]] servers: The backend server. See `servers` below for details.
        :param pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']] sticky_session_config: The configuration of the sticky session. See `sticky_session_config` below for details.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC that you want to access.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ALB Server Group resource.

        For information about ALB Server Group and how to use it,
        see [What is Server Group](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createservergroup).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example_zones = alicloud.get_zones(available_resource_creation="Instance")
        example_instance_types = alicloud.ecs.get_instance_types(availability_zone=example_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        example_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        example_resource_groups = alicloud.resourcemanager.get_resource_groups()
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup",
            description=name,
            vpc_id=example_network.id)
        example_instance = alicloud.ecs.Instance("exampleInstance",
            availability_zone=example_zones.zones[0].id,
            instance_name=name,
            image_id=example_images.images[0].id,
            instance_type=example_instance_types.instance_types[0].id,
            security_groups=[example_security_group.id],
            vswitch_id=example_switch.id)
        example_server_group = alicloud.alb.ServerGroup("exampleServerGroup",
            protocol="HTTP",
            vpc_id=example_network.id,
            server_group_name=name,
            resource_group_id=example_resource_groups.groups[0].id,
            health_check_config=alicloud.alb.ServerGroupHealthCheckConfigArgs(
                health_check_connect_port=46325,
                health_check_enabled=True,
                health_check_host="tf-example.com",
                health_check_codes=[
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                health_check_http_version="HTTP1.1",
                health_check_interval=2,
                health_check_method="HEAD",
                health_check_path="/tf-example",
                health_check_protocol="HTTP",
                health_check_timeout=5,
                healthy_threshold=3,
                unhealthy_threshold=3,
            ),
            sticky_session_config=alicloud.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled=True,
                cookie="tf-example",
                sticky_session_type="Server",
            ),
            tags={
                "Created": "TF",
            },
            servers=[alicloud.alb.ServerGroupServerArgs(
                description=name,
                port=80,
                server_id=example_instance.id,
                server_ip=example_instance.private_ip,
                server_type="Ecs",
                weight=10,
            )])
        ```

        ## Import

        ALB Server Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alb/serverGroup:ServerGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 health_check_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckConfigArgs']]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerGroupServerArgs']]]]] = None,
                 sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerGroupArgs.__new__(ServerGroupArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["health_check_config"] = health_check_config
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scheduler"] = scheduler
            __props__.__dict__["server_group_name"] = server_group_name
            __props__.__dict__["server_group_type"] = server_group_type
            __props__.__dict__["servers"] = servers
            __props__.__dict__["sticky_session_config"] = sticky_session_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["status"] = None
        super(ServerGroup, __self__).__init__(
            'alicloud:alb/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            health_check_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckConfigArgs']]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            scheduler: Optional[pulumi.Input[str]] = None,
            server_group_name: Optional[pulumi.Input[str]] = None,
            server_group_type: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerGroupServerArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'ServerGroup':
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: The dry run.
        :param pulumi.Input[pulumi.InputType['ServerGroupHealthCheckConfigArgs']] health_check_config: The configuration of health checks. See `health_check_config` below for details.
        :param pulumi.Input[str] protocol: The server protocol. Valid values: ` HTTPS`, `HTTP`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        :param pulumi.Input[str] server_group_name: The name of the resource.
        :param pulumi.Input[str] server_group_type: The type of the server group. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerGroupServerArgs']]]] servers: The backend server. See `servers` below for details.
        :param pulumi.Input[str] status: The status of the backend server. Valid values:
        :param pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']] sticky_session_config: The configuration of the sticky session. See `sticky_session_config` below for details.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC that you want to access.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerGroupState.__new__(_ServerGroupState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["health_check_config"] = health_check_config
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_group_name"] = server_group_name
        __props__.__dict__["server_group_type"] = server_group_type
        __props__.__dict__["servers"] = servers
        __props__.__dict__["status"] = status
        __props__.__dict__["sticky_session_config"] = sticky_session_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return ServerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> pulumi.Output[Optional['outputs.ServerGroupHealthCheckConfig']]:
        """
        The configuration of health checks. See `health_check_config` below for details.
        """
        return pulumi.get(self, "health_check_config")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The server protocol. Valid values: ` HTTPS`, `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[str]:
        """
        The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "server_group_name")

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> pulumi.Output[str]:
        """
        The type of the server group. Valid values:
        """
        return pulumi.get(self, "server_group_type")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.ServerGroupServer']]]:
        """
        The backend server. See `servers` below for details.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the backend server. Valid values:
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> pulumi.Output[Optional['outputs.ServerGroupStickySessionConfig']]:
        """
        The configuration of the sticky session. See `sticky_session_config` below for details.
        """
        return pulumi.get(self, "sticky_session_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the VPC that you want to access.
        """
        return pulumi.get(self, "vpc_id")

