# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 deploy_type: pulumi.Input[int],
                 disk_size: pulumi.Input[int],
                 disk_type: pulumi.Input[int],
                 vswitch_id: pulumi.Input[str],
                 config: Optional[pulumi.Input[str]] = None,
                 eip_max: Optional[pulumi.Input[int]] = None,
                 io_max: Optional[pulumi.Input[int]] = None,
                 io_max_spec: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paid_type: Optional[pulumi.Input[str]] = None,
                 partition_num: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_version: Optional[pulumi.Input[str]] = None,
                 spec_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 topic_quota: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
               - 4: eip/vpc instance
               - 5: vpc instance.
        :param pulumi.Input[int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] disk_type: The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        :param pulumi.Input[str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[str] config: The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        :param pulumi.Input[int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[str] paid_type: The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        :param pulumi.Input[int] partition_num: The number of partitions.
        :param pulumi.Input[str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_zones: The zones among which you want to deploy the instance.
               
               > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
               
               | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
               |------|-------------|:----:|:-----:|
               |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
               |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
               |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
               |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
               |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        :param pulumi.Input[str] service_version: The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        :param pulumi.Input[str] spec_type: The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "deploy_type", deploy_type)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if eip_max is not None:
            pulumi.set(__self__, "eip_max", eip_max)
        if io_max is not None:
            pulumi.set(__self__, "io_max", io_max)
        if io_max_spec is not None:
            pulumi.set(__self__, "io_max_spec", io_max_spec)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paid_type is not None:
            pulumi.set(__self__, "paid_type", paid_type)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if selected_zones is not None:
            pulumi.set(__self__, "selected_zones", selected_zones)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_quota is not None:
            warnings.warn("""Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""", DeprecationWarning)
            pulumi.log.warn("""topic_quota is deprecated: Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""")
        if topic_quota is not None:
            pulumi.set(__self__, "topic_quota", topic_quota)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> pulumi.Input[int]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        - 4: eip/vpc instance
        - 5: vpc instance.
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "deploy_type", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Input[int]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Input[int]:
        """
        The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> Optional[pulumi.Input[int]]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @eip_max.setter
    def eip_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_max", value)

    @property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> Optional[pulumi.Input[int]]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @io_max.setter
    def io_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "io_max", value)

    @property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @io_max_spec.setter
    def io_max_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_max_spec", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> Optional[pulumi.Input[str]]:
        """
        The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        """
        return pulumi.get(self, "paid_type")

    @paid_type.setter
    def paid_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "paid_type", value)

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_num", value)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group", value)

    @property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones among which you want to deploy the instance.

        > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.

        | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
        |------|-------------|:----:|:-----:|
        |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
        |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
        |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
        |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
        |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        """
        return pulumi.get(self, "selected_zones")

    @selected_zones.setter
    def selected_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_zones", value)

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[str]]:
        """
        The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_version", value)

    @property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[str]]:
        """
        The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicQuota")
    def topic_quota(self) -> Optional[pulumi.Input[int]]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        warnings.warn("""Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""", DeprecationWarning)
        pulumi.log.warn("""topic_quota is deprecated: Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""")

        return pulumi.get(self, "topic_quota")

    @topic_quota.setter
    def topic_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "topic_quota", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[str]] = None,
                 deploy_type: Optional[pulumi.Input[int]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[int]] = None,
                 eip_max: Optional[pulumi.Input[int]] = None,
                 end_point: Optional[pulumi.Input[str]] = None,
                 io_max: Optional[pulumi.Input[int]] = None,
                 io_max_spec: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paid_type: Optional[pulumi.Input[str]] = None,
                 partition_num: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_version: Optional[pulumi.Input[str]] = None,
                 spec_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 topic_quota: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] config: The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        :param pulumi.Input[int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
               - 4: eip/vpc instance
               - 5: vpc instance.
        :param pulumi.Input[int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] disk_type: The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        :param pulumi.Input[int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[str] end_point: The EndPoint to access the kafka instance.
        :param pulumi.Input[int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[str] paid_type: The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        :param pulumi.Input[int] partition_num: The number of partitions.
        :param pulumi.Input[str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_zones: The zones among which you want to deploy the instance.
               
               > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
               
               | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
               |------|-------------|:----:|:-----:|
               |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
               |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
               |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
               |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
               |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        :param pulumi.Input[str] service_version: The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        :param pulumi.Input[str] spec_type: The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        :param pulumi.Input[int] status: The status of the instance. Valid values:
               - 0: pending
               - 1: deploying
               - 5: running
               - 15: expired
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if deploy_type is not None:
            pulumi.set(__self__, "deploy_type", deploy_type)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if eip_max is not None:
            pulumi.set(__self__, "eip_max", eip_max)
        if end_point is not None:
            pulumi.set(__self__, "end_point", end_point)
        if io_max is not None:
            pulumi.set(__self__, "io_max", io_max)
        if io_max_spec is not None:
            pulumi.set(__self__, "io_max_spec", io_max_spec)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paid_type is not None:
            pulumi.set(__self__, "paid_type", paid_type)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if selected_zones is not None:
            pulumi.set(__self__, "selected_zones", selected_zones)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_quota is not None:
            warnings.warn("""Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""", DeprecationWarning)
            pulumi.log.warn("""topic_quota is deprecated: Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""")
        if topic_quota is not None:
            pulumi.set(__self__, "topic_quota", topic_quota)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> Optional[pulumi.Input[int]]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        - 4: eip/vpc instance
        - 5: vpc instance.
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deploy_type", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[int]]:
        """
        The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> Optional[pulumi.Input[int]]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @eip_max.setter
    def eip_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_max", value)

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> Optional[pulumi.Input[str]]:
        """
        The EndPoint to access the kafka instance.
        """
        return pulumi.get(self, "end_point")

    @end_point.setter
    def end_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_point", value)

    @property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> Optional[pulumi.Input[int]]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @io_max.setter
    def io_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "io_max", value)

    @property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @io_max_spec.setter
    def io_max_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_max_spec", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> Optional[pulumi.Input[str]]:
        """
        The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        """
        return pulumi.get(self, "paid_type")

    @paid_type.setter
    def paid_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "paid_type", value)

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_num", value)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group", value)

    @property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones among which you want to deploy the instance.

        > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.

        | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
        |------|-------------|:----:|:-----:|
        |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
        |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
        |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
        |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
        |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        """
        return pulumi.get(self, "selected_zones")

    @selected_zones.setter
    def selected_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selected_zones", value)

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[str]]:
        """
        The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_version", value)

    @property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[str]]:
        """
        The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of the instance. Valid values:
        - 0: pending
        - 1: deploying
        - 5: running
        - 15: expired
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicQuota")
    def topic_quota(self) -> Optional[pulumi.Input[int]]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        warnings.warn("""Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""", DeprecationWarning)
        pulumi.log.warn("""topic_quota is deprecated: Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""")

        return pulumi.get(self, "topic_quota")

    @topic_quota.setter
    def topic_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "topic_quota", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 deploy_type: Optional[pulumi.Input[int]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[int]] = None,
                 eip_max: Optional[pulumi.Input[int]] = None,
                 io_max: Optional[pulumi.Input[int]] = None,
                 io_max_spec: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paid_type: Optional[pulumi.Input[str]] = None,
                 partition_num: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_version: Optional[pulumi.Input[str]] = None,
                 spec_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 topic_quota: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        ALIKAFKA instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alikafka/instance:Instance instance alikafka_post-cn-123455abc
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        :param pulumi.Input[int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
               - 4: eip/vpc instance
               - 5: vpc instance.
        :param pulumi.Input[int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] disk_type: The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        :param pulumi.Input[int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[str] paid_type: The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        :param pulumi.Input[int] partition_num: The number of partitions.
        :param pulumi.Input[str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_zones: The zones among which you want to deploy the instance.
               
               > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
               
               | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
               |------|-------------|:----:|:-----:|
               |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
               |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
               |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
               |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
               |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        :param pulumi.Input[str] service_version: The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        :param pulumi.Input[str] spec_type: The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ALIKAFKA instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:alikafka/instance:Instance instance alikafka_post-cn-123455abc
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 deploy_type: Optional[pulumi.Input[int]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[int]] = None,
                 eip_max: Optional[pulumi.Input[int]] = None,
                 io_max: Optional[pulumi.Input[int]] = None,
                 io_max_spec: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paid_type: Optional[pulumi.Input[str]] = None,
                 partition_num: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_version: Optional[pulumi.Input[str]] = None,
                 spec_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 topic_quota: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["config"] = config
            if deploy_type is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_type'")
            __props__.__dict__["deploy_type"] = deploy_type
            if disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size'")
            __props__.__dict__["disk_size"] = disk_size
            if disk_type is None and not opts.urn:
                raise TypeError("Missing required property 'disk_type'")
            __props__.__dict__["disk_type"] = disk_type
            __props__.__dict__["eip_max"] = eip_max
            __props__.__dict__["io_max"] = io_max
            __props__.__dict__["io_max_spec"] = io_max_spec
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["paid_type"] = paid_type
            __props__.__dict__["partition_num"] = partition_num
            __props__.__dict__["security_group"] = security_group
            __props__.__dict__["selected_zones"] = selected_zones
            __props__.__dict__["service_version"] = service_version
            __props__.__dict__["spec_type"] = spec_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topic_quota"] = topic_quota
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["end_point"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:alikafka/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[str]] = None,
            deploy_type: Optional[pulumi.Input[int]] = None,
            disk_size: Optional[pulumi.Input[int]] = None,
            disk_type: Optional[pulumi.Input[int]] = None,
            eip_max: Optional[pulumi.Input[int]] = None,
            end_point: Optional[pulumi.Input[str]] = None,
            io_max: Optional[pulumi.Input[int]] = None,
            io_max_spec: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            paid_type: Optional[pulumi.Input[str]] = None,
            partition_num: Optional[pulumi.Input[int]] = None,
            security_group: Optional[pulumi.Input[str]] = None,
            selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_version: Optional[pulumi.Input[str]] = None,
            spec_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            topic_quota: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        :param pulumi.Input[int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
               - 4: eip/vpc instance
               - 5: vpc instance.
        :param pulumi.Input[int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[int] disk_type: The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        :param pulumi.Input[int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[str] end_point: The EndPoint to access the kafka instance.
        :param pulumi.Input[int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[str] paid_type: The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        :param pulumi.Input[int] partition_num: The number of partitions.
        :param pulumi.Input[str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selected_zones: The zones among which you want to deploy the instance.
               
               > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.
               
               | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
               |------|-------------|:----:|:-----:|
               |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
               |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
               |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
               |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
               |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        :param pulumi.Input[str] service_version: The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        :param pulumi.Input[str] spec_type: The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        :param pulumi.Input[int] status: The status of the instance. Valid values:
               - 0: pending
               - 1: deploying
               - 5: running
               - 15: expired
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["config"] = config
        __props__.__dict__["deploy_type"] = deploy_type
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["eip_max"] = eip_max
        __props__.__dict__["end_point"] = end_point
        __props__.__dict__["io_max"] = io_max
        __props__.__dict__["io_max_spec"] = io_max_spec
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["paid_type"] = paid_type
        __props__.__dict__["partition_num"] = partition_num
        __props__.__dict__["security_group"] = security_group
        __props__.__dict__["selected_zones"] = selected_zones
        __props__.__dict__["service_version"] = service_version
        __props__.__dict__["spec_type"] = spec_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_quota"] = topic_quota
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[str]:
        """
        The basic config for this instance. The input should be json type, only the following key allowed: enable.acl, enable.vpc_sasl_ssl, kafka.log.retention.hours, kafka.message.max.bytes.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> pulumi.Output[int]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        - 4: eip/vpc instance
        - 5: vpc instance.
        """
        return pulumi.get(self, "deploy_type")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[int]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[int]:
        """
        The disk type of the instance. 0: efficient cloud disk , 1: SSD.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> pulumi.Output[int]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> pulumi.Output[str]:
        """
        The EndPoint to access the kafka instance.
        """
        return pulumi.get(self, "end_point")

    @property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> pulumi.Output[int]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> pulumi.Output[str]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> pulumi.Output[Optional[str]]:
        """
        The paid type of the instance. Support two type, "PrePaid": pre paid type instance, "PostPaid": post paid type instance. Default is PostPaid. When modify this value, it only support adjust from post pay to pre pay.
        """
        return pulumi.get(self, "paid_type")

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> pulumi.Output[Optional[int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output[str]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The zones among which you want to deploy the instance.

        > **NOTE:** Arguments io_max, disk_size, topic_quota, eip_max should follow the following constraints.

        | io_max | disk_size(min-max:lag) | topic_quota(min-max:lag) | eip_max(min-max:lag) |
        |------|-------------|:----:|:-----:|
        |20          |  500-6100:100   |   50-450:1  |    1-160:1  |
        |30          |  800-6100:100   |   50-450:1  |    1-240:1  |
        |60          |  1400-6100:100  |   80-450:1  |    1-500:1  |
        |90          |  2100-6100:100  |   100-450:1 |    1-500:1  |
        |120         |  2700-6100:100  |   150-450:1 |    1-500:1  |
        """
        return pulumi.get(self, "selected_zones")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> pulumi.Output[str]:
        """
        The kafka openSource version for this instance. Only 0.10.2 or 2.2.0 is allowed, default is 0.10.2.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter(name="specType")
    def spec_type(self) -> pulumi.Output[Optional[str]]:
        """
        The spec type of the instance. Support two type, "normal": normal version instance, "professional": professional version instance. Default is normal. When modify this value, it only support adjust from normal to professional. Note only pre paid type instance support professional specific type.
        """
        return pulumi.get(self, "spec_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status of the instance. Valid values:
        - 0: pending
        - 1: deploying
        - 5: running
        - 15: expired
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicQuota")
    def topic_quota(self) -> pulumi.Output[int]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        warnings.warn("""Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""", DeprecationWarning)
        pulumi.log.warn("""topic_quota is deprecated: Attribute 'topic_quota' has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute 'partition_num' instead.""")

        return pulumi.get(self, "topic_quota")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

