# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 description: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 request_config: pulumi.Input['ApiRequestConfigArgs'],
                 service_type: pulumi.Input[str],
                 constant_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]] = None,
                 fc_service_config: Optional[pulumi.Input['ApiFcServiceConfigArgs']] = None,
                 force_nonce_check: Optional[pulumi.Input[bool]] = None,
                 http_service_config: Optional[pulumi.Input['ApiHttpServiceConfigArgs']] = None,
                 http_vpc_service_config: Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']] = None,
                 mock_service_config: Optional[pulumi.Input['ApiMockServiceConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]] = None,
                 stage_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[str] auth_type: The authorization Type including APP and ANONYMOUS. Defaults to null.
        :param pulumi.Input[str] description: The description of the api. Defaults to null.
        :param pulumi.Input[str] group_id: The api gateway that the api belongs to. Defaults to null.
        :param pulumi.Input['ApiRequestConfigArgs'] request_config: Request_config defines how users can send requests to your API. See `request_config` below.
        :param pulumi.Input[str] service_type: The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]] constant_parameters: constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        :param pulumi.Input['ApiFcServiceConfigArgs'] fc_service_config: fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        :param pulumi.Input[bool] force_nonce_check: Whether to prevent API replay attack. Default value: `false`.
        :param pulumi.Input['ApiHttpServiceConfigArgs'] http_service_config: http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        :param pulumi.Input['ApiHttpVpcServiceConfigArgs'] http_vpc_service_config: http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        :param pulumi.Input['ApiMockServiceConfigArgs'] mock_service_config: http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        :param pulumi.Input[str] name: The name of the api gateway api. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]] request_parameters: request_parameters defines the request parameters of the api. See `request_parameters` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stage_names: Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        :param pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]] system_parameters: system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "request_config", request_config)
        pulumi.set(__self__, "service_type", service_type)
        if constant_parameters is not None:
            pulumi.set(__self__, "constant_parameters", constant_parameters)
        if fc_service_config is not None:
            pulumi.set(__self__, "fc_service_config", fc_service_config)
        if force_nonce_check is not None:
            pulumi.set(__self__, "force_nonce_check", force_nonce_check)
        if http_service_config is not None:
            pulumi.set(__self__, "http_service_config", http_service_config)
        if http_vpc_service_config is not None:
            pulumi.set(__self__, "http_vpc_service_config", http_vpc_service_config)
        if mock_service_config is not None:
            pulumi.set(__self__, "mock_service_config", mock_service_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if stage_names is not None:
            pulumi.set(__self__, "stage_names", stage_names)
        if system_parameters is not None:
            pulumi.set(__self__, "system_parameters", system_parameters)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authorization Type including APP and ANONYMOUS. Defaults to null.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the api. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        The api gateway that the api belongs to. Defaults to null.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="requestConfig")
    def request_config(self) -> pulumi.Input['ApiRequestConfigArgs']:
        """
        Request_config defines how users can send requests to your API. See `request_config` below.
        """
        return pulumi.get(self, "request_config")

    @request_config.setter
    def request_config(self, value: pulumi.Input['ApiRequestConfigArgs']):
        pulumi.set(self, "request_config", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[str]:
        """
        The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="constantParameters")
    def constant_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]]:
        """
        constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        """
        return pulumi.get(self, "constant_parameters")

    @constant_parameters.setter
    def constant_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]]):
        pulumi.set(self, "constant_parameters", value)

    @property
    @pulumi.getter(name="fcServiceConfig")
    def fc_service_config(self) -> Optional[pulumi.Input['ApiFcServiceConfigArgs']]:
        """
        fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        """
        return pulumi.get(self, "fc_service_config")

    @fc_service_config.setter
    def fc_service_config(self, value: Optional[pulumi.Input['ApiFcServiceConfigArgs']]):
        pulumi.set(self, "fc_service_config", value)

    @property
    @pulumi.getter(name="forceNonceCheck")
    def force_nonce_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to prevent API replay attack. Default value: `false`.
        """
        return pulumi.get(self, "force_nonce_check")

    @force_nonce_check.setter
    def force_nonce_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_nonce_check", value)

    @property
    @pulumi.getter(name="httpServiceConfig")
    def http_service_config(self) -> Optional[pulumi.Input['ApiHttpServiceConfigArgs']]:
        """
        http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        """
        return pulumi.get(self, "http_service_config")

    @http_service_config.setter
    def http_service_config(self, value: Optional[pulumi.Input['ApiHttpServiceConfigArgs']]):
        pulumi.set(self, "http_service_config", value)

    @property
    @pulumi.getter(name="httpVpcServiceConfig")
    def http_vpc_service_config(self) -> Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']]:
        """
        http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        """
        return pulumi.get(self, "http_vpc_service_config")

    @http_vpc_service_config.setter
    def http_vpc_service_config(self, value: Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']]):
        pulumi.set(self, "http_vpc_service_config", value)

    @property
    @pulumi.getter(name="mockServiceConfig")
    def mock_service_config(self) -> Optional[pulumi.Input['ApiMockServiceConfigArgs']]:
        """
        http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        """
        return pulumi.get(self, "mock_service_config")

    @mock_service_config.setter
    def mock_service_config(self, value: Optional[pulumi.Input['ApiMockServiceConfigArgs']]):
        pulumi.set(self, "mock_service_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the api gateway api. Defaults to null.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]:
        """
        request_parameters defines the request parameters of the api. See `request_parameters` below.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="stageNames")
    def stage_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        """
        return pulumi.get(self, "stage_names")

    @stage_names.setter
    def stage_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "stage_names", value)

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]]:
        """
        system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        return pulumi.get(self, "system_parameters")

    @system_parameters.setter
    def system_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]]):
        pulumi.set(self, "system_parameters", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 constant_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fc_service_config: Optional[pulumi.Input['ApiFcServiceConfigArgs']] = None,
                 force_nonce_check: Optional[pulumi.Input[bool]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 http_service_config: Optional[pulumi.Input['ApiHttpServiceConfigArgs']] = None,
                 http_vpc_service_config: Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']] = None,
                 mock_service_config: Optional[pulumi.Input['ApiMockServiceConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_config: Optional[pulumi.Input['ApiRequestConfigArgs']] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 stage_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[str] api_id: The ID of the api of api gateway.
        :param pulumi.Input[str] auth_type: The authorization Type including APP and ANONYMOUS. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]] constant_parameters: constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        :param pulumi.Input[str] description: The description of the api. Defaults to null.
        :param pulumi.Input['ApiFcServiceConfigArgs'] fc_service_config: fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        :param pulumi.Input[bool] force_nonce_check: Whether to prevent API replay attack. Default value: `false`.
        :param pulumi.Input[str] group_id: The api gateway that the api belongs to. Defaults to null.
        :param pulumi.Input['ApiHttpServiceConfigArgs'] http_service_config: http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        :param pulumi.Input['ApiHttpVpcServiceConfigArgs'] http_vpc_service_config: http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        :param pulumi.Input['ApiMockServiceConfigArgs'] mock_service_config: http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        :param pulumi.Input[str] name: The name of the api gateway api. Defaults to null.
        :param pulumi.Input['ApiRequestConfigArgs'] request_config: Request_config defines how users can send requests to your API. See `request_config` below.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]] request_parameters: request_parameters defines the request parameters of the api. See `request_parameters` below.
        :param pulumi.Input[str] service_type: The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stage_names: Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        :param pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]] system_parameters: system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if constant_parameters is not None:
            pulumi.set(__self__, "constant_parameters", constant_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fc_service_config is not None:
            pulumi.set(__self__, "fc_service_config", fc_service_config)
        if force_nonce_check is not None:
            pulumi.set(__self__, "force_nonce_check", force_nonce_check)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if http_service_config is not None:
            pulumi.set(__self__, "http_service_config", http_service_config)
        if http_vpc_service_config is not None:
            pulumi.set(__self__, "http_vpc_service_config", http_vpc_service_config)
        if mock_service_config is not None:
            pulumi.set(__self__, "mock_service_config", mock_service_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_config is not None:
            pulumi.set(__self__, "request_config", request_config)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if stage_names is not None:
            pulumi.set(__self__, "stage_names", stage_names)
        if system_parameters is not None:
            pulumi.set(__self__, "system_parameters", system_parameters)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the api of api gateway.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization Type including APP and ANONYMOUS. Defaults to null.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="constantParameters")
    def constant_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]]:
        """
        constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        """
        return pulumi.get(self, "constant_parameters")

    @constant_parameters.setter
    def constant_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiConstantParameterArgs']]]]):
        pulumi.set(self, "constant_parameters", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the api. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fcServiceConfig")
    def fc_service_config(self) -> Optional[pulumi.Input['ApiFcServiceConfigArgs']]:
        """
        fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        """
        return pulumi.get(self, "fc_service_config")

    @fc_service_config.setter
    def fc_service_config(self, value: Optional[pulumi.Input['ApiFcServiceConfigArgs']]):
        pulumi.set(self, "fc_service_config", value)

    @property
    @pulumi.getter(name="forceNonceCheck")
    def force_nonce_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to prevent API replay attack. Default value: `false`.
        """
        return pulumi.get(self, "force_nonce_check")

    @force_nonce_check.setter
    def force_nonce_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_nonce_check", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The api gateway that the api belongs to. Defaults to null.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="httpServiceConfig")
    def http_service_config(self) -> Optional[pulumi.Input['ApiHttpServiceConfigArgs']]:
        """
        http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        """
        return pulumi.get(self, "http_service_config")

    @http_service_config.setter
    def http_service_config(self, value: Optional[pulumi.Input['ApiHttpServiceConfigArgs']]):
        pulumi.set(self, "http_service_config", value)

    @property
    @pulumi.getter(name="httpVpcServiceConfig")
    def http_vpc_service_config(self) -> Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']]:
        """
        http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        """
        return pulumi.get(self, "http_vpc_service_config")

    @http_vpc_service_config.setter
    def http_vpc_service_config(self, value: Optional[pulumi.Input['ApiHttpVpcServiceConfigArgs']]):
        pulumi.set(self, "http_vpc_service_config", value)

    @property
    @pulumi.getter(name="mockServiceConfig")
    def mock_service_config(self) -> Optional[pulumi.Input['ApiMockServiceConfigArgs']]:
        """
        http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        """
        return pulumi.get(self, "mock_service_config")

    @mock_service_config.setter
    def mock_service_config(self, value: Optional[pulumi.Input['ApiMockServiceConfigArgs']]):
        pulumi.set(self, "mock_service_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the api gateway api. Defaults to null.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requestConfig")
    def request_config(self) -> Optional[pulumi.Input['ApiRequestConfigArgs']]:
        """
        Request_config defines how users can send requests to your API. See `request_config` below.
        """
        return pulumi.get(self, "request_config")

    @request_config.setter
    def request_config(self, value: Optional[pulumi.Input['ApiRequestConfigArgs']]):
        pulumi.set(self, "request_config", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]:
        """
        request_parameters defines the request parameters of the api. See `request_parameters` below.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParameterArgs']]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="stageNames")
    def stage_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        """
        return pulumi.get(self, "stage_names")

    @stage_names.setter
    def stage_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "stage_names", value)

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]]:
        """
        system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        return pulumi.get(self, "system_parameters")

    @system_parameters.setter
    def system_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiSystemParameterArgs']]]]):
        pulumi.set(self, "system_parameters", value)


class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 constant_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiConstantParameterArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiFcServiceConfigArgs']]] = None,
                 force_nonce_check: Optional[pulumi.Input[bool]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 http_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpServiceConfigArgs']]] = None,
                 http_vpc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpVpcServiceConfigArgs']]] = None,
                 mock_service_config: Optional[pulumi.Input[pulumi.InputType['ApiMockServiceConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_config: Optional[pulumi.Input[pulumi.InputType['ApiRequestConfigArgs']]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 stage_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiSystemParameterArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_group = alicloud.apigateway.Group("exampleGroup", description="tf-example")
        example_api = alicloud.apigateway.Api("exampleApi",
            group_id=example_group.id,
            description="tf-example",
            auth_type="APP",
            force_nonce_check=False,
            request_config=alicloud.apigateway.ApiRequestConfigArgs(
                protocol="HTTP",
                method="GET",
                path="/example/path",
                mode="MAPPING",
            ),
            service_type="HTTP",
            http_service_config=alicloud.apigateway.ApiHttpServiceConfigArgs(
                address="http://apigateway-backend.alicloudapi.com:8080",
                method="GET",
                path="/web/cloudapi",
                timeout=12,
                aone_name="cloudapi-openapi",
            ),
            request_parameters=[alicloud.apigateway.ApiRequestParameterArgs(
                name="example",
                type="STRING",
                required="OPTIONAL",
                in_="QUERY",
                in_service="QUERY",
                name_service="exampleservice",
            )],
            stage_names=[
                "RELEASE",
                "TEST",
            ])
        ```

        ## Import

        Api gateway api can be imported using the id.Format to `<API Group Id>:<API Id>` e.g.

        ```sh
         $ pulumi import alicloud:apigateway/api:Api example "ab2351f2ce904edaa8d92a0510832b91:e4f728fca5a94148b023b99a3e5d0b62"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: The authorization Type including APP and ANONYMOUS. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiConstantParameterArgs']]]] constant_parameters: constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        :param pulumi.Input[str] description: The description of the api. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiFcServiceConfigArgs']] fc_service_config: fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        :param pulumi.Input[bool] force_nonce_check: Whether to prevent API replay attack. Default value: `false`.
        :param pulumi.Input[str] group_id: The api gateway that the api belongs to. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiHttpServiceConfigArgs']] http_service_config: http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        :param pulumi.Input[pulumi.InputType['ApiHttpVpcServiceConfigArgs']] http_vpc_service_config: http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        :param pulumi.Input[pulumi.InputType['ApiMockServiceConfigArgs']] mock_service_config: http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        :param pulumi.Input[str] name: The name of the api gateway api. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiRequestConfigArgs']] request_config: Request_config defines how users can send requests to your API. See `request_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]] request_parameters: request_parameters defines the request parameters of the api. See `request_parameters` below.
        :param pulumi.Input[str] service_type: The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stage_names: Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiSystemParameterArgs']]]] system_parameters: system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_group = alicloud.apigateway.Group("exampleGroup", description="tf-example")
        example_api = alicloud.apigateway.Api("exampleApi",
            group_id=example_group.id,
            description="tf-example",
            auth_type="APP",
            force_nonce_check=False,
            request_config=alicloud.apigateway.ApiRequestConfigArgs(
                protocol="HTTP",
                method="GET",
                path="/example/path",
                mode="MAPPING",
            ),
            service_type="HTTP",
            http_service_config=alicloud.apigateway.ApiHttpServiceConfigArgs(
                address="http://apigateway-backend.alicloudapi.com:8080",
                method="GET",
                path="/web/cloudapi",
                timeout=12,
                aone_name="cloudapi-openapi",
            ),
            request_parameters=[alicloud.apigateway.ApiRequestParameterArgs(
                name="example",
                type="STRING",
                required="OPTIONAL",
                in_="QUERY",
                in_service="QUERY",
                name_service="exampleservice",
            )],
            stage_names=[
                "RELEASE",
                "TEST",
            ])
        ```

        ## Import

        Api gateway api can be imported using the id.Format to `<API Group Id>:<API Id>` e.g.

        ```sh
         $ pulumi import alicloud:apigateway/api:Api example "ab2351f2ce904edaa8d92a0510832b91:e4f728fca5a94148b023b99a3e5d0b62"
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 constant_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiConstantParameterArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiFcServiceConfigArgs']]] = None,
                 force_nonce_check: Optional[pulumi.Input[bool]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 http_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpServiceConfigArgs']]] = None,
                 http_vpc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpVpcServiceConfigArgs']]] = None,
                 mock_service_config: Optional[pulumi.Input[pulumi.InputType['ApiMockServiceConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_config: Optional[pulumi.Input[pulumi.InputType['ApiRequestConfigArgs']]] = None,
                 request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 stage_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiSystemParameterArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["constant_parameters"] = constant_parameters
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["fc_service_config"] = fc_service_config
            __props__.__dict__["force_nonce_check"] = force_nonce_check
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["http_service_config"] = http_service_config
            __props__.__dict__["http_vpc_service_config"] = http_vpc_service_config
            __props__.__dict__["mock_service_config"] = mock_service_config
            __props__.__dict__["name"] = name
            if request_config is None and not opts.urn:
                raise TypeError("Missing required property 'request_config'")
            __props__.__dict__["request_config"] = request_config
            __props__.__dict__["request_parameters"] = request_parameters
            if service_type is None and not opts.urn:
                raise TypeError("Missing required property 'service_type'")
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["stage_names"] = stage_names
            __props__.__dict__["system_parameters"] = system_parameters
            __props__.__dict__["api_id"] = None
        super(Api, __self__).__init__(
            'alicloud:apigateway/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[str]] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            constant_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiConstantParameterArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiFcServiceConfigArgs']]] = None,
            force_nonce_check: Optional[pulumi.Input[bool]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            http_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpServiceConfigArgs']]] = None,
            http_vpc_service_config: Optional[pulumi.Input[pulumi.InputType['ApiHttpVpcServiceConfigArgs']]] = None,
            mock_service_config: Optional[pulumi.Input[pulumi.InputType['ApiMockServiceConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            request_config: Optional[pulumi.Input[pulumi.InputType['ApiRequestConfigArgs']]] = None,
            request_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            stage_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            system_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiSystemParameterArgs']]]]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_id: The ID of the api of api gateway.
        :param pulumi.Input[str] auth_type: The authorization Type including APP and ANONYMOUS. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiConstantParameterArgs']]]] constant_parameters: constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        :param pulumi.Input[str] description: The description of the api. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiFcServiceConfigArgs']] fc_service_config: fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        :param pulumi.Input[bool] force_nonce_check: Whether to prevent API replay attack. Default value: `false`.
        :param pulumi.Input[str] group_id: The api gateway that the api belongs to. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiHttpServiceConfigArgs']] http_service_config: http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        :param pulumi.Input[pulumi.InputType['ApiHttpVpcServiceConfigArgs']] http_vpc_service_config: http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        :param pulumi.Input[pulumi.InputType['ApiMockServiceConfigArgs']] mock_service_config: http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        :param pulumi.Input[str] name: The name of the api gateway api. Defaults to null.
        :param pulumi.Input[pulumi.InputType['ApiRequestConfigArgs']] request_config: Request_config defines how users can send requests to your API. See `request_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParameterArgs']]]] request_parameters: request_parameters defines the request parameters of the api. See `request_parameters` below.
        :param pulumi.Input[str] service_type: The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stage_names: Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiSystemParameterArgs']]]] system_parameters: system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["constant_parameters"] = constant_parameters
        __props__.__dict__["description"] = description
        __props__.__dict__["fc_service_config"] = fc_service_config
        __props__.__dict__["force_nonce_check"] = force_nonce_check
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["http_service_config"] = http_service_config
        __props__.__dict__["http_vpc_service_config"] = http_vpc_service_config
        __props__.__dict__["mock_service_config"] = mock_service_config
        __props__.__dict__["name"] = name
        __props__.__dict__["request_config"] = request_config
        __props__.__dict__["request_parameters"] = request_parameters
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["stage_names"] = stage_names
        __props__.__dict__["system_parameters"] = system_parameters
        return Api(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[str]:
        """
        The ID of the api of api gateway.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[str]:
        """
        The authorization Type including APP and ANONYMOUS. Defaults to null.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="constantParameters")
    def constant_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ApiConstantParameter']]]:
        """
        constant_parameters defines the constant parameters of the api. See `constant_parameters` below.
        """
        return pulumi.get(self, "constant_parameters")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the api. Defaults to null.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fcServiceConfig")
    def fc_service_config(self) -> pulumi.Output[Optional['outputs.ApiFcServiceConfig']]:
        """
        fc_service_config defines the config when service_type selected 'FunctionCompute'. See `fc_service_config` below.
        """
        return pulumi.get(self, "fc_service_config")

    @property
    @pulumi.getter(name="forceNonceCheck")
    def force_nonce_check(self) -> pulumi.Output[bool]:
        """
        Whether to prevent API replay attack. Default value: `false`.
        """
        return pulumi.get(self, "force_nonce_check")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The api gateway that the api belongs to. Defaults to null.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="httpServiceConfig")
    def http_service_config(self) -> pulumi.Output[Optional['outputs.ApiHttpServiceConfig']]:
        """
        http_service_config defines the config when service_type selected 'HTTP'. See `http_service_config` below.
        """
        return pulumi.get(self, "http_service_config")

    @property
    @pulumi.getter(name="httpVpcServiceConfig")
    def http_vpc_service_config(self) -> pulumi.Output[Optional['outputs.ApiHttpVpcServiceConfig']]:
        """
        http_vpc_service_config defines the config when service_type selected 'HTTP-VPC'. See `http_vpc_service_config` below.
        """
        return pulumi.get(self, "http_vpc_service_config")

    @property
    @pulumi.getter(name="mockServiceConfig")
    def mock_service_config(self) -> pulumi.Output[Optional['outputs.ApiMockServiceConfig']]:
        """
        http_service_config defines the config when service_type selected 'MOCK'. See `mock_service_config` below.
        """
        return pulumi.get(self, "mock_service_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the api gateway api. Defaults to null.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestConfig")
    def request_config(self) -> pulumi.Output['outputs.ApiRequestConfig']:
        """
        Request_config defines how users can send requests to your API. See `request_config` below.
        """
        return pulumi.get(self, "request_config")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ApiRequestParameter']]]:
        """
        request_parameters defines the request parameters of the api. See `request_parameters` below.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        The type of backend service. Type including HTTP,VPC and MOCK. Defaults to null.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="stageNames")
    def stage_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Stages that the api need to be deployed. Valid value: `RELEASE`,`PRE`,`TEST`.
        """
        return pulumi.get(self, "stage_names")

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ApiSystemParameter']]]:
        """
        system_parameters defines the system parameters of the api. See `system_parameters` below.
        """
        return pulumi.get(self, "system_parameters")

