# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApiConstantParameter',
    'ApiFcServiceConfig',
    'ApiHttpServiceConfig',
    'ApiHttpVpcServiceConfig',
    'ApiMockServiceConfig',
    'ApiRequestConfig',
    'ApiRequestParameter',
    'ApiSystemParameter',
    'GetApisApiResult',
    'GetAppsAppResult',
    'GetBackendsBackendResult',
    'GetGroupsGroupResult',
    'GetLogConfigsConfigResult',
    'GetModelsModelResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class ApiConstantParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiConstantParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiConstantParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiConstantParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: str,
                 name: str,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str in_: Constant parameter location; values: 'HEAD' and 'QUERY'.
        :param str name: Constant parameter name.
        :param str value: Constant parameter value.
        :param str description: The description of Constant parameter.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> str:
        """
        Constant parameter location; values: 'HEAD' and 'QUERY'.
        """
        return pulumi.get(self, "in_")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Constant parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Constant parameter value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of Constant parameter.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiFcServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionName":
            suggest = "function_name"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "arnRole":
            suggest = "arn_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFcServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFcServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFcServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_name: str,
                 region: str,
                 service_name: str,
                 timeout: int,
                 arn_role: Optional[str] = None):
        """
        :param str function_name: The function name of function compute service.
        :param str region: The region that the function compute service belongs to.
        :param str service_name: The service name of function compute service.
        :param int timeout: Backend service time-out time; unit: millisecond.
        :param str arn_role: RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "timeout", timeout)
        if arn_role is not None:
            pulumi.set(__self__, "arn_role", arn_role)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        """
        The function name of function compute service.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region that the function compute service belongs to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The service name of function compute service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Backend service time-out time; unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="arnRole")
    def arn_role(self) -> Optional[str]:
        """
        RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
        """
        return pulumi.get(self, "arn_role")


@pulumi.output_type
class ApiHttpServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHttpServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHttpServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHttpServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 method: str,
                 path: str,
                 timeout: int,
                 aone_name: Optional[str] = None):
        """
        :param str address: The address of backend service.
        :param str method: The http method of backend service.
        :param str path: The path of backend service.
        :param int timeout: Backend service time-out time; unit: millisecond.
        :param str aone_name: The name of aone.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "timeout", timeout)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of backend service.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The http method of backend service.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of backend service.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Backend service time-out time; unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")


@pulumi.output_type
class ApiHttpVpcServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHttpVpcServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHttpVpcServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHttpVpcServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: str,
                 name: str,
                 path: str,
                 timeout: int,
                 aone_name: Optional[str] = None):
        """
        :param str method: The http method of backend service.
        :param str name: The name of vpc instance.
        :param str path: The path of backend service.
        :param int timeout: Backend service time-out time. Unit: millisecond.
        :param str aone_name: The name of aone.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "timeout", timeout)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The http method of backend service.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of vpc instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of backend service.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Backend service time-out time. Unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")


@pulumi.output_type
class ApiMockServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 result: str,
                 aone_name: Optional[str] = None):
        """
        :param str result: The result of the mock service.
        :param str aone_name: The name of aone.
        """
        pulumi.set(__self__, "result", result)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The result of the mock service.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")


@pulumi.output_type
class ApiRequestConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyFormat":
            suggest = "body_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiRequestConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiRequestConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiRequestConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: str,
                 mode: str,
                 path: str,
                 protocol: str,
                 body_format: Optional[str] = None):
        """
        :param str method: The method of the api, including 'GET','POST','PUT' etc.
        :param str mode: The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
        :param str path: The request path of the api.
        :param str protocol: The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
        :param str body_format: The body format of the api, which support the values of 'STREAM' and 'FORM'.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "protocol", protocol)
        if body_format is not None:
            pulumi.set(__self__, "body_format", body_format)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The method of the api, including 'GET','POST','PUT' etc.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The request path of the api.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="bodyFormat")
    def body_format(self) -> Optional[str]:
        """
        The body format of the api, which support the values of 'STREAM' and 'FORM'.
        """
        return pulumi.get(self, "body_format")


@pulumi.output_type
class ApiRequestParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"
        elif key == "inService":
            suggest = "in_service"
        elif key == "nameService":
            suggest = "name_service"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiRequestParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiRequestParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiRequestParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: str,
                 in_service: str,
                 name: str,
                 name_service: str,
                 required: str,
                 type: str,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str in_: Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
        :param str in_service: Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
        :param str name: Request's parameter name.
        :param str name_service: Backend service's parameter name.
        :param str required: Parameter required or not; values: REQUIRED and OPTIONAL.
        :param str type: Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
        :param str default_value: The default value of the parameter.
        :param str description: The description of parameter.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "in_service", in_service)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_service", name_service)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> str:
        """
        Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
        """
        return pulumi.get(self, "in_")

    @property
    @pulumi.getter(name="inService")
    def in_service(self) -> str:
        """
        Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
        """
        return pulumi.get(self, "in_service")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Request's parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameService")
    def name_service(self) -> str:
        """
        Backend service's parameter name.
        """
        return pulumi.get(self, "name_service")

    @property
    @pulumi.getter
    def required(self) -> str:
        """
        Parameter required or not; values: REQUIRED and OPTIONAL.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of parameter.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiSystemParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"
        elif key == "nameService":
            suggest = "name_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiSystemParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiSystemParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiSystemParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: str,
                 name: str,
                 name_service: str):
        """
        :param str in_: System parameter location; values: 'HEAD' and 'QUERY'.
        :param str name: System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
        :param str name_service: Backend service's parameter name.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_service", name_service)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> str:
        """
        System parameter location; values: 'HEAD' and 'QUERY'.
        """
        return pulumi.get(self, "in_")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameService")
    def name_service(self) -> str:
        """
        Backend service's parameter name.
        """
        return pulumi.get(self, "name_service")


@pulumi.output_type
class GetApisApiResult(dict):
    def __init__(__self__, *,
                 description: str,
                 group_id: str,
                 group_name: str,
                 id: str,
                 name: str,
                 region_id: str):
        """
        :param str description: API description.
        :param str group_id: ID of the specified group.
        :param str group_name: The group name that the apis belong to.
        :param str id: API ID, which is generated by the system and globally unique.
        :param str name: API name.
        :param str region_id: The ID of the region where the API is located.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        API description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        ID of the specified group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The group name that the apis belong to.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        API ID, which is generated by the system and globally unique.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        API name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The ID of the region where the API is located.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class GetAppsAppResult(dict):
    def __init__(__self__, *,
                 app_code: str,
                 created_time: str,
                 description: str,
                 id: int,
                 modified_time: str,
                 name: str):
        """
        :param str app_code: App code.
        :param str created_time: Creation time (Greenwich mean time).
        :param str description: App description.
        :param int id: App ID, which is generated by the system and globally unique.
        :param str modified_time: Last modification time (Greenwich mean time).
        :param str name: App name.
        """
        pulumi.set(__self__, "app_code", app_code)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="appCode")
    def app_code(self) -> str:
        """
        App code.
        """
        return pulumi.get(self, "app_code")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Creation time (Greenwich mean time).
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        App description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        App ID, which is generated by the system and globally unique.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        Last modification time (Greenwich mean time).
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        App name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBackendsBackendResult(dict):
    def __init__(__self__, *,
                 backend_id: str,
                 backend_name: str,
                 backend_type: str,
                 create_time: str,
                 description: str,
                 id: str,
                 modified_time: str):
        """
        :param str backend_id: The id of the Backend.
        :param str backend_name: The name of the Backend.
        :param str backend_type: The type of the Backend.
        :param str create_time: The created time of the Backend.
        :param str description: The description of the Backend.
        :param str modified_time: The modified time of the Backend.
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "backend_name", backend_name)
        pulumi.set(__self__, "backend_type", backend_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> str:
        """
        The id of the Backend.
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> str:
        """
        The name of the Backend.
        """
        return pulumi.get(self, "backend_name")

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> str:
        """
        The type of the Backend.
        """
        return pulumi.get(self, "backend_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The created time of the Backend.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Backend.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The modified time of the Backend.
        """
        return pulumi.get(self, "modified_time")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 billing_status: str,
                 created_time: str,
                 description: str,
                 id: str,
                 illegal_status: str,
                 modified_time: str,
                 name: str,
                 region_id: str,
                 sub_domain: str,
                 traffic_limit: int):
        """
        :param str billing_status: Billing status.
               - NORMAL: The API group is normal.
               - LOCKED: Locked due to outstanding payment.
        :param str created_time: Creation time (Greenwich mean time).
        :param str description: API group description.
        :param str id: API group ID, which is generated by the system and globally unique.
        :param str illegal_status: Locking in invalid state.
               - NORMAL: The API group is normal.
               - LOCKED: Locked due to illegality.
        :param str modified_time: Last modification time (Greenwich mean time).
        :param str name: API group name.
        :param str region_id: The ID of the region where the API group is located.
        :param str sub_domain: Second-level domain name automatically assigned to the API group.
        :param int traffic_limit: Upper QPS limit of the API group; default value: 500, which can be increased by submitting an application.
        """
        pulumi.set(__self__, "billing_status", billing_status)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "illegal_status", illegal_status)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sub_domain", sub_domain)
        pulumi.set(__self__, "traffic_limit", traffic_limit)

    @property
    @pulumi.getter(name="billingStatus")
    def billing_status(self) -> str:
        """
        Billing status.
        - NORMAL: The API group is normal.
        - LOCKED: Locked due to outstanding payment.
        """
        return pulumi.get(self, "billing_status")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Creation time (Greenwich mean time).
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        API group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        API group ID, which is generated by the system and globally unique.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="illegalStatus")
    def illegal_status(self) -> str:
        """
        Locking in invalid state.
        - NORMAL: The API group is normal.
        - LOCKED: Locked due to illegality.
        """
        return pulumi.get(self, "illegal_status")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        Last modification time (Greenwich mean time).
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        API group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The ID of the region where the API group is located.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> str:
        """
        Second-level domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "sub_domain")

    @property
    @pulumi.getter(name="trafficLimit")
    def traffic_limit(self) -> int:
        """
        Upper QPS limit of the API group; default value: 500, which can be increased by submitting an application.
        """
        return pulumi.get(self, "traffic_limit")


@pulumi.output_type
class GetLogConfigsConfigResult(dict):
    def __init__(__self__, *,
                 id: str,
                 log_type: str,
                 region_id: str,
                 sls_log_store: str,
                 sls_project: str):
        """
        :param str id: The ID of the Log Config.
        :param str log_type: The type the of log.
        :param str region_id: The region ID of the Log Config.
        :param str sls_log_store: The name of the Log Store.
        :param str sls_project: The name of the Project.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sls_log_store", sls_log_store)
        pulumi.set(__self__, "sls_project", sls_project)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Log Config.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The type the of log.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region ID of the Log Config.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="slsLogStore")
    def sls_log_store(self) -> str:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_log_store")

    @property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> str:
        """
        The name of the Project.
        """
        return pulumi.get(self, "sls_project")


@pulumi.output_type
class GetModelsModelResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 group_id: str,
                 id: str,
                 model_id: str,
                 model_name: str,
                 model_ref: str,
                 modified_time: str,
                 schema: str):
        """
        :param str create_time: The creation time of the model.
        :param str description: The description of the model.
        :param str group_id: The ID of the api group.
        :param str id: The ID of the Api Gateway Model.
        :param str model_id: The id of the model.
        :param str model_name: The name of the Model.
        :param str model_ref: The reference of the model.
        :param str modified_time: The modified time of the model.
        :param str schema: The schema of the model.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "model_name", model_name)
        pulumi.set(__self__, "model_ref", model_ref)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the model.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of the api group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Api Gateway Model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The id of the model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> str:
        """
        The name of the Model.
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter(name="modelRef")
    def model_ref(self) -> str:
        """
        The reference of the model.
        """
        return pulumi.get(self, "model_ref")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The modified time of the model.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema of the model.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 id: str,
                 modified_time: str,
                 plugin_data: str,
                 plugin_id: str,
                 plugin_name: str,
                 plugin_type: str,
                 tags: Mapping[str, Any]):
        """
        :param str create_time: The CreateTime of the resource.
        :param str description: The description of the plug-in, which cannot exceed 200 characters.
        :param str id: The ID of the Plugin.
        :param str modified_time: The ModifiedTime of the resource.
        :param str plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param str plugin_id: The first ID of the resource.
        :param str plugin_name: The name of the plug-in that you want to create.
        :param str plugin_type: The type of the plug-in.
        :param Mapping[str, Any] tags: The tag of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "plugin_data", plugin_data)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_type", plugin_type)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The CreateTime of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the plug-in, which cannot exceed 200 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Plugin.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The ModifiedTime of the resource.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="pluginData")
    def plugin_data(self) -> str:
        """
        The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        """
        return pulumi.get(self, "plugin_data")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> str:
        """
        The name of the plug-in that you want to create.
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> str:
        """
        The type of the plug-in.
        """
        return pulumi.get(self, "plugin_type")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


