# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AddonReleaseArgs', 'AddonRelease']

@pulumi.input_type
class AddonReleaseArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[str],
                 addon_version: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 addon_release_name: Optional[pulumi.Input[str]] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AddonRelease resource.
        :param pulumi.Input[str] addon_name: Addon Name.
        :param pulumi.Input[str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] addon_release_name: The name of the resource.
        :param pulumi.Input[str] aliyun_lang: The installed locale.
        :param pulumi.Input[str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "addon_version", addon_version)
        pulumi.set(__self__, "environment_id", environment_id)
        if addon_release_name is not None:
            pulumi.set(__self__, "addon_release_name", addon_release_name)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[str]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_name", value)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Input[str]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_version", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @addon_release_name.setter
    def addon_release_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_release_name", value)

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[str]]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aliyun_lang", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _AddonReleaseState:
    def __init__(__self__, *,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_release_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AddonRelease resources.
        :param pulumi.Input[str] addon_name: Addon Name.
        :param pulumi.Input[str] addon_release_name: The name of the resource.
        :param pulumi.Input[str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[str] aliyun_lang: The installed locale.
        :param pulumi.Input[str] create_time: Creation time.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        if addon_name is not None:
            pulumi.set(__self__, "addon_name", addon_name)
        if addon_release_name is not None:
            pulumi.set(__self__, "addon_release_name", addon_release_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[pulumi.Input[str]]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_name", value)

    @property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @addon_release_name.setter
    def addon_release_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_release_name", value)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_version", value)

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[str]]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aliyun_lang", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values", value)


class AddonRelease(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_release_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ARMS Addon Release resource. Release package of observability addon.

        For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).

        > **NOTE:** Available since v1.212.0.

        ## Import

        ARMS Addon Release can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_name: Addon Name.
        :param pulumi.Input[str] addon_release_name: The name of the resource.
        :param pulumi.Input[str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[str] aliyun_lang: The installed locale.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Addon Release resource. Release package of observability addon.

        For information about ARMS Addon Release and how to use it, see [What is Addon Release](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installaddon).

        > **NOTE:** Available since v1.212.0.

        ## Import

        ARMS Addon Release can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:arms/addonRelease:AddonRelease example <environment_id>:<addon_release_name>
        ```

        :param str resource_name: The name of the resource.
        :param AddonReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_release_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonReleaseArgs.__new__(AddonReleaseArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            __props__.__dict__["addon_release_name"] = addon_release_name
            if addon_version is None and not opts.urn:
                raise TypeError("Missing required property 'addon_version'")
            __props__.__dict__["addon_version"] = addon_version
            __props__.__dict__["aliyun_lang"] = aliyun_lang
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["values"] = values
            __props__.__dict__["create_time"] = None
        super(AddonRelease, __self__).__init__(
            'alicloud:arms/addonRelease:AddonRelease',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_name: Optional[pulumi.Input[str]] = None,
            addon_release_name: Optional[pulumi.Input[str]] = None,
            addon_version: Optional[pulumi.Input[str]] = None,
            aliyun_lang: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            values: Optional[pulumi.Input[str]] = None) -> 'AddonRelease':
        """
        Get an existing AddonRelease resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_name: Addon Name.
        :param pulumi.Input[str] addon_release_name: The name of the resource.
        :param pulumi.Input[str] addon_version: Version number of Addon. Addon information can be obtained through ListAddons.
        :param pulumi.Input[str] aliyun_lang: The installed locale.
        :param pulumi.Input[str] create_time: Creation time.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] values: Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonReleaseState.__new__(_AddonReleaseState)

        __props__.__dict__["addon_name"] = addon_name
        __props__.__dict__["addon_release_name"] = addon_release_name
        __props__.__dict__["addon_version"] = addon_version
        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["values"] = values
        return AddonRelease(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[str]:
        """
        Addon Name.
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonReleaseName")
    def addon_release_name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "addon_release_name")

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Output[str]:
        """
        Version number of Addon. Addon information can be obtained through ListAddons.
        """
        return pulumi.get(self, "addon_version")

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[str]:
        """
        The installed locale.
        """
        return pulumi.get(self, "aliyun_lang")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration information for installing Addon. Obtain the configuration template from ListAddonSchema, for example, {"host":"mysql-service.default","port":3306,"username":"root","password":"roots"}.
        """
        return pulumi.get(self, "values")

