# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EnvServiceMonitorArgs', 'EnvServiceMonitor']

@pulumi.input_type
class EnvServiceMonitorArgs:
    def __init__(__self__, *,
                 config_yaml: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 aliyun_lang: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EnvServiceMonitor resource.
        :param pulumi.Input[str] config_yaml: Yaml configuration string.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] aliyun_lang: Language environment, default is Chinese zh | en.
        """
        pulumi.set(__self__, "config_yaml", config_yaml)
        pulumi.set(__self__, "environment_id", environment_id)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)

    @property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Input[str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_yaml", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aliyun_lang", value)


@pulumi.input_type
class _EnvServiceMonitorState:
    def __init__(__self__, *,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 config_yaml: Optional[pulumi.Input[str]] = None,
                 env_service_monitor_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EnvServiceMonitor resources.
        :param pulumi.Input[str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[str] config_yaml: Yaml configuration string.
        :param pulumi.Input[str] env_service_monitor_name: The name of the resource.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] namespace: The namespace where the resource is located.
        :param pulumi.Input[str] status: Status: run, stop.
        """
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if config_yaml is not None:
            pulumi.set(__self__, "config_yaml", config_yaml)
        if env_service_monitor_name is not None:
            pulumi.set(__self__, "env_service_monitor_name", env_service_monitor_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aliyun_lang", value)

    @property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @config_yaml.setter
    def config_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_yaml", value)

    @property
    @pulumi.getter(name="envServiceMonitorName")
    def env_service_monitor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_service_monitor_name")

    @env_service_monitor_name.setter
    def env_service_monitor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_service_monitor_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace where the resource is located.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class EnvServiceMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 config_yaml: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.

        For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).

        > **NOTE:** Available since v1.212.0.

        ## Import

        ARMS Env Service Monitor can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[str] config_yaml: Yaml configuration string.
        :param pulumi.Input[str] environment_id: Environment id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvServiceMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Env Service Monitor resource. ServiceMonitor for the arms environment.

        For information about ARMS Env Service Monitor and how to use it, see [What is Env Service Monitor](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-createenvservicemonitor).

        > **NOTE:** Available since v1.212.0.

        ## Import

        ARMS Env Service Monitor can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:arms/envServiceMonitor:EnvServiceMonitor example <environment_id>:<namespace>:<env_service_monitor_name>
        ```

        :param str resource_name: The name of the resource.
        :param EnvServiceMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvServiceMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_lang: Optional[pulumi.Input[str]] = None,
                 config_yaml: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvServiceMonitorArgs.__new__(EnvServiceMonitorArgs)

            __props__.__dict__["aliyun_lang"] = aliyun_lang
            if config_yaml is None and not opts.urn:
                raise TypeError("Missing required property 'config_yaml'")
            __props__.__dict__["config_yaml"] = config_yaml
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["env_service_monitor_name"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["status"] = None
        super(EnvServiceMonitor, __self__).__init__(
            'alicloud:arms/envServiceMonitor:EnvServiceMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliyun_lang: Optional[pulumi.Input[str]] = None,
            config_yaml: Optional[pulumi.Input[str]] = None,
            env_service_monitor_name: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'EnvServiceMonitor':
        """
        Get an existing EnvServiceMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aliyun_lang: Language environment, default is Chinese zh | en.
        :param pulumi.Input[str] config_yaml: Yaml configuration string.
        :param pulumi.Input[str] env_service_monitor_name: The name of the resource.
        :param pulumi.Input[str] environment_id: Environment id.
        :param pulumi.Input[str] namespace: The namespace where the resource is located.
        :param pulumi.Input[str] status: Status: run, stop.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvServiceMonitorState.__new__(_EnvServiceMonitorState)

        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["config_yaml"] = config_yaml
        __props__.__dict__["env_service_monitor_name"] = env_service_monitor_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["status"] = status
        return EnvServiceMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[Optional[str]]:
        """
        Language environment, default is Chinese zh | en.
        """
        return pulumi.get(self, "aliyun_lang")

    @property
    @pulumi.getter(name="configYaml")
    def config_yaml(self) -> pulumi.Output[str]:
        """
        Yaml configuration string.
        """
        return pulumi.get(self, "config_yaml")

    @property
    @pulumi.getter(name="envServiceMonitorName")
    def env_service_monitor_name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_service_monitor_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Environment id.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The namespace where the resource is located.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status: run, stop.
        """
        return pulumi.get(self, "status")

