# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertContactsResult',
    'AwaitableGetAlertContactsResult',
    'get_alert_contacts',
    'get_alert_contacts_output',
]

@pulumi.output_type
class GetAlertContactsResult:
    """
    A collection of values returned by getAlertContacts.
    """
    def __init__(__self__, alert_contact_name=None, contacts=None, email=None, id=None, ids=None, name_regex=None, names=None, output_file=None, phone_num=None):
        if alert_contact_name and not isinstance(alert_contact_name, str):
            raise TypeError("Expected argument 'alert_contact_name' to be a str")
        pulumi.set(__self__, "alert_contact_name", alert_contact_name)
        if contacts and not isinstance(contacts, list):
            raise TypeError("Expected argument 'contacts' to be a list")
        pulumi.set(__self__, "contacts", contacts)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if phone_num and not isinstance(phone_num, str):
            raise TypeError("Expected argument 'phone_num' to be a str")
        pulumi.set(__self__, "phone_num", phone_num)

    @property
    @pulumi.getter(name="alertContactName")
    def alert_contact_name(self) -> Optional[str]:
        return pulumi.get(self, "alert_contact_name")

    @property
    @pulumi.getter
    def contacts(self) -> Sequence['outputs.GetAlertContactsContactResult']:
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="phoneNum")
    def phone_num(self) -> Optional[str]:
        return pulumi.get(self, "phone_num")


class AwaitableGetAlertContactsResult(GetAlertContactsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertContactsResult(
            alert_contact_name=self.alert_contact_name,
            contacts=self.contacts,
            email=self.email,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            phone_num=self.phone_num)


def get_alert_contacts(alert_contact_name: Optional[str] = None,
                       email: Optional[str] = None,
                       ids: Optional[Sequence[str]] = None,
                       name_regex: Optional[str] = None,
                       output_file: Optional[str] = None,
                       phone_num: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertContactsResult:
    """
    This data source provides the Arms Alert Contacts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.129.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_alert_contacts()
    pulumi.export("armsAlertContactId1", ids.contacts[0].id)
    name_regex = alicloud.arms.get_alert_contacts(name_regex="^my-AlertContact")
    pulumi.export("armsAlertContactId2", name_regex.contacts[0].id)
    ```


    :param str alert_contact_name: The name of the alert contact.
    :param str email: The email address of the alert contact.
    :param Sequence[str] ids: A list of Alert Contact IDs.
    :param str name_regex: A regex string to filter results by Alert Contact name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str phone_num: The mobile number of the alert contact.
    """
    __args__ = dict()
    __args__['alertContactName'] = alert_contact_name
    __args__['email'] = email
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['phoneNum'] = phone_num
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getAlertContacts:getAlertContacts', __args__, opts=opts, typ=GetAlertContactsResult).value

    return AwaitableGetAlertContactsResult(
        alert_contact_name=pulumi.get(__ret__, 'alert_contact_name'),
        contacts=pulumi.get(__ret__, 'contacts'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        phone_num=pulumi.get(__ret__, 'phone_num'))


@_utilities.lift_output_func(get_alert_contacts)
def get_alert_contacts_output(alert_contact_name: Optional[pulumi.Input[Optional[str]]] = None,
                              email: Optional[pulumi.Input[Optional[str]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              phone_num: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertContactsResult]:
    """
    This data source provides the Arms Alert Contacts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.129.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_alert_contacts()
    pulumi.export("armsAlertContactId1", ids.contacts[0].id)
    name_regex = alicloud.arms.get_alert_contacts(name_regex="^my-AlertContact")
    pulumi.export("armsAlertContactId2", name_regex.contacts[0].id)
    ```


    :param str alert_contact_name: The name of the alert contact.
    :param str email: The email address of the alert contact.
    :param Sequence[str] ids: A list of Alert Contact IDs.
    :param str name_regex: A regex string to filter results by Alert Contact name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str phone_num: The mobile number of the alert contact.
    """
    ...
