# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRemoteWritesResult',
    'AwaitableGetRemoteWritesResult',
    'get_remote_writes',
    'get_remote_writes_output',
]

@pulumi.output_type
class GetRemoteWritesResult:
    """
    A collection of values returned by getRemoteWrites.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, remote_writes=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if remote_writes and not isinstance(remote_writes, list):
            raise TypeError("Expected argument 'remote_writes' to be a list")
        pulumi.set(__self__, "remote_writes", remote_writes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the Prometheus instance.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of Remote Write names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="remoteWrites")
    def remote_writes(self) -> Sequence['outputs.GetRemoteWritesRemoteWriteResult']:
        """
        A list of Remote Writes. Each element contains the following attributes:
        """
        return pulumi.get(self, "remote_writes")


class AwaitableGetRemoteWritesResult(GetRemoteWritesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemoteWritesResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            remote_writes=self.remote_writes)


def get_remote_writes(cluster_id: Optional[str] = None,
                      ids: Optional[Sequence[str]] = None,
                      name_regex: Optional[str] = None,
                      output_file: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemoteWritesResult:
    """
    This data source provides the Arms Remote Writes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.204.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_remote_writes(ids=["example_id"],
        cluster_id="your_cluster_id")
    pulumi.export("armsRemoteWritesId1", ids.remote_writes[0].id)
    name_regex = alicloud.arms.get_remote_writes(name_regex="tf-example",
        cluster_id="your_cluster_id")
    pulumi.export("armsRemoteWritesId2", name_regex.remote_writes[0].id)
    ```


    :param str cluster_id: The ID of the Prometheus instance.
    :param Sequence[str] ids: A list of Remote Write IDs.
    :param str name_regex: A regex string to filter results by Remote Write name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getRemoteWrites:getRemoteWrites', __args__, opts=opts, typ=GetRemoteWritesResult).value

    return AwaitableGetRemoteWritesResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        remote_writes=pulumi.get(__ret__, 'remote_writes'))


@_utilities.lift_output_func(get_remote_writes)
def get_remote_writes_output(cluster_id: Optional[pulumi.Input[str]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRemoteWritesResult]:
    """
    This data source provides the Arms Remote Writes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.204.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_remote_writes(ids=["example_id"],
        cluster_id="your_cluster_id")
    pulumi.export("armsRemoteWritesId1", ids.remote_writes[0].id)
    name_regex = alicloud.arms.get_remote_writes(name_regex="tf-example",
        cluster_id="your_cluster_id")
    pulumi.export("armsRemoteWritesId2", name_regex.remote_writes[0].id)
    ```


    :param str cluster_id: The ID of the Prometheus instance.
    :param Sequence[str] ids: A list of Remote Write IDs.
    :param str name_regex: A regex string to filter results by Remote Write name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
