# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostGroupsResult',
    'AwaitableGetHostGroupsResult',
    'get_host_groups',
    'get_host_groups_output',
]

@pulumi.output_type
class GetHostGroupsResult:
    """
    A collection of values returned by getHostGroups.
    """
    def __init__(__self__, groups=None, host_group_name=None, id=None, ids=None, instance_id=None, name_regex=None, names=None, output_file=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if host_group_name and not isinstance(host_group_name, str):
            raise TypeError("Expected argument 'host_group_name' to be a str")
        pulumi.set(__self__, "host_group_name", host_group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetHostGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="hostGroupName")
    def host_group_name(self) -> Optional[str]:
        return pulumi.get(self, "host_group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetHostGroupsResult(GetHostGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostGroupsResult(
            groups=self.groups,
            host_group_name=self.host_group_name,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_host_groups(host_group_name: Optional[str] = None,
                    ids: Optional[Sequence[str]] = None,
                    instance_id: Optional[str] = None,
                    name_regex: Optional[str] = None,
                    output_file: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostGroupsResult:
    """
    This data source provides the Bastionhost Host Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("bastionhostHostGroupId1", ids.groups[0].id)
    name_regex = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
        name_regex="^my-HostGroup")
    pulumi.export("bastionhostHostGroupId2", name_regex.groups[0].id)
    ```


    :param str host_group_name: Specify the New Host Group Name, Supports up to 128 Characters.
    :param Sequence[str] ids: A list of Host Group IDs.
    :param str instance_id: Specify the New Host Group Where the Bastion Host ID of.
    :param str name_regex: A regex string to filter results by Host Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['hostGroupName'] = host_group_name
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:bastionhost/getHostGroups:getHostGroups', __args__, opts=opts, typ=GetHostGroupsResult).value

    return AwaitableGetHostGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        host_group_name=pulumi.get(__ret__, 'host_group_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_host_groups)
def get_host_groups_output(host_group_name: Optional[pulumi.Input[Optional[str]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           instance_id: Optional[pulumi.Input[str]] = None,
                           name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostGroupsResult]:
    """
    This data source provides the Bastionhost Host Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("bastionhostHostGroupId1", ids.groups[0].id)
    name_regex = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
        name_regex="^my-HostGroup")
    pulumi.export("bastionhostHostGroupId2", name_regex.groups[0].id)
    ```


    :param str host_group_name: Specify the New Host Group Name, Supports up to 128 Characters.
    :param Sequence[str] ids: A list of Host Group IDs.
    :param str instance_id: Specify the New Host Group Where the Bastion Host ID of.
    :param str name_regex: A regex string to filter results by Host Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
