# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HostAccountShareKeyAttachmentArgs', 'HostAccountShareKeyAttachment']

@pulumi.input_type
class HostAccountShareKeyAttachmentArgs:
    def __init__(__self__, *,
                 host_account_id: pulumi.Input[str],
                 host_share_key_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a HostAccountShareKeyAttachment resource.
        :param pulumi.Input[str] host_account_id: The ID list of the host account.
        :param pulumi.Input[str] host_share_key_id: The ID of the host shared key.
        :param pulumi.Input[str] instance_id: The ID of the Bastion machine instance.
        """
        pulumi.set(__self__, "host_account_id", host_account_id)
        pulumi.set(__self__, "host_share_key_id", host_share_key_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="hostAccountId")
    def host_account_id(self) -> pulumi.Input[str]:
        """
        The ID list of the host account.
        """
        return pulumi.get(self, "host_account_id")

    @host_account_id.setter
    def host_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_account_id", value)

    @property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> pulumi.Input[str]:
        """
        The ID of the host shared key.
        """
        return pulumi.get(self, "host_share_key_id")

    @host_share_key_id.setter
    def host_share_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_share_key_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the Bastion machine instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _HostAccountShareKeyAttachmentState:
    def __init__(__self__, *,
                 host_account_id: Optional[pulumi.Input[str]] = None,
                 host_share_key_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostAccountShareKeyAttachment resources.
        :param pulumi.Input[str] host_account_id: The ID list of the host account.
        :param pulumi.Input[str] host_share_key_id: The ID of the host shared key.
        :param pulumi.Input[str] instance_id: The ID of the Bastion machine instance.
        """
        if host_account_id is not None:
            pulumi.set(__self__, "host_account_id", host_account_id)
        if host_share_key_id is not None:
            pulumi.set(__self__, "host_share_key_id", host_share_key_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="hostAccountId")
    def host_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID list of the host account.
        """
        return pulumi.get(self, "host_account_id")

    @host_account_id.setter
    def host_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_account_id", value)

    @property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host shared key.
        """
        return pulumi.get(self, "host_share_key_id")

    @host_share_key_id.setter
    def host_share_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_share_key_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Bastion machine instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class HostAccountShareKeyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_account_id: Optional[pulumi.Input[str]] = None,
                 host_share_key_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Bastion Host Account Share Key Attachment resource.

        For information about Bastion Host Host Account Share Key Attachment and how to use it, see [What is Host Account Share Key Attachment](https://www.alibabacloud.com/help/en/bastion-host/latest/attachhostaccountstohostsharekey).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.bastionhost.Instance("defaultInstance",
            description=name,
            license_code="bhah_ent_50_asset",
            plan_code="cloudbastion",
            storage="5",
            bandwidth="5",
            period=1,
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id])
        default_host = alicloud.bastionhost.Host("defaultHost",
            instance_id=default_instance.id,
            host_name=name,
            active_address_type="Private",
            host_private_address="172.16.0.10",
            os_type="Linux",
            source="Local")
        default_host_account = alicloud.bastionhost.HostAccount("defaultHostAccount",
            host_account_name=name,
            host_id=default_host.host_id,
            instance_id=default_host.instance_id,
            protocol_name="SSH",
            password="YourPassword12345")
        private_key = config.get("privateKey")
        if private_key is None:
            private_key = "LS0tLS1CR*******"
        default_host_share_key = alicloud.bastionhost.HostShareKey("defaultHostShareKey",
            host_share_key_name=name,
            instance_id=default_instance.id,
            pass_phrase="NTIxeGlubXU=",
            private_key=private_key)
        default_host_account_share_key_attachment = alicloud.bastionhost.HostAccountShareKeyAttachment("defaultHostAccountShareKeyAttachment",
            instance_id=default_instance.id,
            host_share_key_id=default_host_share_key.host_share_key_id,
            host_account_id=default_host_account.host_account_id)
        ```

        ## Import

        Bastion Host Account Share Key Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:bastionhost/hostAccountShareKeyAttachment:HostAccountShareKeyAttachment example <instance_id>:<host_share_key_id>:<host_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host_account_id: The ID list of the host account.
        :param pulumi.Input[str] host_share_key_id: The ID of the host shared key.
        :param pulumi.Input[str] instance_id: The ID of the Bastion machine instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostAccountShareKeyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Bastion Host Account Share Key Attachment resource.

        For information about Bastion Host Host Account Share Key Attachment and how to use it, see [What is Host Account Share Key Attachment](https://www.alibabacloud.com/help/en/bastion-host/latest/attachhostaccountstohostsharekey).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_instance = alicloud.bastionhost.Instance("defaultInstance",
            description=name,
            license_code="bhah_ent_50_asset",
            plan_code="cloudbastion",
            storage="5",
            bandwidth="5",
            period=1,
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id])
        default_host = alicloud.bastionhost.Host("defaultHost",
            instance_id=default_instance.id,
            host_name=name,
            active_address_type="Private",
            host_private_address="172.16.0.10",
            os_type="Linux",
            source="Local")
        default_host_account = alicloud.bastionhost.HostAccount("defaultHostAccount",
            host_account_name=name,
            host_id=default_host.host_id,
            instance_id=default_host.instance_id,
            protocol_name="SSH",
            password="YourPassword12345")
        private_key = config.get("privateKey")
        if private_key is None:
            private_key = "LS0tLS1CR*******"
        default_host_share_key = alicloud.bastionhost.HostShareKey("defaultHostShareKey",
            host_share_key_name=name,
            instance_id=default_instance.id,
            pass_phrase="NTIxeGlubXU=",
            private_key=private_key)
        default_host_account_share_key_attachment = alicloud.bastionhost.HostAccountShareKeyAttachment("defaultHostAccountShareKeyAttachment",
            instance_id=default_instance.id,
            host_share_key_id=default_host_share_key.host_share_key_id,
            host_account_id=default_host_account.host_account_id)
        ```

        ## Import

        Bastion Host Account Share Key Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:bastionhost/hostAccountShareKeyAttachment:HostAccountShareKeyAttachment example <instance_id>:<host_share_key_id>:<host_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param HostAccountShareKeyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostAccountShareKeyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_account_id: Optional[pulumi.Input[str]] = None,
                 host_share_key_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostAccountShareKeyAttachmentArgs.__new__(HostAccountShareKeyAttachmentArgs)

            if host_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_account_id'")
            __props__.__dict__["host_account_id"] = host_account_id
            if host_share_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_share_key_id'")
            __props__.__dict__["host_share_key_id"] = host_share_key_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(HostAccountShareKeyAttachment, __self__).__init__(
            'alicloud:bastionhost/hostAccountShareKeyAttachment:HostAccountShareKeyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host_account_id: Optional[pulumi.Input[str]] = None,
            host_share_key_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'HostAccountShareKeyAttachment':
        """
        Get an existing HostAccountShareKeyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host_account_id: The ID list of the host account.
        :param pulumi.Input[str] host_share_key_id: The ID of the host shared key.
        :param pulumi.Input[str] instance_id: The ID of the Bastion machine instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostAccountShareKeyAttachmentState.__new__(_HostAccountShareKeyAttachmentState)

        __props__.__dict__["host_account_id"] = host_account_id
        __props__.__dict__["host_share_key_id"] = host_share_key_id
        __props__.__dict__["instance_id"] = instance_id
        return HostAccountShareKeyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="hostAccountId")
    def host_account_id(self) -> pulumi.Output[str]:
        """
        The ID list of the host account.
        """
        return pulumi.get(self, "host_account_id")

    @property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> pulumi.Output[str]:
        """
        The ID of the host shared key.
        """
        return pulumi.get(self, "host_share_key_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the Bastion machine instance.
        """
        return pulumi.get(self, "instance_id")

