# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupPlansResult',
    'AwaitableGetBackupPlansResult',
    'get_backup_plans',
    'get_backup_plans_output',
]

@pulumi.output_type
class GetBackupPlansResult:
    """
    A collection of values returned by getBackupPlans.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, output_file=None, plans=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetBackupPlansPlanResult']:
        return pulumi.get(self, "plans")


class AwaitableGetBackupPlansResult(GetBackupPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlansResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            plans=self.plans)


def get_backup_plans(cluster_id: Optional[str] = None,
                     output_file: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlansResult:
    """
    This data source provides the Cassandra Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.128.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cassandra.get_backup_plans(cluster_id="example_value")
    pulumi.export("firstCassandraBackupPlanId", example.plans[0].id)
    ```


    :param str cluster_id: The ID of the cluster for the backup.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cassandra/getBackupPlans:getBackupPlans', __args__, opts=opts, typ=GetBackupPlansResult).value

    return AwaitableGetBackupPlansResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        plans=pulumi.get(__ret__, 'plans'))


@_utilities.lift_output_func(get_backup_plans)
def get_backup_plans_output(cluster_id: Optional[pulumi.Input[str]] = None,
                            output_file: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupPlansResult]:
    """
    This data source provides the Cassandra Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.128.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cassandra.get_backup_plans(cluster_id="example_value")
    pulumi.export("firstCassandraBackupPlanId", example.plans[0].id)
    ```


    :param str cluster_id: The ID of the cluster for the backup.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
