# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DedicatedHostArgs', 'DedicatedHost']

@pulumi.input_type
class DedicatedHostArgs:
    def __init__(__self__, *,
                 dedicated_host_group_id: pulumi.Input[str],
                 host_class: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 allocation_status: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_category: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 used_time: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DedicatedHost resource.
        :param pulumi.Input[str] dedicated_host_group_id: The ID of the dedicated cluster.
        :param pulumi.Input[str] host_class: The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch to which the host is connected.
        :param pulumi.Input[str] zone_id: The ID of the zone.
        :param pulumi.Input[str] allocation_status: Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable the auto-renewal feature.
        :param pulumi.Input[str] host_name: The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] image_category: Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        :param pulumi.Input[str] os_password: Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        :param pulumi.Input[str] period: The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] used_time: The subscription duration of the host. Valid values: 
               * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
               * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
               * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        """
        pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        pulumi.set(__self__, "host_class", host_class)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if allocation_status is not None:
            pulumi.set(__self__, "allocation_status", allocation_status)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_category is not None:
            pulumi.set(__self__, "image_category", image_category)
        if os_password is not None:
            pulumi.set(__self__, "os_password", os_password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @property
    @pulumi.getter(name="hostClass")
    def host_class(self) -> pulumi.Input[str]:
        """
        The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        """
        return pulumi.get(self, "host_class")

    @host_class.setter
    def host_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_class", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the vSwitch to which the host is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        """
        return pulumi.get(self, "allocation_status")

    @allocation_status.setter
    def allocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_status", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the auto-renewal feature.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageCategory")
    def image_category(self) -> Optional[pulumi.Input[str]]:
        """
        Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        """
        return pulumi.get(self, "image_category")

    @image_category.setter
    def image_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_category", value)

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> Optional[pulumi.Input[str]]:
        """
        Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        """
        return pulumi.get(self, "os_password")

    @os_password.setter
    def os_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[int]]:
        """
        The subscription duration of the host. Valid values: 
        * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
        * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
        * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_time", value)


@pulumi.input_type
class _DedicatedHostState:
    def __init__(__self__, *,
                 allocation_status: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 dedicated_host_id: Optional[pulumi.Input[str]] = None,
                 host_class: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_category: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DedicatedHost resources.
        :param pulumi.Input[str] allocation_status: Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable the auto-renewal feature.
        :param pulumi.Input[str] dedicated_host_group_id: The ID of the dedicated cluster.
        :param pulumi.Input[str] dedicated_host_id: The ID of the host.
        :param pulumi.Input[str] host_class: The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        :param pulumi.Input[str] host_name: The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] image_category: Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        :param pulumi.Input[str] os_password: Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[str] period: The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        :param pulumi.Input[str] status: The state of the host. Valid values: `0:` The host is being created. `1`: The host is running. `2`: The host is faulty. `3`: The host is ready for deactivation. `4`: The host is being maintained. `5`: The host is deactivated. `6`: The host is restarting. `7`: The host is locked.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] used_time: The subscription duration of the host. Valid values: 
               * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
               * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
               * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch to which the host is connected.
        :param pulumi.Input[str] zone_id: The ID of the zone.
        """
        if allocation_status is not None:
            pulumi.set(__self__, "allocation_status", allocation_status)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if host_class is not None:
            pulumi.set(__self__, "host_class", host_class)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_category is not None:
            pulumi.set(__self__, "image_category", image_category)
        if os_password is not None:
            pulumi.set(__self__, "os_password", os_password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        """
        return pulumi.get(self, "allocation_status")

    @allocation_status.setter
    def allocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_status", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the auto-renewal feature.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @property
    @pulumi.getter(name="hostClass")
    def host_class(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        """
        return pulumi.get(self, "host_class")

    @host_class.setter
    def host_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_class", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageCategory")
    def image_category(self) -> Optional[pulumi.Input[str]]:
        """
        Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        """
        return pulumi.get(self, "image_category")

    @image_category.setter
    def image_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_category", value)

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> Optional[pulumi.Input[str]]:
        """
        Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        """
        return pulumi.get(self, "os_password")

    @os_password.setter
    def os_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_password", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the host. Valid values: `0:` The host is being created. `1`: The host is running. `2`: The host is faulty. `3`: The host is ready for deactivation. `4`: The host is being maintained. `5`: The host is deactivated. `6`: The host is restarting. `7`: The host is locked.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[int]]:
        """
        The subscription duration of the host. Valid values: 
        * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
        * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
        * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_time", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch to which the host is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DedicatedHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_status: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 host_class: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_category: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        ApsaraDB for MyBase Dedicated Host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cddc/dedicatedHost:DedicatedHost example <dedicated_host_group_id>:<dedicated_host_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_status: Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable the auto-renewal feature.
        :param pulumi.Input[str] dedicated_host_group_id: The ID of the dedicated cluster.
        :param pulumi.Input[str] host_class: The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        :param pulumi.Input[str] host_name: The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] image_category: Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        :param pulumi.Input[str] os_password: Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[str] period: The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] used_time: The subscription duration of the host. Valid values: 
               * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
               * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
               * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch to which the host is connected.
        :param pulumi.Input[str] zone_id: The ID of the zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ApsaraDB for MyBase Dedicated Host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cddc/dedicatedHost:DedicatedHost example <dedicated_host_group_id>:<dedicated_host_id>
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_status: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 host_class: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_category: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedHostArgs.__new__(DedicatedHostArgs)

            __props__.__dict__["allocation_status"] = allocation_status
            __props__.__dict__["auto_renew"] = auto_renew
            if dedicated_host_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'dedicated_host_group_id'")
            __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
            if host_class is None and not opts.urn:
                raise TypeError("Missing required property 'host_class'")
            __props__.__dict__["host_class"] = host_class
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_category"] = image_category
            __props__.__dict__["os_password"] = None if os_password is None else pulumi.Output.secret(os_password)
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["tags"] = tags
            __props__.__dict__["used_time"] = used_time
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["dedicated_host_id"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["osPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DedicatedHost, __self__).__init__(
            'alicloud:cddc/dedicatedHost:DedicatedHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_status: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
            dedicated_host_id: Optional[pulumi.Input[str]] = None,
            host_class: Optional[pulumi.Input[str]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            image_category: Optional[pulumi.Input[str]] = None,
            os_password: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            used_time: Optional[pulumi.Input[int]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DedicatedHost':
        """
        Get an existing DedicatedHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_status: Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        :param pulumi.Input[bool] auto_renew: Specifies whether to enable the auto-renewal feature.
        :param pulumi.Input[str] dedicated_host_group_id: The ID of the dedicated cluster.
        :param pulumi.Input[str] dedicated_host_id: The ID of the host.
        :param pulumi.Input[str] host_class: The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        :param pulumi.Input[str] host_name: The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] image_category: Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        :param pulumi.Input[str] os_password: Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        :param pulumi.Input[str] payment_type: The payment type of the resource. Valid values: `Subscription`.
        :param pulumi.Input[str] period: The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        :param pulumi.Input[str] status: The state of the host. Valid values: `0:` The host is being created. `1`: The host is running. `2`: The host is faulty. `3`: The host is ready for deactivation. `4`: The host is being maintained. `5`: The host is deactivated. `6`: The host is restarting. `7`: The host is locked.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] used_time: The subscription duration of the host. Valid values: 
               * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
               * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
               * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch to which the host is connected.
        :param pulumi.Input[str] zone_id: The ID of the zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedHostState.__new__(_DedicatedHostState)

        __props__.__dict__["allocation_status"] = allocation_status
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
        __props__.__dict__["dedicated_host_id"] = dedicated_host_id
        __props__.__dict__["host_class"] = host_class
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_category"] = image_category
        __props__.__dict__["os_password"] = os_password
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["used_time"] = used_time
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DedicatedHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> pulumi.Output[str]:
        """
        Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
        """
        return pulumi.get(self, "allocation_status")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the auto-renewal feature.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> pulumi.Output[str]:
        """
        The ID of the host.
        """
        return pulumi.get(self, "dedicated_host_id")

    @property
    @pulumi.getter(name="hostClass")
    def host_class(self) -> pulumi.Output[str]:
        """
        The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
        """
        return pulumi.get(self, "host_class")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="imageCategory")
    def image_category(self) -> pulumi.Output[Optional[str]]:
        """
        Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
        """
        return pulumi.get(self, "image_category")

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> pulumi.Output[Optional[str]]:
        """
        Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
        """
        return pulumi.get(self, "os_password")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource. Valid values: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The state of the host. Valid values: `0:` The host is being created. `1`: The host is running. `2`: The host is faulty. `3`: The host is ready for deactivation. `4`: The host is being maintained. `5`: The host is deactivated. `6`: The host is restarting. `7`: The host is locked.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[int]]:
        """
        The subscription duration of the host. Valid values: 
        * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
        * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
        * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
        """
        return pulumi.get(self, "used_time")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of the vSwitch to which the host is connected.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

