# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DedicatedPropreHostArgs', 'DedicatedPropreHost']

@pulumi.input_type
class DedicatedPropreHostArgs:
    def __init__(__self__, *,
                 ecs_class_lists: pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]],
                 ecs_zone_id: pulumi.Input[str],
                 engine: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_deployment_set_id: Optional[pulumi.Input[str]] = None,
                 ecs_host_name: Optional[pulumi.Input[str]] = None,
                 ecs_instance_name: Optional[pulumi.Input[str]] = None,
                 ecs_unique_suffix: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DedicatedPropreHost resource.
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]] ecs_class_lists: ECS specifications. See `ecs_class_list` below.
        :param pulumi.Input[str] ecs_zone_id: The ID of the zone.
        :param pulumi.Input[str] engine: Database type, value:
               - **alisql**
               - **tair**
               - **mssql**
               Must be consistent with the parent resource cluster engine attributes.
        :param pulumi.Input[str] payment_type: The Payment type. Currently, only **Subscription** is supported.
        :param pulumi.Input[str] security_group_id: The ID of the security group.
        :param pulumi.Input[str] vpc_id: VPCID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the virtual switch.
        :param pulumi.Input[str] auto_renew: Whether to enable automatic renewal. Valid values:
               - **true**: On
               - **false** (default): Off
        :param pulumi.Input[str] dedicated_host_group_id: You have a dedicated cluster ID.
        :param pulumi.Input[str] ecs_deployment_set_id: The ID of the cloud server deployment set.
        :param pulumi.Input[str] ecs_host_name: Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        :param pulumi.Input[str] ecs_instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] ecs_unique_suffix: Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
               - **true**: added.
               - **false** (default): Do not add.
               When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        :param pulumi.Input[str] image_id: The ID of the custom image.
               > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        :param pulumi.Input[str] key_pair_name: The key pair name.
        :param pulumi.Input[str] os_password: Host login password, which can be set later. The password must meet the following requirements:
               - Length is 8~30 characters.
               - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
               - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
               > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        :param pulumi.Input[str] password_inherit: Whether to use the default password of the image.
               - **false**: (default)Do not use
               - **true**: Use
               > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        :param pulumi.Input[str] period: Duration of purchase.
        :param pulumi.Input[str] period_type: The subscription type. Currently, only **Monthly** (subscription) is supported.
        """
        pulumi.set(__self__, "ecs_class_lists", ecs_class_lists)
        pulumi.set(__self__, "ecs_zone_id", ecs_zone_id)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if ecs_deployment_set_id is not None:
            pulumi.set(__self__, "ecs_deployment_set_id", ecs_deployment_set_id)
        if ecs_host_name is not None:
            pulumi.set(__self__, "ecs_host_name", ecs_host_name)
        if ecs_instance_name is not None:
            pulumi.set(__self__, "ecs_instance_name", ecs_instance_name)
        if ecs_unique_suffix is not None:
            pulumi.set(__self__, "ecs_unique_suffix", ecs_unique_suffix)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if os_password is not None:
            pulumi.set(__self__, "os_password", os_password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)

    @property
    @pulumi.getter(name="ecsClassLists")
    def ecs_class_lists(self) -> pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]]:
        """
        ECS specifications. See `ecs_class_list` below.
        """
        return pulumi.get(self, "ecs_class_lists")

    @ecs_class_lists.setter
    def ecs_class_lists(self, value: pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]]):
        pulumi.set(self, "ecs_class_lists", value)

    @property
    @pulumi.getter(name="ecsZoneId")
    def ecs_zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "ecs_zone_id")

    @ecs_zone_id.setter
    def ecs_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ecs_zone_id", value)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Database type, value:
        - **alisql**
        - **tair**
        - **mssql**
        Must be consistent with the parent resource cluster engine attributes.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The Payment type. Currently, only **Subscription** is supported.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPCID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the virtual switch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable automatic renewal. Valid values:
        - **true**: On
        - **false** (default): Off
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        You have a dedicated cluster ID.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @property
    @pulumi.getter(name="ecsDeploymentSetId")
    def ecs_deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cloud server deployment set.
        """
        return pulumi.get(self, "ecs_deployment_set_id")

    @ecs_deployment_set_id.setter
    def ecs_deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_deployment_set_id", value)

    @property
    @pulumi.getter(name="ecsHostName")
    def ecs_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        """
        return pulumi.get(self, "ecs_host_name")

    @ecs_host_name.setter
    def ecs_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_host_name", value)

    @property
    @pulumi.getter(name="ecsInstanceName")
    def ecs_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "ecs_instance_name")

    @ecs_instance_name.setter
    def ecs_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_instance_name", value)

    @property
    @pulumi.getter(name="ecsUniqueSuffix")
    def ecs_unique_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
        - **true**: added.
        - **false** (default): Do not add.
        When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        """
        return pulumi.get(self, "ecs_unique_suffix")

    @ecs_unique_suffix.setter
    def ecs_unique_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_unique_suffix", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the custom image.
        > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key pair name.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> Optional[pulumi.Input[str]]:
        """
        Host login password, which can be set later. The password must meet the following requirements:
        - Length is 8~30 characters.
        - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
        - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
        > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        """
        return pulumi.get(self, "os_password")

    @os_password.setter
    def os_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to use the default password of the image.
        - **false**: (default)Do not use
        - **true**: Use
        > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of purchase.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription type. Currently, only **Monthly** (subscription) is supported.
        """
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_type", value)


@pulumi.input_type
class _DedicatedPropreHostState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_class_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]]] = None,
                 ecs_deployment_set_id: Optional[pulumi.Input[str]] = None,
                 ecs_host_name: Optional[pulumi.Input[str]] = None,
                 ecs_instance_id: Optional[pulumi.Input[str]] = None,
                 ecs_instance_name: Optional[pulumi.Input[str]] = None,
                 ecs_unique_suffix: Optional[pulumi.Input[str]] = None,
                 ecs_zone_id: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DedicatedPropreHost resources.
        :param pulumi.Input[str] auto_renew: Whether to enable automatic renewal. Valid values:
               - **true**: On
               - **false** (default): Off
        :param pulumi.Input[str] dedicated_host_group_id: You have a dedicated cluster ID.
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]] ecs_class_lists: ECS specifications. See `ecs_class_list` below.
        :param pulumi.Input[str] ecs_deployment_set_id: The ID of the cloud server deployment set.
        :param pulumi.Input[str] ecs_host_name: Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        :param pulumi.Input[str] ecs_instance_id: ECS instance ID.
        :param pulumi.Input[str] ecs_instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] ecs_unique_suffix: Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
               - **true**: added.
               - **false** (default): Do not add.
               When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        :param pulumi.Input[str] ecs_zone_id: The ID of the zone.
        :param pulumi.Input[str] engine: Database type, value:
               - **alisql**
               - **tair**
               - **mssql**
               Must be consistent with the parent resource cluster engine attributes.
        :param pulumi.Input[str] image_id: The ID of the custom image.
               > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        :param pulumi.Input[str] key_pair_name: The key pair name.
        :param pulumi.Input[str] os_password: Host login password, which can be set later. The password must meet the following requirements:
               - Length is 8~30 characters.
               - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
               - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
               > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        :param pulumi.Input[str] password_inherit: Whether to use the default password of the image.
               - **false**: (default)Do not use
               - **true**: Use
               > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        :param pulumi.Input[str] payment_type: The Payment type. Currently, only **Subscription** is supported.
        :param pulumi.Input[str] period: Duration of purchase.
        :param pulumi.Input[str] period_type: The subscription type. Currently, only **Monthly** (subscription) is supported.
        :param pulumi.Input[str] security_group_id: The ID of the security group.
        :param pulumi.Input[str] vpc_id: VPCID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the virtual switch.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if ecs_class_lists is not None:
            pulumi.set(__self__, "ecs_class_lists", ecs_class_lists)
        if ecs_deployment_set_id is not None:
            pulumi.set(__self__, "ecs_deployment_set_id", ecs_deployment_set_id)
        if ecs_host_name is not None:
            pulumi.set(__self__, "ecs_host_name", ecs_host_name)
        if ecs_instance_id is not None:
            pulumi.set(__self__, "ecs_instance_id", ecs_instance_id)
        if ecs_instance_name is not None:
            pulumi.set(__self__, "ecs_instance_name", ecs_instance_name)
        if ecs_unique_suffix is not None:
            pulumi.set(__self__, "ecs_unique_suffix", ecs_unique_suffix)
        if ecs_zone_id is not None:
            pulumi.set(__self__, "ecs_zone_id", ecs_zone_id)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if os_password is not None:
            pulumi.set(__self__, "os_password", os_password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable automatic renewal. Valid values:
        - **true**: On
        - **false** (default): Off
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        You have a dedicated cluster ID.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @property
    @pulumi.getter(name="ecsClassLists")
    def ecs_class_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]]]:
        """
        ECS specifications. See `ecs_class_list` below.
        """
        return pulumi.get(self, "ecs_class_lists")

    @ecs_class_lists.setter
    def ecs_class_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedPropreHostEcsClassListArgs']]]]):
        pulumi.set(self, "ecs_class_lists", value)

    @property
    @pulumi.getter(name="ecsDeploymentSetId")
    def ecs_deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cloud server deployment set.
        """
        return pulumi.get(self, "ecs_deployment_set_id")

    @ecs_deployment_set_id.setter
    def ecs_deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_deployment_set_id", value)

    @property
    @pulumi.getter(name="ecsHostName")
    def ecs_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        """
        return pulumi.get(self, "ecs_host_name")

    @ecs_host_name.setter
    def ecs_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_host_name", value)

    @property
    @pulumi.getter(name="ecsInstanceId")
    def ecs_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ECS instance ID.
        """
        return pulumi.get(self, "ecs_instance_id")

    @ecs_instance_id.setter
    def ecs_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_instance_id", value)

    @property
    @pulumi.getter(name="ecsInstanceName")
    def ecs_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "ecs_instance_name")

    @ecs_instance_name.setter
    def ecs_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_instance_name", value)

    @property
    @pulumi.getter(name="ecsUniqueSuffix")
    def ecs_unique_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
        - **true**: added.
        - **false** (default): Do not add.
        When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        """
        return pulumi.get(self, "ecs_unique_suffix")

    @ecs_unique_suffix.setter
    def ecs_unique_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_unique_suffix", value)

    @property
    @pulumi.getter(name="ecsZoneId")
    def ecs_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "ecs_zone_id")

    @ecs_zone_id.setter
    def ecs_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_zone_id", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database type, value:
        - **alisql**
        - **tair**
        - **mssql**
        Must be consistent with the parent resource cluster engine attributes.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the custom image.
        > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key pair name.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> Optional[pulumi.Input[str]]:
        """
        Host login password, which can be set later. The password must meet the following requirements:
        - Length is 8~30 characters.
        - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
        - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
        > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        """
        return pulumi.get(self, "os_password")

    @os_password.setter
    def os_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to use the default password of the image.
        - **false**: (default)Do not use
        - **true**: Use
        > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Payment type. Currently, only **Subscription** is supported.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of purchase.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription type. Currently, only **Monthly** (subscription) is supported.
        """
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_type", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPCID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the virtual switch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class DedicatedPropreHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_class_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedPropreHostEcsClassListArgs']]]]] = None,
                 ecs_deployment_set_id: Optional[pulumi.Input[str]] = None,
                 ecs_host_name: Optional[pulumi.Input[str]] = None,
                 ecs_instance_name: Optional[pulumi.Input[str]] = None,
                 ecs_unique_suffix: Optional[pulumi.Input[str]] = None,
                 ecs_zone_id: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        CDDC Dedicated Propre Host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cddc/dedicatedPropreHost:DedicatedPropreHost example <dedicated_host_group_id>:<ecs_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Whether to enable automatic renewal. Valid values:
               - **true**: On
               - **false** (default): Off
        :param pulumi.Input[str] dedicated_host_group_id: You have a dedicated cluster ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedPropreHostEcsClassListArgs']]]] ecs_class_lists: ECS specifications. See `ecs_class_list` below.
        :param pulumi.Input[str] ecs_deployment_set_id: The ID of the cloud server deployment set.
        :param pulumi.Input[str] ecs_host_name: Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        :param pulumi.Input[str] ecs_instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] ecs_unique_suffix: Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
               - **true**: added.
               - **false** (default): Do not add.
               When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        :param pulumi.Input[str] ecs_zone_id: The ID of the zone.
        :param pulumi.Input[str] engine: Database type, value:
               - **alisql**
               - **tair**
               - **mssql**
               Must be consistent with the parent resource cluster engine attributes.
        :param pulumi.Input[str] image_id: The ID of the custom image.
               > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        :param pulumi.Input[str] key_pair_name: The key pair name.
        :param pulumi.Input[str] os_password: Host login password, which can be set later. The password must meet the following requirements:
               - Length is 8~30 characters.
               - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
               - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
               > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        :param pulumi.Input[str] password_inherit: Whether to use the default password of the image.
               - **false**: (default)Do not use
               - **true**: Use
               > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        :param pulumi.Input[str] payment_type: The Payment type. Currently, only **Subscription** is supported.
        :param pulumi.Input[str] period: Duration of purchase.
        :param pulumi.Input[str] period_type: The subscription type. Currently, only **Monthly** (subscription) is supported.
        :param pulumi.Input[str] security_group_id: The ID of the security group.
        :param pulumi.Input[str] vpc_id: VPCID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the virtual switch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedPropreHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        CDDC Dedicated Propre Host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cddc/dedicatedPropreHost:DedicatedPropreHost example <dedicated_host_group_id>:<ecs_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedPropreHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedPropreHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_class_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedPropreHostEcsClassListArgs']]]]] = None,
                 ecs_deployment_set_id: Optional[pulumi.Input[str]] = None,
                 ecs_host_name: Optional[pulumi.Input[str]] = None,
                 ecs_instance_name: Optional[pulumi.Input[str]] = None,
                 ecs_unique_suffix: Optional[pulumi.Input[str]] = None,
                 ecs_zone_id: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 os_password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedPropreHostArgs.__new__(DedicatedPropreHostArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
            if ecs_class_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ecs_class_lists'")
            __props__.__dict__["ecs_class_lists"] = ecs_class_lists
            __props__.__dict__["ecs_deployment_set_id"] = ecs_deployment_set_id
            __props__.__dict__["ecs_host_name"] = ecs_host_name
            __props__.__dict__["ecs_instance_name"] = ecs_instance_name
            __props__.__dict__["ecs_unique_suffix"] = ecs_unique_suffix
            if ecs_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'ecs_zone_id'")
            __props__.__dict__["ecs_zone_id"] = ecs_zone_id
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["os_password"] = os_password
            __props__.__dict__["password_inherit"] = password_inherit
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_type"] = period_type
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["ecs_instance_id"] = None
        super(DedicatedPropreHost, __self__).__init__(
            'alicloud:cddc/dedicatedPropreHost:DedicatedPropreHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            dedicated_host_group_id: Optional[pulumi.Input[str]] = None,
            ecs_class_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedPropreHostEcsClassListArgs']]]]] = None,
            ecs_deployment_set_id: Optional[pulumi.Input[str]] = None,
            ecs_host_name: Optional[pulumi.Input[str]] = None,
            ecs_instance_id: Optional[pulumi.Input[str]] = None,
            ecs_instance_name: Optional[pulumi.Input[str]] = None,
            ecs_unique_suffix: Optional[pulumi.Input[str]] = None,
            ecs_zone_id: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            os_password: Optional[pulumi.Input[str]] = None,
            password_inherit: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            period_type: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'DedicatedPropreHost':
        """
        Get an existing DedicatedPropreHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Whether to enable automatic renewal. Valid values:
               - **true**: On
               - **false** (default): Off
        :param pulumi.Input[str] dedicated_host_group_id: You have a dedicated cluster ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedPropreHostEcsClassListArgs']]]] ecs_class_lists: ECS specifications. See `ecs_class_list` below.
        :param pulumi.Input[str] ecs_deployment_set_id: The ID of the cloud server deployment set.
        :param pulumi.Input[str] ecs_host_name: Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        :param pulumi.Input[str] ecs_instance_id: ECS instance ID.
        :param pulumi.Input[str] ecs_instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] ecs_unique_suffix: Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
               - **true**: added.
               - **false** (default): Do not add.
               When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        :param pulumi.Input[str] ecs_zone_id: The ID of the zone.
        :param pulumi.Input[str] engine: Database type, value:
               - **alisql**
               - **tair**
               - **mssql**
               Must be consistent with the parent resource cluster engine attributes.
        :param pulumi.Input[str] image_id: The ID of the custom image.
               > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        :param pulumi.Input[str] key_pair_name: The key pair name.
        :param pulumi.Input[str] os_password: Host login password, which can be set later. The password must meet the following requirements:
               - Length is 8~30 characters.
               - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
               - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
               > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        :param pulumi.Input[str] password_inherit: Whether to use the default password of the image.
               - **false**: (default)Do not use
               - **true**: Use
               > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        :param pulumi.Input[str] payment_type: The Payment type. Currently, only **Subscription** is supported.
        :param pulumi.Input[str] period: Duration of purchase.
        :param pulumi.Input[str] period_type: The subscription type. Currently, only **Monthly** (subscription) is supported.
        :param pulumi.Input[str] security_group_id: The ID of the security group.
        :param pulumi.Input[str] vpc_id: VPCID of the VPC.
        :param pulumi.Input[str] vswitch_id: The ID of the virtual switch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedPropreHostState.__new__(_DedicatedPropreHostState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
        __props__.__dict__["ecs_class_lists"] = ecs_class_lists
        __props__.__dict__["ecs_deployment_set_id"] = ecs_deployment_set_id
        __props__.__dict__["ecs_host_name"] = ecs_host_name
        __props__.__dict__["ecs_instance_id"] = ecs_instance_id
        __props__.__dict__["ecs_instance_name"] = ecs_instance_name
        __props__.__dict__["ecs_unique_suffix"] = ecs_unique_suffix
        __props__.__dict__["ecs_zone_id"] = ecs_zone_id
        __props__.__dict__["engine"] = engine
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["os_password"] = os_password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_type"] = period_type
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return DedicatedPropreHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to enable automatic renewal. Valid values:
        - **true**: On
        - **false** (default): Off
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Output[str]:
        """
        You have a dedicated cluster ID.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @property
    @pulumi.getter(name="ecsClassLists")
    def ecs_class_lists(self) -> pulumi.Output[Sequence['outputs.DedicatedPropreHostEcsClassList']]:
        """
        ECS specifications. See `ecs_class_list` below.
        """
        return pulumi.get(self, "ecs_class_lists")

    @property
    @pulumi.getter(name="ecsDeploymentSetId")
    def ecs_deployment_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the cloud server deployment set.
        """
        return pulumi.get(self, "ecs_deployment_set_id")

    @property
    @pulumi.getter(name="ecsHostName")
    def ecs_host_name(self) -> pulumi.Output[Optional[str]]:
        """
        Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers.Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
        """
        return pulumi.get(self, "ecs_host_name")

    @property
    @pulumi.getter(name="ecsInstanceId")
    def ecs_instance_id(self) -> pulumi.Output[str]:
        """
        ECS instance ID.
        """
        return pulumi.get(self, "ecs_instance_id")

    @property
    @pulumi.getter(name="ecsInstanceName")
    def ecs_instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "ecs_instance_name")

    @property
    @pulumi.getter(name="ecsUniqueSuffix")
    def ecs_unique_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
        - **true**: added.
        - **false** (default): Do not add.
        When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
        """
        return pulumi.get(self, "ecs_unique_suffix")

    @property
    @pulumi.getter(name="ecsZoneId")
    def ecs_zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "ecs_zone_id")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Database type, value:
        - **alisql**
        - **tair**
        - **mssql**
        Must be consistent with the parent resource cluster engine attributes.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the custom image.
        > **NOTE:**  If you need to use the default image, you do not need to fill it in.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The key pair name.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="osPassword")
    def os_password(self) -> pulumi.Output[Optional[str]]:
        """
        Host login password, which can be set later. The password must meet the following requirements:
        - Length is 8~30 characters.
        - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
        - Special symbol '()\\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
        > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
        """
        return pulumi.get(self, "os_password")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to use the default password of the image.
        - **false**: (default)Do not use
        - **true**: Use
        > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
        """
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The Payment type. Currently, only **Subscription** is supported.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        Duration of purchase.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> pulumi.Output[Optional[str]]:
        """
        The subscription type. Currently, only **Monthly** (subscription) is supported.
        """
        return pulumi.get(self, "period_type")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPCID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of the virtual switch.
        """
        return pulumi.get(self, "vswitch_id")

