# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FcTriggerArgs', 'FcTrigger']

@pulumi.input_type
class FcTriggerArgs:
    def __init__(__self__, *,
                 event_meta_name: pulumi.Input[str],
                 event_meta_version: pulumi.Input[str],
                 notes: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 source_arn: pulumi.Input[str],
                 trigger_arn: pulumi.Input[str],
                 function_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FcTrigger resource.
        :param pulumi.Input[str] event_meta_name: The name of the Event.
        :param pulumi.Input[str] event_meta_version: The version of the Event.
        :param pulumi.Input[str] notes: The Note information.
        :param pulumi.Input[str] role_arn: The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        :param pulumi.Input[str] source_arn: Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] trigger_arn: The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        :param pulumi.Input[str] function_arn: The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        """
        pulumi.set(__self__, "event_meta_name", event_meta_name)
        pulumi.set(__self__, "event_meta_version", event_meta_version)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "source_arn", source_arn)
        pulumi.set(__self__, "trigger_arn", trigger_arn)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventMetaName")
    def event_meta_name(self) -> pulumi.Input[str]:
        """
        The name of the Event.
        """
        return pulumi.get(self, "event_meta_name")

    @event_meta_name.setter
    def event_meta_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_meta_name", value)

    @property
    @pulumi.getter(name="eventMetaVersion")
    def event_meta_version(self) -> pulumi.Input[str]:
        """
        The version of the Event.
        """
        return pulumi.get(self, "event_meta_version")

    @event_meta_version.setter
    def event_meta_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_meta_version", value)

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Input[str]:
        """
        The Note information.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: pulumi.Input[str]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Input[str]:
        """
        Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="triggerArn")
    def trigger_arn(self) -> pulumi.Input[str]:
        """
        The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        return pulumi.get(self, "trigger_arn")

    @trigger_arn.setter
    def trigger_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger_arn", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_arn", value)


@pulumi.input_type
class _FcTriggerState:
    def __init__(__self__, *,
                 event_meta_name: Optional[pulumi.Input[str]] = None,
                 event_meta_version: Optional[pulumi.Input[str]] = None,
                 function_arn: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 trigger_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FcTrigger resources.
        :param pulumi.Input[str] event_meta_name: The name of the Event.
        :param pulumi.Input[str] event_meta_version: The version of the Event.
        :param pulumi.Input[str] function_arn: The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] notes: The Note information.
        :param pulumi.Input[str] role_arn: The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        :param pulumi.Input[str] source_arn: Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] trigger_arn: The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        if event_meta_name is not None:
            pulumi.set(__self__, "event_meta_name", event_meta_name)
        if event_meta_version is not None:
            pulumi.set(__self__, "event_meta_version", event_meta_version)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if trigger_arn is not None:
            pulumi.set(__self__, "trigger_arn", trigger_arn)

    @property
    @pulumi.getter(name="eventMetaName")
    def event_meta_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Event.
        """
        return pulumi.get(self, "event_meta_name")

    @event_meta_name.setter
    def event_meta_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_meta_name", value)

    @property
    @pulumi.getter(name="eventMetaVersion")
    def event_meta_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Event.
        """
        return pulumi.get(self, "event_meta_version")

    @event_meta_version.setter
    def event_meta_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_meta_version", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        The Note information.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="triggerArn")
    def trigger_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        return pulumi.get(self, "trigger_arn")

    @trigger_arn.setter
    def trigger_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_arn", value)


class FcTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_meta_name: Optional[pulumi.Input[str]] = None,
                 event_meta_version: Optional[pulumi.Input[str]] = None,
                 function_arn: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 trigger_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CDN Fc Trigger resource.

        For information about CDN Fc Trigger and how to use it, see [What is Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger).

        > **NOTE:** Available in v1.165.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        example = alicloud.cdn.FcTrigger("example",
            event_meta_name="LogFileCreated",
            event_meta_version="1.0.0",
            notes="example_value",
            role_arn=f"acs:ram::{default_account.id}:role/aliyuncdneventnotificationrole",
            source_arn=f"acs:cdn:*:{default_account.id}:domain/example.com",
            trigger_arn=f"acs:fc:{default_regions.regions[0].id}:{default_account.id}:services/FCTestService/functions/printEvent/triggers/testtrigger")
        ```

        ## Import

        CDN Fc Trigger can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cdn/fcTrigger:FcTrigger example <trigger_arn>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_meta_name: The name of the Event.
        :param pulumi.Input[str] event_meta_version: The version of the Event.
        :param pulumi.Input[str] function_arn: The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] notes: The Note information.
        :param pulumi.Input[str] role_arn: The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        :param pulumi.Input[str] source_arn: Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] trigger_arn: The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FcTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CDN Fc Trigger resource.

        For information about CDN Fc Trigger and how to use it, see [What is Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger).

        > **NOTE:** Available in v1.165.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        example = alicloud.cdn.FcTrigger("example",
            event_meta_name="LogFileCreated",
            event_meta_version="1.0.0",
            notes="example_value",
            role_arn=f"acs:ram::{default_account.id}:role/aliyuncdneventnotificationrole",
            source_arn=f"acs:cdn:*:{default_account.id}:domain/example.com",
            trigger_arn=f"acs:fc:{default_regions.regions[0].id}:{default_account.id}:services/FCTestService/functions/printEvent/triggers/testtrigger")
        ```

        ## Import

        CDN Fc Trigger can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cdn/fcTrigger:FcTrigger example <trigger_arn>
        ```

        :param str resource_name: The name of the resource.
        :param FcTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FcTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_meta_name: Optional[pulumi.Input[str]] = None,
                 event_meta_version: Optional[pulumi.Input[str]] = None,
                 function_arn: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 trigger_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FcTriggerArgs.__new__(FcTriggerArgs)

            if event_meta_name is None and not opts.urn:
                raise TypeError("Missing required property 'event_meta_name'")
            __props__.__dict__["event_meta_name"] = event_meta_name
            if event_meta_version is None and not opts.urn:
                raise TypeError("Missing required property 'event_meta_version'")
            __props__.__dict__["event_meta_version"] = event_meta_version
            __props__.__dict__["function_arn"] = function_arn
            if notes is None and not opts.urn:
                raise TypeError("Missing required property 'notes'")
            __props__.__dict__["notes"] = notes
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if source_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_arn'")
            __props__.__dict__["source_arn"] = source_arn
            if trigger_arn is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_arn'")
            __props__.__dict__["trigger_arn"] = trigger_arn
        super(FcTrigger, __self__).__init__(
            'alicloud:cdn/fcTrigger:FcTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            event_meta_name: Optional[pulumi.Input[str]] = None,
            event_meta_version: Optional[pulumi.Input[str]] = None,
            function_arn: Optional[pulumi.Input[str]] = None,
            notes: Optional[pulumi.Input[str]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            source_arn: Optional[pulumi.Input[str]] = None,
            trigger_arn: Optional[pulumi.Input[str]] = None) -> 'FcTrigger':
        """
        Get an existing FcTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_meta_name: The name of the Event.
        :param pulumi.Input[str] event_meta_version: The version of the Event.
        :param pulumi.Input[str] function_arn: The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] notes: The Note information.
        :param pulumi.Input[str] role_arn: The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        :param pulumi.Input[str] source_arn: Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        :param pulumi.Input[str] trigger_arn: The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FcTriggerState.__new__(_FcTriggerState)

        __props__.__dict__["event_meta_name"] = event_meta_name
        __props__.__dict__["event_meta_version"] = event_meta_version
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["notes"] = notes
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["trigger_arn"] = trigger_arn
        return FcTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventMetaName")
    def event_meta_name(self) -> pulumi.Output[str]:
        """
        The name of the Event.
        """
        return pulumi.get(self, "event_meta_name")

    @property
    @pulumi.getter(name="eventMetaVersion")
    def event_meta_version(self) -> pulumi.Output[str]:
        """
        The version of the Event.
        """
        return pulumi.get(self, "event_meta_version")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[str]:
        """
        The Note information.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[str]:
        """
        Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="triggerArn")
    def trigger_arn(self) -> pulumi.Output[str]:
        """
        The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
        """
        return pulumi.get(self, "trigger_arn")

