# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInterRegionTrafficQosQueuesResult',
    'AwaitableGetInterRegionTrafficQosQueuesResult',
    'get_inter_region_traffic_qos_queues',
    'get_inter_region_traffic_qos_queues_output',
]

@pulumi.output_type
class GetInterRegionTrafficQosQueuesResult:
    """
    A collection of values returned by getInterRegionTrafficQosQueues.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, queues=None, traffic_qos_policy_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if queues and not isinstance(queues, list):
            raise TypeError("Expected argument 'queues' to be a list")
        pulumi.set(__self__, "queues", queues)
        if traffic_qos_policy_id and not isinstance(traffic_qos_policy_id, str):
            raise TypeError("Expected argument 'traffic_qos_policy_id' to be a str")
        pulumi.set(__self__, "traffic_qos_policy_id", traffic_qos_policy_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of Inter Region Traffic Qos Queue IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of name of Inter Region Traffic Qos Queues.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def queues(self) -> Sequence['outputs.GetInterRegionTrafficQosQueuesQueueResult']:
        """
        A list of Inter Region Traffic Qos Queue Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> str:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")


class AwaitableGetInterRegionTrafficQosQueuesResult(GetInterRegionTrafficQosQueuesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInterRegionTrafficQosQueuesResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            queues=self.queues,
            traffic_qos_policy_id=self.traffic_qos_policy_id)


def get_inter_region_traffic_qos_queues(ids: Optional[Sequence[str]] = None,
                                        name_regex: Optional[str] = None,
                                        output_file: Optional[str] = None,
                                        traffic_qos_policy_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInterRegionTrafficQosQueuesResult:
    """
    This data source provides Cen Inter Region Traffic Qos Queue available to the user.

    > **NOTE:** Available in 1.195.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_inter_region_traffic_qos_queues(ids=[alicloud_cen_inter_region_traffic_qos_queue["default"]["id"]],
        name_regex=alicloud_cen_inter_region_traffic_qos_queue["default"]["name"],
        traffic_qos_policy_id="qos-xxxxxxx")
    pulumi.export("alicloudCenInterRegionTrafficQosQueueExampleId", default.queues[0].id)
    ```


    :param Sequence[str] ids: A list of Inter Region Traffic Qos Queue IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str traffic_qos_policy_id: The ID of the traffic scheduling policy.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['trafficQosPolicyId'] = traffic_qos_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getInterRegionTrafficQosQueues:getInterRegionTrafficQosQueues', __args__, opts=opts, typ=GetInterRegionTrafficQosQueuesResult).value

    return AwaitableGetInterRegionTrafficQosQueuesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        queues=pulumi.get(__ret__, 'queues'),
        traffic_qos_policy_id=pulumi.get(__ret__, 'traffic_qos_policy_id'))


@_utilities.lift_output_func(get_inter_region_traffic_qos_queues)
def get_inter_region_traffic_qos_queues_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                               name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                               output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                               traffic_qos_policy_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInterRegionTrafficQosQueuesResult]:
    """
    This data source provides Cen Inter Region Traffic Qos Queue available to the user.

    > **NOTE:** Available in 1.195.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_inter_region_traffic_qos_queues(ids=[alicloud_cen_inter_region_traffic_qos_queue["default"]["id"]],
        name_regex=alicloud_cen_inter_region_traffic_qos_queue["default"]["name"],
        traffic_qos_policy_id="qos-xxxxxxx")
    pulumi.export("alicloudCenInterRegionTrafficQosQueueExampleId", default.queues[0].id)
    ```


    :param Sequence[str] ids: A list of Inter Region Traffic Qos Queue IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str traffic_qos_policy_id: The ID of the traffic scheduling policy.
    """
    ...
