# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteMapsResult',
    'AwaitableGetRouteMapsResult',
    'get_route_maps',
    'get_route_maps_output',
]

@pulumi.output_type
class GetRouteMapsResult:
    """
    A collection of values returned by getRouteMaps.
    """
    def __init__(__self__, cen_id=None, cen_region_id=None, description_regex=None, id=None, ids=None, maps=None, output_file=None, status=None, transmit_direction=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if cen_region_id and not isinstance(cen_region_id, str):
            raise TypeError("Expected argument 'cen_region_id' to be a str")
        pulumi.set(__self__, "cen_region_id", cen_region_id)
        if description_regex and not isinstance(description_regex, str):
            raise TypeError("Expected argument 'description_regex' to be a str")
        pulumi.set(__self__, "description_regex", description_regex)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if maps and not isinstance(maps, list):
            raise TypeError("Expected argument 'maps' to be a list")
        pulumi.set(__self__, "maps", maps)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transmit_direction and not isinstance(transmit_direction, str):
            raise TypeError("Expected argument 'transmit_direction' to be a str")
        pulumi.set(__self__, "transmit_direction", transmit_direction)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cenRegionId")
    def cen_region_id(self) -> Optional[str]:
        """
        The ID of the region to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_region_id")

    @property
    @pulumi.getter(name="descriptionRegex")
    def description_regex(self) -> Optional[str]:
        return pulumi.get(self, "description_regex")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`. Before 1.161.0, its element is `route_map_id`.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def maps(self) -> Sequence['outputs.GetRouteMapsMapResult']:
        """
        A list of CEN instances. Each element contains the following attributes:
        """
        return pulumi.get(self, "maps")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the route map.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transmitDirection")
    def transmit_direction(self) -> Optional[str]:
        """
        The direction in which the route map is applied.
        """
        return pulumi.get(self, "transmit_direction")


class AwaitableGetRouteMapsResult(GetRouteMapsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteMapsResult(
            cen_id=self.cen_id,
            cen_region_id=self.cen_region_id,
            description_regex=self.description_regex,
            id=self.id,
            ids=self.ids,
            maps=self.maps,
            output_file=self.output_file,
            status=self.status,
            transmit_direction=self.transmit_direction)


def get_route_maps(cen_id: Optional[str] = None,
                   cen_region_id: Optional[str] = None,
                   description_regex: Optional[str] = None,
                   ids: Optional[Sequence[str]] = None,
                   output_file: Optional[str] = None,
                   status: Optional[str] = None,
                   transmit_direction: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteMapsResult:
    """
    This data source provides CEN Route Maps available to the user.

    > **NOTE:** Available in v1.87.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    this = alicloud.cen.get_route_maps(cen_id="cen-ihdlgo87ai********",
        ids=["cen-ihdlgo87ai:cenrmap-bnh97kb3mn********"],
        description_regex="datasource_test",
        cen_region_id="cn-hangzhou",
        transmit_direction="RegionIn",
        status="Active")
    pulumi.export("firstCenRouteMapId", this.maps[0].route_map_id)
    ```


    :param str cen_id: The ID of the CEN instance.
    :param str cen_region_id: The ID of the region to which the CEN instance belongs.
    :param str description_regex: A regex string to filter CEN route map by description.
    :param Sequence[str] ids: A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the route map, including `Creating`, `Active` and `Deleting`.
    :param str transmit_direction: The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['cenRegionId'] = cen_region_id
    __args__['descriptionRegex'] = description_regex
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transmitDirection'] = transmit_direction
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getRouteMaps:getRouteMaps', __args__, opts=opts, typ=GetRouteMapsResult).value

    return AwaitableGetRouteMapsResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        cen_region_id=pulumi.get(__ret__, 'cen_region_id'),
        description_regex=pulumi.get(__ret__, 'description_regex'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        maps=pulumi.get(__ret__, 'maps'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        transmit_direction=pulumi.get(__ret__, 'transmit_direction'))


@_utilities.lift_output_func(get_route_maps)
def get_route_maps_output(cen_id: Optional[pulumi.Input[str]] = None,
                          cen_region_id: Optional[pulumi.Input[Optional[str]]] = None,
                          description_regex: Optional[pulumi.Input[Optional[str]]] = None,
                          ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          output_file: Optional[pulumi.Input[Optional[str]]] = None,
                          status: Optional[pulumi.Input[Optional[str]]] = None,
                          transmit_direction: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRouteMapsResult]:
    """
    This data source provides CEN Route Maps available to the user.

    > **NOTE:** Available in v1.87.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    this = alicloud.cen.get_route_maps(cen_id="cen-ihdlgo87ai********",
        ids=["cen-ihdlgo87ai:cenrmap-bnh97kb3mn********"],
        description_regex="datasource_test",
        cen_region_id="cn-hangzhou",
        transmit_direction="RegionIn",
        status="Active")
    pulumi.export("firstCenRouteMapId", this.maps[0].route_map_id)
    ```


    :param str cen_id: The ID of the CEN instance.
    :param str cen_region_id: The ID of the region to which the CEN instance belongs.
    :param str description_regex: A regex string to filter CEN route map by description.
    :param Sequence[str] ids: A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the route map, including `Creating`, `Active` and `Deleting`.
    :param str transmit_direction: The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
    """
    ...
