# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterCidrsResult',
    'AwaitableGetTransitRouterCidrsResult',
    'get_transit_router_cidrs',
    'get_transit_router_cidrs_output',
]

@pulumi.output_type
class GetTransitRouterCidrsResult:
    """
    A collection of values returned by getTransitRouterCidrs.
    """
    def __init__(__self__, cidrs=None, id=None, ids=None, name_regex=None, names=None, output_file=None, transit_router_cidr_id=None, transit_router_id=None):
        if cidrs and not isinstance(cidrs, list):
            raise TypeError("Expected argument 'cidrs' to be a list")
        pulumi.set(__self__, "cidrs", cidrs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if transit_router_cidr_id and not isinstance(transit_router_cidr_id, str):
            raise TypeError("Expected argument 'transit_router_cidr_id' to be a str")
        pulumi.set(__self__, "transit_router_cidr_id", transit_router_cidr_id)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence['outputs.GetTransitRouterCidrsCidrResult']:
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="transitRouterCidrId")
    def transit_router_cidr_id(self) -> Optional[str]:
        return pulumi.get(self, "transit_router_cidr_id")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        return pulumi.get(self, "transit_router_id")


class AwaitableGetTransitRouterCidrsResult(GetTransitRouterCidrsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterCidrsResult(
            cidrs=self.cidrs,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            transit_router_cidr_id=self.transit_router_cidr_id,
            transit_router_id=self.transit_router_id)


def get_transit_router_cidrs(ids: Optional[Sequence[str]] = None,
                             name_regex: Optional[str] = None,
                             output_file: Optional[str] = None,
                             transit_router_cidr_id: Optional[str] = None,
                             transit_router_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterCidrsResult:
    """
    This data source provides the Cen Transit Router Cidrs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.193.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cen.get_transit_router_cidrs(ids=["example_id"],
        transit_router_id="tr-6ehx7q2jze8ch5ji0****")
    pulumi.export("cenTransitRouterCidrId0", ids.cidrs[0].id)
    name_regex = alicloud.cen.get_transit_router_cidrs(name_regex="^my-name",
        transit_router_id="tr-6ehx7q2jze8ch5ji0****")
    pulumi.export("cenTransitRouterCidrId1", name_regex.cidrs[0].id)
    ```


    :param Sequence[str] ids: A list of Cen Transit Router Cidr IDs.
    :param str name_regex: A regex string to filter results by Transit Router Cidr name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str transit_router_cidr_id: The ID of the transit router cidr.
    :param str transit_router_id: The ID of the transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['transitRouterCidrId'] = transit_router_cidr_id
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterCidrs:getTransitRouterCidrs', __args__, opts=opts, typ=GetTransitRouterCidrsResult).value

    return AwaitableGetTransitRouterCidrsResult(
        cidrs=pulumi.get(__ret__, 'cidrs'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        transit_router_cidr_id=pulumi.get(__ret__, 'transit_router_cidr_id'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))


@_utilities.lift_output_func(get_transit_router_cidrs)
def get_transit_router_cidrs_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                    transit_router_cidr_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    transit_router_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransitRouterCidrsResult]:
    """
    This data source provides the Cen Transit Router Cidrs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.193.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cen.get_transit_router_cidrs(ids=["example_id"],
        transit_router_id="tr-6ehx7q2jze8ch5ji0****")
    pulumi.export("cenTransitRouterCidrId0", ids.cidrs[0].id)
    name_regex = alicloud.cen.get_transit_router_cidrs(name_regex="^my-name",
        transit_router_id="tr-6ehx7q2jze8ch5ji0****")
    pulumi.export("cenTransitRouterCidrId1", name_regex.cidrs[0].id)
    ```


    :param Sequence[str] ids: A list of Cen Transit Router Cidr IDs.
    :param str name_regex: A regex string to filter results by Transit Router Cidr name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str transit_router_cidr_id: The ID of the transit router cidr.
    :param str transit_router_id: The ID of the transit router.
    """
    ...
