# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterMulticastDomainMembersResult',
    'AwaitableGetTransitRouterMulticastDomainMembersResult',
    'get_transit_router_multicast_domain_members',
    'get_transit_router_multicast_domain_members_output',
]

@pulumi.output_type
class GetTransitRouterMulticastDomainMembersResult:
    """
    A collection of values returned by getTransitRouterMulticastDomainMembers.
    """
    def __init__(__self__, id=None, ids=None, members=None, network_interface_id=None, output_file=None, transit_router_multicast_domain_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if transit_router_multicast_domain_id and not isinstance(transit_router_multicast_domain_id, str):
            raise TypeError("Expected argument 'transit_router_multicast_domain_id' to be a str")
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetTransitRouterMulticastDomainMembersMemberResult']:
        """
        A list of Transit Router Multicast Domain Member Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[str]:
        """
        ENI ID of multicast member.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")


class AwaitableGetTransitRouterMulticastDomainMembersResult(GetTransitRouterMulticastDomainMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterMulticastDomainMembersResult(
            id=self.id,
            ids=self.ids,
            members=self.members,
            network_interface_id=self.network_interface_id,
            output_file=self.output_file,
            transit_router_multicast_domain_id=self.transit_router_multicast_domain_id)


def get_transit_router_multicast_domain_members(ids: Optional[Sequence[str]] = None,
                                                network_interface_id: Optional[str] = None,
                                                output_file: Optional[str] = None,
                                                transit_router_multicast_domain_id: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterMulticastDomainMembersResult:
    """
    This data source provides Cen Transit Router Multicast Domain Member available to the user. [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_multicast_domain_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfr29")
    pulumi.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default.members[0].id)
    ```


    :param Sequence[str] ids: A list of Transit Router Multicast Domain Member IDs.
    :param str network_interface_id: The ID of the ENI.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['networkInterfaceId'] = network_interface_id
    __args__['outputFile'] = output_file
    __args__['transitRouterMulticastDomainId'] = transit_router_multicast_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterMulticastDomainMembers:getTransitRouterMulticastDomainMembers', __args__, opts=opts, typ=GetTransitRouterMulticastDomainMembersResult).value

    return AwaitableGetTransitRouterMulticastDomainMembersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        members=pulumi.get(__ret__, 'members'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        transit_router_multicast_domain_id=pulumi.get(__ret__, 'transit_router_multicast_domain_id'))


@_utilities.lift_output_func(get_transit_router_multicast_domain_members)
def get_transit_router_multicast_domain_members_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                       network_interface_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                                       transit_router_multicast_domain_id: Optional[pulumi.Input[str]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransitRouterMulticastDomainMembersResult]:
    """
    This data source provides Cen Transit Router Multicast Domain Member available to the user. [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_multicast_domain_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfr29")
    pulumi.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default.members[0].id)
    ```


    :param Sequence[str] ids: A list of Transit Router Multicast Domain Member IDs.
    :param str network_interface_id: The ID of the ENI.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
    """
    ...
