# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterPrefixListAssociationsResult',
    'AwaitableGetTransitRouterPrefixListAssociationsResult',
    'get_transit_router_prefix_list_associations',
    'get_transit_router_prefix_list_associations_output',
]

@pulumi.output_type
class GetTransitRouterPrefixListAssociationsResult:
    """
    A collection of values returned by getTransitRouterPrefixListAssociations.
    """
    def __init__(__self__, associations=None, id=None, ids=None, output_file=None, owner_uid=None, page_number=None, page_size=None, prefix_list_id=None, status=None, transit_router_id=None, transit_router_table_id=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if owner_uid and not isinstance(owner_uid, int):
            raise TypeError("Expected argument 'owner_uid' to be a int")
        pulumi.set(__self__, "owner_uid", owner_uid)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if prefix_list_id and not isinstance(prefix_list_id, str):
            raise TypeError("Expected argument 'prefix_list_id' to be a str")
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_table_id and not isinstance(transit_router_table_id, str):
            raise TypeError("Expected argument 'transit_router_table_id' to be a str")
        pulumi.set(__self__, "transit_router_table_id", transit_router_table_id)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetTransitRouterPrefixListAssociationsAssociationResult']:
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> Optional[int]:
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[str]:
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterTableId")
    def transit_router_table_id(self) -> str:
        return pulumi.get(self, "transit_router_table_id")


class AwaitableGetTransitRouterPrefixListAssociationsResult(GetTransitRouterPrefixListAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterPrefixListAssociationsResult(
            associations=self.associations,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            owner_uid=self.owner_uid,
            page_number=self.page_number,
            page_size=self.page_size,
            prefix_list_id=self.prefix_list_id,
            status=self.status,
            transit_router_id=self.transit_router_id,
            transit_router_table_id=self.transit_router_table_id)


def get_transit_router_prefix_list_associations(ids: Optional[Sequence[str]] = None,
                                                output_file: Optional[str] = None,
                                                owner_uid: Optional[int] = None,
                                                page_number: Optional[int] = None,
                                                page_size: Optional[int] = None,
                                                prefix_list_id: Optional[str] = None,
                                                status: Optional[str] = None,
                                                transit_router_id: Optional[str] = None,
                                                transit_router_table_id: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterPrefixListAssociationsResult:
    """
    This data source provides the Cen Transit Router Prefix List Associations of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.188.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_prefix_list_associations(transit_router_id="tr-6ehx7q2jze8ch5ji0****",
        transit_router_table_id="vtb-6ehgc262hr170qgyc****")
    pulumi.export("cenTransitRouterPrefixListAssociationId", default.associations[0].id)
    ```


    :param Sequence[str] ids: A list of Cen Transit Router Prefix List Association IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int owner_uid: The ID of the Alibaba Cloud account to which the prefix list belongs.
    :param str prefix_list_id: The ID of the prefix list.
    :param str status: The status of the prefix list.
    :param str transit_router_id: The ID of the transit router.
    :param str transit_router_table_id: The ID of the route table of the transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['ownerUid'] = owner_uid
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['prefixListId'] = prefix_list_id
    __args__['status'] = status
    __args__['transitRouterId'] = transit_router_id
    __args__['transitRouterTableId'] = transit_router_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterPrefixListAssociations:getTransitRouterPrefixListAssociations', __args__, opts=opts, typ=GetTransitRouterPrefixListAssociationsResult).value

    return AwaitableGetTransitRouterPrefixListAssociationsResult(
        associations=pulumi.get(__ret__, 'associations'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        owner_uid=pulumi.get(__ret__, 'owner_uid'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        prefix_list_id=pulumi.get(__ret__, 'prefix_list_id'),
        status=pulumi.get(__ret__, 'status'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'),
        transit_router_table_id=pulumi.get(__ret__, 'transit_router_table_id'))


@_utilities.lift_output_func(get_transit_router_prefix_list_associations)
def get_transit_router_prefix_list_associations_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                                       owner_uid: Optional[pulumi.Input[Optional[int]]] = None,
                                                       page_number: Optional[pulumi.Input[Optional[int]]] = None,
                                                       page_size: Optional[pulumi.Input[Optional[int]]] = None,
                                                       prefix_list_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                       status: Optional[pulumi.Input[Optional[str]]] = None,
                                                       transit_router_id: Optional[pulumi.Input[str]] = None,
                                                       transit_router_table_id: Optional[pulumi.Input[str]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransitRouterPrefixListAssociationsResult]:
    """
    This data source provides the Cen Transit Router Prefix List Associations of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.188.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_prefix_list_associations(transit_router_id="tr-6ehx7q2jze8ch5ji0****",
        transit_router_table_id="vtb-6ehgc262hr170qgyc****")
    pulumi.export("cenTransitRouterPrefixListAssociationId", default.associations[0].id)
    ```


    :param Sequence[str] ids: A list of Cen Transit Router Prefix List Association IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int owner_uid: The ID of the Alibaba Cloud account to which the prefix list belongs.
    :param str prefix_list_id: The ID of the prefix list.
    :param str status: The status of the prefix list.
    :param str transit_router_id: The ID of the transit router.
    :param str transit_router_table_id: The ID of the route table of the transit router.
    """
    ...
