# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InterRegionTrafficQosQueueArgs', 'InterRegionTrafficQosQueue']

@pulumi.input_type
class InterRegionTrafficQosQueueArgs:
    def __init__(__self__, *,
                 dscps: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remain_bandwidth_percent: pulumi.Input[int],
                 traffic_qos_policy_id: pulumi.Input[str],
                 inter_region_traffic_qos_queue_description: Optional[pulumi.Input[str]] = None,
                 inter_region_traffic_qos_queue_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InterRegionTrafficQosQueue resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param pulumi.Input[int] remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param pulumi.Input[str] traffic_qos_policy_id: The ID of the traffic scheduling policy.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        """
        pulumi.set(__self__, "dscps", dscps)
        pulumi.set(__self__, "remain_bandwidth_percent", remain_bandwidth_percent)
        pulumi.set(__self__, "traffic_qos_policy_id", traffic_qos_policy_id)
        if inter_region_traffic_qos_queue_description is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_queue_description", inter_region_traffic_qos_queue_description)
        if inter_region_traffic_qos_queue_name is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_queue_name", inter_region_traffic_qos_queue_name)

    @property
    @pulumi.getter
    def dscps(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        """
        return pulumi.get(self, "dscps")

    @dscps.setter
    def dscps(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dscps", value)

    @property
    @pulumi.getter(name="remainBandwidthPercent")
    def remain_bandwidth_percent(self) -> pulumi.Input[int]:
        """
        The percentage of cross-region bandwidth that the current queue can use.
        """
        return pulumi.get(self, "remain_bandwidth_percent")

    @remain_bandwidth_percent.setter
    def remain_bandwidth_percent(self, value: pulumi.Input[int]):
        pulumi.set(self, "remain_bandwidth_percent", value)

    @property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> pulumi.Input[str]:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")

    @traffic_qos_policy_id.setter
    def traffic_qos_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "traffic_qos_policy_id", value)

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueDescription")
    def inter_region_traffic_qos_queue_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_description")

    @inter_region_traffic_qos_queue_description.setter
    def inter_region_traffic_qos_queue_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inter_region_traffic_qos_queue_description", value)

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueName")
    def inter_region_traffic_qos_queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_name")

    @inter_region_traffic_qos_queue_name.setter
    def inter_region_traffic_qos_queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inter_region_traffic_qos_queue_name", value)


@pulumi.input_type
class _InterRegionTrafficQosQueueState:
    def __init__(__self__, *,
                 dscps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inter_region_traffic_qos_queue_description: Optional[pulumi.Input[str]] = None,
                 inter_region_traffic_qos_queue_name: Optional[pulumi.Input[str]] = None,
                 remain_bandwidth_percent: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 traffic_qos_policy_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InterRegionTrafficQosQueue resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        :param pulumi.Input[int] remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param pulumi.Input[str] status: The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        :param pulumi.Input[str] traffic_qos_policy_id: The ID of the traffic scheduling policy.
        """
        if dscps is not None:
            pulumi.set(__self__, "dscps", dscps)
        if inter_region_traffic_qos_queue_description is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_queue_description", inter_region_traffic_qos_queue_description)
        if inter_region_traffic_qos_queue_name is not None:
            pulumi.set(__self__, "inter_region_traffic_qos_queue_name", inter_region_traffic_qos_queue_name)
        if remain_bandwidth_percent is not None:
            pulumi.set(__self__, "remain_bandwidth_percent", remain_bandwidth_percent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traffic_qos_policy_id is not None:
            pulumi.set(__self__, "traffic_qos_policy_id", traffic_qos_policy_id)

    @property
    @pulumi.getter
    def dscps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        """
        return pulumi.get(self, "dscps")

    @dscps.setter
    def dscps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dscps", value)

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueDescription")
    def inter_region_traffic_qos_queue_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_description")

    @inter_region_traffic_qos_queue_description.setter
    def inter_region_traffic_qos_queue_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inter_region_traffic_qos_queue_description", value)

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueName")
    def inter_region_traffic_qos_queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_name")

    @inter_region_traffic_qos_queue_name.setter
    def inter_region_traffic_qos_queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inter_region_traffic_qos_queue_name", value)

    @property
    @pulumi.getter(name="remainBandwidthPercent")
    def remain_bandwidth_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of cross-region bandwidth that the current queue can use.
        """
        return pulumi.get(self, "remain_bandwidth_percent")

    @remain_bandwidth_percent.setter
    def remain_bandwidth_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remain_bandwidth_percent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")

    @traffic_qos_policy_id.setter
    def traffic_qos_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_qos_policy_id", value)


class InterRegionTrafficQosQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dscps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inter_region_traffic_qos_queue_description: Optional[pulumi.Input[str]] = None,
                 inter_region_traffic_qos_queue_name: Optional[pulumi.Input[str]] = None,
                 remain_bandwidth_percent: Optional[pulumi.Input[int]] = None,
                 traffic_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cen Inter Region Traffic Qos Queue resource.

        For information about Cen Inter Region Traffic Qos Queue and how to use it, see [What is Inter Region Traffic Qos Queue](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createceninterregiontrafficqosqueue).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_region = config.get("defaultRegion")
        if default_region is None:
            default_region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        hz = alicloud.Provider("hz", region=default_region)
        bj = alicloud.Provider("bj", region=peer_region)
        default_instance = alicloud.cen.Instance("defaultInstance",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_bandwidth_package = alicloud.cen.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China",
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            instance_id=default_instance.id,
            bandwidth_package_id=default_bandwidth_package.id,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_transit_router = alicloud.cen.TransitRouter("defaultTransitRouter",
            cen_id=default_instance.id,
            support_multicast=True,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        peer = alicloud.cen.TransitRouter("peer",
            cen_id=default_transit_router.cen_id,
            support_multicast=True,
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        default_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("defaultTransitRouterPeerAttachment",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=default_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_inter_region_traffic_qos_policy = alicloud.cen.InterRegionTrafficQosPolicy("defaultInterRegionTrafficQosPolicy",
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_attachment_id=default_transit_router_peer_attachment.transit_router_attachment_id,
            inter_region_traffic_qos_policy_name=name,
            inter_region_traffic_qos_policy_description=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_inter_region_traffic_qos_queue = alicloud.cen.InterRegionTrafficQosQueue("defaultInterRegionTrafficQosQueue",
            remain_bandwidth_percent=20,
            traffic_qos_policy_id=default_inter_region_traffic_qos_policy.id,
            dscps=[
                "1",
                "2",
            ],
            inter_region_traffic_qos_queue_description=name)
        ```

        ## Import

        Cen Inter Region Traffic Qos Queue can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/interRegionTrafficQosQueue:InterRegionTrafficQosQueue example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        :param pulumi.Input[int] remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param pulumi.Input[str] traffic_qos_policy_id: The ID of the traffic scheduling policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterRegionTrafficQosQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cen Inter Region Traffic Qos Queue resource.

        For information about Cen Inter Region Traffic Qos Queue and how to use it, see [What is Inter Region Traffic Qos Queue](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createceninterregiontrafficqosqueue).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_region = config.get("defaultRegion")
        if default_region is None:
            default_region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        hz = alicloud.Provider("hz", region=default_region)
        bj = alicloud.Provider("bj", region=peer_region)
        default_instance = alicloud.cen.Instance("defaultInstance",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_bandwidth_package = alicloud.cen.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China",
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            instance_id=default_instance.id,
            bandwidth_package_id=default_bandwidth_package.id,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_transit_router = alicloud.cen.TransitRouter("defaultTransitRouter",
            cen_id=default_instance.id,
            support_multicast=True,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        peer = alicloud.cen.TransitRouter("peer",
            cen_id=default_transit_router.cen_id,
            support_multicast=True,
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        default_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("defaultTransitRouterPeerAttachment",
            cen_id=default_instance.id,
            transit_router_id=default_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=default_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_inter_region_traffic_qos_policy = alicloud.cen.InterRegionTrafficQosPolicy("defaultInterRegionTrafficQosPolicy",
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_attachment_id=default_transit_router_peer_attachment.transit_router_attachment_id,
            inter_region_traffic_qos_policy_name=name,
            inter_region_traffic_qos_policy_description=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        default_inter_region_traffic_qos_queue = alicloud.cen.InterRegionTrafficQosQueue("defaultInterRegionTrafficQosQueue",
            remain_bandwidth_percent=20,
            traffic_qos_policy_id=default_inter_region_traffic_qos_policy.id,
            dscps=[
                "1",
                "2",
            ],
            inter_region_traffic_qos_queue_description=name)
        ```

        ## Import

        Cen Inter Region Traffic Qos Queue can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/interRegionTrafficQosQueue:InterRegionTrafficQosQueue example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InterRegionTrafficQosQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterRegionTrafficQosQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dscps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 inter_region_traffic_qos_queue_description: Optional[pulumi.Input[str]] = None,
                 inter_region_traffic_qos_queue_name: Optional[pulumi.Input[str]] = None,
                 remain_bandwidth_percent: Optional[pulumi.Input[int]] = None,
                 traffic_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterRegionTrafficQosQueueArgs.__new__(InterRegionTrafficQosQueueArgs)

            if dscps is None and not opts.urn:
                raise TypeError("Missing required property 'dscps'")
            __props__.__dict__["dscps"] = dscps
            __props__.__dict__["inter_region_traffic_qos_queue_description"] = inter_region_traffic_qos_queue_description
            __props__.__dict__["inter_region_traffic_qos_queue_name"] = inter_region_traffic_qos_queue_name
            if remain_bandwidth_percent is None and not opts.urn:
                raise TypeError("Missing required property 'remain_bandwidth_percent'")
            __props__.__dict__["remain_bandwidth_percent"] = remain_bandwidth_percent
            if traffic_qos_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_qos_policy_id'")
            __props__.__dict__["traffic_qos_policy_id"] = traffic_qos_policy_id
            __props__.__dict__["status"] = None
        super(InterRegionTrafficQosQueue, __self__).__init__(
            'alicloud:cen/interRegionTrafficQosQueue:InterRegionTrafficQosQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dscps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            inter_region_traffic_qos_queue_description: Optional[pulumi.Input[str]] = None,
            inter_region_traffic_qos_queue_name: Optional[pulumi.Input[str]] = None,
            remain_bandwidth_percent: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            traffic_qos_policy_id: Optional[pulumi.Input[str]] = None) -> 'InterRegionTrafficQosQueue':
        """
        Get an existing InterRegionTrafficQosQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param pulumi.Input[str] inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        :param pulumi.Input[int] remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param pulumi.Input[str] status: The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        :param pulumi.Input[str] traffic_qos_policy_id: The ID of the traffic scheduling policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterRegionTrafficQosQueueState.__new__(_InterRegionTrafficQosQueueState)

        __props__.__dict__["dscps"] = dscps
        __props__.__dict__["inter_region_traffic_qos_queue_description"] = inter_region_traffic_qos_queue_description
        __props__.__dict__["inter_region_traffic_qos_queue_name"] = inter_region_traffic_qos_queue_name
        __props__.__dict__["remain_bandwidth_percent"] = remain_bandwidth_percent
        __props__.__dict__["status"] = status
        __props__.__dict__["traffic_qos_policy_id"] = traffic_qos_policy_id
        return InterRegionTrafficQosQueue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dscps(self) -> pulumi.Output[Sequence[str]]:
        """
        The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        """
        return pulumi.get(self, "dscps")

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueDescription")
    def inter_region_traffic_qos_queue_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_description")

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueName")
    def inter_region_traffic_qos_queue_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_name")

    @property
    @pulumi.getter(name="remainBandwidthPercent")
    def remain_bandwidth_percent(self) -> pulumi.Output[int]:
        """
        The percentage of cross-region bandwidth that the current queue can use.
        """
        return pulumi.get(self, "remain_bandwidth_percent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")

