# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'TransitRouterVpcAttachmentZoneMapping',
    'TransitRouterVpnAttachmentZone',
    'GetBandwidthLimitsLimitResult',
    'GetBandwidthPackagesPackageResult',
    'GetChildInstanceRouteEntryToAttachmentsAttachmentResult',
    'GetFlowlogsFlowlogResult',
    'GetInstanceAttachmentsAttachmentResult',
    'GetInstancesInstanceResult',
    'GetInterRegionTrafficQosPoliciesPolicyResult',
    'GetInterRegionTrafficQosQueuesQueueResult',
    'GetPrivateZonesZoneResult',
    'GetRegionRouteEntriesEntryResult',
    'GetRouteEntriesEntryResult',
    'GetRouteEntriesEntryConflictResult',
    'GetRouteMapsMapResult',
    'GetRouteServicesServiceResult',
    'GetTrafficMarkingPoliciesPolicyResult',
    'GetTransitRouteTableAggregationsTransitRouteTableAggregationResult',
    'GetTransitRouterAvailableResourcesResourceResult',
    'GetTransitRouterCidrsCidrResult',
    'GetTransitRouterMulticastDomainAssociationsAssociationResult',
    'GetTransitRouterMulticastDomainMembersMemberResult',
    'GetTransitRouterMulticastDomainPeerMembersMemberResult',
    'GetTransitRouterMulticastDomainSourcesSourceResult',
    'GetTransitRouterMulticastDomainsDomainResult',
    'GetTransitRouterPeerAttachmentsAttachmentResult',
    'GetTransitRouterPrefixListAssociationsAssociationResult',
    'GetTransitRouterRouteEntriesEntryResult',
    'GetTransitRouterRouteTableAssociationsAssociationResult',
    'GetTransitRouterRouteTablePropagationsPropagationResult',
    'GetTransitRouterRouteTablesTableResult',
    'GetTransitRouterVbrAttachmentsAttachmentResult',
    'GetTransitRouterVpcAttachmentsAttachmentResult',
    'GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult',
    'GetTransitRouterVpnAttachmentsAttachmentResult',
    'GetTransitRouterVpnAttachmentsAttachmentZoneResult',
    'GetTransitRoutersTransitRouterResult',
    'GetVbrHealthChecksCheckResult',
]

@pulumi.output_type
class TransitRouterVpcAttachmentZoneMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterVpcAttachmentZoneMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterVpcAttachmentZoneMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterVpcAttachmentZoneMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: Optional[str] = None,
                 zone_id: Optional[str] = None):
        """
        :param str vswitch_id: The VSwitch id of attachment.
        :param str zone_id: The zone Id of VSwitch.
        """
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The VSwitch id of attachment.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The zone Id of VSwitch.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class TransitRouterVpnAttachmentZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterVpnAttachmentZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterVpnAttachmentZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterVpnAttachmentZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 zone_id: str):
        """
        :param str zone_id: The id of the zone.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetBandwidthLimitsLimitResult(dict):
    def __init__(__self__, *,
                 bandwidth_limit: int,
                 instance_id: str,
                 local_region_id: str,
                 opposite_region_id: str,
                 status: str):
        """
        :param int bandwidth_limit: The bandwidth limit configured for the interconnected regions communication.
        :param str instance_id: ID of the CEN instance.
        :param str local_region_id: ID of local region.
        :param str opposite_region_id: ID of opposite region.
        :param str status: Status of the CEN Bandwidth Limit, including "Active" and "Modifying".
        """
        pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "local_region_id", local_region_id)
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> int:
        """
        The bandwidth limit configured for the interconnected regions communication.
        """
        return pulumi.get(self, "bandwidth_limit")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> str:
        """
        ID of local region.
        """
        return pulumi.get(self, "local_region_id")

    @property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> str:
        """
        ID of opposite region.
        """
        return pulumi.get(self, "opposite_region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the CEN Bandwidth Limit, including "Active" and "Modifying".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBandwidthPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 bandwidth_package_charge_type: str,
                 business_status: str,
                 cen_bandwidth_package_id: str,
                 cen_bandwidth_package_name: str,
                 cen_ids: Sequence[str],
                 description: str,
                 expired_time: str,
                 geographic_region_a_id: str,
                 geographic_region_b_id: str,
                 geographic_span_id: str,
                 has_reservation_data: str,
                 id: str,
                 instance_id: str,
                 is_cross_border: bool,
                 name: str,
                 payment_type: str,
                 reservation_active_time: str,
                 reservation_bandwidth: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 status: str):
        """
        :param int bandwidth: The bandwidth in Mbps of the CEN bandwidth package.
        :param str bandwidth_package_charge_type: The billing method, including `POSTPAY` and `PREPAY`.
        :param str business_status: Status of the CEN Bandwidth Package, including `Normal`, `FinancialLocked` and `SecurityLocked`.
        :param str cen_bandwidth_package_id: The ID of the bandwidth package.
        :param str cen_bandwidth_package_name: The name of the bandwidth package.
        :param Sequence[str] cen_ids: The list of CEN instances that are associated with the bandwidth package.
        :param str description: Description of the CEN Bandwidth Package.
        :param str geographic_region_a_id: Region ID of the interconnected regions.
        :param str geographic_region_b_id: Region ID of the interconnected regions.
        :param str geographic_span_id: The area ID of the cross-area connection.
        :param str has_reservation_data: Indicates whether renewal data is involved.
        :param str id: ID of the CEN Bandwidth Package.
        :param str instance_id: ID of a CEN instance.
        :param bool is_cross_border: Indicates whether the bandwidth package is a cross-border bandwidth package.
        :param str name: Name of the CEN Bandwidth Package.
        :param str payment_type: The billing method of the bandwidth package.
        :param str reservation_active_time: The expiration time of the temporary upgrade.
        :param str reservation_bandwidth: The restored bandwidth after the temporary upgrade.
        :param str reservation_internet_charge_type: The billing method after the configuration change.
        :param str reservation_order_type: The type of the configuration change.
        :param str status: Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_charge_type", bandwidth_package_charge_type)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        pulumi.set(__self__, "cen_bandwidth_package_name", cen_bandwidth_package_name)
        pulumi.set(__self__, "cen_ids", cen_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "geographic_region_a_id", geographic_region_a_id)
        pulumi.set(__self__, "geographic_region_b_id", geographic_region_b_id)
        pulumi.set(__self__, "geographic_span_id", geographic_span_id)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_cross_border", is_cross_border)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth in Mbps of the CEN bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageChargeType")
    def bandwidth_package_charge_type(self) -> str:
        """
        The billing method, including `POSTPAY` and `PREPAY`.
        """
        return pulumi.get(self, "bandwidth_package_charge_type")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        Status of the CEN Bandwidth Package, including `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> str:
        """
        The ID of the bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @property
    @pulumi.getter(name="cenBandwidthPackageName")
    def cen_bandwidth_package_name(self) -> str:
        """
        The name of the bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_name")

    @property
    @pulumi.getter(name="cenIds")
    def cen_ids(self) -> Sequence[str]:
        """
        The list of CEN instances that are associated with the bandwidth package.
        """
        return pulumi.get(self, "cen_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="geographicRegionAId")
    def geographic_region_a_id(self) -> str:
        """
        Region ID of the interconnected regions.
        """
        return pulumi.get(self, "geographic_region_a_id")

    @property
    @pulumi.getter(name="geographicRegionBId")
    def geographic_region_b_id(self) -> str:
        """
        Region ID of the interconnected regions.
        """
        return pulumi.get(self, "geographic_region_b_id")

    @property
    @pulumi.getter(name="geographicSpanId")
    def geographic_span_id(self) -> str:
        """
        The area ID of the cross-area connection.
        """
        return pulumi.get(self, "geographic_span_id")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> str:
        """
        Indicates whether renewal data is involved.
        """
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of a CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isCrossBorder")
    def is_cross_border(self) -> bool:
        """
        Indicates whether the bandwidth package is a cross-border bandwidth package.
        """
        return pulumi.get(self, "is_cross_border")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The billing method of the bandwidth package.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        """
        The expiration time of the temporary upgrade.
        """
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> str:
        """
        The restored bandwidth after the temporary upgrade.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        """
        The billing method after the configuration change.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        """
        The type of the configuration change.
        """
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetChildInstanceRouteEntryToAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 cen_id: str,
                 child_instance_route_table_id: str,
                 destination_cidr_block: str,
                 id: str,
                 service_type: str,
                 status: str,
                 transit_router_attachment_id: str):
        """
        :param str cen_id: The ID of the CEN instance.
        :param str child_instance_route_table_id: The first ID of the resource
        :param str destination_cidr_block: DestinationCidrBlock
        :param str id: The ID of the resource. The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
        :param str service_type: ServiceType
        :param str status: The status of the resource
        :param str transit_router_attachment_id: TransitRouterAttachmentId
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "child_instance_route_table_id", child_instance_route_table_id)
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="childInstanceRouteTableId")
    def child_instance_route_table_id(self) -> str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "child_instance_route_table_id")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> str:
        """
        DestinationCidrBlock
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource. The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        ServiceType
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        TransitRouterAttachmentId
        """
        return pulumi.get(self, "transit_router_attachment_id")


@pulumi.output_type
class GetFlowlogsFlowlogResult(dict):
    def __init__(__self__, *,
                 cen_id: str,
                 description: str,
                 flow_log_id: str,
                 flow_log_name: str,
                 id: str,
                 log_store_name: str,
                 project_name: str,
                 status: str):
        """
        :param str cen_id: The ID of the CEN Instance.
        :param str description: The description of flowlog.
        :param str flow_log_id: ID of the CEN flow log.
        :param str flow_log_name: The name of flowlog.
        :param str id: ID of the CEN flow log.
        :param str log_store_name: The name of the log store which is in the  `project_name` SLS project.
        :param str project_name: The name of the SLS project.
        :param str status: The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_store_name", log_store_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN Instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of flowlog.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> str:
        """
        ID of the CEN flow log.
        """
        return pulumi.get(self, "flow_log_id")

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> str:
        """
        The name of flowlog.
        """
        return pulumi.get(self, "flow_log_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the CEN flow log.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> str:
        """
        The name of the log store which is in the  `project_name` SLS project.
        """
        return pulumi.get(self, "log_store_name")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The name of the SLS project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstanceAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 child_instance_attach_time: str,
                 child_instance_id: str,
                 child_instance_owner_id: int,
                 child_instance_region_id: str,
                 child_instance_type: str,
                 id: str,
                 instance_id: str,
                 status: str):
        """
        :param str child_instance_attach_time: The time when the network is associated with the CEN instance.
        :param str child_instance_id: The ID of the network.
        :param int child_instance_owner_id: The ID of the account to which the network belongs.
        :param str child_instance_region_id: The region to which the network to be queried belongs.
        :param str child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param str id: The ID of the CEN Instance Attachment.
        :param str instance_id: The ID of the CEN instance.
        :param str status: The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
        """
        pulumi.set(__self__, "child_instance_attach_time", child_instance_attach_time)
        pulumi.set(__self__, "child_instance_id", child_instance_id)
        pulumi.set(__self__, "child_instance_owner_id", child_instance_owner_id)
        pulumi.set(__self__, "child_instance_region_id", child_instance_region_id)
        pulumi.set(__self__, "child_instance_type", child_instance_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="childInstanceAttachTime")
    def child_instance_attach_time(self) -> str:
        """
        The time when the network is associated with the CEN instance.
        """
        return pulumi.get(self, "child_instance_attach_time")

    @property
    @pulumi.getter(name="childInstanceId")
    def child_instance_id(self) -> str:
        """
        The ID of the network.
        """
        return pulumi.get(self, "child_instance_id")

    @property
    @pulumi.getter(name="childInstanceOwnerId")
    def child_instance_owner_id(self) -> int:
        """
        The ID of the account to which the network belongs.
        """
        return pulumi.get(self, "child_instance_owner_id")

    @property
    @pulumi.getter(name="childInstanceRegionId")
    def child_instance_region_id(self) -> str:
        """
        The region to which the network to be queried belongs.
        """
        return pulumi.get(self, "child_instance_region_id")

    @property
    @pulumi.getter(name="childInstanceType")
    def child_instance_type(self) -> str:
        """
        The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        """
        return pulumi.get(self, "child_instance_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the CEN Instance Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cen_bandwidth_package_ids: Sequence[str],
                 cen_id: str,
                 cen_instance_name: str,
                 create_time: str,
                 description: str,
                 id: str,
                 name: str,
                 protection_level: str,
                 status: str,
                 tags: Mapping[str, Any]):
        """
        :param Sequence[str] cen_bandwidth_package_ids: List of CEN Bandwidth Package IDs in the specified CEN instance.
        :param str cen_id: ID of the CEN instance.
        :param str cen_instance_name: Name of the CEN instance.
        :param str create_time: The creation time of the CEN Instance.
        :param str description: Description of the CEN instance.
        :param str id: ID of the CEN instance.
        :param str name: Name of the CEN instance.
        :param str protection_level: Indicates the allowed level of CIDR block overlapping.
        :param str status: The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "cen_bandwidth_package_ids", cen_bandwidth_package_ids)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_instance_name", cen_instance_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protection_level", protection_level)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cenBandwidthPackageIds")
    def cen_bandwidth_package_ids(self) -> Sequence[str]:
        """
        List of CEN Bandwidth Package IDs in the specified CEN instance.
        """
        return pulumi.get(self, "cen_bandwidth_package_ids")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cenInstanceName")
    def cen_instance_name(self) -> str:
        """
        Name of the CEN instance.
        """
        return pulumi.get(self, "cen_instance_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the CEN Instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the CEN instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the CEN instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> str:
        """
        Indicates the allowed level of CIDR block overlapping.
        """
        return pulumi.get(self, "protection_level")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInterRegionTrafficQosPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 id: str,
                 inter_region_traffic_qos_policy_description: str,
                 inter_region_traffic_qos_policy_id: str,
                 inter_region_traffic_qos_policy_name: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_id: str):
        """
        :param str id: The ID of the Inter Region Traffic Qos Policy.
        :param str inter_region_traffic_qos_policy_description: The description of the Inter Region Traffic Qos Policy.
        :param str inter_region_traffic_qos_policy_id: The ID of the Inter Region Traffic Qos Policy.
        :param str inter_region_traffic_qos_policy_name: The name of the Inter Region Traffic Qos Policy.
        :param str status: The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
        :param str transit_router_attachment_id: The ID of the inter-region connection.
        :param str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_description", inter_region_traffic_qos_policy_description)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_id", inter_region_traffic_qos_policy_id)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_name", inter_region_traffic_qos_policy_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interRegionTrafficQosPolicyDescription")
    def inter_region_traffic_qos_policy_description(self) -> str:
        """
        The description of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_description")

    @property
    @pulumi.getter(name="interRegionTrafficQosPolicyId")
    def inter_region_traffic_qos_policy_id(self) -> str:
        """
        The ID of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_id")

    @property
    @pulumi.getter(name="interRegionTrafficQosPolicyName")
    def inter_region_traffic_qos_policy_name(self) -> str:
        """
        The name of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of the inter-region connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetInterRegionTrafficQosQueuesQueueResult(dict):
    def __init__(__self__, *,
                 dscps: Sequence[str],
                 id: str,
                 inter_region_traffic_qos_queue_description: str,
                 inter_region_traffic_qos_queue_id: str,
                 inter_region_traffic_qos_queue_name: str,
                 remain_bandwidth_percent: int,
                 status: str,
                 traffic_qos_policy_id: str):
        """
        :param Sequence[str] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param str inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param str inter_region_traffic_qos_queue_id: The ID of the resource.
        :param str inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        :param int remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param str status: The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        :param str traffic_qos_policy_id: The ID of the traffic scheduling policy.
        """
        pulumi.set(__self__, "dscps", dscps)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_description", inter_region_traffic_qos_queue_description)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_id", inter_region_traffic_qos_queue_id)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_name", inter_region_traffic_qos_queue_name)
        pulumi.set(__self__, "remain_bandwidth_percent", remain_bandwidth_percent)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_qos_policy_id", traffic_qos_policy_id)

    @property
    @pulumi.getter
    def dscps(self) -> Sequence[str]:
        """
        The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        """
        return pulumi.get(self, "dscps")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueDescription")
    def inter_region_traffic_qos_queue_description(self) -> str:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_description")

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueId")
    def inter_region_traffic_qos_queue_id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_id")

    @property
    @pulumi.getter(name="interRegionTrafficQosQueueName")
    def inter_region_traffic_qos_queue_name(self) -> str:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_name")

    @property
    @pulumi.getter(name="remainBandwidthPercent")
    def remain_bandwidth_percent(self) -> int:
        """
        The percentage of cross-region bandwidth that the current queue can use.
        """
        return pulumi.get(self, "remain_bandwidth_percent")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> str:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")


@pulumi.output_type
class GetPrivateZonesZoneResult(dict):
    def __init__(__self__, *,
                 access_region_id: str,
                 cen_id: str,
                 host_region_id: str,
                 host_vpc_id: str,
                 id: str,
                 private_zone_dns_servers: str,
                 status: str):
        """
        :param str access_region_id: The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
        :param str cen_id: The ID of the CEN instance.
        :param str host_region_id: The service region. The service region is the target region of the PrivateZone service accessed through CEN.
        :param str host_vpc_id: The VPC that belongs to the service region.
        :param str id: The ID of the private zone. It formats as `<cen_id>:<access_region_id>`.
        :param str private_zone_dns_servers: The DNS IP addresses of the PrivateZone service.
        :param str status: The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_zone_dns_servers", private_zone_dns_servers)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> str:
        """
        The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
        """
        return pulumi.get(self, "access_region_id")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> str:
        """
        The service region. The service region is the target region of the PrivateZone service accessed through CEN.
        """
        return pulumi.get(self, "host_region_id")

    @property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> str:
        """
        The VPC that belongs to the service region.
        """
        return pulumi.get(self, "host_vpc_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the private zone. It formats as `<cen_id>:<access_region_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateZoneDnsServers")
    def private_zone_dns_servers(self) -> str:
        """
        The DNS IP addresses of the PrivateZone service.
        """
        return pulumi.get(self, "private_zone_dns_servers")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRegionRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 next_hop_id: str,
                 next_hop_region_id: str,
                 next_hop_type: str,
                 type: str):
        """
        :param str cidr_block: The destination CIDR block of the route entry.
        :param str next_hop_id: ID of the next hop.
        :param str next_hop_region_id: ID of the region where the next hop is located.
        :param str next_hop_type: Type of the next hop.
        :param str type: Type of the route entry.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        pulumi.set(__self__, "next_hop_region_id", next_hop_region_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @property
    @pulumi.getter(name="nextHopRegionId")
    def next_hop_region_id(self) -> str:
        """
        ID of the region where the next hop is located.
        """
        return pulumi.get(self, "next_hop_region_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        Type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the route entry.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 conflicts: Sequence['outputs.GetRouteEntriesEntryConflictResult'],
                 next_hop_id: str,
                 next_hop_type: str,
                 operational_mode: bool,
                 publish_status: str,
                 route_table_id: str,
                 route_type: str):
        """
        :param str cidr_block: The destination CIDR block of the route entry to query.
        :param Sequence['GetRouteEntriesEntryConflictArgs'] conflicts: A list of conflicted Route Entries. Each element contains the following attributes:
        :param str next_hop_id: ID of the next hop.
        :param str next_hop_type: Type of the next hop, including "Instance", "HaVip" and "RouterInterface".
        :param bool operational_mode: Whether to allow the route entry to be published or removed to or from CEN.
        :param str publish_status: The publish status of the route entry in CEN, including "Published" and "NonPublished".
        :param str route_table_id: ID of the route table of the VPC or VBR.
        :param str route_type: Type of the route entry, including "System", "Custom" and "BGP".
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "conflicts", conflicts)
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "operational_mode", operational_mode)
        pulumi.set(__self__, "publish_status", publish_status)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "route_type", route_type)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        The destination CIDR block of the route entry to query.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter
    def conflicts(self) -> Sequence['outputs.GetRouteEntriesEntryConflictResult']:
        """
        A list of conflicted Route Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "conflicts")

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        Type of the next hop, including "Instance", "HaVip" and "RouterInterface".
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="operationalMode")
    def operational_mode(self) -> bool:
        """
        Whether to allow the route entry to be published or removed to or from CEN.
        """
        return pulumi.get(self, "operational_mode")

    @property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> str:
        """
        The publish status of the route entry in CEN, including "Published" and "NonPublished".
        """
        return pulumi.get(self, "publish_status")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        ID of the route table of the VPC or VBR.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> str:
        """
        Type of the route entry, including "System", "Custom" and "BGP".
        """
        return pulumi.get(self, "route_type")


@pulumi.output_type
class GetRouteEntriesEntryConflictResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 instance_id: str,
                 instance_type: str,
                 region_id: str,
                 status: str):
        """
        :param str cidr_block: The destination CIDR block of the route entry to query.
        :param str instance_id: ID of the CEN instance.
        :param str instance_type: The type of the CEN child instance.
        :param str region_id: ID of the region where the conflicted route entry is located.
        :param str status: Reasons of exceptions.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        The destination CIDR block of the route entry to query.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the CEN child instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        ID of the region where the conflicted route entry is located.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Reasons of exceptions.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRouteMapsMapResult(dict):
    def __init__(__self__, *,
                 as_path_match_mode: str,
                 cen_id: str,
                 cen_region_id: str,
                 cidr_match_mode: str,
                 community_match_mode: str,
                 community_operate_mode: str,
                 description: str,
                 destination_child_instance_types: Sequence[str],
                 destination_cidr_blocks: Sequence[str],
                 destination_instance_ids: Sequence[str],
                 destination_instance_ids_reverse_match: bool,
                 destination_route_table_ids: Sequence[str],
                 id: str,
                 map_result: str,
                 match_asns: Sequence[str],
                 match_community_sets: Sequence[str],
                 next_priority: int,
                 operate_community_sets: Sequence[str],
                 preference: int,
                 prepend_as_paths: Sequence[str],
                 priority: int,
                 route_map_id: str,
                 route_types: Sequence[str],
                 source_child_instance_types: Sequence[str],
                 source_instance_ids: Sequence[str],
                 source_instance_ids_reverse_match: bool,
                 source_region_ids: Sequence[str],
                 source_route_table_ids: Sequence[str],
                 status: str,
                 transmit_direction: str):
        """
        :param str as_path_match_mode: A match statement. It indicates the mode in which the as-path attribute is matched.
        :param str cen_id: The ID of the CEN instance.
        :param str cen_region_id: The ID of the region to which the CEN instance belongs.
        :param str cidr_match_mode: A match statement. It indicates the mode in which the prefix attribute is matched.
        :param str community_match_mode: A match statement. It indicates the mode in which the community attribute is matched.
        :param str community_operate_mode: An action statement. It indicates the mode in which the community attribute is operated.
        :param str description: The description of the route map.
        :param Sequence[str] destination_child_instance_types: A match statement that indicates the list of IDs of the destination instances.
        :param Sequence[str] destination_cidr_blocks: A match statement that indicates the prefix list.
        :param Sequence[str] destination_instance_ids: A match statement that indicates the list of IDs of the destination instances.
        :param bool destination_instance_ids_reverse_match: Indicates whether to enable the reverse match method of the DestinationInstanceIds match condition.
        :param Sequence[str] destination_route_table_ids: A match statement that indicates the list of IDs of the destination route tables.
        :param str id: The ID of the route map. It formats as `<cen_id>:<route_map_id>`. Before 1.161.0, it is `route_map_id`.
        :param str map_result: The action that is performed to a route if the route meets all the match conditions.
        :param Sequence[str] match_asns: A match statement that indicates the As path list.
        :param Sequence[str] match_community_sets: A match statement that indicates the community set.
        :param int next_priority: The priority of the next route map that is associated with the current route map.
        :param Sequence[str] operate_community_sets: An action statement that operates the community attribute.
        :param int preference: An action statement that modifies the preference of the route.
        :param Sequence[str] prepend_as_paths: Indicates AS Path prepending when a regional gateway receives or publishes a route.
        :param int priority: The priority of the route map.
        :param str route_map_id: The ID of the route map.
        :param Sequence[str] route_types: A match statement that indicates the list of route types.
        :param Sequence[str] source_child_instance_types: A match statement that indicates the list of IDs of the source instances.
        :param Sequence[str] source_instance_ids: A match statement that indicates the list of IDs of the source instances.
        :param bool source_instance_ids_reverse_match: Indicates whether to enable the reverse match method of the SourceInstanceIds match condition.
        :param Sequence[str] source_region_ids: A match statement that indicates the list of IDs of the source regions.
        :param Sequence[str] source_route_table_ids: A match statement that indicates the list of IDs of the source route tables.
        :param str status: The status of the route map, including `Creating`, `Active` and `Deleting`.
        :param str transmit_direction: The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
        """
        pulumi.set(__self__, "as_path_match_mode", as_path_match_mode)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_region_id", cen_region_id)
        pulumi.set(__self__, "cidr_match_mode", cidr_match_mode)
        pulumi.set(__self__, "community_match_mode", community_match_mode)
        pulumi.set(__self__, "community_operate_mode", community_operate_mode)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_child_instance_types", destination_child_instance_types)
        pulumi.set(__self__, "destination_cidr_blocks", destination_cidr_blocks)
        pulumi.set(__self__, "destination_instance_ids", destination_instance_ids)
        pulumi.set(__self__, "destination_instance_ids_reverse_match", destination_instance_ids_reverse_match)
        pulumi.set(__self__, "destination_route_table_ids", destination_route_table_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "map_result", map_result)
        pulumi.set(__self__, "match_asns", match_asns)
        pulumi.set(__self__, "match_community_sets", match_community_sets)
        pulumi.set(__self__, "next_priority", next_priority)
        pulumi.set(__self__, "operate_community_sets", operate_community_sets)
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "route_map_id", route_map_id)
        pulumi.set(__self__, "route_types", route_types)
        pulumi.set(__self__, "source_child_instance_types", source_child_instance_types)
        pulumi.set(__self__, "source_instance_ids", source_instance_ids)
        pulumi.set(__self__, "source_instance_ids_reverse_match", source_instance_ids_reverse_match)
        pulumi.set(__self__, "source_region_ids", source_region_ids)
        pulumi.set(__self__, "source_route_table_ids", source_route_table_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transmit_direction", transmit_direction)

    @property
    @pulumi.getter(name="asPathMatchMode")
    def as_path_match_mode(self) -> str:
        """
        A match statement. It indicates the mode in which the as-path attribute is matched.
        """
        return pulumi.get(self, "as_path_match_mode")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cenRegionId")
    def cen_region_id(self) -> str:
        """
        The ID of the region to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_region_id")

    @property
    @pulumi.getter(name="cidrMatchMode")
    def cidr_match_mode(self) -> str:
        """
        A match statement. It indicates the mode in which the prefix attribute is matched.
        """
        return pulumi.get(self, "cidr_match_mode")

    @property
    @pulumi.getter(name="communityMatchMode")
    def community_match_mode(self) -> str:
        """
        A match statement. It indicates the mode in which the community attribute is matched.
        """
        return pulumi.get(self, "community_match_mode")

    @property
    @pulumi.getter(name="communityOperateMode")
    def community_operate_mode(self) -> str:
        """
        An action statement. It indicates the mode in which the community attribute is operated.
        """
        return pulumi.get(self, "community_operate_mode")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the route map.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationChildInstanceTypes")
    def destination_child_instance_types(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the destination instances.
        """
        return pulumi.get(self, "destination_child_instance_types")

    @property
    @pulumi.getter(name="destinationCidrBlocks")
    def destination_cidr_blocks(self) -> Sequence[str]:
        """
        A match statement that indicates the prefix list.
        """
        return pulumi.get(self, "destination_cidr_blocks")

    @property
    @pulumi.getter(name="destinationInstanceIds")
    def destination_instance_ids(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the destination instances.
        """
        return pulumi.get(self, "destination_instance_ids")

    @property
    @pulumi.getter(name="destinationInstanceIdsReverseMatch")
    def destination_instance_ids_reverse_match(self) -> bool:
        """
        Indicates whether to enable the reverse match method of the DestinationInstanceIds match condition.
        """
        return pulumi.get(self, "destination_instance_ids_reverse_match")

    @property
    @pulumi.getter(name="destinationRouteTableIds")
    def destination_route_table_ids(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the destination route tables.
        """
        return pulumi.get(self, "destination_route_table_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the route map. It formats as `<cen_id>:<route_map_id>`. Before 1.161.0, it is `route_map_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mapResult")
    def map_result(self) -> str:
        """
        The action that is performed to a route if the route meets all the match conditions.
        """
        return pulumi.get(self, "map_result")

    @property
    @pulumi.getter(name="matchAsns")
    def match_asns(self) -> Sequence[str]:
        """
        A match statement that indicates the As path list.
        """
        return pulumi.get(self, "match_asns")

    @property
    @pulumi.getter(name="matchCommunitySets")
    def match_community_sets(self) -> Sequence[str]:
        """
        A match statement that indicates the community set.
        """
        return pulumi.get(self, "match_community_sets")

    @property
    @pulumi.getter(name="nextPriority")
    def next_priority(self) -> int:
        """
        The priority of the next route map that is associated with the current route map.
        """
        return pulumi.get(self, "next_priority")

    @property
    @pulumi.getter(name="operateCommunitySets")
    def operate_community_sets(self) -> Sequence[str]:
        """
        An action statement that operates the community attribute.
        """
        return pulumi.get(self, "operate_community_sets")

    @property
    @pulumi.getter
    def preference(self) -> int:
        """
        An action statement that modifies the preference of the route.
        """
        return pulumi.get(self, "preference")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Sequence[str]:
        """
        Indicates AS Path prepending when a regional gateway receives or publishes a route.
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the route map.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="routeMapId")
    def route_map_id(self) -> str:
        """
        The ID of the route map.
        """
        return pulumi.get(self, "route_map_id")

    @property
    @pulumi.getter(name="routeTypes")
    def route_types(self) -> Sequence[str]:
        """
        A match statement that indicates the list of route types.
        """
        return pulumi.get(self, "route_types")

    @property
    @pulumi.getter(name="sourceChildInstanceTypes")
    def source_child_instance_types(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the source instances.
        """
        return pulumi.get(self, "source_child_instance_types")

    @property
    @pulumi.getter(name="sourceInstanceIds")
    def source_instance_ids(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the source instances.
        """
        return pulumi.get(self, "source_instance_ids")

    @property
    @pulumi.getter(name="sourceInstanceIdsReverseMatch")
    def source_instance_ids_reverse_match(self) -> bool:
        """
        Indicates whether to enable the reverse match method of the SourceInstanceIds match condition.
        """
        return pulumi.get(self, "source_instance_ids_reverse_match")

    @property
    @pulumi.getter(name="sourceRegionIds")
    def source_region_ids(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the source regions.
        """
        return pulumi.get(self, "source_region_ids")

    @property
    @pulumi.getter(name="sourceRouteTableIds")
    def source_route_table_ids(self) -> Sequence[str]:
        """
        A match statement that indicates the list of IDs of the source route tables.
        """
        return pulumi.get(self, "source_route_table_ids")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route map, including `Creating`, `Active` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transmitDirection")
    def transmit_direction(self) -> str:
        """
        The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
        """
        return pulumi.get(self, "transmit_direction")


@pulumi.output_type
class GetRouteServicesServiceResult(dict):
    def __init__(__self__, *,
                 access_region_id: str,
                 cen_id: str,
                 cidrs: Sequence[str],
                 description: str,
                 host: str,
                 host_region_id: str,
                 host_vpc_id: str,
                 id: str,
                 status: str,
                 update_interval: str):
        """
        :param str access_region_id: The region of the network instances that access the cloud services.
        :param str cen_id: The ID of the CEN instance.
        :param Sequence[str] cidrs: The IP address of the cloud service.
        :param str description: The description of the cloud service.
        :param str host: The domain name or IP address of the cloud service.
        :param str host_region_id: The region of the cloud service.
        :param str host_vpc_id: The VPC associated with the cloud service.
        :param str id: The ID of the route service.
        :param str status: The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
        :param str update_interval: The update interval. Default value: 5. The value cannot be modified.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "update_interval", update_interval)

    @property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> str:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence[str]:
        """
        The IP address of the cloud service.
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the cloud service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> str:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> str:
        """
        The VPC associated with the cloud service.
        """
        return pulumi.get(self, "host_vpc_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the route service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateInterval")
    def update_interval(self) -> str:
        """
        The update interval. Default value: 5. The value cannot be modified.
        """
        return pulumi.get(self, "update_interval")


@pulumi.output_type
class GetTrafficMarkingPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 marking_dscp: int,
                 priority: int,
                 status: str,
                 traffic_marking_policy_id: str,
                 traffic_marking_policy_name: str,
                 transit_router_id: str):
        """
        :param str description: The description of the Traffic Marking Policy.
        :param str id: The ID of the resource. The value is formatted `<transit_router_id>:<traffic_marking_policy_id>`.
        :param int marking_dscp: The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy.
        :param int priority: The Priority of the Traffic Marking Policy.
        :param str status: The status of the resource.
        :param str traffic_marking_policy_id: The ID of the Traffic Marking Policy.
        :param str traffic_marking_policy_name: The name of the Traffic Marking Policy.
        :param str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "marking_dscp", marking_dscp)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_marking_policy_id", traffic_marking_policy_id)
        pulumi.set(__self__, "traffic_marking_policy_name", traffic_marking_policy_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Traffic Marking Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource. The value is formatted `<transit_router_id>:<traffic_marking_policy_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="markingDscp")
    def marking_dscp(self) -> int:
        """
        The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy.
        """
        return pulumi.get(self, "marking_dscp")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The Priority of the Traffic Marking Policy.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMarkingPolicyId")
    def traffic_marking_policy_id(self) -> str:
        """
        The ID of the Traffic Marking Policy.
        """
        return pulumi.get(self, "traffic_marking_policy_id")

    @property
    @pulumi.getter(name="trafficMarkingPolicyName")
    def traffic_marking_policy_name(self) -> str:
        """
        The name of the Traffic Marking Policy.
        """
        return pulumi.get(self, "traffic_marking_policy_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouteTableAggregationsTransitRouteTableAggregationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 route_type: str,
                 status: str,
                 transit_route_table_aggregation_cidr: str,
                 transit_route_table_aggregation_description: str,
                 transit_route_table_aggregation_name: str,
                 transit_route_table_aggregation_scope: str,
                 transit_route_table_id: str):
        """
        :param str id: The ID of the Transit Route Table Aggregation. It formats as `<transit_route_table_id>:<transit_route_table_aggregation_cidr>`.
        :param str route_type: The route type of the aggregate route.
        :param str status: The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
        :param str transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route.
        :param str transit_route_table_aggregation_description: The description of the aggregate route.
        :param str transit_route_table_aggregation_name: The name of the aggregate route.
        :param str transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route.
        :param str transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "route_type", route_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_route_table_aggregation_cidr", transit_route_table_aggregation_cidr)
        pulumi.set(__self__, "transit_route_table_aggregation_description", transit_route_table_aggregation_description)
        pulumi.set(__self__, "transit_route_table_aggregation_name", transit_route_table_aggregation_name)
        pulumi.set(__self__, "transit_route_table_aggregation_scope", transit_route_table_aggregation_scope)
        pulumi.set(__self__, "transit_route_table_id", transit_route_table_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Transit Route Table Aggregation. It formats as `<transit_route_table_id>:<transit_route_table_aggregation_cidr>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> str:
        """
        The route type of the aggregate route.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> str:
        """
        The destination CIDR block of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @property
    @pulumi.getter(name="transitRouteTableAggregationDescription")
    def transit_route_table_aggregation_description(self) -> str:
        """
        The description of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_description")

    @property
    @pulumi.getter(name="transitRouteTableAggregationName")
    def transit_route_table_aggregation_name(self) -> str:
        """
        The name of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_name")

    @property
    @pulumi.getter(name="transitRouteTableAggregationScope")
    def transit_route_table_aggregation_scope(self) -> str:
        """
        The scope of networks that you want to advertise the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_scope")

    @property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")


@pulumi.output_type
class GetTransitRouterAvailableResourcesResourceResult(dict):
    def __init__(__self__, *,
                 master_zones: Sequence[str],
                 slave_zones: Sequence[str]):
        """
        :param Sequence[str] master_zones: The list of primary zones.
        :param Sequence[str] slave_zones: The list of secondary zones.
        """
        pulumi.set(__self__, "master_zones", master_zones)
        pulumi.set(__self__, "slave_zones", slave_zones)

    @property
    @pulumi.getter(name="masterZones")
    def master_zones(self) -> Sequence[str]:
        """
        The list of primary zones.
        """
        return pulumi.get(self, "master_zones")

    @property
    @pulumi.getter(name="slaveZones")
    def slave_zones(self) -> Sequence[str]:
        """
        The list of secondary zones.
        """
        return pulumi.get(self, "slave_zones")


@pulumi.output_type
class GetTransitRouterCidrsCidrResult(dict):
    def __init__(__self__, *,
                 cidr: str,
                 description: str,
                 family: str,
                 id: str,
                 publish_cidr_route: bool,
                 transit_router_cidr_id: str,
                 transit_router_cidr_name: str,
                 transit_router_id: str):
        """
        :param str cidr: The cidr of the transit router.
        :param str description: The description of the transit router.
        :param str family: The type of the transit router cidr.
        :param str id: The ID of the Cen Transit Router Cidr. It formats as `<transit_router_id>:<transit_router_cidr_id>`.
        :param bool publish_cidr_route: Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table.
        :param str transit_router_cidr_id: The ID of the transit router cidr.
        :param str transit_router_cidr_name: The name of the transit router.
        :param str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "publish_cidr_route", publish_cidr_route)
        pulumi.set(__self__, "transit_router_cidr_id", transit_router_cidr_id)
        pulumi.set(__self__, "transit_router_cidr_name", transit_router_cidr_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        The cidr of the transit router.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the transit router.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        The type of the transit router cidr.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Cen Transit Router Cidr. It formats as `<transit_router_id>:<transit_router_cidr_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publishCidrRoute")
    def publish_cidr_route(self) -> bool:
        """
        Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table.
        """
        return pulumi.get(self, "publish_cidr_route")

    @property
    @pulumi.getter(name="transitRouterCidrId")
    def transit_router_cidr_id(self) -> str:
        """
        The ID of the transit router cidr.
        """
        return pulumi.get(self, "transit_router_cidr_id")

    @property
    @pulumi.getter(name="transitRouterCidrName")
    def transit_router_cidr_name(self) -> str:
        """
        The name of the transit router.
        """
        return pulumi.get(self, "transit_router_cidr_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_id: str,
                 resource_owner_id: int,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_multicast_domain_id: str,
                 vswitch_id: str):
        """
        :param str id: The ID of the Transit Router Multicast Domain Association. It formats as `<transit_router_multicast_domain_id>:<transit_router_attachment_id>:<vswitch_id>`.
        :param str resource_id: The ID of the resource associated with the multicast domain.
        :param int resource_owner_id: The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
        :param str resource_type: The type of resource associated with the multicast domain. Valid Value: `VPC`.
        :param str status: The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
        :param str transit_router_attachment_id: The ID of the network instance connection.
        :param str transit_router_multicast_domain_id: The ID of the multicast domain.
        :param str vswitch_id: The ID of the vSwitch.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_owner_id", resource_owner_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Transit Router Multicast Domain Association. It formats as `<transit_router_multicast_domain_id>:<transit_router_attachment_id>:<vswitch_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the resource associated with the multicast domain.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceOwnerId")
    def resource_owner_id(self) -> int:
        """
        The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
        """
        return pulumi.get(self, "resource_owner_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of resource associated with the multicast domain. Valid Value: `VPC`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainMembersMemberResult(dict):
    def __init__(__self__, *,
                 group_ip_address: str,
                 id: str,
                 network_interface_id: str,
                 status: str,
                 transit_router_multicast_domain_id: str,
                 vpc_id: str):
        """
        :param str group_ip_address: The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        :param str id: The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>`.
        :param str network_interface_id: The ID of the ENI.
        :param str status: The status of the resource
        :param str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
        :param str vpc_id: The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> str:
        """
        The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        """
        return pulumi.get(self, "group_ip_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The ID of the ENI.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainPeerMembersMemberResult(dict):
    def __init__(__self__, *,
                 group_ip_address: str,
                 id: str,
                 peer_transit_router_multicast_domain_id: str,
                 status: str,
                 transit_router_multicast_domain_id: str):
        """
        :param str group_ip_address: The IP address of the multicast group to which the multicast member belongs. Value range: **224.0.0.1** to **239.255.255.254**.If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        :param str id: The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<peer_transit_router_multicast_domain_id>`.
        :param str peer_transit_router_multicast_domain_id: The multicast domain ID of the peer transit router.
        :param str status: The status of the resource
        :param str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_transit_router_multicast_domain_id", peer_transit_router_multicast_domain_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)

    @property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> str:
        """
        The IP address of the multicast group to which the multicast member belongs. Value range: **224.0.0.1** to **239.255.255.254**.If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        """
        return pulumi.get(self, "group_ip_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<peer_transit_router_multicast_domain_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerTransitRouterMulticastDomainId")
    def peer_transit_router_multicast_domain_id(self) -> str:
        """
        The multicast domain ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_multicast_domain_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainSourcesSourceResult(dict):
    def __init__(__self__, *,
                 group_ip_address: str,
                 id: str,
                 network_interface_id: str,
                 status: str,
                 transit_router_multicast_domain_id: str,
                 vpc_id: str):
        """
        :param str group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param str id: The id of the resource.
        :param str network_interface_id: ENI ID of the multicast source.
        :param str status: The status of the resource.
        :param str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param str vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> str:
        """
        The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        """
        return pulumi.get(self, "group_ip_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        ENI ID of the multicast source.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain to which the multicast source belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainsDomainResult(dict):
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 transit_router_id: str,
                 transit_router_multicast_domain_description: str,
                 transit_router_multicast_domain_id: str,
                 transit_router_multicast_domain_name: str):
        """
        :param str id: The ID of the Transit Router Multicast Domain.
        :param str status: The status of the multicast domain. Valid Value: `Active`.
        :param str transit_router_id: The ID of the transit router.
        :param str transit_router_multicast_domain_description: The description of the Transit Router Multicast Domain.
        :param str transit_router_multicast_domain_id: The ID of the multicast domain.
        :param str transit_router_multicast_domain_name: The name of the Transit Router Multicast Domain.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_multicast_domain_description", transit_router_multicast_domain_description)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "transit_router_multicast_domain_name", transit_router_multicast_domain_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the multicast domain. Valid Value: `Active`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainDescription")
    def transit_router_multicast_domain_description(self) -> str:
        """
        The description of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_description")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> str:
        """
        The ID of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @property
    @pulumi.getter(name="transitRouterMulticastDomainName")
    def transit_router_multicast_domain_name(self) -> str:
        """
        The name of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_name")


@pulumi.output_type
class GetTransitRouterPeerAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: bool,
                 bandwidth: int,
                 cen_bandwidth_package_id: str,
                 geographic_span_id: str,
                 id: str,
                 peer_transit_router_id: str,
                 peer_transit_router_owner_id: str,
                 peer_transit_router_region_id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_description: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_id: str):
        """
        :param bool auto_publish_route_enabled: Auto publish route enabled.
        :param int bandwidth: The bandwidth of the bandwidth package.
        :param str cen_bandwidth_package_id: ID of the CEN bandwidth package.
        :param str geographic_span_id: ID of the geographic.
        :param str id: The ID of CEN Transit Router peer attachments.
        :param str peer_transit_router_id: ID of the peer transit router.
        :param str peer_transit_router_owner_id: Owner ID of the peer transit router.
        :param str peer_transit_router_region_id: Region ID of the peer transit router.
        :param str resource_type: Type of the resource.
        :param str status: The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
        :param str transit_router_attachment_description: The description of CEN Transit Router peer attachments.
        :param str transit_router_attachment_id: The ID of CEN Transit Router peer attachments.
        :param str transit_router_attachment_name: Name of the transit router attachment.
        :param str transit_router_id: The ID of transit router.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        pulumi.set(__self__, "geographic_span_id", geographic_span_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        pulumi.set(__self__, "peer_transit_router_owner_id", peer_transit_router_owner_id)
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> bool:
        """
        Auto publish route enabled.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> str:
        """
        ID of the CEN bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @property
    @pulumi.getter(name="geographicSpanId")
    def geographic_span_id(self) -> str:
        """
        ID of the geographic.
        """
        return pulumi.get(self, "geographic_span_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> str:
        """
        ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @property
    @pulumi.getter(name="peerTransitRouterOwnerId")
    def peer_transit_router_owner_id(self) -> str:
        """
        Owner ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_owner_id")

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> str:
        """
        Region ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> str:
        """
        The description of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        Name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouterPrefixListAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 next_hop: str,
                 next_hop_instance_id: str,
                 next_hop_type: str,
                 owner_uid: int,
                 prefix_list_id: str,
                 status: str,
                 transit_router_id: str,
                 transit_router_table_id: str):
        """
        :param str id: The ID of the Cen Transit Router Prefix List Association. It formats as `<prefix_list_id>:<transit_router_id>:<transit_router_table_id>:<next_hop>`.
        :param str next_hop: The ID of the next hop connection.
        :param str next_hop_instance_id: The ID of the network instance associated with the next hop connection.
        :param str next_hop_type: The type of the next hop.
        :param int owner_uid: The ID of the Alibaba Cloud account to which the prefix list belongs.
        :param str prefix_list_id: The ID of the prefix list.
        :param str status: The status of the prefix list.
        :param str transit_router_id: The ID of the transit router.
        :param str transit_router_table_id: The ID of the route table of the transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "next_hop_instance_id", next_hop_instance_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_table_id", transit_router_table_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Cen Transit Router Prefix List Association. It formats as `<prefix_list_id>:<transit_router_id>:<transit_router_table_id>:<next_hop>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The ID of the next hop connection.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="nextHopInstanceId")
    def next_hop_instance_id(self) -> str:
        """
        The ID of the network instance associated with the next hop connection.
        """
        return pulumi.get(self, "next_hop_instance_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> int:
        """
        The ID of the Alibaba Cloud account to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> str:
        """
        The ID of the prefix list.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the prefix list.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterTableId")
    def transit_router_table_id(self) -> str:
        """
        The ID of the route table of the transit router.
        """
        return pulumi.get(self, "transit_router_table_id")


@pulumi.output_type
class GetTransitRouterRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 transit_router_route_entry_description: str,
                 transit_router_route_entry_destination_cidr_block: str,
                 transit_router_route_entry_id: str,
                 transit_router_route_entry_name: str,
                 transit_router_route_entry_next_hop_id: str,
                 transit_router_route_entry_next_hop_type: str,
                 transit_router_route_entry_type: str):
        """
        :param str transit_router_route_entry_destination_cidr_block: The target network segment of the route entry.
        :param str transit_router_route_entry_next_hop_id: ID of the next hop.
        :param str transit_router_route_entry_next_hop_type: Type of the next hop.
        :param str transit_router_route_entry_type: Type of the route entry.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_entry_description", transit_router_route_entry_description)
        pulumi.set(__self__, "transit_router_route_entry_destination_cidr_block", transit_router_route_entry_destination_cidr_block)
        pulumi.set(__self__, "transit_router_route_entry_id", transit_router_route_entry_id)
        pulumi.set(__self__, "transit_router_route_entry_name", transit_router_route_entry_name)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_id", transit_router_route_entry_next_hop_id)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_type", transit_router_route_entry_next_hop_type)
        pulumi.set(__self__, "transit_router_route_entry_type", transit_router_route_entry_type)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterRouteEntryDescription")
    def transit_router_route_entry_description(self) -> str:
        return pulumi.get(self, "transit_router_route_entry_description")

    @property
    @pulumi.getter(name="transitRouterRouteEntryDestinationCidrBlock")
    def transit_router_route_entry_destination_cidr_block(self) -> str:
        """
        The target network segment of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_destination_cidr_block")

    @property
    @pulumi.getter(name="transitRouterRouteEntryId")
    def transit_router_route_entry_id(self) -> str:
        return pulumi.get(self, "transit_router_route_entry_id")

    @property
    @pulumi.getter(name="transitRouterRouteEntryName")
    def transit_router_route_entry_name(self) -> str:
        return pulumi.get(self, "transit_router_route_entry_name")

    @property
    @pulumi.getter(name="transitRouterRouteEntryNextHopId")
    def transit_router_route_entry_next_hop_id(self) -> str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_id")

    @property
    @pulumi.getter(name="transitRouterRouteEntryNextHopType")
    def transit_router_route_entry_next_hop_type(self) -> str:
        """
        Type of the next hop.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_type")

    @property
    @pulumi.getter(name="transitRouterRouteEntryType")
    def transit_router_route_entry_type(self) -> str:
        """
        Type of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_type")


@pulumi.output_type
class GetTransitRouterRouteTableAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_route_table_id: str):
        """
        :param str resource_id: ID of the transit router route table association.
        :param str resource_type: Type of the resource.
        :param str status: The status of the route table, including `Active`, `Associating`, `Dissociating`.
        :param str transit_router_attachment_id: The ID of the network instance connection.
        :param str transit_router_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        ID of the transit router route table association.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route table, including `Active`, `Associating`, `Dissociating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_route_table_id")


@pulumi.output_type
class GetTransitRouterRouteTablePropagationsPropagationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_id: str):
        """
        :param str resource_id: ID of the transit router route table association.
        :param str resource_type: Type of the resource.
        :param str status: The status of the route table, including `Active`, `Enabling`, `Disabling`, `Deleted`.
        :param str transit_router_attachment_id: ID of the cen transit router attachment.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        ID of the transit router route table association.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route table, including `Active`, `Enabling`, `Disabling`, `Deleted`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        ID of the cen transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")


@pulumi.output_type
class GetTransitRouterRouteTablesTableResult(dict):
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 transit_router_route_table_description: str,
                 transit_router_route_table_id: str,
                 transit_router_route_table_name: str,
                 transit_router_route_table_type: str):
        """
        :param str id: ID of resource.
        :param str transit_router_route_table_description: The description of the transit router route table.
        :param str transit_router_route_table_id: ID of the trabsit router route table.
        :param str transit_router_route_table_name: Name of the transit router route table.
        :param str transit_router_route_table_type: The type of the transit router route table to query. Valid values `Creating`, `Active` and `Deleting`..
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_table_description", transit_router_route_table_description)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        pulumi.set(__self__, "transit_router_route_table_name", transit_router_route_table_name)
        pulumi.set(__self__, "transit_router_route_table_type", transit_router_route_table_type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterRouteTableDescription")
    def transit_router_route_table_description(self) -> str:
        """
        The description of the transit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_description")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        ID of the trabsit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> str:
        """
        Name of the transit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableType")
    def transit_router_route_table_type(self) -> str:
        """
        The type of the transit router route table to query. Valid values `Creating`, `Active` and `Deleting`..
        """
        return pulumi.get(self, "transit_router_route_table_type")


@pulumi.output_type
class GetTransitRouterVbrAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: bool,
                 id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_description: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 vbr_id: str,
                 vbr_owner_id: str):
        """
        :param bool auto_publish_route_enabled: ID of the region where the conflicted VBR is located.
        :param str resource_type: Type of the resource.
        :param str status: The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        :param str transit_router_attachment_id: ID of the transit router VBR attachment.
        :param str transit_router_attachment_name: Name of the transit router attachment.
        :param str vbr_id: ID of the VBR.
        :param str vbr_owner_id: The Owner ID of the VBR.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "vbr_id", vbr_id)
        pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> bool:
        """
        ID of the region where the conflicted VBR is located.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> str:
        return pulumi.get(self, "transit_router_attachment_description")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        ID of the transit router VBR attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        Name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> str:
        """
        ID of the VBR.
        """
        return pulumi.get(self, "vbr_id")

    @property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> str:
        """
        The Owner ID of the VBR.
        """
        return pulumi.get(self, "vbr_owner_id")


@pulumi.output_type
class GetTransitRouterVpcAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 id: str,
                 payment_type: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_description: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 vpc_id: str,
                 vpc_owner_id: str,
                 zone_mappings: Sequence['outputs.GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult']):
        """
        :param str id: The ID of the transit router.
        :param str payment_type: The payment type of the resource.
        :param str resource_type: Type of the resource.
        :param str status: The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        :param str transit_router_attachment_description: The description of transit router attachment.
        :param str transit_router_attachment_id: ID of the transit router VBR attachment.
        :param str transit_router_attachment_name: Name of the transit router attachment.
        :param str vpc_id: ID of the VPC.
        :param str vpc_owner_id: The Owner ID of the VPC.
        :param Sequence['GetTransitRouterVpcAttachmentsAttachmentZoneMappingArgs'] zone_mappings: The mappings of zone
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> str:
        """
        The description of transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        ID of the transit router VBR attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        Name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> str:
        """
        The Owner ID of the VPC.
        """
        return pulumi.get(self, "vpc_owner_id")

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Sequence['outputs.GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult']:
        """
        The mappings of zone
        """
        return pulumi.get(self, "zone_mappings")


@pulumi.output_type
class GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult(dict):
    def __init__(__self__, *,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param str vswitch_id: The VSwitch ID.
        :param str zone_id: The zone ID.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTransitRouterVpnAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: bool,
                 create_time: str,
                 id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_description: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_id: str,
                 vpn_id: str,
                 vpn_owner_id: str,
                 zones: Sequence['outputs.GetTransitRouterVpnAttachmentsAttachmentZoneResult']):
        """
        :param bool auto_publish_route_enabled: Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
        :param str create_time: The creation time of the resource.
        :param str resource_type: Type of the resource.
        :param str status: The status of the transit router attachment.
        :param str transit_router_attachment_description: The description of the VPN connection.
        :param str transit_router_attachment_name: The name of the VPN connection.
        :param str transit_router_id: The ID of the forwarding router instance.
        :param str vpn_id: The id of the vpn.
        :param str vpn_owner_id: The owner id of vpn.
        :param Sequence['GetTransitRouterVpnAttachmentsAttachmentZoneArgs'] zones: The list of zone mapping.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "vpn_id", vpn_id)
        pulumi.set(__self__, "vpn_owner_id", vpn_owner_id)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> bool:
        """
        Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router attachment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> str:
        """
        The description of the VPN connection.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> str:
        """
        The id of the vpn.
        """
        return pulumi.get(self, "vpn_id")

    @property
    @pulumi.getter(name="vpnOwnerId")
    def vpn_owner_id(self) -> str:
        """
        The owner id of vpn.
        """
        return pulumi.get(self, "vpn_owner_id")

    @property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetTransitRouterVpnAttachmentsAttachmentZoneResult']:
        """
        The list of zone mapping.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetTransitRouterVpnAttachmentsAttachmentZoneResult(dict):
    def __init__(__self__, *,
                 zone_id: str):
        """
        :param str zone_id: The id of the zone.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTransitRoutersTransitRouterResult(dict):
    def __init__(__self__, *,
                 ali_uid: str,
                 cen_id: str,
                 id: str,
                 status: str,
                 transit_router_description: str,
                 transit_router_id: str,
                 transit_router_name: str,
                 type: str,
                 xgw_vip: str):
        """
        :param str ali_uid: The UID of the Aliyun.
        :param str cen_id: The ID of the CEN instance.
        :param str id: The ID of the resource, It is formatted to `<cen_id>:<transit_router_id>`. **NOTE:** Before 1.151.0, It is formatted to `<transit_router_id>`.
        :param str status: The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
        :param str transit_router_description: The description of the transit router.
        :param str transit_router_id: The ID of the transit router.
        :param str transit_router_name: The name of the transit router.
        :param str type: The Type of the transit router.
        :param str xgw_vip: The vip of the XGW.
        """
        pulumi.set(__self__, "ali_uid", ali_uid)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_description", transit_router_description)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_name", transit_router_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "xgw_vip", xgw_vip)

    @property
    @pulumi.getter(name="aliUid")
    def ali_uid(self) -> str:
        """
        The UID of the Aliyun.
        """
        return pulumi.get(self, "ali_uid")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource, It is formatted to `<cen_id>:<transit_router_id>`. **NOTE:** Before 1.151.0, It is formatted to `<transit_router_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterDescription")
    def transit_router_description(self) -> str:
        """
        The description of the transit router.
        """
        return pulumi.get(self, "transit_router_description")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> str:
        """
        The name of the transit router.
        """
        return pulumi.get(self, "transit_router_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Type of the transit router.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="xgwVip")
    def xgw_vip(self) -> str:
        """
        The vip of the XGW.
        """
        return pulumi.get(self, "xgw_vip")


@pulumi.output_type
class GetVbrHealthChecksCheckResult(dict):
    def __init__(__self__, *,
                 cen_id: str,
                 health_check_interval: int,
                 health_check_source_ip: str,
                 health_check_target_ip: str,
                 healthy_threshold: int,
                 id: str,
                 vbr_instance_id: str,
                 vbr_instance_region_id: str):
        """
        :param str cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param int health_check_interval: The time interval at which probe packets are sent during the health check.
        :param str health_check_source_ip: The source IP address of the health check.
        :param str health_check_target_ip: The destination IP address of the health check.
        :param int healthy_threshold: The number of probe packets that are sent during the health check.
        :param str id: The ID of the CEN VBR Heath Check.
        :param str vbr_instance_id: The ID of the VBR instance.
        :param str vbr_instance_region_id: The ID of the region where the VBR instance is deployed.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "vbr_instance_id", vbr_instance_id)
        pulumi.set(__self__, "vbr_instance_region_id", vbr_instance_region_id)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> int:
        """
        The time interval at which probe packets are sent during the health check.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> str:
        """
        The source IP address of the health check.
        """
        return pulumi.get(self, "health_check_source_ip")

    @property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> str:
        """
        The destination IP address of the health check.
        """
        return pulumi.get(self, "health_check_target_ip")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        The number of probe packets that are sent during the health check.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the CEN VBR Heath Check.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="vbrInstanceId")
    def vbr_instance_id(self) -> str:
        """
        The ID of the VBR instance.
        """
        return pulumi.get(self, "vbr_instance_id")

    @property
    @pulumi.getter(name="vbrInstanceRegionId")
    def vbr_instance_region_id(self) -> str:
        """
        The ID of the region where the VBR instance is deployed.
        """
        return pulumi.get(self, "vbr_instance_region_id")


