# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TransitRouteTableAggregationArgs', 'TransitRouteTableAggregation']

@pulumi.input_type
class TransitRouteTableAggregationArgs:
    def __init__(__self__, *,
                 transit_route_table_aggregation_cidr: pulumi.Input[str],
                 transit_route_table_aggregation_scope: pulumi.Input[str],
                 transit_route_table_id: pulumi.Input[str],
                 transit_route_table_aggregation_description: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TransitRouteTableAggregation resource.
        :param pulumi.Input[str] transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        :param pulumi.Input[str] transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        :param pulumi.Input[str] transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        :param pulumi.Input[str] transit_route_table_aggregation_description: The description of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_name: The name of the aggregate route.
        """
        pulumi.set(__self__, "transit_route_table_aggregation_cidr", transit_route_table_aggregation_cidr)
        pulumi.set(__self__, "transit_route_table_aggregation_scope", transit_route_table_aggregation_scope)
        pulumi.set(__self__, "transit_route_table_id", transit_route_table_id)
        if transit_route_table_aggregation_description is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_description", transit_route_table_aggregation_description)
        if transit_route_table_aggregation_name is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_name", transit_route_table_aggregation_name)

    @property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> pulumi.Input[str]:
        """
        The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @transit_route_table_aggregation_cidr.setter
    def transit_route_table_aggregation_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_route_table_aggregation_cidr", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationScope")
    def transit_route_table_aggregation_scope(self) -> pulumi.Input[str]:
        """
        The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_scope")

    @transit_route_table_aggregation_scope.setter
    def transit_route_table_aggregation_scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_route_table_aggregation_scope", value)

    @property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> pulumi.Input[str]:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")

    @transit_route_table_id.setter
    def transit_route_table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_route_table_id", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationDescription")
    def transit_route_table_aggregation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_description")

    @transit_route_table_aggregation_description.setter
    def transit_route_table_aggregation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_description", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationName")
    def transit_route_table_aggregation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_name")

    @transit_route_table_aggregation_name.setter
    def transit_route_table_aggregation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_name", value)


@pulumi.input_type
class _TransitRouteTableAggregationState:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_cidr: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_description: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_name: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_scope: Optional[pulumi.Input[str]] = None,
                 transit_route_table_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TransitRouteTableAggregation resources.
        :param pulumi.Input[str] status: The status of the Transit Route Table Aggregation.
        :param pulumi.Input[str] transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        :param pulumi.Input[str] transit_route_table_aggregation_description: The description of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_name: The name of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        :param pulumi.Input[str] transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_route_table_aggregation_cidr is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_cidr", transit_route_table_aggregation_cidr)
        if transit_route_table_aggregation_description is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_description", transit_route_table_aggregation_description)
        if transit_route_table_aggregation_name is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_name", transit_route_table_aggregation_name)
        if transit_route_table_aggregation_scope is not None:
            pulumi.set(__self__, "transit_route_table_aggregation_scope", transit_route_table_aggregation_scope)
        if transit_route_table_id is not None:
            pulumi.set(__self__, "transit_route_table_id", transit_route_table_id)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Transit Route Table Aggregation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @transit_route_table_aggregation_cidr.setter
    def transit_route_table_aggregation_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_cidr", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationDescription")
    def transit_route_table_aggregation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_description")

    @transit_route_table_aggregation_description.setter
    def transit_route_table_aggregation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_description", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationName")
    def transit_route_table_aggregation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_name")

    @transit_route_table_aggregation_name.setter
    def transit_route_table_aggregation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_name", value)

    @property
    @pulumi.getter(name="transitRouteTableAggregationScope")
    def transit_route_table_aggregation_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_scope")

    @transit_route_table_aggregation_scope.setter
    def transit_route_table_aggregation_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_aggregation_scope", value)

    @property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")

    @transit_route_table_id.setter
    def transit_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_route_table_id", value)


class TransitRouteTableAggregation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 transit_route_table_aggregation_cidr: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_description: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_name: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_scope: Optional[pulumi.Input[str]] = None,
                 transit_route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Route Table Aggregation resource.

        For information about Cloud Enterprise Network (CEN) Transit Route Table Aggregation and how to use it, see [What is Transit Route Table Aggregation](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutetableaggregation).

        > **NOTE:** Available since v1.202.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router = alicloud.cen.TransitRouter("exampleTransitRouter",
            transit_router_name="tf_example",
            cen_id=example_instance.id)
        example_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("exampleTransitRouterRouteTable", transit_router_id=example_transit_router.transit_router_id)
        example_transit_route_table_aggregation = alicloud.cen.TransitRouteTableAggregation("exampleTransitRouteTableAggregation",
            transit_route_table_id=example_transit_router_route_table.transit_router_route_table_id,
            transit_route_table_aggregation_cidr="10.0.0.0/8",
            transit_route_table_aggregation_scope="VPC",
            transit_route_table_aggregation_name="tf_example",
            transit_route_table_aggregation_description="tf_example")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Route Table Aggregation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouteTableAggregation:TransitRouteTableAggregation example <transit_route_table_id>:<transit_route_table_aggregation_cidr>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        :param pulumi.Input[str] transit_route_table_aggregation_description: The description of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_name: The name of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        :param pulumi.Input[str] transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouteTableAggregationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Route Table Aggregation resource.

        For information about Cloud Enterprise Network (CEN) Transit Route Table Aggregation and how to use it, see [What is Transit Route Table Aggregation](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutetableaggregation).

        > **NOTE:** Available since v1.202.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router = alicloud.cen.TransitRouter("exampleTransitRouter",
            transit_router_name="tf_example",
            cen_id=example_instance.id)
        example_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("exampleTransitRouterRouteTable", transit_router_id=example_transit_router.transit_router_id)
        example_transit_route_table_aggregation = alicloud.cen.TransitRouteTableAggregation("exampleTransitRouteTableAggregation",
            transit_route_table_id=example_transit_router_route_table.transit_router_route_table_id,
            transit_route_table_aggregation_cidr="10.0.0.0/8",
            transit_route_table_aggregation_scope="VPC",
            transit_route_table_aggregation_name="tf_example",
            transit_route_table_aggregation_description="tf_example")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Route Table Aggregation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouteTableAggregation:TransitRouteTableAggregation example <transit_route_table_id>:<transit_route_table_aggregation_cidr>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouteTableAggregationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouteTableAggregationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 transit_route_table_aggregation_cidr: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_description: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_name: Optional[pulumi.Input[str]] = None,
                 transit_route_table_aggregation_scope: Optional[pulumi.Input[str]] = None,
                 transit_route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouteTableAggregationArgs.__new__(TransitRouteTableAggregationArgs)

            if transit_route_table_aggregation_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'transit_route_table_aggregation_cidr'")
            __props__.__dict__["transit_route_table_aggregation_cidr"] = transit_route_table_aggregation_cidr
            __props__.__dict__["transit_route_table_aggregation_description"] = transit_route_table_aggregation_description
            __props__.__dict__["transit_route_table_aggregation_name"] = transit_route_table_aggregation_name
            if transit_route_table_aggregation_scope is None and not opts.urn:
                raise TypeError("Missing required property 'transit_route_table_aggregation_scope'")
            __props__.__dict__["transit_route_table_aggregation_scope"] = transit_route_table_aggregation_scope
            if transit_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_route_table_id'")
            __props__.__dict__["transit_route_table_id"] = transit_route_table_id
            __props__.__dict__["status"] = None
        super(TransitRouteTableAggregation, __self__).__init__(
            'alicloud:cen/transitRouteTableAggregation:TransitRouteTableAggregation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_route_table_aggregation_cidr: Optional[pulumi.Input[str]] = None,
            transit_route_table_aggregation_description: Optional[pulumi.Input[str]] = None,
            transit_route_table_aggregation_name: Optional[pulumi.Input[str]] = None,
            transit_route_table_aggregation_scope: Optional[pulumi.Input[str]] = None,
            transit_route_table_id: Optional[pulumi.Input[str]] = None) -> 'TransitRouteTableAggregation':
        """
        Get an existing TransitRouteTableAggregation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] status: The status of the Transit Route Table Aggregation.
        :param pulumi.Input[str] transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        :param pulumi.Input[str] transit_route_table_aggregation_description: The description of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_name: The name of the aggregate route.
        :param pulumi.Input[str] transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        :param pulumi.Input[str] transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouteTableAggregationState.__new__(_TransitRouteTableAggregationState)

        __props__.__dict__["status"] = status
        __props__.__dict__["transit_route_table_aggregation_cidr"] = transit_route_table_aggregation_cidr
        __props__.__dict__["transit_route_table_aggregation_description"] = transit_route_table_aggregation_description
        __props__.__dict__["transit_route_table_aggregation_name"] = transit_route_table_aggregation_name
        __props__.__dict__["transit_route_table_aggregation_scope"] = transit_route_table_aggregation_scope
        __props__.__dict__["transit_route_table_id"] = transit_route_table_id
        return TransitRouteTableAggregation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Transit Route Table Aggregation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> pulumi.Output[str]:
        """
        The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @property
    @pulumi.getter(name="transitRouteTableAggregationDescription")
    def transit_route_table_aggregation_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_description")

    @property
    @pulumi.getter(name="transitRouteTableAggregationName")
    def transit_route_table_aggregation_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_name")

    @property
    @pulumi.getter(name="transitRouteTableAggregationScope")
    def transit_route_table_aggregation_scope(self) -> pulumi.Output[str]:
        """
        The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
        """
        return pulumi.get(self, "transit_route_table_aggregation_scope")

    @property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> pulumi.Output[str]:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")

