# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TransitRouterGrantAttachmentArgs', 'TransitRouterGrantAttachment']

@pulumi.input_type
class TransitRouterGrantAttachmentArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[str],
                 cen_owner_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 order_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TransitRouterGrantAttachment resource.
        :param pulumi.Input[str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        :param pulumi.Input[str] cen_owner_id: The ID of the Alibaba Cloud account to which the CEN instance belongs.
        :param pulumi.Input[str] instance_id: The ID of the network instance.
        :param pulumi.Input[str] instance_type: The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        :param pulumi.Input[str] order_type: The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        if order_type is not None:
            pulumi.set(__self__, "order_type", order_type)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[str]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> pulumi.Input[str]:
        """
        The ID of the Alibaba Cloud account to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_owner_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="orderType")
    def order_type(self) -> Optional[pulumi.Input[str]]:
        """
        The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        return pulumi.get(self, "order_type")

    @order_type.setter
    def order_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_type", value)


@pulumi.input_type
class _TransitRouterGrantAttachmentState:
    def __init__(__self__, *,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 cen_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 order_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterGrantAttachment resources.
        :param pulumi.Input[str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        :param pulumi.Input[str] cen_owner_id: The ID of the Alibaba Cloud account to which the CEN instance belongs.
        :param pulumi.Input[str] instance_id: The ID of the network instance.
        :param pulumi.Input[str] instance_type: The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        :param pulumi.Input[str] order_type: The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if cen_owner_id is not None:
            pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if order_type is not None:
            pulumi.set(__self__, "order_type", order_type)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_owner_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="orderType")
    def order_type(self) -> Optional[pulumi.Input[str]]:
        """
        The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        return pulumi.get(self, "order_type")

    @order_type.setter
    def order_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_type", value)


class TransitRouterGrantAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 cen_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 order_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Grant Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Grant Attachment and how to use it, see [What is Transit Router Grant Attachment](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/grantinstancetotransitrouter).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_account()
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router_grant_attachment = alicloud.cen.TransitRouterGrantAttachment("exampleTransitRouterGrantAttachment",
            cen_id=example_instance.id,
            cen_owner_id=default.id,
            instance_id=example_network.id,
            instance_type="VPC",
            order_type="PayByCenOwner")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Grant Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouterGrantAttachment:TransitRouterGrantAttachment example <instance_type>:<instance_id>:<cen_owner_id>:<cen_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        :param pulumi.Input[str] cen_owner_id: The ID of the Alibaba Cloud account to which the CEN instance belongs.
        :param pulumi.Input[str] instance_id: The ID of the network instance.
        :param pulumi.Input[str] instance_type: The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        :param pulumi.Input[str] order_type: The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterGrantAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Grant Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Grant Attachment and how to use it, see [What is Transit Router Grant Attachment](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/grantinstancetotransitrouter).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_account()
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_transit_router_grant_attachment = alicloud.cen.TransitRouterGrantAttachment("exampleTransitRouterGrantAttachment",
            cen_id=example_instance.id,
            cen_owner_id=default.id,
            instance_id=example_network.id,
            instance_type="VPC",
            order_type="PayByCenOwner")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Grant Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouterGrantAttachment:TransitRouterGrantAttachment example <instance_type>:<instance_id>:<cen_owner_id>:<cen_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterGrantAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterGrantAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 cen_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 order_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterGrantAttachmentArgs.__new__(TransitRouterGrantAttachmentArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            if cen_owner_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_owner_id'")
            __props__.__dict__["cen_owner_id"] = cen_owner_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["order_type"] = order_type
        super(TransitRouterGrantAttachment, __self__).__init__(
            'alicloud:cen/transitRouterGrantAttachment:TransitRouterGrantAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_id: Optional[pulumi.Input[str]] = None,
            cen_owner_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            order_type: Optional[pulumi.Input[str]] = None) -> 'TransitRouterGrantAttachment':
        """
        Get an existing TransitRouterGrantAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        :param pulumi.Input[str] cen_owner_id: The ID of the Alibaba Cloud account to which the CEN instance belongs.
        :param pulumi.Input[str] instance_id: The ID of the network instance.
        :param pulumi.Input[str] instance_type: The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        :param pulumi.Input[str] order_type: The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterGrantAttachmentState.__new__(_TransitRouterGrantAttachmentState)

        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["cen_owner_id"] = cen_owner_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["order_type"] = order_type
        return TransitRouterGrantAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[str]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> pulumi.Output[str]:
        """
        The ID of the Alibaba Cloud account to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_owner_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="orderType")
    def order_type(self) -> pulumi.Output[str]:
        """
        The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
        """
        return pulumi.get(self, "order_type")

