# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TransitRouterPeerAttachmentArgs', 'TransitRouterPeerAttachment']

@pulumi.input_type
class TransitRouterPeerAttachmentArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[str],
                 peer_transit_router_id: pulumi.Input[str],
                 peer_transit_router_region_id: pulumi.Input[str],
                 auto_publish_route_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bandwidth_type: Optional[pulumi.Input[str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[bool]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TransitRouterPeerAttachment resource.
        :param pulumi.Input[str] cen_id: The ID of the CEN.
        :param pulumi.Input[str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region ID of peer transit router.
        :param pulumi.Input[bool] auto_publish_route_enabled: Auto publish route enabled. The system default value is `false`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the bandwidth package.
        :param pulumi.Input[str] bandwidth_type: The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        :param pulumi.Input[str] cen_bandwidth_package_id: The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        :param pulumi.Input[bool] dry_run: Whether to perform pre-check for this request, including permission, instance status verification, etc.
        :param pulumi.Input[str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
        :param pulumi.Input[bool] route_table_association_enabled: Whether to association route table. System default is `false`.
        :param pulumi.Input[bool] route_table_propagation_enabled: Whether to propagation route table. System default is `false`.
        :param pulumi.Input[str] transit_router_attachment_description: The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        :param pulumi.Input[str] transit_router_attachment_name: The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        :param pulumi.Input[str] transit_router_id: The ID of the transit router to attach.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if cen_bandwidth_package_id is not None:
            pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Input[str]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_transit_router_id", value)

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> pulumi.Input[str]:
        """
        The region ID of peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto publish route enabled. The system default value is `false`.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_type", value)

    @property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @cen_bandwidth_package_id.setter
    def cen_bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_bandwidth_package_id", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to perform pre-check for this request, including permission, instance status verification, etc.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="routeTableAssociationEnabled")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to association route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @property
    @pulumi.getter(name="routeTablePropagationEnabled")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to propagation route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the transit router to attach.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)


@pulumi.input_type
class _TransitRouterPeerAttachmentState:
    def __init__(__self__, *,
                 auto_publish_route_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bandwidth_type: Optional[pulumi.Input[str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterPeerAttachment resources.
        :param pulumi.Input[bool] auto_publish_route_enabled: Auto publish route enabled. The system default value is `false`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the bandwidth package.
        :param pulumi.Input[str] bandwidth_type: The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        :param pulumi.Input[str] cen_bandwidth_package_id: The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        :param pulumi.Input[str] cen_id: The ID of the CEN.
        :param pulumi.Input[bool] dry_run: Whether to perform pre-check for this request, including permission, instance status verification, etc.
        :param pulumi.Input[str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region ID of peer transit router.
        :param pulumi.Input[str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
        :param pulumi.Input[bool] route_table_association_enabled: Whether to association route table. System default is `false`.
        :param pulumi.Input[bool] route_table_propagation_enabled: Whether to propagation route table. System default is `false`.
        :param pulumi.Input[str] status: The associating status of the network.
        :param pulumi.Input[str] transit_router_attachment_description: The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        :param pulumi.Input[str] transit_router_attachment_id: The ID of transit router attachment id.
        :param pulumi.Input[str] transit_router_attachment_name: The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        :param pulumi.Input[str] transit_router_id: The ID of the transit router to attach.
        """
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if cen_bandwidth_package_id is not None:
            pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if peer_transit_router_id is not None:
            pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        if peer_transit_router_region_id is not None:
            pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto publish route enabled. The system default value is `false`.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_type", value)

    @property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @cen_bandwidth_package_id.setter
    def cen_bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_bandwidth_package_id", value)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to perform pre-check for this request, including permission, instance status verification, etc.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_transit_router_id", value)

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="routeTableAssociationEnabled")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to association route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @property
    @pulumi.getter(name="routeTablePropagationEnabled")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to propagation route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The associating status of the network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of transit router attachment id.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the transit router to attach.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)


class TransitRouterPeerAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bandwidth_type: Optional[pulumi.Input[str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[bool]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CEN transit router peer attachment resource that associate the transit router with the CEN instance. [What is CEN transit router peer attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterpeerattachment)

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        hz = alicloud.Provider("hz", region=region)
        bj = alicloud.Provider("bj", region=peer_region)
        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name=name,
            protection_level="REDUCED",
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_bandwidth_package = alicloud.cen.BandwidthPackage("exampleBandwidthPackage",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China",
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("exampleBandwidthPackageAttachment",
            instance_id=example_instance.id,
            bandwidth_package_id=example_bandwidth_package.id,
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_transit_router = alicloud.cen.TransitRouter("exampleTransitRouter", cen_id=example_bandwidth_package_attachment.instance_id,
        opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id,
        opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("exampleTransitRouterPeerAttachment",
            cen_id=example_instance.id,
            transit_router_id=example_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        ```

        ## Import

        CEN instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example tr-********:tr-attach-*******
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_publish_route_enabled: Auto publish route enabled. The system default value is `false`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the bandwidth package.
        :param pulumi.Input[str] bandwidth_type: The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        :param pulumi.Input[str] cen_bandwidth_package_id: The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        :param pulumi.Input[str] cen_id: The ID of the CEN.
        :param pulumi.Input[bool] dry_run: Whether to perform pre-check for this request, including permission, instance status verification, etc.
        :param pulumi.Input[str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region ID of peer transit router.
        :param pulumi.Input[str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
        :param pulumi.Input[bool] route_table_association_enabled: Whether to association route table. System default is `false`.
        :param pulumi.Input[bool] route_table_propagation_enabled: Whether to propagation route table. System default is `false`.
        :param pulumi.Input[str] transit_router_attachment_description: The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        :param pulumi.Input[str] transit_router_attachment_name: The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        :param pulumi.Input[str] transit_router_id: The ID of the transit router to attach.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterPeerAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CEN transit router peer attachment resource that associate the transit router with the CEN instance. [What is CEN transit router peer attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterpeerattachment)

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        hz = alicloud.Provider("hz", region=region)
        bj = alicloud.Provider("bj", region=peer_region)
        example_instance = alicloud.cen.Instance("exampleInstance",
            cen_instance_name=name,
            protection_level="REDUCED",
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_bandwidth_package = alicloud.cen.BandwidthPackage("exampleBandwidthPackage",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China",
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("exampleBandwidthPackageAttachment",
            instance_id=example_instance.id,
            bandwidth_package_id=example_bandwidth_package.id,
            opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_transit_router = alicloud.cen.TransitRouter("exampleTransitRouter", cen_id=example_bandwidth_package_attachment.instance_id,
        opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id,
        opts=pulumi.ResourceOptions(provider=alicloud["bj"]))
        example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("exampleTransitRouterPeerAttachment",
            cen_id=example_instance.id,
            transit_router_id=example_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            opts=pulumi.ResourceOptions(provider=alicloud["hz"]))
        ```

        ## Import

        CEN instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example tr-********:tr-attach-*******
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterPeerAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterPeerAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bandwidth_type: Optional[pulumi.Input[str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[bool]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterPeerAttachmentArgs.__new__(TransitRouterPeerAttachmentArgs)

            __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_type"] = bandwidth_type
            __props__.__dict__["cen_bandwidth_package_id"] = cen_bandwidth_package_id
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["dry_run"] = dry_run
            if peer_transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_transit_router_id'")
            __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
            if peer_transit_router_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_transit_router_region_id'")
            __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
            __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
            __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_attachment_id"] = None
        super(TransitRouterPeerAttachment, __self__).__init__(
            'alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_publish_route_enabled: Optional[pulumi.Input[bool]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            bandwidth_type: Optional[pulumi.Input[str]] = None,
            cen_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
            cen_id: Optional[pulumi.Input[str]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            peer_transit_router_id: Optional[pulumi.Input[str]] = None,
            peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            route_table_association_enabled: Optional[pulumi.Input[bool]] = None,
            route_table_propagation_enabled: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_description: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None) -> 'TransitRouterPeerAttachment':
        """
        Get an existing TransitRouterPeerAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_publish_route_enabled: Auto publish route enabled. The system default value is `false`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the bandwidth package.
        :param pulumi.Input[str] bandwidth_type: The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        :param pulumi.Input[str] cen_bandwidth_package_id: The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        :param pulumi.Input[str] cen_id: The ID of the CEN.
        :param pulumi.Input[bool] dry_run: Whether to perform pre-check for this request, including permission, instance status verification, etc.
        :param pulumi.Input[str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region ID of peer transit router.
        :param pulumi.Input[str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
        :param pulumi.Input[bool] route_table_association_enabled: Whether to association route table. System default is `false`.
        :param pulumi.Input[bool] route_table_propagation_enabled: Whether to propagation route table. System default is `false`.
        :param pulumi.Input[str] status: The associating status of the network.
        :param pulumi.Input[str] transit_router_attachment_description: The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        :param pulumi.Input[str] transit_router_attachment_id: The ID of transit router attachment id.
        :param pulumi.Input[str] transit_router_attachment_name: The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        :param pulumi.Input[str] transit_router_id: The ID of the transit router to attach.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterPeerAttachmentState.__new__(_TransitRouterPeerAttachmentState)

        __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_type"] = bandwidth_type
        __props__.__dict__["cen_bandwidth_package_id"] = cen_bandwidth_package_id
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
        __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
        __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        return TransitRouterPeerAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Auto publish route enabled. The system default value is `false`.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The bandwidth of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> pulumi.Output[str]:
        """
        The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth_type")

    @property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to perform pre-check for this request, including permission, instance status verification, etc.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Output[str]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> pulumi.Output[str]:
        """
        The region ID of peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[Optional[str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="routeTableAssociationEnabled")
    def route_table_association_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to association route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @property
    @pulumi.getter(name="routeTablePropagationEnabled")
    def route_table_propagation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to propagation route table. System default is `false`.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The associating status of the network.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[str]:
        """
        The ID of transit router attachment id.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the transit router to attach.
        """
        return pulumi.get(self, "transit_router_id")

