# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AggregateCompliancePackConfigRule',
    'AggregateCompliancePackConfigRuleConfigRuleParameter',
    'AggregateCompliancePackConfigRuleId',
    'AggregatorAggregatorAccount',
    'CompliancePackConfigRule',
    'CompliancePackConfigRuleConfigRuleParameter',
    'CompliancePackConfigRuleId',
    'RuleCompliance',
    'GetAggregateCompliancePacksPackResult',
    'GetAggregateCompliancePacksPackConfigRuleResult',
    'GetAggregateCompliancePacksPackConfigRuleConfigRuleParameterResult',
    'GetAggregateConfigRulesRuleResult',
    'GetAggregateConfigRulesRuleComplianceResult',
    'GetAggregateDeliveriesDeliveryResult',
    'GetAggregatorsAggregatorResult',
    'GetAggregatorsAggregatorAggregatorAccountResult',
    'GetCompliancePacksPackResult',
    'GetCompliancePacksPackConfigRuleResult',
    'GetCompliancePacksPackConfigRuleConfigRuleParameterResult',
    'GetConfigurationRecordersRecorderResult',
    'GetDeliveriesDeliveryResult',
    'GetDeliveryChannelsChannelResult',
    'GetRulesRuleResult',
    'GetRulesRuleComplianceResult',
]

@pulumi.output_type
class AggregateCompliancePackConfigRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedRuleIdentifier":
            suggest = "managed_rule_identifier"
        elif key == "configRuleParameters":
            suggest = "config_rule_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregateCompliancePackConfigRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregateCompliancePackConfigRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregateCompliancePackConfigRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_rule_identifier: str,
                 config_rule_parameters: Optional[Sequence['outputs.AggregateCompliancePackConfigRuleConfigRuleParameter']] = None):
        """
        :param str managed_rule_identifier: The Managed Rule Identifier.
        :param Sequence['AggregateCompliancePackConfigRuleConfigRuleParameterArgs'] config_rule_parameters: A list of parameter rules. See `config_rule_parameters` below.
        """
        pulumi.set(__self__, "managed_rule_identifier", managed_rule_identifier)
        if config_rule_parameters is not None:
            pulumi.set(__self__, "config_rule_parameters", config_rule_parameters)

    @property
    @pulumi.getter(name="managedRuleIdentifier")
    def managed_rule_identifier(self) -> str:
        """
        The Managed Rule Identifier.
        """
        return pulumi.get(self, "managed_rule_identifier")

    @property
    @pulumi.getter(name="configRuleParameters")
    def config_rule_parameters(self) -> Optional[Sequence['outputs.AggregateCompliancePackConfigRuleConfigRuleParameter']]:
        """
        A list of parameter rules. See `config_rule_parameters` below.
        """
        return pulumi.get(self, "config_rule_parameters")


@pulumi.output_type
class AggregateCompliancePackConfigRuleConfigRuleParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregateCompliancePackConfigRuleConfigRuleParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregateCompliancePackConfigRuleConfigRuleParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregateCompliancePackConfigRuleConfigRuleParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: Optional[str] = None,
                 parameter_value: Optional[str] = None):
        """
        :param str parameter_name: The Parameter Name.
        :param str parameter_value: The Parameter Value.
        """
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[str]:
        """
        The Parameter Name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[str]:
        """
        The Parameter Value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class AggregateCompliancePackConfigRuleId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configRuleId":
            suggest = "config_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregateCompliancePackConfigRuleId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregateCompliancePackConfigRuleId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregateCompliancePackConfigRuleId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_rule_id: Optional[str] = None):
        """
        :param str config_rule_id: The rule ID of Aggregate Config Rule.
        """
        if config_rule_id is not None:
            pulumi.set(__self__, "config_rule_id", config_rule_id)

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> Optional[str]:
        """
        The rule ID of Aggregate Config Rule.
        """
        return pulumi.get(self, "config_rule_id")


@pulumi.output_type
class AggregatorAggregatorAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "accountType":
            suggest = "account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregatorAggregatorAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregatorAggregatorAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregatorAggregatorAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 account_name: str,
                 account_type: str):
        """
        :param str account_id: Aggregator account Uid.
        :param str account_name: Aggregator account name.
        :param str account_type: Aggregator account source type. Valid values: `ResourceDirectory`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_type", account_type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Aggregator account Uid.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Aggregator account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        Aggregator account source type. Valid values: `ResourceDirectory`.
        """
        return pulumi.get(self, "account_type")


@pulumi.output_type
class CompliancePackConfigRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedRuleIdentifier":
            suggest = "managed_rule_identifier"
        elif key == "configRuleParameters":
            suggest = "config_rule_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompliancePackConfigRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompliancePackConfigRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompliancePackConfigRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_rule_identifier: str,
                 config_rule_parameters: Optional[Sequence['outputs.CompliancePackConfigRuleConfigRuleParameter']] = None):
        """
        :param str managed_rule_identifier: The Managed Rule Identifier.
        :param Sequence['CompliancePackConfigRuleConfigRuleParameterArgs'] config_rule_parameters: A list of Config Rule Parameters. See `config_rule_parameters` below.
        """
        pulumi.set(__self__, "managed_rule_identifier", managed_rule_identifier)
        if config_rule_parameters is not None:
            pulumi.set(__self__, "config_rule_parameters", config_rule_parameters)

    @property
    @pulumi.getter(name="managedRuleIdentifier")
    def managed_rule_identifier(self) -> str:
        """
        The Managed Rule Identifier.
        """
        return pulumi.get(self, "managed_rule_identifier")

    @property
    @pulumi.getter(name="configRuleParameters")
    def config_rule_parameters(self) -> Optional[Sequence['outputs.CompliancePackConfigRuleConfigRuleParameter']]:
        """
        A list of Config Rule Parameters. See `config_rule_parameters` below.
        """
        return pulumi.get(self, "config_rule_parameters")


@pulumi.output_type
class CompliancePackConfigRuleConfigRuleParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompliancePackConfigRuleConfigRuleParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompliancePackConfigRuleConfigRuleParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompliancePackConfigRuleConfigRuleParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: Optional[str] = None,
                 parameter_value: Optional[str] = None):
        """
        :param str parameter_name: The parameter name.
        :param str parameter_value: The parameter value.
        """
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class CompliancePackConfigRuleId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configRuleId":
            suggest = "config_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompliancePackConfigRuleId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompliancePackConfigRuleId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompliancePackConfigRuleId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_rule_id: Optional[str] = None):
        """
        :param str config_rule_id: The rule ID of Config Rule.
        """
        if config_rule_id is not None:
            pulumi.set(__self__, "config_rule_id", config_rule_id)

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> Optional[str]:
        """
        The rule ID of Config Rule.
        """
        return pulumi.get(self, "config_rule_id")


@pulumi.output_type
class RuleCompliance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceType":
            suggest = "compliance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleCompliance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleCompliance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleCompliance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_type: Optional[str] = None,
                 count: Optional[int] = None):
        """
        :param str compliance_type: The type of compliance. Valid values: `COMPLIANT`, `NON_COMPLIANT`, `NOT_APPLICABLE`, `INSUFFICIENT_DATA`.
        :param int count: The count of compliance.
        """
        if compliance_type is not None:
            pulumi.set(__self__, "compliance_type", compliance_type)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter(name="complianceType")
    def compliance_type(self) -> Optional[str]:
        """
        The type of compliance. Valid values: `COMPLIANT`, `NON_COMPLIANT`, `NOT_APPLICABLE`, `INSUFFICIENT_DATA`.
        """
        return pulumi.get(self, "compliance_type")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The count of compliance.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class GetAggregateCompliancePacksPackResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 aggregate_compliance_pack_name: str,
                 aggregator_compliance_pack_id: str,
                 compliance_pack_template_id: str,
                 config_rules: Sequence['outputs.GetAggregateCompliancePacksPackConfigRuleResult'],
                 description: str,
                 id: str,
                 risk_level: int,
                 status: str):
        """
        :param str account_id: The Aliyun User Id.
        :param str aggregate_compliance_pack_name: The Aggregate Compliance Package Name.
        :param str aggregator_compliance_pack_id: The Aggregate Compliance Package Id.
        :param str compliance_pack_template_id: The template ID of the Compliance Package.
        :param Sequence['GetAggregateCompliancePacksPackConfigRuleArgs'] config_rules: A list of The Aggregate Compliance Package Rules.
        :param str description: The description of aggregate compliance pack.
        :param str id: The ID of the Aggregate Compliance Pack.
        :param int risk_level: The Risk Level.
        :param str status: The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "aggregate_compliance_pack_name", aggregate_compliance_pack_name)
        pulumi.set(__self__, "aggregator_compliance_pack_id", aggregator_compliance_pack_id)
        pulumi.set(__self__, "compliance_pack_template_id", compliance_pack_template_id)
        pulumi.set(__self__, "config_rules", config_rules)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Aliyun User Id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aggregateCompliancePackName")
    def aggregate_compliance_pack_name(self) -> str:
        """
        The Aggregate Compliance Package Name.
        """
        return pulumi.get(self, "aggregate_compliance_pack_name")

    @property
    @pulumi.getter(name="aggregatorCompliancePackId")
    def aggregator_compliance_pack_id(self) -> str:
        """
        The Aggregate Compliance Package Id.
        """
        return pulumi.get(self, "aggregator_compliance_pack_id")

    @property
    @pulumi.getter(name="compliancePackTemplateId")
    def compliance_pack_template_id(self) -> str:
        """
        The template ID of the Compliance Package.
        """
        return pulumi.get(self, "compliance_pack_template_id")

    @property
    @pulumi.getter(name="configRules")
    def config_rules(self) -> Sequence['outputs.GetAggregateCompliancePacksPackConfigRuleResult']:
        """
        A list of The Aggregate Compliance Package Rules.
        """
        return pulumi.get(self, "config_rules")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of aggregate compliance pack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Aggregate Compliance Pack.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> int:
        """
        The Risk Level.
        """
        return pulumi.get(self, "risk_level")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values `ACTIVE`, `CREATING`, `INACTIVE`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAggregateCompliancePacksPackConfigRuleResult(dict):
    def __init__(__self__, *,
                 config_rule_id: str,
                 config_rule_parameters: Sequence['outputs.GetAggregateCompliancePacksPackConfigRuleConfigRuleParameterResult'],
                 managed_rule_identifier: str):
        """
        :param str config_rule_id: The ID of the rule.
        :param Sequence['GetAggregateCompliancePacksPackConfigRuleConfigRuleParameterArgs'] config_rule_parameters: A list of parameter rules.
        :param str managed_rule_identifier: Managed Rule Identifier.
        """
        pulumi.set(__self__, "config_rule_id", config_rule_id)
        pulumi.set(__self__, "config_rule_parameters", config_rule_parameters)
        pulumi.set(__self__, "managed_rule_identifier", managed_rule_identifier)

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> str:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleParameters")
    def config_rule_parameters(self) -> Sequence['outputs.GetAggregateCompliancePacksPackConfigRuleConfigRuleParameterResult']:
        """
        A list of parameter rules.
        """
        return pulumi.get(self, "config_rule_parameters")

    @property
    @pulumi.getter(name="managedRuleIdentifier")
    def managed_rule_identifier(self) -> str:
        """
        Managed Rule Identifier.
        """
        return pulumi.get(self, "managed_rule_identifier")


@pulumi.output_type
class GetAggregateCompliancePacksPackConfigRuleConfigRuleParameterResult(dict):
    def __init__(__self__, *,
                 parameter_name: str,
                 parameter_value: str,
                 required: bool):
        """
        :param str parameter_name: The Parameter Name.
        :param str parameter_value: The Parameter Value.
        :param bool required: Required.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The Parameter Name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        The Parameter Value.
        """
        return pulumi.get(self, "parameter_value")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Required.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GetAggregateConfigRulesRuleResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 aggregate_config_rule_name: str,
                 aggregator_id: str,
                 compliance_pack_id: str,
                 compliances: Sequence['outputs.GetAggregateConfigRulesRuleComplianceResult'],
                 config_rule_arn: str,
                 config_rule_id: str,
                 config_rule_trigger_types: str,
                 description: str,
                 event_source: str,
                 exclude_resource_ids_scope: str,
                 id: str,
                 input_parameters: Mapping[str, Any],
                 maximum_execution_frequency: str,
                 modified_timestamp: str,
                 region_ids_scope: str,
                 resource_group_ids_scope: str,
                 resource_types_scopes: Sequence[str],
                 risk_level: int,
                 source_identifier: str,
                 source_owner: str,
                 status: str,
                 tag_key_scope: str,
                 tag_value_scope: str):
        """
        :param str account_id: The Aliyun User ID.
        :param str aggregate_config_rule_name: The config rule name.
        :param str aggregator_id: The ID of aggregator.
        :param str compliance_pack_id: The ID of Compliance Package.
        :param Sequence['GetAggregateConfigRulesRuleComplianceArgs'] compliances: The Compliance information.
        :param str config_rule_arn: The config rule arn.
        :param str config_rule_id: The ID of the rule.
        :param str config_rule_trigger_types: The trigger types of config rules.
        :param str description: The description of the rule.
        :param str event_source: Event source of the Config Rule.
        :param str exclude_resource_ids_scope: The id of the resources to be evaluated against the rule.
        :param str id: The ID of the Aggregate Config Rule.
        :param Mapping[str, Any] input_parameters: The settings of the input parameters for the rule.
        :param str maximum_execution_frequency: The frequency of the compliance evaluations.
        :param str modified_timestamp: The timestamp when the rule was last modified.
        :param str region_ids_scope: The scope of resource region ids.
        :param str resource_group_ids_scope: The scope of resource group ids.
        :param int risk_level: Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
        :param str source_identifier: The identifier of the managed rule or the arn of the custom function.
        :param str source_owner: The source owner of the Config Rule.
        :param str status: The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
        :param str tag_key_scope: The scope of tay key.
        :param str tag_value_scope: The scope of tay value.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "aggregate_config_rule_name", aggregate_config_rule_name)
        pulumi.set(__self__, "aggregator_id", aggregator_id)
        pulumi.set(__self__, "compliance_pack_id", compliance_pack_id)
        pulumi.set(__self__, "compliances", compliances)
        pulumi.set(__self__, "config_rule_arn", config_rule_arn)
        pulumi.set(__self__, "config_rule_id", config_rule_id)
        pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_source", event_source)
        pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "input_parameters", input_parameters)
        pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        pulumi.set(__self__, "modified_timestamp", modified_timestamp)
        pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "source_owner", source_owner)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Aliyun User ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aggregateConfigRuleName")
    def aggregate_config_rule_name(self) -> str:
        """
        The config rule name.
        """
        return pulumi.get(self, "aggregate_config_rule_name")

    @property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> str:
        """
        The ID of aggregator.
        """
        return pulumi.get(self, "aggregator_id")

    @property
    @pulumi.getter(name="compliancePackId")
    def compliance_pack_id(self) -> str:
        """
        The ID of Compliance Package.
        """
        return pulumi.get(self, "compliance_pack_id")

    @property
    @pulumi.getter
    def compliances(self) -> Sequence['outputs.GetAggregateConfigRulesRuleComplianceResult']:
        """
        The Compliance information.
        """
        return pulumi.get(self, "compliances")

    @property
    @pulumi.getter(name="configRuleArn")
    def config_rule_arn(self) -> str:
        """
        The config rule arn.
        """
        return pulumi.get(self, "config_rule_arn")

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> str:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> str:
        """
        The trigger types of config rules.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> str:
        """
        Event source of the Config Rule.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> str:
        """
        The id of the resources to be evaluated against the rule.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Aggregate Config Rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Mapping[str, Any]:
        """
        The settings of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> str:
        """
        The frequency of the compliance evaluations.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @property
    @pulumi.getter(name="modifiedTimestamp")
    def modified_timestamp(self) -> str:
        """
        The timestamp when the rule was last modified.
        """
        return pulumi.get(self, "modified_timestamp")

    @property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> str:
        """
        The scope of resource region ids.
        """
        return pulumi.get(self, "region_ids_scope")

    @property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> str:
        """
        The scope of resource group ids.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Sequence[str]:
        return pulumi.get(self, "resource_types_scopes")

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> int:
        """
        Optional, ForceNew) The Risk Level. Valid values `1`: critical, `2`: warning, `3`: info.
        """
        return pulumi.get(self, "risk_level")

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> str:
        """
        The identifier of the managed rule or the arn of the custom function.
        """
        return pulumi.get(self, "source_identifier")

    @property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> str:
        """
        The source owner of the Config Rule.
        """
        return pulumi.get(self, "source_owner")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> str:
        """
        The scope of tay key.
        """
        return pulumi.get(self, "tag_key_scope")

    @property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> str:
        """
        The scope of tay value.
        """
        return pulumi.get(self, "tag_value_scope")


@pulumi.output_type
class GetAggregateConfigRulesRuleComplianceResult(dict):
    def __init__(__self__, *,
                 compliance_type: str,
                 count: int):
        """
        :param str compliance_type: The Compliance Type.
        :param int count: The Count.
        """
        pulumi.set(__self__, "compliance_type", compliance_type)
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter(name="complianceType")
    def compliance_type(self) -> str:
        """
        The Compliance Type.
        """
        return pulumi.get(self, "compliance_type")

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The Count.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class GetAggregateDeliveriesDeliveryResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 aggregator_id: str,
                 configuration_item_change_notification: bool,
                 configuration_snapshot: bool,
                 delivery_channel_assume_role_arn: str,
                 delivery_channel_condition: str,
                 delivery_channel_id: str,
                 delivery_channel_name: str,
                 delivery_channel_target_arn: str,
                 delivery_channel_type: str,
                 description: str,
                 id: str,
                 non_compliant_notification: bool,
                 oversized_data_oss_target_arn: str,
                 status: int):
        """
        :param str account_id: The Aliyun User Id.
        :param str aggregator_id: The ID of the Aggregator.
        :param bool configuration_item_change_notification: Open or close delivery configuration change history.
        :param bool configuration_snapshot: Open or close timed snapshot of shipping resources.
        :param str delivery_channel_assume_role_arn: The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
        :param str delivery_channel_condition: The rule attached to the delivery method.
        :param str delivery_channel_id: The ID of the delivery method.
        :param str delivery_channel_name: The name of the delivery method.
        :param str delivery_channel_target_arn: The ARN of the delivery destination.
        :param str delivery_channel_type: The type of the delivery method.
        :param str description: The description of the delivery method.
        :param str id: The ID of the Aggregate Delivery.
        :param bool non_compliant_notification: Open or close non-compliance events of delivery resources.
        :param str oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.
        :param int status: The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "aggregator_id", aggregator_id)
        pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        pulumi.set(__self__, "delivery_channel_assume_role_arn", delivery_channel_assume_role_arn)
        pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        pulumi.set(__self__, "delivery_channel_id", delivery_channel_id)
        pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Aliyun User Id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> str:
        """
        The ID of the Aggregator.
        """
        return pulumi.get(self, "aggregator_id")

    @property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> bool:
        """
        Open or close delivery configuration change history.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> bool:
        """
        Open or close timed snapshot of shipping resources.
        """
        return pulumi.get(self, "configuration_snapshot")

    @property
    @pulumi.getter(name="deliveryChannelAssumeRoleArn")
    def delivery_channel_assume_role_arn(self) -> str:
        """
        The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
        """
        return pulumi.get(self, "delivery_channel_assume_role_arn")

    @property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> str:
        """
        The rule attached to the delivery method.
        """
        return pulumi.get(self, "delivery_channel_condition")

    @property
    @pulumi.getter(name="deliveryChannelId")
    def delivery_channel_id(self) -> str:
        """
        The ID of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_id")

    @property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> str:
        """
        The name of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_name")

    @property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> str:
        """
        The ARN of the delivery destination.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> str:
        """
        The type of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the delivery method.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Aggregate Delivery.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> bool:
        """
        Open or close non-compliance events of delivery resources.
        """
        return pulumi.get(self, "non_compliant_notification")

    @property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> str:
        """
        The oss ARN of the delivery channel when the value data oversized limit.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAggregatorsAggregatorResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 aggregator_accounts: Sequence['outputs.GetAggregatorsAggregatorAggregatorAccountResult'],
                 aggregator_id: str,
                 aggregator_name: str,
                 aggregator_type: str,
                 description: str,
                 id: str,
                 status: str):
        """
        :param str account_id: Aggregator account uid.
        :param Sequence['GetAggregatorsAggregatorAggregatorAccountArgs'] aggregator_accounts: Account information in aggregator.
        :param str aggregator_id: The id of aggregator.
        :param str aggregator_name: The name of aggregator.
        :param str aggregator_type: The type of aggregator.
        :param str description: The description of aggregator.
        :param str id: The id of the aggregator.
        :param str status: The status of the resource. Valid Values:  `0`: creating `1`: normal `2`: deleting.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "aggregator_accounts", aggregator_accounts)
        pulumi.set(__self__, "aggregator_id", aggregator_id)
        pulumi.set(__self__, "aggregator_name", aggregator_name)
        pulumi.set(__self__, "aggregator_type", aggregator_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Aggregator account uid.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aggregatorAccounts")
    def aggregator_accounts(self) -> Sequence['outputs.GetAggregatorsAggregatorAggregatorAccountResult']:
        """
        Account information in aggregator.
        """
        return pulumi.get(self, "aggregator_accounts")

    @property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> str:
        """
        The id of aggregator.
        """
        return pulumi.get(self, "aggregator_id")

    @property
    @pulumi.getter(name="aggregatorName")
    def aggregator_name(self) -> str:
        """
        The name of aggregator.
        """
        return pulumi.get(self, "aggregator_name")

    @property
    @pulumi.getter(name="aggregatorType")
    def aggregator_type(self) -> str:
        """
        The type of aggregator.
        """
        return pulumi.get(self, "aggregator_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of aggregator.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the aggregator.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid Values:  `0`: creating `1`: normal `2`: deleting.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAggregatorsAggregatorAggregatorAccountResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 account_name: str,
                 account_type: str):
        """
        :param str account_id: Aggregator account uid.
        :param str account_name: Aggregator account name.
        :param str account_type: Aggregator account source type.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_type", account_type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Aggregator account uid.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Aggregator account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        Aggregator account source type.
        """
        return pulumi.get(self, "account_type")


@pulumi.output_type
class GetCompliancePacksPackResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 compliance_pack_id: str,
                 compliance_pack_name: str,
                 compliance_pack_template_id: str,
                 config_rules: Sequence['outputs.GetCompliancePacksPackConfigRuleResult'],
                 description: str,
                 id: str,
                 risk_level: int,
                 status: str):
        """
        :param str account_id: The Aliyun User Id.
        :param str compliance_pack_id: The Compliance Package ID.
        :param str compliance_pack_name: The Compliance Package Name.
        :param str compliance_pack_template_id: The template ID of the Compliance Package.
        :param Sequence['GetCompliancePacksPackConfigRuleArgs'] config_rules: A list of The Compliance Package Rules.
        :param str description: The description of compliance pack.
        :param str id: The ID of the Compliance Pack.
        :param int risk_level: The Ris Level.
        :param str status: The status of the resource. Valid values `ACTIVE`, `CREATING`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "compliance_pack_id", compliance_pack_id)
        pulumi.set(__self__, "compliance_pack_name", compliance_pack_name)
        pulumi.set(__self__, "compliance_pack_template_id", compliance_pack_template_id)
        pulumi.set(__self__, "config_rules", config_rules)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Aliyun User Id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="compliancePackId")
    def compliance_pack_id(self) -> str:
        """
        The Compliance Package ID.
        """
        return pulumi.get(self, "compliance_pack_id")

    @property
    @pulumi.getter(name="compliancePackName")
    def compliance_pack_name(self) -> str:
        """
        The Compliance Package Name.
        """
        return pulumi.get(self, "compliance_pack_name")

    @property
    @pulumi.getter(name="compliancePackTemplateId")
    def compliance_pack_template_id(self) -> str:
        """
        The template ID of the Compliance Package.
        """
        return pulumi.get(self, "compliance_pack_template_id")

    @property
    @pulumi.getter(name="configRules")
    def config_rules(self) -> Sequence['outputs.GetCompliancePacksPackConfigRuleResult']:
        """
        A list of The Compliance Package Rules.
        """
        return pulumi.get(self, "config_rules")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of compliance pack.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Compliance Pack.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> int:
        """
        The Ris Level.
        """
        return pulumi.get(self, "risk_level")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCompliancePacksPackConfigRuleResult(dict):
    def __init__(__self__, *,
                 config_rule_id: str,
                 config_rule_parameters: Sequence['outputs.GetCompliancePacksPackConfigRuleConfigRuleParameterResult'],
                 managed_rule_identifier: str):
        """
        :param str config_rule_id: The ID of the rule.
        :param Sequence['GetCompliancePacksPackConfigRuleConfigRuleParameterArgs'] config_rule_parameters: A list of parameter rules.
        :param str managed_rule_identifier: Managed Rule Identifier.
        """
        pulumi.set(__self__, "config_rule_id", config_rule_id)
        pulumi.set(__self__, "config_rule_parameters", config_rule_parameters)
        pulumi.set(__self__, "managed_rule_identifier", managed_rule_identifier)

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> str:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleParameters")
    def config_rule_parameters(self) -> Sequence['outputs.GetCompliancePacksPackConfigRuleConfigRuleParameterResult']:
        """
        A list of parameter rules.
        """
        return pulumi.get(self, "config_rule_parameters")

    @property
    @pulumi.getter(name="managedRuleIdentifier")
    def managed_rule_identifier(self) -> str:
        """
        Managed Rule Identifier.
        """
        return pulumi.get(self, "managed_rule_identifier")


@pulumi.output_type
class GetCompliancePacksPackConfigRuleConfigRuleParameterResult(dict):
    def __init__(__self__, *,
                 parameter_name: str,
                 parameter_value: str,
                 required: bool):
        """
        :param str parameter_name: The Parameter Name.
        :param str parameter_value: The Parameter Value.
        :param bool required: Required.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The Parameter Name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        The Parameter Value.
        """
        return pulumi.get(self, "parameter_value")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Required.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GetConfigurationRecordersRecorderResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 id: str,
                 organization_enable_status: str,
                 organization_master_id: int,
                 resource_types: Sequence[str],
                 status: str):
        """
        :param str account_id: The ID of the Alicloud account.
        :param str id: The ID of the Config Configuration Recorder. Value as the `account_id`.
        :param str organization_enable_status: Enterprise version configuration audit enabled status.
        :param int organization_master_id: The ID of the Enterprise management account.
        :param Sequence[str] resource_types: A list of resource types to be monitored.
        :param str status: Status of resource monitoring.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "organization_enable_status", organization_enable_status)
        pulumi.set(__self__, "organization_master_id", organization_master_id)
        pulumi.set(__self__, "resource_types", resource_types)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the Alicloud account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Config Configuration Recorder. Value as the `account_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationEnableStatus")
    def organization_enable_status(self) -> str:
        """
        Enterprise version configuration audit enabled status.
        """
        return pulumi.get(self, "organization_enable_status")

    @property
    @pulumi.getter(name="organizationMasterId")
    def organization_master_id(self) -> int:
        """
        The ID of the Enterprise management account.
        """
        return pulumi.get(self, "organization_master_id")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Sequence[str]:
        """
        A list of resource types to be monitored.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of resource monitoring.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDeliveriesDeliveryResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 configuration_item_change_notification: bool,
                 configuration_snapshot: bool,
                 delivery_channel_assume_role_arn: str,
                 delivery_channel_condition: str,
                 delivery_channel_id: str,
                 delivery_channel_name: str,
                 delivery_channel_target_arn: str,
                 delivery_channel_type: str,
                 description: str,
                 id: str,
                 non_compliant_notification: bool,
                 oversized_data_oss_target_arn: str,
                 status: int):
        """
        :param str account_id: The Aliyun User Id.
        :param bool configuration_item_change_notification: Open or close delivery configuration change history.
        :param bool configuration_snapshot: Open or close timed snapshot of shipping resources.
        :param str delivery_channel_assume_role_arn: The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
        :param str delivery_channel_condition: The rule attached to the delivery method.
        :param str delivery_channel_id: The ID of the delivery method.
        :param str delivery_channel_name: The name of the delivery method.
        :param str delivery_channel_target_arn: The ARN of the delivery destination.
        :param str delivery_channel_type: The type of the delivery method.
        :param str description: The description of the delivery method.
        :param str id: The ID of the Delivery.
        :param bool non_compliant_notification: Open or close non-compliance events of delivery resources.
        :param str oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.
        :param int status: The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        pulumi.set(__self__, "delivery_channel_assume_role_arn", delivery_channel_assume_role_arn)
        pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        pulumi.set(__self__, "delivery_channel_id", delivery_channel_id)
        pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Aliyun User Id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> bool:
        """
        Open or close delivery configuration change history.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> bool:
        """
        Open or close timed snapshot of shipping resources.
        """
        return pulumi.get(self, "configuration_snapshot")

    @property
    @pulumi.getter(name="deliveryChannelAssumeRoleArn")
    def delivery_channel_assume_role_arn(self) -> str:
        """
        The Alibaba Cloud Resource Name (ARN) of the role to be assumed by the delivery method.
        """
        return pulumi.get(self, "delivery_channel_assume_role_arn")

    @property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> str:
        """
        The rule attached to the delivery method.
        """
        return pulumi.get(self, "delivery_channel_condition")

    @property
    @pulumi.getter(name="deliveryChannelId")
    def delivery_channel_id(self) -> str:
        """
        The ID of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_id")

    @property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> str:
        """
        The name of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_name")

    @property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> str:
        """
        The ARN of the delivery destination.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> str:
        """
        The type of the delivery method.
        """
        return pulumi.get(self, "delivery_channel_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the delivery method.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Delivery.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> bool:
        """
        Open or close non-compliance events of delivery resources.
        """
        return pulumi.get(self, "non_compliant_notification")

    @property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> str:
        """
        The oss ARN of the delivery channel when the value data oversized limit.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        The status of the delivery method. Valid values: `0`: The delivery method is disabled. `1`: The delivery destination is enabled.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDeliveryChannelsChannelResult(dict):
    def __init__(__self__, *,
                 delivery_channel_assume_role_arn: str,
                 delivery_channel_condition: str,
                 delivery_channel_id: str,
                 delivery_channel_name: str,
                 delivery_channel_target_arn: str,
                 delivery_channel_type: str,
                 description: str,
                 id: str,
                 status: int):
        """
        :param str delivery_channel_assume_role_arn: The Alibaba Cloud Resource Name (ARN) of the role assumed by delivery method.
        :param str delivery_channel_condition: The rule attached to the delivery method. This parameter is applicable only to delivery methods of the Message Service (MNS) type.
        :param str delivery_channel_id: The ID of the delivery channel.
        :param str delivery_channel_name: The name of the delivery channel.
        :param str delivery_channel_target_arn: The ARN of the delivery destination.
        :param str delivery_channel_type: The type of the delivery channel.
        :param str description: The description of the delivery channel.
        :param str id: The ID of the Config Delivery Channel.
        :param int status: The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
        """
        pulumi.set(__self__, "delivery_channel_assume_role_arn", delivery_channel_assume_role_arn)
        pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        pulumi.set(__self__, "delivery_channel_id", delivery_channel_id)
        pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="deliveryChannelAssumeRoleArn")
    def delivery_channel_assume_role_arn(self) -> str:
        """
        The Alibaba Cloud Resource Name (ARN) of the role assumed by delivery method.
        """
        return pulumi.get(self, "delivery_channel_assume_role_arn")

    @property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> str:
        """
        The rule attached to the delivery method. This parameter is applicable only to delivery methods of the Message Service (MNS) type.
        """
        return pulumi.get(self, "delivery_channel_condition")

    @property
    @pulumi.getter(name="deliveryChannelId")
    def delivery_channel_id(self) -> str:
        """
        The ID of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_id")

    @property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> str:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> str:
        """
        The ARN of the delivery destination.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> str:
        """
        The type of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Config Delivery Channel.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        The status of the config delivery channel. Valid values `0`: Disable delivery channel, `1`: Enable delivery channel.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRulesRuleResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 compliance_pack_id: str,
                 compliances: Sequence['outputs.GetRulesRuleComplianceResult'],
                 config_rule_arn: str,
                 config_rule_id: str,
                 config_rule_state: str,
                 config_rule_trigger_types: str,
                 description: str,
                 event_source: str,
                 exclude_resource_ids_scope: str,
                 id: str,
                 input_parameters: Mapping[str, Any],
                 maximum_execution_frequency: str,
                 modified_timestamp: str,
                 region_ids_scope: str,
                 resource_group_ids_scope: str,
                 resource_types_scopes: Sequence[str],
                 risk_level: int,
                 rule_name: str,
                 scope_compliance_resource_types: Sequence[str],
                 source_detail_message_type: str,
                 source_identifier: str,
                 source_maximum_execution_frequency: str,
                 source_owner: str,
                 status: str,
                 tag_key_scope: str,
                 tag_value_scope: str):
        """
        :param str account_id: The ID of the Alicloud account.
        :param Sequence['GetRulesRuleComplianceArgs'] compliances: The information about the compliance evaluations based on the rule.
        :param str config_rule_arn: The ARN of the Config Rule.
        :param str config_rule_id: The ID of the Config Rule.
        :param str config_rule_state: Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
        :param str config_rule_trigger_types: (Available in 1.124.1+) A list of trigger types of config rule.
        :param str description: The description of the Config Rule.
        :param str event_source: Event source of the Config Rule.
        :param str exclude_resource_ids_scope: (Available in 1.124.1+) The scope of exclude of resource ids.
        :param str id: The ID of the Config Rule.
        :param Mapping[str, Any] input_parameters: The input parameters of the Config Rule.
        :param str maximum_execution_frequency: (Available in 1.124.1+) The frequency of maximum execution.
        :param str modified_timestamp: the timestamp of the Config Rule modified.
        :param str region_ids_scope: (Available in 1.124.1+) The scope of region ids.
        :param str resource_group_ids_scope: (Available in 1.124.1+) The scope of resource group ids.
        :param Sequence[str] resource_types_scopes: (Available in 1.124.1+) The scope of resource types.
        :param int risk_level: The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
        :param str rule_name: The name of config rule.
        :param Sequence[str] scope_compliance_resource_types: The types of the resources to be evaluated against the rule.
        :param str source_detail_message_type: Rule trigger mechanism.
        :param str source_identifier: The identifier of the managed rule or the arn of the custom function.
        :param str source_maximum_execution_frequency: Rule execution cycle.
        :param str source_owner: The source owner of the Config Rule.
        :param str status: The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
        :param str tag_key_scope: (Available in 1.124.1+) The scope of tag key.
        :param str tag_value_scope: (Available in 1.124.1+) The scope of tag value.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "compliance_pack_id", compliance_pack_id)
        pulumi.set(__self__, "compliances", compliances)
        pulumi.set(__self__, "config_rule_arn", config_rule_arn)
        pulumi.set(__self__, "config_rule_id", config_rule_id)
        pulumi.set(__self__, "config_rule_state", config_rule_state)
        pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_source", event_source)
        pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "input_parameters", input_parameters)
        pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        pulumi.set(__self__, "modified_timestamp", modified_timestamp)
        pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "scope_compliance_resource_types", scope_compliance_resource_types)
        pulumi.set(__self__, "source_detail_message_type", source_detail_message_type)
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "source_maximum_execution_frequency", source_maximum_execution_frequency)
        pulumi.set(__self__, "source_owner", source_owner)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the Alicloud account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="compliancePackId")
    def compliance_pack_id(self) -> str:
        return pulumi.get(self, "compliance_pack_id")

    @property
    @pulumi.getter
    def compliances(self) -> Sequence['outputs.GetRulesRuleComplianceResult']:
        """
        The information about the compliance evaluations based on the rule.
        """
        return pulumi.get(self, "compliances")

    @property
    @pulumi.getter(name="configRuleArn")
    def config_rule_arn(self) -> str:
        """
        The ARN of the Config Rule.
        """
        return pulumi.get(self, "config_rule_arn")

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> str:
        """
        The ID of the Config Rule.
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleState")
    def config_rule_state(self) -> str:
        """
        Field `config_rule_state` has been deprecated from provider version 1.124.1. New field `status` instead.
        """
        return pulumi.get(self, "config_rule_state")

    @property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> str:
        """
        (Available in 1.124.1+) A list of trigger types of config rule.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Config Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> str:
        """
        Event source of the Config Rule.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> str:
        """
        (Available in 1.124.1+) The scope of exclude of resource ids.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Config Rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Mapping[str, Any]:
        """
        The input parameters of the Config Rule.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> str:
        """
        (Available in 1.124.1+) The frequency of maximum execution.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @property
    @pulumi.getter(name="modifiedTimestamp")
    def modified_timestamp(self) -> str:
        """
        the timestamp of the Config Rule modified.
        """
        return pulumi.get(self, "modified_timestamp")

    @property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> str:
        """
        (Available in 1.124.1+) The scope of region ids.
        """
        return pulumi.get(self, "region_ids_scope")

    @property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> str:
        """
        (Available in 1.124.1+) The scope of resource group ids.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Sequence[str]:
        """
        (Available in 1.124.1+) The scope of resource types.
        """
        return pulumi.get(self, "resource_types_scopes")

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> int:
        """
        The risk level of Config Rule. Valid values: `1`: Critical ,`2`: Warning , `3`: Info.
        """
        return pulumi.get(self, "risk_level")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The name of config rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="scopeComplianceResourceTypes")
    def scope_compliance_resource_types(self) -> Sequence[str]:
        """
        The types of the resources to be evaluated against the rule.
        """
        return pulumi.get(self, "scope_compliance_resource_types")

    @property
    @pulumi.getter(name="sourceDetailMessageType")
    def source_detail_message_type(self) -> str:
        """
        Rule trigger mechanism.
        """
        return pulumi.get(self, "source_detail_message_type")

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> str:
        """
        The identifier of the managed rule or the arn of the custom function.
        """
        return pulumi.get(self, "source_identifier")

    @property
    @pulumi.getter(name="sourceMaximumExecutionFrequency")
    def source_maximum_execution_frequency(self) -> str:
        """
        Rule execution cycle.
        """
        return pulumi.get(self, "source_maximum_execution_frequency")

    @property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> str:
        """
        The source owner of the Config Rule.
        """
        return pulumi.get(self, "source_owner")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the config rule, valid values: `ACTIVE`, `DELETING`, `EVALUATING` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> str:
        """
        (Available in 1.124.1+) The scope of tag key.
        """
        return pulumi.get(self, "tag_key_scope")

    @property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> str:
        """
        (Available in 1.124.1+) The scope of tag value.
        """
        return pulumi.get(self, "tag_value_scope")


@pulumi.output_type
class GetRulesRuleComplianceResult(dict):
    def __init__(__self__, *,
                 compliance_type: str,
                 count: int):
        """
        :param str compliance_type: The compliance evaluation result of the target resources.
        :param int count: The number of resources with the specified compliance evaluation result.
        """
        pulumi.set(__self__, "compliance_type", compliance_type)
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter(name="complianceType")
    def compliance_type(self) -> str:
        """
        The compliance evaluation result of the target resources.
        """
        return pulumi.get(self, "compliance_type")

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of resources with the specified compliance evaluation result.
        """
        return pulumi.get(self, "count")


