# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 risk_level: pulumi.Input[int],
                 rule_name: pulumi.Input[str],
                 source_identifier: pulumi.Input[str],
                 source_owner: pulumi.Input[str],
                 config_rule_trigger_types: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 region_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope_compliance_resource_types: Optional[pulumi.Input[str]] = None,
                 source_detail_message_type: Optional[pulumi.Input[str]] = None,
                 source_maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tag_key_scope: Optional[pulumi.Input[str]] = None,
                 tag_value_scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        :param pulumi.Input[str] rule_name: The name of the rule.
        :param pulumi.Input[str] source_identifier: The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        :param pulumi.Input[str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        :param pulumi.Input[str] config_rule_trigger_types: The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, Any]] input_parameters: The settings of the input parameters for the rule.
        :param pulumi.Input[str] maximum_execution_frequency: The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        :param pulumi.Input[str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types_scopes: The types of the resources to be evaluated against the rule.
        :param pulumi.Input[str] scope_compliance_resource_types: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        :param pulumi.Input[str] source_detail_message_type: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        :param pulumi.Input[str] source_maximum_execution_frequency: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        :param pulumi.Input[str] status: The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        :param pulumi.Input[str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[str] tag_value_scope: The rule monitors the tag value, only applies to rules created based on managed rules.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "source_owner", source_owner)
        if config_rule_trigger_types is not None:
            pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if resource_types_scopes is not None:
            pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        if scope_compliance_resource_types is not None:
            warnings.warn("""Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""", DeprecationWarning)
            pulumi.log.warn("""scope_compliance_resource_types is deprecated: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""")
        if scope_compliance_resource_types is not None:
            pulumi.set(__self__, "scope_compliance_resource_types", scope_compliance_resource_types)
        if source_detail_message_type is not None:
            warnings.warn("""Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""", DeprecationWarning)
            pulumi.log.warn("""source_detail_message_type is deprecated: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""")
        if source_detail_message_type is not None:
            pulumi.set(__self__, "source_detail_message_type", source_detail_message_type)
        if source_maximum_execution_frequency is not None:
            warnings.warn("""Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""", DeprecationWarning)
            pulumi.log.warn("""source_maximum_execution_frequency is deprecated: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""")
        if source_maximum_execution_frequency is not None:
            pulumi.set(__self__, "source_maximum_execution_frequency", source_maximum_execution_frequency)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> pulumi.Input[int]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        """
        return pulumi.get(self, "risk_level")

    @risk_level.setter
    def risk_level(self, value: pulumi.Input[int]):
        pulumi.set(self, "risk_level", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_identifier", value)

    @property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> pulumi.Input[str]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        """
        return pulumi.get(self, "source_owner")

    @source_owner.setter
    def source_owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_owner", value)

    @property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> Optional[pulumi.Input[str]]:
        """
        The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @config_rule_trigger_types.setter
    def config_rule_trigger_types(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_rule_trigger_types", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The settings of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "input_parameters", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_ids_scope", value)

    @property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of the resources to be evaluated against the rule.
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @property
    @pulumi.getter(name="scopeComplianceResourceTypes")
    def scope_compliance_resource_types(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        """
        warnings.warn("""Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""", DeprecationWarning)
        pulumi.log.warn("""scope_compliance_resource_types is deprecated: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""")

        return pulumi.get(self, "scope_compliance_resource_types")

    @scope_compliance_resource_types.setter
    def scope_compliance_resource_types(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_compliance_resource_types", value)

    @property
    @pulumi.getter(name="sourceDetailMessageType")
    def source_detail_message_type(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        """
        warnings.warn("""Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_detail_message_type is deprecated: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""")

        return pulumi.get(self, "source_detail_message_type")

    @source_detail_message_type.setter
    def source_detail_message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_detail_message_type", value)

    @property
    @pulumi.getter(name="sourceMaximumExecutionFrequency")
    def source_maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        """
        warnings.warn("""Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_maximum_execution_frequency is deprecated: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""")

        return pulumi.get(self, "source_maximum_execution_frequency")

    @source_maximum_execution_frequency.setter
    def source_maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_maximum_execution_frequency", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key_scope", value)

    @property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors the tag value, only applies to rules created based on managed rules.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_value_scope", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[int]] = None,
                 compliance: Optional[pulumi.Input['RuleComplianceArgs']] = None,
                 compliance_pack_id: Optional[pulumi.Input[str]] = None,
                 config_rule_arn: Optional[pulumi.Input[str]] = None,
                 config_rule_id: Optional[pulumi.Input[str]] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_source: Optional[pulumi.Input[str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 modified_timestamp: Optional[pulumi.Input[int]] = None,
                 region_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 risk_level: Optional[pulumi.Input[int]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scope_compliance_resource_types: Optional[pulumi.Input[str]] = None,
                 source_detail_message_type: Optional[pulumi.Input[str]] = None,
                 source_identifier: Optional[pulumi.Input[str]] = None,
                 source_maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 source_owner: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tag_key_scope: Optional[pulumi.Input[str]] = None,
                 tag_value_scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[int] account_id: The ID of Alicloud account.
        :param pulumi.Input['RuleComplianceArgs'] compliance: compliance information.
        :param pulumi.Input[str] compliance_pack_id: Compliance Package ID.
        :param pulumi.Input[str] config_rule_arn: config rule arn.
        :param pulumi.Input[str] config_rule_id: The ID of the rule.
        :param pulumi.Input[str] config_rule_trigger_types: The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[int] create_time: The timestamp when the rule was created.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] event_source: The event source of the rule.
        :param pulumi.Input[str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, Any]] input_parameters: The settings of the input parameters for the rule.
        :param pulumi.Input[str] maximum_execution_frequency: The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        :param pulumi.Input[int] modified_timestamp: The timestamp when the rule was last modified.
        :param pulumi.Input[str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types_scopes: The types of the resources to be evaluated against the rule.
        :param pulumi.Input[int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        :param pulumi.Input[str] rule_name: The name of the rule.
        :param pulumi.Input[str] scope_compliance_resource_types: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        :param pulumi.Input[str] source_detail_message_type: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        :param pulumi.Input[str] source_identifier: The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        :param pulumi.Input[str] source_maximum_execution_frequency: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        :param pulumi.Input[str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        :param pulumi.Input[str] status: The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        :param pulumi.Input[str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[str] tag_value_scope: The rule monitors the tag value, only applies to rules created based on managed rules.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if compliance is not None:
            pulumi.set(__self__, "compliance", compliance)
        if compliance_pack_id is not None:
            pulumi.set(__self__, "compliance_pack_id", compliance_pack_id)
        if config_rule_arn is not None:
            pulumi.set(__self__, "config_rule_arn", config_rule_arn)
        if config_rule_id is not None:
            pulumi.set(__self__, "config_rule_id", config_rule_id)
        if config_rule_trigger_types is not None:
            pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if modified_timestamp is not None:
            pulumi.set(__self__, "modified_timestamp", modified_timestamp)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if resource_types_scopes is not None:
            pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        if risk_level is not None:
            pulumi.set(__self__, "risk_level", risk_level)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if scope_compliance_resource_types is not None:
            warnings.warn("""Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""", DeprecationWarning)
            pulumi.log.warn("""scope_compliance_resource_types is deprecated: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""")
        if scope_compliance_resource_types is not None:
            pulumi.set(__self__, "scope_compliance_resource_types", scope_compliance_resource_types)
        if source_detail_message_type is not None:
            warnings.warn("""Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""", DeprecationWarning)
            pulumi.log.warn("""source_detail_message_type is deprecated: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""")
        if source_detail_message_type is not None:
            pulumi.set(__self__, "source_detail_message_type", source_detail_message_type)
        if source_identifier is not None:
            pulumi.set(__self__, "source_identifier", source_identifier)
        if source_maximum_execution_frequency is not None:
            warnings.warn("""Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""", DeprecationWarning)
            pulumi.log.warn("""source_maximum_execution_frequency is deprecated: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""")
        if source_maximum_execution_frequency is not None:
            pulumi.set(__self__, "source_maximum_execution_frequency", source_maximum_execution_frequency)
        if source_owner is not None:
            pulumi.set(__self__, "source_owner", source_owner)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of Alicloud account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def compliance(self) -> Optional[pulumi.Input['RuleComplianceArgs']]:
        """
        compliance information.
        """
        return pulumi.get(self, "compliance")

    @compliance.setter
    def compliance(self, value: Optional[pulumi.Input['RuleComplianceArgs']]):
        pulumi.set(self, "compliance", value)

    @property
    @pulumi.getter(name="compliancePackId")
    def compliance_pack_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compliance Package ID.
        """
        return pulumi.get(self, "compliance_pack_id")

    @compliance_pack_id.setter
    def compliance_pack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compliance_pack_id", value)

    @property
    @pulumi.getter(name="configRuleArn")
    def config_rule_arn(self) -> Optional[pulumi.Input[str]]:
        """
        config rule arn.
        """
        return pulumi.get(self, "config_rule_arn")

    @config_rule_arn.setter
    def config_rule_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_rule_arn", value)

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "config_rule_id")

    @config_rule_id.setter
    def config_rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_rule_id", value)

    @property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> Optional[pulumi.Input[str]]:
        """
        The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @config_rule_trigger_types.setter
    def config_rule_trigger_types(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_rule_trigger_types", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        The timestamp when the rule was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[pulumi.Input[str]]:
        """
        The event source of the rule.
        """
        return pulumi.get(self, "event_source")

    @event_source.setter
    def event_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source", value)

    @property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The settings of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "input_parameters", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @property
    @pulumi.getter(name="modifiedTimestamp")
    def modified_timestamp(self) -> Optional[pulumi.Input[int]]:
        """
        The timestamp when the rule was last modified.
        """
        return pulumi.get(self, "modified_timestamp")

    @modified_timestamp.setter
    def modified_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "modified_timestamp", value)

    @property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_ids_scope", value)

    @property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The types of the resources to be evaluated against the rule.
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> Optional[pulumi.Input[int]]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        """
        return pulumi.get(self, "risk_level")

    @risk_level.setter
    def risk_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "risk_level", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="scopeComplianceResourceTypes")
    def scope_compliance_resource_types(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        """
        warnings.warn("""Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""", DeprecationWarning)
        pulumi.log.warn("""scope_compliance_resource_types is deprecated: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""")

        return pulumi.get(self, "scope_compliance_resource_types")

    @scope_compliance_resource_types.setter
    def scope_compliance_resource_types(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_compliance_resource_types", value)

    @property
    @pulumi.getter(name="sourceDetailMessageType")
    def source_detail_message_type(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        """
        warnings.warn("""Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_detail_message_type is deprecated: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""")

        return pulumi.get(self, "source_detail_message_type")

    @source_detail_message_type.setter
    def source_detail_message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_detail_message_type", value)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_identifier", value)

    @property
    @pulumi.getter(name="sourceMaximumExecutionFrequency")
    def source_maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        """
        warnings.warn("""Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_maximum_execution_frequency is deprecated: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""")

        return pulumi.get(self, "source_maximum_execution_frequency")

    @source_maximum_execution_frequency.setter
    def source_maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_maximum_execution_frequency", value)

    @property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        """
        return pulumi.get(self, "source_owner")

    @source_owner.setter
    def source_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_owner", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key_scope", value)

    @property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The rule monitors the tag value, only applies to rules created based on managed rules.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_value_scope", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 region_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 risk_level: Optional[pulumi.Input[int]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scope_compliance_resource_types: Optional[pulumi.Input[str]] = None,
                 source_detail_message_type: Optional[pulumi.Input[str]] = None,
                 source_identifier: Optional[pulumi.Input[str]] = None,
                 source_maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 source_owner: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tag_key_scope: Optional[pulumi.Input[str]] = None,
                 tag_value_scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Config Rule resource.

        For information about Config Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigrule).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_rule = alicloud.cfg.Rule("defaultRule",
            description="If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
            source_owner="ALIYUN",
            source_identifier="contains-tag",
            risk_level=1,
            tag_value_scope="example-value",
            tag_key_scope="example-key",
            exclude_resource_ids_scope="example-resource_id",
            region_ids_scope="cn-hangzhou",
            config_rule_trigger_types="ConfigurationItemChangeNotification",
            resource_group_ids_scope=default_resource_groups.ids[0],
            resource_types_scopes=["ACS::RDS::DBInstance"],
            rule_name="contains-tag",
            input_parameters={
                "key": "example",
                "value": "example",
            })
        ```

        ## Import

        Config Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cfg/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_rule_trigger_types: The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, Any]] input_parameters: The settings of the input parameters for the rule.
        :param pulumi.Input[str] maximum_execution_frequency: The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        :param pulumi.Input[str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types_scopes: The types of the resources to be evaluated against the rule.
        :param pulumi.Input[int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        :param pulumi.Input[str] rule_name: The name of the rule.
        :param pulumi.Input[str] scope_compliance_resource_types: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        :param pulumi.Input[str] source_detail_message_type: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        :param pulumi.Input[str] source_identifier: The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        :param pulumi.Input[str] source_maximum_execution_frequency: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        :param pulumi.Input[str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        :param pulumi.Input[str] status: The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        :param pulumi.Input[str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[str] tag_value_scope: The rule monitors the tag value, only applies to rules created based on managed rules.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Config Rule resource.

        For information about Config Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigrule).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_rule = alicloud.cfg.Rule("defaultRule",
            description="If the resource matches one of the specified tag key-value pairs, the configuration is considered compliant.",
            source_owner="ALIYUN",
            source_identifier="contains-tag",
            risk_level=1,
            tag_value_scope="example-value",
            tag_key_scope="example-key",
            exclude_resource_ids_scope="example-resource_id",
            region_ids_scope="cn-hangzhou",
            config_rule_trigger_types="ConfigurationItemChangeNotification",
            resource_group_ids_scope=default_resource_groups.ids[0],
            resource_types_scopes=["ACS::RDS::DBInstance"],
            rule_name="contains-tag",
            input_parameters={
                "key": "example",
                "value": "example",
            })
        ```

        ## Import

        Config Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:cfg/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 region_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 risk_level: Optional[pulumi.Input[int]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 scope_compliance_resource_types: Optional[pulumi.Input[str]] = None,
                 source_detail_message_type: Optional[pulumi.Input[str]] = None,
                 source_identifier: Optional[pulumi.Input[str]] = None,
                 source_maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
                 source_owner: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tag_key_scope: Optional[pulumi.Input[str]] = None,
                 tag_value_scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["config_rule_trigger_types"] = config_rule_trigger_types
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
            __props__.__dict__["input_parameters"] = input_parameters
            __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
            __props__.__dict__["region_ids_scope"] = region_ids_scope
            __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
            __props__.__dict__["resource_types_scopes"] = resource_types_scopes
            if risk_level is None and not opts.urn:
                raise TypeError("Missing required property 'risk_level'")
            __props__.__dict__["risk_level"] = risk_level
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["scope_compliance_resource_types"] = scope_compliance_resource_types
            __props__.__dict__["source_detail_message_type"] = source_detail_message_type
            if source_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'source_identifier'")
            __props__.__dict__["source_identifier"] = source_identifier
            __props__.__dict__["source_maximum_execution_frequency"] = source_maximum_execution_frequency
            if source_owner is None and not opts.urn:
                raise TypeError("Missing required property 'source_owner'")
            __props__.__dict__["source_owner"] = source_owner
            __props__.__dict__["status"] = status
            __props__.__dict__["tag_key_scope"] = tag_key_scope
            __props__.__dict__["tag_value_scope"] = tag_value_scope
            __props__.__dict__["account_id"] = None
            __props__.__dict__["compliance"] = None
            __props__.__dict__["compliance_pack_id"] = None
            __props__.__dict__["config_rule_arn"] = None
            __props__.__dict__["config_rule_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["event_source"] = None
            __props__.__dict__["modified_timestamp"] = None
        super(Rule, __self__).__init__(
            'alicloud:cfg/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[int]] = None,
            compliance: Optional[pulumi.Input[pulumi.InputType['RuleComplianceArgs']]] = None,
            compliance_pack_id: Optional[pulumi.Input[str]] = None,
            config_rule_arn: Optional[pulumi.Input[str]] = None,
            config_rule_id: Optional[pulumi.Input[str]] = None,
            config_rule_trigger_types: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            event_source: Optional[pulumi.Input[str]] = None,
            exclude_resource_ids_scope: Optional[pulumi.Input[str]] = None,
            input_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
            modified_timestamp: Optional[pulumi.Input[int]] = None,
            region_ids_scope: Optional[pulumi.Input[str]] = None,
            resource_group_ids_scope: Optional[pulumi.Input[str]] = None,
            resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            risk_level: Optional[pulumi.Input[int]] = None,
            rule_name: Optional[pulumi.Input[str]] = None,
            scope_compliance_resource_types: Optional[pulumi.Input[str]] = None,
            source_detail_message_type: Optional[pulumi.Input[str]] = None,
            source_identifier: Optional[pulumi.Input[str]] = None,
            source_maximum_execution_frequency: Optional[pulumi.Input[str]] = None,
            source_owner: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tag_key_scope: Optional[pulumi.Input[str]] = None,
            tag_value_scope: Optional[pulumi.Input[str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] account_id: The ID of Alicloud account.
        :param pulumi.Input[pulumi.InputType['RuleComplianceArgs']] compliance: compliance information.
        :param pulumi.Input[str] compliance_pack_id: Compliance Package ID.
        :param pulumi.Input[str] config_rule_arn: config rule arn.
        :param pulumi.Input[str] config_rule_id: The ID of the rule.
        :param pulumi.Input[str] config_rule_trigger_types: The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[int] create_time: The timestamp when the rule was created.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[str] event_source: The event source of the rule.
        :param pulumi.Input[str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, Any]] input_parameters: The settings of the input parameters for the rule.
        :param pulumi.Input[str] maximum_execution_frequency: The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        :param pulumi.Input[int] modified_timestamp: The timestamp when the rule was last modified.
        :param pulumi.Input[str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types_scopes: The types of the resources to be evaluated against the rule.
        :param pulumi.Input[int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        :param pulumi.Input[str] rule_name: The name of the rule.
        :param pulumi.Input[str] scope_compliance_resource_types: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        :param pulumi.Input[str] source_detail_message_type: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        :param pulumi.Input[str] source_identifier: The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        :param pulumi.Input[str] source_maximum_execution_frequency: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        :param pulumi.Input[str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        :param pulumi.Input[str] status: The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        :param pulumi.Input[str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[str] tag_value_scope: The rule monitors the tag value, only applies to rules created based on managed rules.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["compliance"] = compliance
        __props__.__dict__["compliance_pack_id"] = compliance_pack_id
        __props__.__dict__["config_rule_arn"] = config_rule_arn
        __props__.__dict__["config_rule_id"] = config_rule_id
        __props__.__dict__["config_rule_trigger_types"] = config_rule_trigger_types
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["event_source"] = event_source
        __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
        __props__.__dict__["input_parameters"] = input_parameters
        __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
        __props__.__dict__["modified_timestamp"] = modified_timestamp
        __props__.__dict__["region_ids_scope"] = region_ids_scope
        __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
        __props__.__dict__["resource_types_scopes"] = resource_types_scopes
        __props__.__dict__["risk_level"] = risk_level
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["scope_compliance_resource_types"] = scope_compliance_resource_types
        __props__.__dict__["source_detail_message_type"] = source_detail_message_type
        __props__.__dict__["source_identifier"] = source_identifier
        __props__.__dict__["source_maximum_execution_frequency"] = source_maximum_execution_frequency
        __props__.__dict__["source_owner"] = source_owner
        __props__.__dict__["status"] = status
        __props__.__dict__["tag_key_scope"] = tag_key_scope
        __props__.__dict__["tag_value_scope"] = tag_value_scope
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[int]:
        """
        The ID of Alicloud account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def compliance(self) -> pulumi.Output['outputs.RuleCompliance']:
        """
        compliance information.
        """
        return pulumi.get(self, "compliance")

    @property
    @pulumi.getter(name="compliancePackId")
    def compliance_pack_id(self) -> pulumi.Output[str]:
        """
        Compliance Package ID.
        """
        return pulumi.get(self, "compliance_pack_id")

    @property
    @pulumi.getter(name="configRuleArn")
    def config_rule_arn(self) -> pulumi.Output[str]:
        """
        config rule arn.
        """
        return pulumi.get(self, "config_rule_arn")

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> pulumi.Output[str]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> pulumi.Output[str]:
        """
        The trigger type of the rule. Valid values:  `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        The timestamp when the rule was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> pulumi.Output[str]:
        """
        The event source of the rule.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The settings of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> pulumi.Output[str]:
        """
        The frequency of the compliance evaluations, it is required if the ConfigRuleTriggerTypes value is ScheduledNotification. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @property
    @pulumi.getter(name="modifiedTimestamp")
    def modified_timestamp(self) -> pulumi.Output[int]:
        """
        The timestamp when the rule was last modified.
        """
        return pulumi.get(self, "modified_timestamp")

    @property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        The types of the resources to be evaluated against the rule.
        """
        return pulumi.get(self, "resource_types_scopes")

    @property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> pulumi.Output[int]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info
        """
        return pulumi.get(self, "risk_level")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="scopeComplianceResourceTypes")
    def scope_compliance_resource_types(self) -> pulumi.Output[str]:
        """
        Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.
        """
        warnings.warn("""Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""", DeprecationWarning)
        pulumi.log.warn("""scope_compliance_resource_types is deprecated: Field 'scope_compliance_resource_types' has been deprecated from provider version 1.124.1. New field 'resource_types_scope' instead.""")

        return pulumi.get(self, "scope_compliance_resource_types")

    @property
    @pulumi.getter(name="sourceDetailMessageType")
    def source_detail_message_type(self) -> pulumi.Output[str]:
        """
        Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.
        """
        warnings.warn("""Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_detail_message_type is deprecated: Field 'source_detail_message_type' has been deprecated from provider version 1.124.1. New field 'config_rule_trigger_types' instead.""")

        return pulumi.get(self, "source_detail_message_type")

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the rule.  For a managed rule, the value is the name of the managed rule. For a custom rule, the value is the ARN of the custom rule.
        """
        return pulumi.get(self, "source_identifier")

    @property
    @pulumi.getter(name="sourceMaximumExecutionFrequency")
    def source_maximum_execution_frequency(self) -> pulumi.Output[str]:
        """
        Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.
        """
        warnings.warn("""Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""", DeprecationWarning)
        pulumi.log.warn("""source_maximum_execution_frequency is deprecated: Field 'source_maximum_execution_frequency' has been deprecated from provider version 1.124.1. New field 'maximum_execution_frequency' instead.""")

        return pulumi.get(self, "source_maximum_execution_frequency")

    @property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> pulumi.Output[str]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values:  `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule
        """
        return pulumi.get(self, "source_owner")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the rule. Valid values: ACTIVE: The rule is monitoring the configurations of target resources. DELETING_RESULTS: The compliance evaluation result returned by the rule is being deleted. EVALUATING: The rule is triggered and is evaluating whether the configurations of target resources are compliant. INACTIVE: The rule is disabled from monitoring the configurations of target resources.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The rule monitors the tag value, only applies to rules created based on managed rules.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tag_value_scope")

